/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class SplitsAndConstraintsUtil {
    private SplitsAndConstraintsUtil() {
    }

    private static FileSplit[] getDatabaseSplits(IClusterStateManager clusterStateManager, String databasePath) {
        return SplitsAndConstraintsUtil.getSplits(clusterStateManager, databasePath);
    }

    private static FileSplit[] getDataverseSplits(IClusterStateManager clusterStateManager, String dataversePath) {
        return SplitsAndConstraintsUtil.getSplits(clusterStateManager, dataversePath);
    }

    private static FileSplit[] getSplits(IClusterStateManager clusterStateManager, String path) {
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (ClusterPartition clusterPartition : clusterStateManager.getClusterPartitons()) {
            File f = new File(StoragePathUtil.prepareStoragePartitionPath((int)clusterPartition.getPartitionId()), path);
            splits.add(StoragePathUtil.getFileSplitForClusterPartition((ClusterPartition)clusterPartition, (String)f.getPath()));
        }
        return splits.toArray(new FileSplit[0]);
    }

    public static FileSplit[] getIndexSplits(Dataset dataset, String indexName, MetadataTransactionContext mdTxnCtx, IClusterStateManager csm, String namespacePath) throws AlgebricksException {
        try {
            NodeGroup nodeGroup = MetadataManager.INSTANCE.getNodegroup(mdTxnCtx, dataset.getNodeGroupName());
            if (nodeGroup == null) {
                throw new AlgebricksException("Couldn't find node group " + dataset.getNodeGroupName());
            }
            List<String> nodeList = nodeGroup.getNodeNames();
            return SplitsAndConstraintsUtil.getIndexSplits(csm, dataset, indexName, nodeList, namespacePath);
        }
        catch (MetadataException me) {
            throw new AlgebricksException((Throwable)me);
        }
    }

    public static FileSplit[] getIndexSplits(IClusterStateManager clusterStateManager, Dataset dataset, String indexName, List<String> nodes, String namespacePath) {
        String relPath = StoragePathUtil.prepareNamespaceIndexName((String)dataset.getDatasetName(), (String)indexName, (long)dataset.getRebalanceCount(), (String)namespacePath);
        List<ClusterPartition> datasetPartitions = SplitsAndConstraintsUtil.getDatasetPartitions(clusterStateManager, dataset, nodes);
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (ClusterPartition partition : datasetPartitions) {
            File f = new File(StoragePathUtil.prepareStoragePartitionPath((int)partition.getPartitionId()), relPath);
            splits.add(StoragePathUtil.getFileSplitForClusterPartition((ClusterPartition)partition, (String)f.getPath()));
        }
        return splits.toArray(new FileSplit[0]);
    }

    public static Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getDatabaseSplitProviderAndConstraints(IClusterStateManager clusterStateManager, String databaseName) {
        FileSplit[] splits = SplitsAndConstraintsUtil.getDatabaseSplits(clusterStateManager, databaseName);
        return StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
    }

    public static Pair<IFileSplitProvider, AlgebricksPartitionConstraint> getDataverseSplitProviderAndConstraints(IClusterStateManager clusterStateManager, String dataversePath) {
        FileSplit[] splits = SplitsAndConstraintsUtil.getDataverseSplits(clusterStateManager, dataversePath);
        return StoragePathUtil.splitProviderAndPartitionConstraints((FileSplit[])splits);
    }

    private static List<ClusterPartition> getDatasetPartitions(IClusterStateManager clusterStateManager, Dataset dataset, List<String> nodes) {
        if (dataset.getNodeGroupName().compareTo("MetadataGroup") == 0) {
            return Collections.singletonList(clusterStateManager.getMetadataPartition());
        }
        ArrayList<ClusterPartition> datasetPartitions = new ArrayList<ClusterPartition>();
        for (String node : nodes) {
            ClusterPartition[] nodePartitions = clusterStateManager.getNodePartitions(node);
            datasetPartitions.addAll(Arrays.asList(nodePartitions));
        }
        return datasetPartitions;
    }
}

