/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class DatasourceAdapterEntity {
    private static final DatasourceAdapterEntity DATASOURCE_ADAPTER = new DatasourceAdapterEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATASOURCE_ADAPTER, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("Name")), 0, DatasourceAdapterEntity.datasourceAdapterType(), true, new int[]{0, 1}), 2, -1);
    private static final DatasourceAdapterEntity DB_DATASOURCE_ADAPTER = new DatasourceAdapterEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATASOURCE_ADAPTER, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("Name")), 0, DatasourceAdapterEntity.databaseDatasourceAdapterType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int adapterNameIndex;
    private final int classNameIndex;
    private final int typeIndex;
    private final int timestampIndex;

    private DatasourceAdapterEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.adapterNameIndex = startIndex++;
        this.classNameIndex = startIndex++;
        this.typeIndex = startIndex++;
        this.timestampIndex = startIndex++;
    }

    public static DatasourceAdapterEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_DATASOURCE_ADAPTER : DATASOURCE_ADAPTER;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int adapterNameIndex() {
        return this.adapterNameIndex;
    }

    public int classNameIndex() {
        return this.classNameIndex;
    }

    public int typeIndex() {
        return this.typeIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    private static ARecordType datasourceAdapterType() {
        return MetadataRecordTypes.createRecordType("DatasourceAdapterRecordType", new String[]{"DataverseName", "Name", "Classname", "Type", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }

    private static ARecordType databaseDatasourceAdapterType() {
        return MetadataRecordTypes.createRecordType("DatasourceAdapterRecordType", new String[]{"DatabaseName", "DataverseName", "Name", "Classname", "Type", "Timestamp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, true);
    }
}

