/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class DatasetEntity {
    private static final DatasetEntity DATASET = new DatasetEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATASET, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("DatasetName")), 0, DatasetEntity.datasetType(), true, new int[]{0, 1}), 2, -1);
    private static final DatasetEntity DB_DATASET = new DatasetEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_DATASET, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("DatasetName")), 0, DatasetEntity.databaseDatasetType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int datasetNameIndex;
    private final int datatypeDataverseNameIndex;
    private final int datatypeNameIndex;
    private final int datasetTypeIndex;
    private final int groupNameIndex;
    private final int compactionPolicyIndex;
    private final int compactionPolicyPropertiesIndex;
    private final int internalDetailsIndex;
    private final int externalDetailsIndex;
    private final int hintsIndex;
    private final int timestampIndex;
    private final int datasetIdIndex;
    private final int pendingOpIndex;

    private DatasetEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.datasetNameIndex = startIndex++;
        this.datatypeDataverseNameIndex = startIndex++;
        this.datatypeNameIndex = startIndex++;
        this.datasetTypeIndex = startIndex++;
        this.groupNameIndex = startIndex++;
        this.compactionPolicyIndex = startIndex++;
        this.compactionPolicyPropertiesIndex = startIndex++;
        this.internalDetailsIndex = startIndex++;
        this.externalDetailsIndex = startIndex++;
        this.hintsIndex = startIndex++;
        this.timestampIndex = startIndex++;
        this.datasetIdIndex = startIndex++;
        this.pendingOpIndex = startIndex++;
    }

    public static DatasetEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_DATASET : DATASET;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int datasetNameIndex() {
        return this.datasetNameIndex;
    }

    public int datatypeDataverseNameIndex() {
        return this.datatypeDataverseNameIndex;
    }

    public int datatypeNameIndex() {
        return this.datatypeNameIndex;
    }

    public int datasetTypeIndex() {
        return this.datasetTypeIndex;
    }

    public int groupNameIndex() {
        return this.groupNameIndex;
    }

    public int compactionPolicyIndex() {
        return this.compactionPolicyIndex;
    }

    public int compactionPolicyPropertiesIndex() {
        return this.compactionPolicyPropertiesIndex;
    }

    public int internalDetailsIndex() {
        return this.internalDetailsIndex;
    }

    public int externalDetailsIndex() {
        return this.externalDetailsIndex;
    }

    public int hintsIndex() {
        return this.hintsIndex;
    }

    public int timestampIndex() {
        return this.timestampIndex;
    }

    public int datasetIdIndex() {
        return this.datasetIdIndex;
    }

    public int pendingOpIndex() {
        return this.pendingOpIndex;
    }

    private static ARecordType datasetType() {
        return MetadataRecordTypes.createRecordType("DatasetRecordType", new String[]{"DataverseName", "DatasetName", "DatatypeDataverseName", "DatatypeName", "DatasetType", "GroupName", "CompactionPolicy", "CompactionPolicyProperties", "InternalDetails", "ExternalDetails", "Hints", "Timestamp", "DatasetId", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)MetadataRecordTypes.COMPACTION_POLICY_PROPERTIES_RECORDTYPE, null), AUnionType.createUnknownableType((IAType)MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE), AUnionType.createUnknownableType((IAType)MetadataRecordTypes.EXTERNAL_DETAILS_RECORDTYPE), new AUnorderedListType((IAType)MetadataRecordTypes.DATASET_HINTS_RECORDTYPE, null), BuiltinType.ASTRING, BuiltinType.AINT32, BuiltinType.AINT32}, true);
    }

    private static ARecordType databaseDatasetType() {
        return MetadataRecordTypes.createRecordType("DatasetRecordType", new String[]{"DatabaseName", "DataverseName", "DatasetName", "DatatypeDataverseName", "DatatypeName", "DatasetType", "GroupName", "CompactionPolicy", "CompactionPolicyProperties", "InternalDetails", "ExternalDetails", "Hints", "Timestamp", "DatasetId", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, new AOrderedListType((IAType)MetadataRecordTypes.COMPACTION_POLICY_PROPERTIES_RECORDTYPE, null), AUnionType.createUnknownableType((IAType)MetadataRecordTypes.INTERNAL_DETAILS_RECORDTYPE), AUnionType.createUnknownableType((IAType)MetadataRecordTypes.EXTERNAL_DETAILS_RECORDTYPE), new AUnorderedListType((IAType)MetadataRecordTypes.DATASET_HINTS_RECORDTYPE, null), BuiltinType.ASTRING, BuiltinType.AINT32, BuiltinType.AINT32}, true);
    }
}

