/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.CheckDatasetOnlyResolutionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class VariableCheckAndRewriteVisitor
extends AbstractSqlppExpressionScopingVisitor {
    protected final MetadataProvider metadataProvider;

    public VariableCheckAndRewriteVisitor(LangRewritingContext context, MetadataProvider metadataProvider, Collection<VarIdentifier> externalVars) {
        super(context, externalVars);
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Expression visit(VariableExpr varExpr, ILangExpression parent) throws CompilationException {
        String datasetName;
        if (this.resolveAsVariableReference(varExpr)) {
            return varExpr;
        }
        Namespace defaultNamespace = this.metadataProvider.getDefaultNamespace();
        DataverseName dataverseName = defaultNamespace.getDataverseName();
        String databaseName = defaultNamespace.getDatabaseName();
        CallExpr datasetExpr = this.resolveAsDataset(databaseName, dataverseName, datasetName = SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue(), parent, varExpr);
        return datasetExpr != null ? datasetExpr : this.resolveAsFieldAccessOverContextVar(varExpr);
    }

    @Override
    public Expression visit(FieldAccessor fa, ILangExpression parent) throws CompilationException {
        Expression leadingExpr = fa.getExpr();
        if (leadingExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            DataverseName dataverseName;
            VariableExpr leadingVarExpr = (VariableExpr)leadingExpr;
            if (this.resolveAsVariableReference(leadingVarExpr)) {
                return fa;
            }
            String dataverseNamePart = SqlppVariableUtil.toUserDefinedVariableName(leadingVarExpr.getVar().getValue()).getValue();
            try {
                dataverseName = DataverseName.createSinglePartName((String)dataverseNamePart);
            }
            catch (AsterixException e) {
                throw new CompilationException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, fa.getSourceLocation(), new Serializable[]{dataverseNamePart});
            }
            String databaseName = MetadataUtil.databaseFor((DataverseName)dataverseName);
            String datasetName = fa.getIdent().getValue();
            CallExpr datasetExpr = this.resolveAsDataset(databaseName, dataverseName, datasetName, parent, leadingVarExpr);
            if (datasetExpr != null) {
                return datasetExpr;
            }
            fa.setExpr((Expression)this.resolveAsFieldAccessOverContextVar(leadingVarExpr));
            return fa;
        }
        ArrayList<String> dataverseNameParts = new ArrayList<String>(4);
        Pair topExprs = new Pair(null, null);
        if (VariableCheckAndRewriteVisitor.extractDataverseName(fa.getExpr(), dataverseNameParts, (Pair<VariableExpr, FieldAccessor>)topExprs)) {
            Namespace namespace;
            VariableExpr topVarExpr = (VariableExpr)topExprs.getFirst();
            if (this.resolveAsVariableReference(topVarExpr)) {
                return fa;
            }
            try {
                namespace = this.metadataProvider.resolve(dataverseNameParts);
            }
            catch (AsterixException e) {
                throw new CompilationException(ErrorCode.INVALID_DATABASE_OBJECT_NAME, fa.getSourceLocation(), new Serializable[]{((Object)dataverseNameParts).toString()});
            }
            String databaseName = namespace.getDatabaseName();
            DataverseName dataverseName = namespace.getDataverseName();
            String datasetName = fa.getIdent().getValue();
            CallExpr datasetExpr = this.resolveAsDataset(databaseName, dataverseName, datasetName, parent, topVarExpr);
            if (datasetExpr != null) {
                return datasetExpr;
            }
            FieldAccessor topFaExpr = (FieldAccessor)topExprs.getSecond();
            topFaExpr.setExpr((Expression)this.resolveAsFieldAccessOverContextVar(topVarExpr));
            return fa;
        }
        fa.setExpr((Expression)leadingExpr.accept((ILangVisitor)this, (Object)parent));
        return fa;
    }

    private boolean resolveAsVariableReference(VariableExpr varExpr) throws CompilationException {
        VarIdentifier varId = varExpr.getVar();
        String varName = varId.getValue();
        if (this.scopeChecker.isInForbiddenScopes(varName)) {
            throw new CompilationException(ErrorCode.FORBIDDEN_SCOPE, varExpr.getSourceLocation(), new Serializable[0]);
        }
        Identifier ident = this.scopeChecker.lookupSymbol(varName);
        if (ident == null) {
            if (SqlppVariableUtil.isExternalVariableIdentifier(varId)) {
                throw new CompilationException(ErrorCode.PARAMETER_NO_VALUE, varExpr.getSourceLocation(), new Serializable[]{SqlppVariableUtil.variableNameToDisplayedFieldName(varId.getValue())});
            }
            return false;
        }
        varExpr.setIsNewVar(false);
        varExpr.setVar((VarIdentifier)ident);
        return true;
    }

    private CallExpr resolveAsDataset(String databaseName, DataverseName dataverseName, String datasetName, ILangExpression parent, VariableExpr varExpr) throws CompilationException {
        boolean isView;
        boolean viaSynonym;
        String resolvedDatasetName;
        DataverseName resolvedDataverseName;
        String resolvedDatabaseName;
        if (!((Boolean)parent.accept((ILangVisitor)CheckDatasetOnlyResolutionVisitor.INSTANCE, (Object)varExpr)).booleanValue()) {
            return null;
        }
        SourceLocation sourceLoc = varExpr.getSourceLocation();
        ViewDecl viewDecl = this.findDeclaredView(databaseName, dataverseName, datasetName);
        if (viewDecl != null) {
            resolvedDatabaseName = viewDecl.getViewName().getDatabaseName();
            resolvedDataverseName = viewDecl.getViewName().getDataverseName();
            resolvedDatasetName = viewDecl.getViewName().getDatasetName();
            viaSynonym = false;
            isView = true;
        } else {
            Pair<Dataset, Boolean> p = this.findDataset(databaseName, dataverseName, datasetName, true, sourceLoc);
            if (p == null) {
                throw this.createUnresolvableError(databaseName, dataverseName, datasetName, sourceLoc);
            }
            Dataset resolvedDataset = (Dataset)p.first;
            resolvedDatabaseName = resolvedDataset.getDatabaseName();
            resolvedDataverseName = resolvedDataset.getDataverseName();
            resolvedDatasetName = resolvedDataset.getDatasetName();
            viaSynonym = (Boolean)p.second;
            isView = resolvedDataset.getDatasetType() == DatasetConfig.DatasetType.VIEW;
        }
        CallExpr callExpr = viaSynonym ? FunctionUtil.makeSynonymDatasetCallExpr((String)resolvedDatabaseName, (DataverseName)resolvedDataverseName, (String)resolvedDatasetName, (boolean)isView, (String)databaseName, (DataverseName)dataverseName, (String)datasetName) : FunctionUtil.makeDatasetCallExpr((String)resolvedDatabaseName, (DataverseName)resolvedDataverseName, (String)resolvedDatasetName, (boolean)isView);
        callExpr.addHints(varExpr.getHints());
        callExpr.setSourceLocation(sourceLoc);
        return callExpr;
    }

    private FieldAccessor resolveAsFieldAccessOverContextVar(VariableExpr varExpr) throws CompilationException {
        Map localVars = this.scopeChecker.getCurrentScope().getLiveVariables(this.scopeChecker.getPrecedingScope());
        Set contextVars = Scope.findVariablesAnnotatedBy(localVars.keySet(), (Scope.SymbolAnnotation)AbstractSqlppExpressionScopingVisitor.SqlppVariableAnnotation.CONTEXT_VARIABLE, (Map)localVars, (SourceLocation)varExpr.getSourceLocation());
        VariableExpr contextVar = VariableCheckAndRewriteVisitor.pickContextVar(contextVars, varExpr);
        return VariableCheckAndRewriteVisitor.generateFieldAccess((Expression)contextVar, varExpr.getVar(), varExpr.getSourceLocation());
    }

    static FieldAccessor generateFieldAccess(Expression sourceExpr, VarIdentifier fieldVar, SourceLocation sourceLoc) {
        VarIdentifier fieldName = SqlppVariableUtil.toUserDefinedVariableName(fieldVar.getValue());
        FieldAccessor fa = new FieldAccessor(sourceExpr, (Identifier)fieldName);
        fa.setSourceLocation(sourceLoc);
        return fa;
    }

    private static boolean extractDataverseName(Expression expr, List<String> outDataverseName, Pair<VariableExpr, FieldAccessor> outTopExprs) {
        switch (expr.getKind()) {
            case VARIABLE_EXPRESSION: {
                VariableExpr varExpr = (VariableExpr)expr;
                String varName = SqlppVariableUtil.toUserDefinedVariableName(varExpr.getVar().getValue()).getValue();
                outDataverseName.add(varName);
                outTopExprs.setFirst((Object)varExpr);
                return true;
            }
            case FIELD_ACCESSOR_EXPRESSION: {
                FieldAccessor faExpr = (FieldAccessor)expr;
                if (VariableCheckAndRewriteVisitor.extractDataverseName(faExpr.getExpr(), outDataverseName, outTopExprs)) {
                    outDataverseName.add(faExpr.getIdent().getValue());
                    if (outTopExprs.getSecond() == null) {
                        outTopExprs.setSecond((Object)faExpr);
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private CompilationException createUnresolvableError(String databaseName, DataverseName dataverseName, String datasetName, SourceLocation sourceLoc) {
        DataverseName defaultDataverseName = this.metadataProvider.getDefaultNamespace().getDataverseName();
        String defaultDatabaseName = this.metadataProvider.getDefaultNamespace().getDatabaseName();
        if (dataverseName == null && defaultDataverseName == null) {
            return new CompilationException(ErrorCode.NAME_RESOLVE_UNKNOWN_DATASET, sourceLoc, new Serializable[]{datasetName});
        }
        boolean useDb = this.metadataProvider.isUsingDatabase();
        String namespace = dataverseName == null ? MetadataUtil.dataverseName((String)defaultDatabaseName, (DataverseName)defaultDataverseName, (boolean)useDb) : MetadataUtil.dataverseName((String)databaseName, (DataverseName)dataverseName, (boolean)useDb);
        return new CompilationException(ErrorCode.NAME_RESOLVE_UNKNOWN_DATASET_IN_DATAVERSE, sourceLoc, new Serializable[]{datasetName, namespace});
    }

    private Pair<Dataset, Boolean> findDataset(String databaseName, DataverseName dataverseName, String datasetName, boolean includingViews, SourceLocation sourceLoc) throws CompilationException {
        try {
            Dataset dataset;
            Boolean viaSynonym = false;
            Quadruple dsName = this.metadataProvider.resolveDatasetNameUsingSynonyms(databaseName, dataverseName, datasetName, includingViews);
            if (dsName != null) {
                dataverseName = (DataverseName)dsName.getFirst();
                databaseName = (String)dsName.getFourth();
                datasetName = (String)dsName.getSecond();
                viaSynonym = (Boolean)dsName.getThird();
            }
            return (dataset = this.metadataProvider.findDataset(databaseName, dataverseName, datasetName, includingViews)) == null ? null : new Pair((Object)dataset, (Object)viaSynonym);
        }
        catch (AlgebricksException e) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, (Throwable)e, sourceLoc, new Serializable[]{e.getMessage()});
        }
    }

    private ViewDecl findDeclaredView(String databaseName, DataverseName dataverseName, String viewName) {
        Map declaredViews = this.context.getDeclaredViews();
        return declaredViews.isEmpty() ? null : (ViewDecl)declaredViews.get(new DatasetFullyQualifiedName(databaseName, dataverseName, viewName));
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        if (FunctionMapUtil.isSql92AggregateFunction(callExpr.getFunctionSignature())) {
            return callExpr;
        }
        return super.visit(callExpr, arg);
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature fs = winExpr.getFunctionSignature();
        FunctionIdentifier winfi = FunctionMapUtil.getInternalWindowFunction(fs);
        if (winfi != null) {
            if (BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)winfi, (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.WindowFunctionProperty.HAS_LIST_ARG)) {
                this.visitWindowExpressionExcludingExprListAndAggFilter(winExpr, arg);
                List exprList = winExpr.getExprList();
                ArrayList<Expression> newExprList = new ArrayList<Expression>(exprList.size());
                Iterator i = exprList.iterator();
                newExprList.add((Expression)i.next());
                while (i.hasNext()) {
                    newExprList.add(this.visit((Expression)i.next(), arg));
                }
                winExpr.setExprList(newExprList);
                return winExpr;
            }
            return super.visit(winExpr, arg);
        }
        if (FunctionMapUtil.isSql92AggregateFunction(fs)) {
            this.visitWindowExpressionExcludingExprListAndAggFilter(winExpr, arg);
            return winExpr;
        }
        return super.visit(winExpr, arg);
    }

    static VariableExpr pickContextVar(Collection<VariableExpr> contextVars, VariableExpr usedVar) throws CompilationException {
        switch (contextVars.size()) {
            case 0: {
                throw new CompilationException(ErrorCode.UNDEFINED_IDENTIFIER, usedVar.getSourceLocation(), new Serializable[]{SqlppVariableUtil.toUserDefinedVariableName(usedVar.getVar().getValue()).getValue()});
            }
            case 1: {
                return contextVars.iterator().next();
            }
        }
        throw new CompilationException(ErrorCode.AMBIGUOUS_IDENTIFIER, usedVar.getSourceLocation(), new Serializable[]{SqlppVariableUtil.toUserDefinedVariableName(usedVar.getVar().getValue()).getValue()});
    }
}

