/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;

class BatchScanAdapter
implements BatchScan {
    private final TableScan scan;

    BatchScanAdapter(TableScan scan) {
        this.scan = scan;
    }

    @Override
    public Table table() {
        return this.scan.table();
    }

    @Override
    public BatchScan useSnapshot(long snapshotId) {
        return new BatchScanAdapter(this.scan.useSnapshot(snapshotId));
    }

    @Override
    public BatchScan useRef(String ref) {
        return new BatchScanAdapter(this.scan.useRef(ref));
    }

    @Override
    public BatchScan asOfTime(long timestampMillis) {
        return new BatchScanAdapter(this.scan.asOfTime(timestampMillis));
    }

    @Override
    public Snapshot snapshot() {
        return this.scan.snapshot();
    }

    @Override
    public BatchScan option(String property, String value) {
        return new BatchScanAdapter((TableScan)this.scan.option(property, value));
    }

    @Override
    public BatchScan project(Schema schema) {
        return new BatchScanAdapter((TableScan)this.scan.project(schema));
    }

    @Override
    public BatchScan caseSensitive(boolean caseSensitive) {
        return new BatchScanAdapter((TableScan)this.scan.caseSensitive(caseSensitive));
    }

    @Override
    public boolean isCaseSensitive() {
        return this.scan.isCaseSensitive();
    }

    @Override
    public BatchScan includeColumnStats() {
        return new BatchScanAdapter((TableScan)this.scan.includeColumnStats());
    }

    @Override
    public BatchScan select(Collection<String> columns) {
        return new BatchScanAdapter((TableScan)this.scan.select(columns));
    }

    @Override
    public BatchScan filter(Expression expr) {
        return new BatchScanAdapter((TableScan)this.scan.filter(expr));
    }

    @Override
    public Expression filter() {
        return this.scan.filter();
    }

    @Override
    public BatchScan ignoreResiduals() {
        return new BatchScanAdapter((TableScan)this.scan.ignoreResiduals());
    }

    @Override
    public BatchScan planWith(ExecutorService executorService) {
        return new BatchScanAdapter((TableScan)this.scan.planWith(executorService));
    }

    @Override
    public Schema schema() {
        return this.scan.schema();
    }

    @Override
    public CloseableIterable<ScanTask> planFiles() {
        CloseableIterable<ScanTask> tasks = this.scan.planFiles();
        return tasks;
    }

    @Override
    public CloseableIterable<ScanTaskGroup<ScanTask>> planTasks() {
        CloseableIterable<ScanTaskGroup<ScanTask>> taskGroups = this.scan.planTasks();
        return taskGroups;
    }

    @Override
    public long targetSplitSize() {
        return this.scan.targetSplitSize();
    }

    @Override
    public int splitLookback() {
        return this.scan.splitLookback();
    }

    @Override
    public long splitOpenFileCost() {
        return this.scan.splitOpenFileCost();
    }
}

