/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.logging;

import java.util.Set;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.common.transactions.ILogRecord;

public class TxnAck {
    private final Set<IReplicationDestination> pendingAcks;
    private final ILogRecord logRecord;

    public TxnAck(ILogRecord logRecord, Set<IReplicationDestination> pendingAcks) {
        this.logRecord = logRecord;
        this.pendingAcks = pendingAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void ack(IReplicationDestination dest) {
        this.pendingAcks.remove(dest);
        if (this.allAcked()) {
            ILogRecord iLogRecord = this.logRecord;
            synchronized (iLogRecord) {
                this.logRecord.setReplicated(true);
                this.logRecord.notifyAll();
            }
        }
    }

    public synchronized boolean allAcked() {
        return this.pendingAcks.isEmpty();
    }
}

