/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto.util;

import java.util.Arrays;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;

public class Hmac {
    public static byte[] hmac(HashProvider hashProvider, byte[] key, byte[] data, int outputSize) throws KrbException {
        return Hmac.hmac(hashProvider, key, data, 0, data.length, outputSize);
    }

    public static byte[] hmac(HashProvider hashProvider, byte[] key, byte[] data, int start, int len, int outputSize) throws KrbException {
        byte[] hash = Hmac.hmac(hashProvider, key, data, start, len);
        byte[] output = new byte[outputSize];
        System.arraycopy(hash, 0, output, 0, outputSize);
        return output;
    }

    public static byte[] hmac(HashProvider hashProvider, byte[] key, byte[] data) throws KrbException {
        return Hmac.hmac(hashProvider, key, data, 0, data.length);
    }

    public static byte[] hmac(HashProvider hashProvider, byte[] key, byte[] data, int start, int len) throws KrbException {
        int i;
        int blockLen = hashProvider.blockSize();
        byte[] innerPaddedKey = new byte[blockLen];
        byte[] outerPaddedKey = new byte[blockLen];
        Arrays.fill(innerPaddedKey, (byte)54);
        for (i = 0; i < key.length; ++i) {
            int n = i;
            innerPaddedKey[n] = (byte)(innerPaddedKey[n] ^ key[i]);
        }
        Arrays.fill(outerPaddedKey, (byte)92);
        for (i = 0; i < key.length; ++i) {
            int n = i;
            outerPaddedKey[n] = (byte)(outerPaddedKey[n] ^ key[i]);
        }
        hashProvider.hash(innerPaddedKey);
        hashProvider.hash(data, start, len);
        byte[] tmp = hashProvider.output();
        hashProvider.hash(outerPaddedKey);
        hashProvider.hash(tmp);
        return hashProvider.output();
    }
}

