/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.projection;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.projection.IProjectionFiltrationWarningFactory;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;

public class ProjectionFiltrationWarningFactoryProvider {
    public static final IProjectionFiltrationWarningFactory TYPE_MISMATCH_FACTORY = new IProjectionFiltrationWarningFactory(){
        private static final long serialVersionUID = 4263556611813387010L;

        @Override
        public Warning createWarning(SourceLocation sourceLocation, String functionName, String position, ATypeTag expectedType, ATypeTag actualType) {
            return Warning.of((SourceLocation)sourceLocation, (IError)ErrorCode.TYPE_MISMATCH_FUNCTION, (Serializable[])new Serializable[]{functionName, ExceptionUtil.indexToPosition((int)0), expectedType, actualType});
        }

        @Override
        public ErrorCode getErrorCode() {
            return ErrorCode.TYPE_MISMATCH_FUNCTION;
        }
    };
    private static final IProjectionFiltrationWarningFactory LEFT_CONSTANT_INCOMPARABLE_TYPES_FACTORY = new IProjectionFiltrationWarningFactory(){
        private static final long serialVersionUID = -7447187099851545763L;

        @Override
        public Warning createWarning(SourceLocation sourceLocation, String functionName, String position, ATypeTag expectedType, ATypeTag actualType) {
            return Warning.of((SourceLocation)sourceLocation, (IError)ErrorCode.INCOMPARABLE_TYPES, (Serializable[])new Serializable[]{expectedType, actualType});
        }

        @Override
        public ErrorCode getErrorCode() {
            return ErrorCode.INCOMPARABLE_TYPES;
        }
    };
    private static final IProjectionFiltrationWarningFactory RIGHT_CONSTANT_INCOMPARABLE_TYPES_FACTORY = new IProjectionFiltrationWarningFactory(){
        private static final long serialVersionUID = 2818081955008928378L;

        @Override
        public Warning createWarning(SourceLocation sourceLocation, String functionName, String position, ATypeTag expectedType, ATypeTag actualType) {
            return Warning.of((SourceLocation)sourceLocation, (IError)ErrorCode.INCOMPARABLE_TYPES, (Serializable[])new Serializable[]{actualType, expectedType});
        }

        @Override
        public ErrorCode getErrorCode() {
            return ErrorCode.INCOMPARABLE_TYPES;
        }
    };

    private ProjectionFiltrationWarningFactoryProvider() {
    }

    public static IProjectionFiltrationWarningFactory getIncomparableTypesFactory(boolean leftConstant) {
        return leftConstant ? LEFT_CONSTANT_INCOMPARABLE_TYPES_FACTORY : RIGHT_CONSTANT_INCOMPARABLE_TYPES_FACTORY;
    }
}

