/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.scalar;

import org.apache.asterix.runtime.aggregates.base.SingleFieldFrameTupleReference;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class GenericScalarAggregateFunction
implements IScalarEvaluator {
    private final IAggregateEvaluator aggFunc;
    private final IUnnestingEvaluator scanCollection;
    private final IPointable listItemOut = new VoidPointable();
    private final SingleFieldFrameTupleReference itemTuple = new SingleFieldFrameTupleReference();
    protected final SourceLocation sourceLoc;

    public GenericScalarAggregateFunction(IAggregateEvaluator aggFunc, IUnnestingEvaluatorFactory scanCollectionFactory, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
        this.aggFunc = aggFunc;
        this.scanCollection = scanCollectionFactory.createUnnestingEvaluator(context);
        this.sourceLoc = sourceLoc;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.scanCollection.init(tuple);
        this.aggInit();
        while (this.scanCollection.step(this.listItemOut)) {
            this.aggStep(this.listItemOut);
        }
        this.aggFinish(result);
    }

    protected void aggInit() throws HyracksDataException {
        this.aggFunc.init();
    }

    protected void aggStep(IPointable item) throws HyracksDataException {
        this.itemTuple.reset(item.getByteArray(), item.getStartOffset(), item.getLength());
        this.aggFunc.step((IFrameTupleReference)this.itemTuple);
    }

    protected void aggFinish(IPointable result) throws HyracksDataException {
        this.aggFunc.finish(result);
    }
}

