/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.UseDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.AbstractFilterPushdownProcessor;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.visitor.ArrayPathCheckerVisitor;
import org.apache.asterix.optimizer.rules.pushdown.visitor.ColumnFilterPathBuilderVisitor;
import org.apache.asterix.optimizer.rules.pushdown.visitor.ExpressionToExpectedSchemaNodeVisitor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionVisitor;

public class ColumnFilterPushdownProcessor
extends AbstractFilterPushdownProcessor {
    protected final ExpressionToExpectedSchemaNodeVisitor exprToNodeVisitor = new ExpressionToExpectedSchemaNodeVisitor();
    protected final ColumnFilterPathBuilderVisitor pathBuilderVisitor = new ColumnFilterPathBuilderVisitor();
    protected final Map<ILogicalExpression, ARecordType> paths = new HashMap<ILogicalExpression, ARecordType>();
    private final ArrayPathCheckerVisitor checkerVisitor = new ArrayPathCheckerVisitor();

    public ColumnFilterPushdownProcessor(PushdownContext pushdownContext, IOptimizationContext context) {
        super(pushdownContext, context);
    }

    @Override
    protected boolean skip(ScanDefineDescriptor scanDefineDescriptor) throws AlgebricksException {
        Dataset dataset = scanDefineDescriptor.getDataset();
        LogicalOperatorTag scanOpTag = scanDefineDescriptor.getOperator().getOperatorTag();
        return scanOpTag != LogicalOperatorTag.DATASOURCESCAN || dataset.getDatasetFormatInfo().getFormat() != DatasetConfig.DatasetFormat.COLUMN || !DatasetUtil.isFilterPushdownSupported((Dataset)dataset);
    }

    @Override
    protected void prepareScan(ScanDefineDescriptor scanDefineDescriptor) {
        this.exprToNodeVisitor.reset(scanDefineDescriptor);
    }

    @Override
    protected void preparePushdown(UseDescriptor useDescriptor, ScanDefineDescriptor scanDescriptor) throws AlgebricksException {
        ILogicalOperator useOp = useDescriptor.getOperator();
        ILogicalOperator scanOp = scanDescriptor.getOperator();
        this.exprToNodeVisitor.setTypeEnv(PushdownUtil.getTypeEnv((ILogicalOperator)useOp, (ILogicalOperator)scanOp, (IOptimizationContext)this.context));
        this.paths.clear();
    }

    @Override
    protected boolean isNotPushable(AbstractFunctionCallExpression expression) {
        FunctionIdentifier fid = expression.getFunctionIdentifier();
        return PushdownUtil.isProhibitedFilterFunction((ILogicalExpression)expression);
    }

    @Override
    protected boolean handleCompare(AbstractFunctionCallExpression expression) throws AlgebricksException {
        List args = expression.getArguments();
        Mutable leftRef = (Mutable)args.get(0);
        Mutable rightRef = (Mutable)args.get(1);
        ILogicalExpression left = (ILogicalExpression)leftRef.getValue();
        ILogicalExpression right = (ILogicalExpression)rightRef.getValue();
        return this.pushdownFilterExpression(left) && this.pushdownFilterExpression(right);
    }

    @Override
    protected boolean handlePath(AbstractFunctionCallExpression expression) throws AlgebricksException {
        IExpectedSchemaNode node = (IExpectedSchemaNode)expression.accept((ILogicalExpressionVisitor)this.exprToNodeVisitor, null);
        if (node == null || node.getType() != ExpectedSchemaNodeType.ANY) {
            return false;
        }
        this.paths.put((ILogicalExpression)expression, this.pathBuilderVisitor.buildPath((AnyExpectedSchemaNode)node));
        return true;
    }

    @Override
    protected void putFilterInformation(ScanDefineDescriptor scanDefineDescriptor, ILogicalExpression inlinedExpr) throws AlgebricksException {
        ILogicalExpression filterExpr = scanDefineDescriptor.getFilterExpression();
        if (filterExpr != null) {
            filterExpr = this.andExpression(filterExpr, inlinedExpr);
            scanDefineDescriptor.setFilterExpression(filterExpr);
        } else {
            scanDefineDescriptor.setFilterExpression(inlinedExpr);
        }
        if (this.checkerVisitor.containsMultipleArrayPaths(this.paths.values())) {
            return;
        }
        scanDefineDescriptor.getFilterPaths().putAll(this.paths);
    }

    protected final AbstractFunctionCallExpression andExpression(ILogicalExpression filterExpr, ILogicalExpression inlinedExpr) {
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)filterExpr;
        if (!BuiltinFunctions.AND.equals((Object)funcExpr.getFunctionIdentifier())) {
            IFunctionInfo fInfo = this.context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.AND);
            ArrayList<MutableObject> args = new ArrayList<MutableObject>();
            args.add(new MutableObject((Object)filterExpr));
            funcExpr = new ScalarFunctionCallExpression(fInfo, args);
        }
        funcExpr.getArguments().add(new MutableObject((Object)inlinedExpr));
        return funcExpr;
    }
}

