/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am.array;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.am.array.IIntroduceAccessMethodRuleLocalRewrite;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class AbstractOperatorFromSubplanRewrite<T>
implements IIntroduceAccessMethodRuleLocalRewrite<T> {
    private static final List<IAlgebricksConstantValue> ZEROS_AS_ASTERIX_CONSTANTS = Arrays.asList(new AsterixConstantValue((IAObject)new AInt64(0L)), new AsterixConstantValue((IAObject)new AInt32(0)), new AsterixConstantValue((IAObject)new AInt16(0)), new AsterixConstantValue((IAObject)new AInt8(0)));
    private Set<FunctionIdentifier> optimizableFunctions;
    private IOptimizationContext context;
    private SourceLocation sourceLocation;

    public static boolean isApplicableForRewriteCursory(MetadataProvider metadataProvider, ILogicalOperator workingOp) throws AlgebricksException {
        boolean isApplicableForRewrite = false;
        if (workingOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            String datasetName;
            DataSourceScanOperator dataSourceScanOperator = (DataSourceScanOperator)workingOp;
            DataSourceId srcId = (DataSourceId)dataSourceScanOperator.getDataSource().getId();
            DataverseName dataverseName = srcId.getDataverseName();
            String database = srcId.getDatabaseName();
            if (metadataProvider.getDatasetIndexes(database, dataverseName, datasetName = srcId.getDatasourceName()).stream().anyMatch(i -> i.getIndexType() == DatasetConfig.IndexType.ARRAY)) {
                return true;
            }
        }
        for (Mutable inputOp : workingOp.getInputs()) {
            isApplicableForRewrite |= AbstractOperatorFromSubplanRewrite.isApplicableForRewriteCursory(metadataProvider, (ILogicalOperator)inputOp.getValue());
        }
        return isApplicableForRewrite;
    }

    protected void reset(SourceLocation sourceLocation, IOptimizationContext context, Set<FunctionIdentifier> optimizableFunctions) {
        this.optimizableFunctions = optimizableFunctions;
        this.sourceLocation = sourceLocation;
        this.context = context;
    }

    protected void gatherBooleanVariables(ILogicalExpression condition, List<VariableReferenceExpression> outputList, List<ILogicalExpression> miscExpressions) {
        ArrayList<Mutable<ILogicalExpression>> selectConjuncts = new ArrayList<Mutable<ILogicalExpression>>();
        if (this.splitIntoConjuncts(condition, selectConjuncts)) {
            for (Mutable mutable : selectConjuncts) {
                if (((ILogicalExpression)mutable.getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.VARIABLE)) {
                    outputList.add((VariableReferenceExpression)mutable.getValue());
                    continue;
                }
                miscExpressions.add((ILogicalExpression)mutable.getValue());
            }
        } else if (condition.getExpressionTag().equals((Object)LogicalExpressionTag.VARIABLE)) {
            outputList.add((VariableReferenceExpression)condition);
        } else {
            miscExpressions.add(condition);
        }
    }

    protected void gatherSubplanOperators(ILogicalOperator rootOperator, List<SubplanOperator> outputList) {
        block4: for (Mutable inputOpRef : rootOperator.getInputs()) {
            LogicalOperatorTag operatorTag = ((ILogicalOperator)inputOpRef.getValue()).getOperatorTag();
            switch (operatorTag) {
                case SUBPLAN: {
                    outputList.add((SubplanOperator)inputOpRef.getValue());
                    this.gatherSubplanOperators((ILogicalOperator)inputOpRef.getValue(), outputList);
                    continue block4;
                }
                case ASSIGN: 
                case UNNEST: 
                case SELECT: {
                    this.gatherSubplanOperators((ILogicalOperator)inputOpRef.getValue(), outputList);
                    continue block4;
                }
            }
            return;
        }
    }

    protected Pair<SelectOperator, UnnestOperator> traverseSubplanBranch(SubplanOperator subplanOperator, ILogicalOperator parentInput, boolean isConnectInput) throws AlgebricksException {
        AggregateOperator workingSubplanRootAsAggregate = this.getAggregateFromSubplan(subplanOperator);
        if (workingSubplanRootAsAggregate == null) {
            return null;
        }
        SelectOperator optimizableSelect = AbstractOperatorFromSubplanRewrite.getSelectFromPlan(workingSubplanRootAsAggregate);
        if (optimizableSelect == null) {
            return null;
        }
        ILogicalExpression normalizedSelectCondition = this.normalizeCondition(workingSubplanRootAsAggregate, (ILogicalExpression)optimizableSelect.getCondition().getValue());
        normalizedSelectCondition = this.keepOptimizableFunctions(normalizedSelectCondition);
        SelectOperator rewriteRootSelect = new SelectOperator((Mutable)new MutableObject((Object)normalizedSelectCondition), optimizableSelect.getRetainMissingAsValue(), optimizableSelect.getMissingPlaceholderVariable());
        rewriteRootSelect.setSourceLocation(this.sourceLocation);
        rewriteRootSelect.setExecutionMode(optimizableSelect.getExecutionMode());
        SelectOperator workingNewOperator = rewriteRootSelect;
        UnnestOperator bottommostNewUnnest = null;
        ILogicalOperator workingOriginalOperator = (ILogicalOperator)((Mutable)optimizableSelect.getInputs().get(0)).getValue();
        while (!workingOriginalOperator.getOperatorTag().equals((Object)LogicalOperatorTag.NESTEDTUPLESOURCE)) {
            if (workingOriginalOperator.getInputs().isEmpty()) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, workingSubplanRootAsAggregate.getSourceLocation(), new Serializable[]{"NESTED-TUPLE-SOURCE expected in nested plan branch, but not found."});
            }
            switch (workingOriginalOperator.getOperatorTag()) {
                case UNNEST: {
                    UnnestOperator originalUnnest = (UnnestOperator)workingOriginalOperator;
                    UnnestOperator newUnnest = (UnnestOperator)OperatorManipulationUtil.deepCopy((ILogicalOperator)originalUnnest);
                    workingNewOperator.getInputs().add(new MutableObject((Object)newUnnest));
                    workingNewOperator = newUnnest;
                    bottommostNewUnnest = (UnnestOperator)workingNewOperator;
                    break;
                }
                case ASSIGN: {
                    AssignOperator originalAssign = (AssignOperator)workingOriginalOperator;
                    AssignOperator newAssign = (AssignOperator)OperatorManipulationUtil.deepCopy((ILogicalOperator)originalAssign);
                    newAssign.setSourceLocation(this.sourceLocation);
                    workingNewOperator.getInputs().add(new MutableObject((Object)newAssign));
                    workingNewOperator = newAssign;
                    break;
                }
                case SELECT: {
                    ScalarFunctionCallExpression updatedSelectCond = this.coalesceConditions(rewriteRootSelect, workingOriginalOperator);
                    SelectOperator updatedSelectOperator = new SelectOperator((Mutable)new MutableObject((Object)updatedSelectCond), rewriteRootSelect.getRetainMissingAsValue(), rewriteRootSelect.getMissingPlaceholderVariable());
                    updatedSelectOperator.setSourceLocation(this.sourceLocation);
                    updatedSelectOperator.getInputs().addAll(rewriteRootSelect.getInputs());
                    rewriteRootSelect = updatedSelectOperator;
                    if (!workingNewOperator.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) break;
                    workingNewOperator = rewriteRootSelect;
                    break;
                }
                case SUBPLAN: {
                    SelectOperator updatedSelectOperator;
                    ScalarFunctionCallExpression updatedSelectCond;
                    Pair<SelectOperator, UnnestOperator> traversalOutput = this.traverseSubplanBranch((SubplanOperator)workingOriginalOperator, (ILogicalOperator)optimizableSelect, false);
                    if (traversalOutput != null) {
                        updatedSelectCond = this.coalesceConditions(rewriteRootSelect, (ILogicalOperator)traversalOutput.first);
                        updatedSelectOperator = new SelectOperator((Mutable)new MutableObject((Object)updatedSelectCond), rewriteRootSelect.getRetainMissingAsValue(), rewriteRootSelect.getMissingPlaceholderVariable());
                        updatedSelectOperator.setSourceLocation(this.sourceLocation);
                        updatedSelectOperator.getInputs().addAll(rewriteRootSelect.getInputs());
                        rewriteRootSelect = updatedSelectOperator;
                        if (workingNewOperator.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
                            workingNewOperator = rewriteRootSelect;
                        }
                        Mutable traversalOperator = (Mutable)((SelectOperator)traversalOutput.first).getInputs().get(0);
                        while (traversalOperator != null) {
                            ILogicalOperator traversalOperatorDeepCopy = OperatorManipulationUtil.deepCopy((ILogicalOperator)((ILogicalOperator)traversalOperator.getValue()));
                            if (((ILogicalOperator)traversalOperator.getValue()).equals(traversalOutput.second)) {
                                traversalOutput.second = (UnnestOperator)traversalOperatorDeepCopy;
                            }
                            workingNewOperator.getInputs().add(new MutableObject((Object)traversalOperatorDeepCopy));
                            workingNewOperator = (ILogicalOperator)((Mutable)workingNewOperator.getInputs().get(0)).getValue();
                            traversalOperator = ((ILogicalOperator)traversalOperator.getValue()).getInputs().isEmpty() ? null : (Mutable)((ILogicalOperator)traversalOperator.getValue()).getInputs().get(0);
                        }
                        workingNewOperator.getInputs().clear();
                        bottommostNewUnnest = (UnnestOperator)traversalOutput.second;
                        break;
                    }
                }
                default: {
                    return null;
                }
            }
            workingOriginalOperator = (ILogicalOperator)((Mutable)workingOriginalOperator.getInputs().get(0)).getValue();
        }
        if (bottommostNewUnnest == null) {
            return null;
        }
        if (this.isStrictUniversalQuantification(workingSubplanRootAsAggregate) && this.isArrayNonEmptyConjunctMissing(bottommostNewUnnest, (ILogicalOperator)((Mutable)subplanOperator.getInputs().get(0)).getValue()) && (parentInput == null || this.isArrayNonEmptyConjunctMissing(bottommostNewUnnest, parentInput))) {
            return null;
        }
        if (isConnectInput) {
            bottommostNewUnnest.getInputs().addAll(subplanOperator.getInputs());
            OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)rewriteRootSelect, (ITypingContext)this.context);
        }
        return new Pair((Object)rewriteRootSelect, bottommostNewUnnest);
    }

    protected ScalarFunctionCallExpression coalesceConditions(SelectOperator selectOp, ILogicalOperator auxOp) {
        ScalarFunctionCallExpression combinedCondition = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND));
        combinedCondition.setSourceLocation(selectOp.getSourceLocation());
        ArrayList<Mutable<ILogicalExpression>> conjuncts = new ArrayList<Mutable<ILogicalExpression>>();
        if (this.splitIntoConjuncts((ILogicalExpression)selectOp.getCondition().getValue(), conjuncts)) {
            combinedCondition.getArguments().addAll(conjuncts);
            conjuncts.clear();
        } else {
            combinedCondition.getArguments().add(selectOp.getCondition());
        }
        switch (auxOp.getOperatorTag()) {
            case LEFTOUTERJOIN: 
            case INNERJOIN: {
                AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)auxOp;
                if (this.splitIntoConjuncts((ILogicalExpression)joinOp.getCondition().getValue(), conjuncts)) {
                    combinedCondition.getArguments().addAll(conjuncts);
                    break;
                }
                combinedCondition.getArguments().add(joinOp.getCondition());
                break;
            }
            case SELECT: {
                SelectOperator selectOp2 = (SelectOperator)auxOp;
                if (this.splitIntoConjuncts((ILogicalExpression)selectOp2.getCondition().getValue(), conjuncts)) {
                    combinedCondition.getArguments().addAll(conjuncts);
                    break;
                }
                combinedCondition.getArguments().add(selectOp2.getCondition());
            }
        }
        return combinedCondition.cloneExpression();
    }

    public static SelectOperator getSelectFromPlan(AggregateOperator subplanRoot) {
        ILogicalExpression aggregateCondition = null;
        boolean isNonEmptyStream = false;
        for (Mutable expression : subplanRoot.getExpressions()) {
            AggregateFunctionCallExpression aggExpression = (AggregateFunctionCallExpression)expression.getValue();
            if (aggExpression.getFunctionIdentifier().equals((Object)BuiltinFunctions.NON_EMPTY_STREAM)) {
                isNonEmptyStream = true;
                continue;
            }
            if (!aggExpression.isTwoStep() || !aggExpression.getStepOneAggregate().getFunctionIdentifier().equals((Object)BuiltinFunctions.SQL_COUNT) || !aggExpression.getStepTwoAggregate().getFunctionIdentifier().equals((Object)BuiltinFunctions.SQL_SUM) || !((ILogicalExpression)((Mutable)aggExpression.getArguments().get(0)).getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) continue;
            AbstractFunctionCallExpression switchExpression = (AbstractFunctionCallExpression)((Mutable)aggExpression.getArguments().get(0)).getValue();
            ILogicalExpression arg1 = (ILogicalExpression)((Mutable)switchExpression.getArguments().get(0)).getValue();
            ILogicalExpression arg2 = (ILogicalExpression)((Mutable)switchExpression.getArguments().get(1)).getValue();
            ILogicalExpression arg3 = (ILogicalExpression)((Mutable)switchExpression.getArguments().get(2)).getValue();
            ILogicalExpression arg4 = (ILogicalExpression)((Mutable)switchExpression.getArguments().get(3)).getValue();
            if (!arg2.getExpressionTag().equals((Object)LogicalExpressionTag.CONSTANT) || !arg3.getExpressionTag().equals((Object)LogicalExpressionTag.CONSTANT) || !arg4.getExpressionTag().equals((Object)LogicalExpressionTag.CONSTANT) || !((ConstantExpression)arg2).getValue().isTrue() || !((ConstantExpression)arg3).getValue().isNull() || !((ConstantExpression)arg4).getValue().isTrue()) continue;
            aggregateCondition = arg1;
        }
        if (isNonEmptyStream && aggregateCondition != null) {
            SelectOperator selectFromAgg = new SelectOperator((Mutable)new MutableObject(aggregateCondition));
            selectFromAgg.getInputs().addAll(subplanRoot.getInputs());
            selectFromAgg.setSourceLocation(subplanRoot.getSourceLocation());
            return selectFromAgg;
        }
        ILogicalOperator workingOperator = (ILogicalOperator)((Mutable)subplanRoot.getInputs().get(0)).getValue();
        while (workingOperator != null) {
            if (workingOperator.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
                return (SelectOperator)workingOperator;
            }
            workingOperator = workingOperator.getInputs().isEmpty() ? null : (ILogicalOperator)((Mutable)workingOperator.getInputs().get(0)).getValue();
        }
        return null;
    }

    private ILogicalExpression keepOptimizableFunctions(ILogicalExpression cond) {
        if (cond.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            AbstractFunctionCallExpression func = (AbstractFunctionCallExpression)cond;
            ArrayList<Mutable<ILogicalExpression>> conjuncts = new ArrayList<Mutable<ILogicalExpression>>();
            if (this.splitIntoConjuncts((ILogicalExpression)func, conjuncts)) {
                ArrayList<Mutable> optimizableConjuncts = new ArrayList<Mutable>();
                for (Mutable mutable : conjuncts) {
                    if (!((ILogicalExpression)mutable.getValue()).getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || !this.optimizableFunctions.contains(((AbstractFunctionCallExpression)mutable.getValue()).getFunctionIdentifier())) continue;
                    optimizableConjuncts.add(mutable);
                }
                if (optimizableConjuncts.size() == 1) {
                    return (ILogicalExpression)((Mutable)optimizableConjuncts.get(0)).getValue();
                }
                if (optimizableConjuncts.size() > 1) {
                    ScalarFunctionCallExpression andCond = new ScalarFunctionCallExpression((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)BuiltinFunctions.AND));
                    andCond.setSourceLocation(cond.getSourceLocation());
                    andCond.getArguments().addAll(optimizableConjuncts);
                    return andCond;
                }
            } else if (func.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && this.optimizableFunctions.contains(func.getFunctionIdentifier())) {
                return cond;
            }
        }
        return ConstantExpression.TRUE;
    }

    protected AggregateOperator getAggregateFromSubplan(SubplanOperator subplanOperator) {
        if (subplanOperator.getNestedPlans().size() > 1 || ((ILogicalPlan)subplanOperator.getNestedPlans().get(0)).getRoots().size() > 1) {
            return null;
        }
        ILogicalOperator workingSubplanRoot = (ILogicalOperator)((Mutable)((ILogicalPlan)subplanOperator.getNestedPlans().get(0)).getRoots().get(0)).getValue();
        if (!workingSubplanRoot.getOperatorTag().equals((Object)LogicalOperatorTag.AGGREGATE)) {
            return null;
        }
        AggregateOperator workingSubplanRootAsAggregate = (AggregateOperator)workingSubplanRoot;
        return workingSubplanRootAsAggregate;
    }

    private boolean isStrictUniversalQuantification(AggregateOperator workingSubplanRoot) {
        for (Mutable expression : workingSubplanRoot.getExpressions()) {
            AggregateFunctionCallExpression funcExpr = (AggregateFunctionCallExpression)expression.getValue();
            if (!funcExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.EMPTY_STREAM)) continue;
            return true;
        }
        return false;
    }

    private boolean isArrayNonEmptyConjunctMissing(UnnestOperator firstUnnestInNTS, ILogicalOperator subplanInput) {
        ArrayList<Mutable<ILogicalExpression>> conjunctsFromSelect;
        UnnestingFunctionCallExpression unnestFunction = (UnnestingFunctionCallExpression)firstUnnestInNTS.getExpressionRef().getValue();
        VariableReferenceExpression unnestVarExpr = (VariableReferenceExpression)((Mutable)unnestFunction.getArguments().get(0)).getValue();
        LogicalVariable arrayVariable = unnestVarExpr.getVariableReference();
        if (!subplanInput.getOperatorTag().equals((Object)LogicalOperatorTag.SELECT)) {
            return true;
        }
        ILogicalExpression selectCondExpr = this.normalizeCondition(null, (ILogicalExpression)((SelectOperator)subplanInput).getCondition().getValue());
        if (this.splitIntoConjuncts(selectCondExpr, conjunctsFromSelect = new ArrayList<Mutable<ILogicalExpression>>())) {
            for (Mutable mutable : conjunctsFromSelect) {
                ILogicalExpression workingConjunct = (ILogicalExpression)mutable.getValue();
                if (!workingConjunct.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) || !this.analyzeConjunctForArrayNonEmptiness(arrayVariable, (ScalarFunctionCallExpression)workingConjunct)) continue;
                return false;
            }
            return true;
        }
        if (!selectCondExpr.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL)) {
            return true;
        }
        return !this.analyzeConjunctForArrayNonEmptiness(arrayVariable, (ScalarFunctionCallExpression)selectCondExpr);
    }

    private boolean analyzeConjunctForArrayNonEmptiness(LogicalVariable arrayVariable, ScalarFunctionCallExpression workingSelectCondExpr) {
        if (workingSelectCondExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.GT)) {
            ILogicalExpression firstArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(0)).getValue();
            ILogicalExpression secondArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(1)).getValue();
            if (firstArg.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && ((ScalarFunctionCallExpression)firstArg).getFunctionIdentifier().equals((Object)BuiltinFunctions.LEN)) {
                ScalarFunctionCallExpression lenFunction = (ScalarFunctionCallExpression)firstArg;
                ArrayList usedVariables = new ArrayList();
                lenFunction.getUsedVariables(usedVariables);
                return usedVariables.contains(arrayVariable) && secondArg.getExpressionTag().equals((Object)LogicalExpressionTag.CONSTANT) && ZEROS_AS_ASTERIX_CONSTANTS.contains(((ConstantExpression)secondArg).getValue());
            }
        } else if (workingSelectCondExpr.getFunctionIdentifier().equals((Object)BuiltinFunctions.LT)) {
            ILogicalExpression firstArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(0)).getValue();
            ILogicalExpression secondArg = (ILogicalExpression)((Mutable)workingSelectCondExpr.getArguments().get(1)).getValue();
            if (secondArg.getExpressionTag().equals((Object)LogicalExpressionTag.FUNCTION_CALL) && ((ScalarFunctionCallExpression)secondArg).getFunctionIdentifier().equals((Object)BuiltinFunctions.LEN)) {
                ScalarFunctionCallExpression lenFunction = (ScalarFunctionCallExpression)secondArg;
                ArrayList usedVariables = new ArrayList();
                lenFunction.getUsedVariables(usedVariables);
                return usedVariables.contains(arrayVariable) && firstArg.getExpressionTag().equals((Object)LogicalExpressionTag.CONSTANT) && ZEROS_AS_ASTERIX_CONSTANTS.contains(((ConstantExpression)firstArg).getValue());
            }
        }
        return false;
    }

    private ILogicalExpression normalizeCondition(AggregateOperator aggregateOperator, ILogicalExpression expr) {
        if (aggregateOperator != null && !this.isStrictUniversalQuantification(aggregateOperator)) {
            return expr;
        }
        if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return expr;
        }
        ScalarFunctionCallExpression notFunction = (ScalarFunctionCallExpression)expr;
        if (!notFunction.getFunctionIdentifier().equals((Object)BuiltinFunctions.NOT)) {
            return expr;
        }
        ScalarFunctionCallExpression ifMissingOrNullFunction = (ScalarFunctionCallExpression)((Mutable)notFunction.getArguments().get(0)).getValue();
        if (!ifMissingOrNullFunction.getFunctionIdentifier().equals((Object)BuiltinFunctions.IF_MISSING_OR_NULL)) {
            return expr;
        }
        return (ILogicalExpression)((Mutable)ifMissingOrNullFunction.getArguments().get(0)).getValue();
    }

    private boolean splitIntoConjuncts(ILogicalExpression expression, List<Mutable<ILogicalExpression>> conjuncts) {
        ArrayList exprConjuncts = new ArrayList();
        if (expression.splitIntoConjuncts(exprConjuncts)) {
            for (Mutable conjunct : exprConjuncts) {
                ArrayList<Mutable<ILogicalExpression>> innerExprConjuncts = new ArrayList<Mutable<ILogicalExpression>>();
                if (this.splitIntoConjuncts((ILogicalExpression)conjunct.getValue(), innerExprConjuncts)) {
                    conjuncts.addAll(innerExprConjuncts);
                    continue;
                }
                conjuncts.add((Mutable<ILogicalExpression>)new MutableObject((Object)((ILogicalExpression)conjunct.getValue())));
            }
            return true;
        }
        return false;
    }
}

