/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.google.common.base.Preconditions;
import com.teradata.tpcds.JoinKeyUtils;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.SlowlyChangingDimensionUtils;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.EnglishDistributions;
import com.teradata.tpcds.distribution.NamesDistributions;
import com.teradata.tpcds.generator.WebSiteGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.WebSiteRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Address;
import com.teradata.tpcds.type.Decimal;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class WebSiteRowGenerator
extends AbstractRowGenerator {
    private Optional<WebSiteRow> previousRow = Optional.empty();

    public WebSiteRowGenerator() {
        super(Table.WEB_SITE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        String webName;
        long webCloseDate;
        long webOpenDate;
        long nullBitMap = Nulls.createNullBitMap(Table.WEB_SITE, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_NULLS));
        long webSiteSk = rowNumber;
        String webClass = "Unknown";
        SlowlyChangingDimensionUtils.SlowlyChangingDimensionKey slowlyChangingDimensionKey = SlowlyChangingDimensionUtils.computeScdKey(Table.WEB_SITE, rowNumber);
        String webSiteId = slowlyChangingDimensionKey.getBusinessKey();
        long webRecStartDateId = slowlyChangingDimensionKey.getStartDate();
        long webRecEndDateId = slowlyChangingDimensionKey.getEndDate();
        boolean isNewBusinessKey = slowlyChangingDimensionKey.isNewBusinessKey();
        Scaling scaling = session.getScaling();
        if (isNewBusinessKey) {
            webOpenDate = JoinKeyUtils.generateJoinKey(WebSiteGeneratorColumn.WEB_OPEN_DATE, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_OPEN_DATE), Table.DATE_DIM, rowNumber, scaling);
            webCloseDate = JoinKeyUtils.generateJoinKey(WebSiteGeneratorColumn.WEB_CLOSE_DATE, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_CLOSE_DATE), Table.DATE_DIM, rowNumber, scaling);
            if (webCloseDate > webRecEndDateId) {
                webCloseDate = -1L;
            }
            webName = String.format("site_%d", (int)(rowNumber / 6L));
        } else {
            Preconditions.checkState((boolean)this.previousRow.isPresent(), (Object)"previousRow has not yet been initialized");
            webOpenDate = this.previousRow.get().getWebOpenDate();
            webCloseDate = this.previousRow.get().getWebCloseDate();
            webName = this.previousRow.get().getWebName();
        }
        int fieldChangeFlags = (int)this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_SCD).nextRandom();
        String firstName = NamesDistributions.pickRandomFirstName(session.isSexist() ? NamesDistributions.FirstNamesWeights.MALE_FREQUENCY : NamesDistributions.FirstNamesWeights.GENERAL_FREQUENCY, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_MANAGER));
        String lastName = NamesDistributions.pickRandomLastName(this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_MANAGER));
        String webManager = String.format("%s %s", firstName, lastName);
        if (this.previousRow.isPresent()) {
            webManager = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebManager(), webManager);
        }
        fieldChangeFlags >>= 1;
        int webMarketId = RandomValueGenerator.generateUniformRandomInt(1, 6, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_MARKET_ID));
        if (this.previousRow.isPresent()) {
            webMarketId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebMarketId(), webMarketId);
        }
        fieldChangeFlags >>= 1;
        String webMarketClass = RandomValueGenerator.generateRandomText(20, 50, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_MARKET_CLASS));
        if (this.previousRow.isPresent()) {
            webMarketClass = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebMarketClass(), webMarketClass);
        }
        fieldChangeFlags >>= 1;
        String webMarketDesc = RandomValueGenerator.generateRandomText(20, 100, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_MARKET_DESC));
        if (this.previousRow.isPresent()) {
            webMarketDesc = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebMarketDesc(), webMarketDesc);
        }
        fieldChangeFlags >>= 1;
        firstName = NamesDistributions.pickRandomFirstName(session.isSexist() ? NamesDistributions.FirstNamesWeights.MALE_FREQUENCY : NamesDistributions.FirstNamesWeights.GENERAL_FREQUENCY, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_MARKET_MANAGER));
        lastName = NamesDistributions.pickRandomLastName(this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_MARKET_MANAGER));
        String webMarketManager = String.format("%s %s", firstName, lastName);
        if (this.previousRow.isPresent()) {
            webMarketManager = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebMarketManager(), webMarketManager);
        }
        fieldChangeFlags >>= 1;
        int webCompanyId = RandomValueGenerator.generateUniformRandomInt(1, 6, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_COMPANY_ID));
        if (this.previousRow.isPresent()) {
            webCompanyId = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebCompanyId(), webCompanyId);
        }
        fieldChangeFlags >>= 1;
        String webCompanyName = RandomValueGenerator.generateWord(webCompanyId, 100, EnglishDistributions.SYLLABLES_DISTRIBUTION);
        if (this.previousRow.isPresent()) {
            webCompanyName = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebCompanyName(), webCompanyName);
        }
        fieldChangeFlags >>= 1;
        Address webAddress = Address.makeAddressForColumn(Table.WEB_SITE, this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_ADDRESS), scaling);
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        int gmtOffset = webAddress.getGmtOffset();
        if (this.previousRow.isPresent()) {
            gmtOffset = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebAddress().getGmtOffset(), gmtOffset);
        }
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        fieldChangeFlags >>= 1;
        int streetNumber = webAddress.getStreetNumber();
        if (this.previousRow.isPresent()) {
            streetNumber = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebAddress().getStreetNumber(), streetNumber);
        }
        fieldChangeFlags >>= 1;
        int zip = webAddress.getZip();
        if (this.previousRow.isPresent()) {
            zip = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebAddress().getZip(), zip);
        }
        fieldChangeFlags >>= 1;
        webAddress = new Address(webAddress.getSuiteNumber(), streetNumber, webAddress.getStreetName1(), webAddress.getStreetName2(), webAddress.getStreetType(), webAddress.getCity(), webAddress.getCounty(), webAddress.getState(), webAddress.getCountry(), zip, gmtOffset);
        Decimal webTaxPercentage = RandomValueGenerator.generateUniformRandomDecimal(Decimal.ZERO, new Decimal(12L, 2), this.getRandomNumberStream(WebSiteGeneratorColumn.WEB_TAX_PERCENTAGE));
        if (this.previousRow.isPresent()) {
            webTaxPercentage = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewBusinessKey, this.previousRow.get().getWebTaxPercentage(), webTaxPercentage);
        }
        WebSiteRow row = new WebSiteRow(nullBitMap, webSiteSk, webSiteId, webRecStartDateId, webRecEndDateId, webName, webOpenDate, webCloseDate, webClass, webManager, webMarketId, webMarketClass, webMarketDesc, webMarketManager, webCompanyId, webCompanyName, webAddress, webTaxPercentage);
        this.previousRow = Optional.of(row);
        return new RowGeneratorResult(row);
    }
}

