/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.partitions;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.partitions.IPartition;

public class MaterializedPartition
implements IPartition {
    private final IHyracksTaskContext ctx;
    private final FileReference partitionFile;
    private final Executor executor;
    private final IIOManager ioManager;

    public MaterializedPartition(IHyracksTaskContext ctx, FileReference partitionFile, Executor executor, IIOManager ioManager) {
        this.ctx = ctx;
        this.partitionFile = partitionFile;
        this.executor = executor;
        this.ioManager = ioManager;
    }

    public IHyracksTaskContext getTaskContext() {
        return this.ctx;
    }

    public void deallocate() {
        if (this.partitionFile != null) {
            this.partitionFile.delete();
        }
    }

    public void writeTo(final IFrameWriter writer) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (MaterializedPartition.this.partitionFile == null) {
                        writer.open();
                        writer.close();
                        return;
                    }
                    IFileHandle fh = MaterializedPartition.this.ioManager.open(MaterializedPartition.this.partitionFile, IIOManager.FileReadWriteMode.READ_ONLY, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
                    try {
                        writer.open();
                        try {
                            long offset = 0L;
                            ByteBuffer buffer = MaterializedPartition.this.ctx.allocateFrame();
                            while (true) {
                                buffer.clear();
                                long size = MaterializedPartition.this.ioManager.syncRead(fh, offset, buffer);
                                if (size < 0L) {
                                    break;
                                }
                                if (size < (long)buffer.capacity()) {
                                    throw new HyracksDataException("Premature end of file");
                                }
                                offset += size;
                                buffer.flip();
                                writer.nextFrame(buffer);
                            }
                        }
                        finally {
                            writer.close();
                        }
                    }
                    finally {
                        MaterializedPartition.this.ioManager.close(fh);
                    }
                }
                catch (HyracksDataException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public boolean isReusable() {
        return true;
    }
}

