/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.filter;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.external.input.filter.IExternalFilterValueEvaluator;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.Integer64SerializerDeserializer;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class ExternalFilterValueEvaluator
implements IExternalFilterValueEvaluator {
    private final ATypeTag typeTag;
    private final ArrayBackedValueStorage value;
    private final AStringSerializerDeserializer stringSerDer;

    ExternalFilterValueEvaluator(ATypeTag typeTag) {
        this.typeTag = typeTag;
        this.value = new ArrayBackedValueStorage();
        this.stringSerDer = new AStringSerializerDeserializer(new UTF8StringWriter(), null);
    }

    @Override
    public void setValue(String stringValue) throws HyracksDataException {
        this.value.reset();
        try {
            ExternalFilterValueEvaluator.writeValue(this.typeTag, stringValue, this.value, this.stringSerDer);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        result.set((IValueReference)this.value);
    }

    public static void writeValue(ATypeTag typeTag, String stringValue, ArrayBackedValueStorage value, AStringSerializerDeserializer stringSerDer) throws HyracksDataException {
        DataOutput output = value.getDataOutput();
        SerializerDeserializerUtil.serializeTag((ATypeTag)typeTag, (DataOutput)output);
        switch (typeTag) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                Integer64SerializerDeserializer.write((long)Long.parseLong(stringValue), (DataOutput)output);
                break;
            }
            case DOUBLE: {
                DoubleSerializerDeserializer.write((double)Double.parseDouble(stringValue), (DataOutput)output);
                break;
            }
            case STRING: {
                stringSerDer.serialize(stringValue, output);
            }
        }
    }
}

