/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public final class SerializerDeserializerUtil {
    private SerializerDeserializerUtil() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static void writeIntToByteArray(byte[] array, int value, int offset) {
        array[offset] = (byte)(0xFF & value >> 24);
        array[offset + 1] = (byte)(0xFF & value >> 16);
        array[offset + 2] = (byte)(0xFF & value >> 8);
        array[offset + 3] = (byte)(0xFF & value);
    }

    public static void writeShortToByteArray(byte[] array, short value, int offset) {
        array[offset] = (byte)(0xFF & value >> 8);
        array[offset + 1] = (byte)(0xFF & value);
    }

    public static int readIntFromByteArray(byte[] array) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (array[i] & 0xFF) << shift;
        }
        return value;
    }

    public static short readShortFromByteArray(byte[] array) {
        short value = 0;
        for (int i = 0; i < 2; ++i) {
            int shift = (1 - i) * 8;
            value = (short)(value + ((array[i] & 0xFF) << shift));
        }
        return value;
    }

    public static void serializeTag(IAObject instance, DataOutput out) throws HyracksDataException {
        IAType t = instance.getType();
        SerializerDeserializerUtil.serializeTag(t.getTypeTag(), out);
    }

    public static void serializeTag(ATypeTag tag, DataOutput out) throws HyracksDataException {
        try {
            out.writeByte(tag.serialize());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static ATypeTag deserializeTag(DataInput in) throws HyracksDataException {
        try {
            return EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(in.readByte());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static byte[] computeByteArrayForIntValue(int value) throws AlgebricksException {
        ArrayBackedValueStorage castBuffer = new ArrayBackedValueStorage();
        try {
            AInt32 val = new AInt32(value);
            SerializerDeserializerUtil.serializeTag(val, castBuffer.getDataOutput());
            AInt32SerializerDeserializer.INSTANCE.serialize(val, castBuffer.getDataOutput());
        }
        catch (HyracksDataException e) {
            throw CompilationException.create((ErrorCode)ErrorCode.CANNOT_SERIALIZE_A_VALUE, (Serializable[])new Serializable[]{e});
        }
        return castBuffer.getByteArray();
    }

    public static int getNumberOfItemsNonTagged(TaggedValueReference list) {
        return AInt32SerializerDeserializer.getInt(list.getByteArray(), list.getStartOffset() + 5);
    }

    public static int getItemOffset(byte[] listBytes, int offset, int itemIndex) throws HyracksDataException {
        ATypeTag itemTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[offset + 1]);
        if (NonTaggedFormatUtil.isFixedSizedCollection(itemTag)) {
            int valueLength = NonTaggedFormatUtil.getFieldValueLength(listBytes, offset + 1, itemTag, true);
            return offset + 10 + valueLength * itemIndex;
        }
        return offset + AInt32SerializerDeserializer.getInt(listBytes, offset + 10 + 4 * itemIndex);
    }

    public static int getItemOffsetNonTagged(TaggedValueReference list, int itemIndex) throws HyracksDataException {
        int offset;
        byte[] listValueBytes = list.getByteArray();
        ATypeTag itemTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listValueBytes[offset = list.getStartOffset()]);
        if (NonTaggedFormatUtil.isFixedSizedCollection(itemTag)) {
            int valueLength = NonTaggedFormatUtil.getFieldValueLength(listValueBytes, offset, itemTag, true);
            return offset + 9 + valueLength * itemIndex;
        }
        return offset + AInt32SerializerDeserializer.getInt(listValueBytes, offset + 9 + 4 * itemIndex) - 1;
    }
}

