/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.JoinKeyUtils;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.CatalogReturnsGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.CatalogReturnsRow;
import com.teradata.tpcds.row.CatalogSalesRow;
import com.teradata.tpcds.row.TableRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Pricing;
import java.util.Collections;
import java.util.List;

public class CatalogReturnsRowGenerator
extends AbstractRowGenerator {
    public static final int RETURN_PERCENT = 10;

    public CatalogReturnsRowGenerator() {
        super(Table.CATALOG_RETURNS);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        RowGeneratorResult salesAndReturnsResult = parentRowGenerator.generateRowAndChildRows(rowNumber, session, null, this);
        if (salesAndReturnsResult.getRowAndChildRows().size() == 2) {
            return new RowGeneratorResult((List<TableRow>)ImmutableList.of((Object)salesAndReturnsResult.getRowAndChildRows().get(1)), salesAndReturnsResult.shouldEndRow());
        }
        return new RowGeneratorResult(Collections.emptyList(), salesAndReturnsResult.shouldEndRow());
    }

    public TableRow generateRow(Session session, CatalogSalesRow salesRow) {
        long nullBitMap = Nulls.createNullBitMap(Table.CATALOG_RETURNS, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_NULLS));
        Scaling scaling = session.getScaling();
        long crReturningCustomerSk = JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_RETURNING_CUSTOMER_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_RETURNING_CUSTOMER_SK), Table.CUSTOMER, 2L, scaling);
        long crReturningCdemoSk = JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_RETURNING_CDEMO_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_RETURNING_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 2L, scaling);
        long crReturningHdemoSk = JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_RETURNING_HDEMO_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_RETURNING_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 2L, scaling);
        long crReturningAddrSk = JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_RETURNING_ADDR_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_RETURNING_ADDR_SK), Table.CUSTOMER_ADDRESS, 2L, scaling);
        if (RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_RETURNING_CUSTOMER_SK)) < 10) {
            crReturningCustomerSk = salesRow.getCsShipCustomerSk();
            crReturningCdemoSk = salesRow.getCsShipCdemoSk();
            crReturningAddrSk = salesRow.getCsShipAddrSk();
        }
        Pricing salesPricing = salesRow.getCsPricing();
        int quantity = salesPricing.getQuantity();
        if (salesRow.getCsPricing().getQuantity() != -1) {
            quantity = RandomValueGenerator.generateUniformRandomInt(1, quantity, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_PRICING));
        }
        Pricing crPricing = Pricing.generatePricingForReturnsTable(CatalogReturnsGeneratorColumn.CR_PRICING, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_PRICING), quantity, salesPricing);
        return new CatalogReturnsRow(JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_RETURNED_DATE_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_RETURNED_DATE_SK), Table.DATE_DIM, salesRow.getCsShipDateSk(), scaling), JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_RETURNED_TIME_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_RETURNED_TIME_SK), Table.TIME_DIM, 1L, scaling), salesRow.getCsSoldItemSk(), salesRow.getCsBillCustomerSk(), salesRow.getCsBillCdemoSk(), salesRow.getCsBillHdemoSk(), salesRow.getCsBillAddrSk(), crReturningCustomerSk, crReturningCdemoSk, crReturningHdemoSk, crReturningAddrSk, salesRow.getCsCallCenterSk(), salesRow.getCsCatalogPageSk(), JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_SHIP_MODE_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_SHIP_MODE_SK), Table.SHIP_MODE, 1L, scaling), JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_WAREHOUSE_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_WAREHOUSE_SK), Table.WAREHOUSE, 1L, scaling), JoinKeyUtils.generateJoinKey(CatalogReturnsGeneratorColumn.CR_REASON_SK, this.getRandomNumberStream(CatalogReturnsGeneratorColumn.CR_REASON_SK), Table.REASON, 1L, scaling), salesRow.getCsOrderNumber(), crPricing, nullBitMap);
    }
}

