/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.util.Arrays;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.AbstractQuadStringStringEval;
import org.apache.asterix.runtime.evaluators.functions.utils.RegExpMatcher;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

@MissingNullInOutFunction
public class StringRegExpReplaceWithFlagDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = StringRegExpReplaceWithFlagDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractQuadStringStringEval(ctx, args[0], args[1], args[2], args[3], StringRegExpReplaceWithFlagDescriptor.this.getIdentifier(), StringRegExpReplaceWithFlagDescriptor.this.sourceLoc){
                    private final UTF8StringPointable emptyFlags;
                    private final RegExpMatcher matcher;
                    private final AMutableInt32 mutableInt;
                    private byte[] expectedTypes;
                    private int limit;
                    {
                        super(context, eval0, eval1, eval2, eval3, funcID, sourceLoc);
                        this.emptyFlags = UTF8StringPointable.generateUTF8Pointable((String)"");
                        this.matcher = new RegExpMatcher();
                        this.mutableInt = new AMutableInt32(0);
                    }

                    @Override
                    protected boolean processArgument(int argIdx, IPointable argPtr, UTF8StringPointable outStrPtr) throws HyracksDataException {
                        if (argIdx == 3) {
                            int start;
                            byte[] bytes = argPtr.getByteArray();
                            ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[start = argPtr.getStartOffset()]];
                            if (ATypeHierarchy.getTypeDomain((ATypeTag)tt) != ATypeHierarchy.Domain.NUMERIC && tt != ATypeTag.STRING) {
                                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)bytes[start], (int)argIdx, (byte[])this.getExpectedTypes());
                                return false;
                            }
                            switch (tt) {
                                case TINYINT: 
                                case SMALLINT: 
                                case INTEGER: 
                                case BIGINT: 
                                case FLOAT: 
                                case DOUBLE: {
                                    if (!ArgumentUtils.setInteger(ctx, this.sourceLoc, this.funcID, argIdx, bytes, start, this.mutableInt)) {
                                        return false;
                                    }
                                    this.limit = this.mutableInt.getIntegerValue();
                                    outStrPtr.set((IValueReference)this.emptyFlags);
                                    return true;
                                }
                            }
                            this.limit = Integer.MAX_VALUE;
                        }
                        return super.processArgument(argIdx, argPtr, outStrPtr);
                    }

                    @Override
                    protected String compute(UTF8StringPointable srcPtr, UTF8StringPointable patternPtr, UTF8StringPointable replacePtr, UTF8StringPointable flagsPtr) throws IOException {
                        this.matcher.build(srcPtr, patternPtr, flagsPtr);
                        return this.matcher.replace(replacePtr, this.limit);
                    }

                    private byte[] getExpectedTypes() {
                        if (this.expectedTypes == null) {
                            this.expectedTypes = Arrays.copyOf(ArgumentUtils.NUMERIC_TYPES, ArgumentUtils.NUMERIC_TYPES.length + 1);
                            this.expectedTypes[this.expectedTypes.length - 1] = ATypeTag.SERIALIZED_STRING_TYPE_TAG;
                        }
                        return this.expectedTypes;
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_REGEXP_REPLACE_WITH_FLAG;
    }
}

