/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.transaction;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.common.transactions.IResourceIdManager;

public class ResourceIdManager
implements IResourceIdManager {
    private final IClusterStateManager csm;
    private final AtomicLong globalResourceId = new AtomicLong();
    private Set<String> reportedNodes = ConcurrentHashMap.newKeySet();

    public ResourceIdManager(IClusterStateManager csm) {
        this.csm = csm;
    }

    public long createResourceId() {
        return this.readyState() ? this.globalResourceId.incrementAndGet() : -1L;
    }

    protected boolean readyState() {
        return this.csm.isClusterActive() || this.reportedNodes.containsAll(this.csm.getParticipantNodes(true));
    }

    public boolean reported(String nodeId) {
        return this.reportedNodes.contains(nodeId);
    }

    public void report(String nodeId, long maxResourceId) {
        this.globalResourceId.updateAndGet(prev -> Math.max(maxResourceId, prev));
        this.reportedNodes.add(nodeId);
    }

    public long createResourceIdBlock(int blockSize) {
        return this.readyState() ? this.globalResourceId.getAndAdd(blockSize) + 1L : -1L;
    }
}

