/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.ipc;

import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.DeployedJobSpecId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.deployment.DeploymentStatus;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.job.PartitionDescriptor;
import org.apache.hyracks.control.common.job.PartitionRequest;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.ipc.api.IIPCHandle;

public class ClusterControllerRemoteProxy
implements IClusterController {
    private IIPCHandle ipcHandle;

    public ClusterControllerRemoteProxy(IIPCHandle ipcHandle) {
        this.ipcHandle = ipcHandle;
    }

    @Override
    public void registerNode(NodeRegistration reg, int registrationId) throws Exception {
        CCNCFunctions.RegisterNodeFunction fn = new CCNCFunctions.RegisterNodeFunction(reg, registrationId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void unregisterNode(String nodeId) throws Exception {
        CCNCFunctions.UnregisterNodeFunction fn = new CCNCFunctions.UnregisterNodeFunction(nodeId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyTaskComplete(JobId jobId, TaskAttemptId taskId, String nodeId, TaskProfile statistics) throws Exception {
        CCNCFunctions.NotifyTaskCompleteFunction fn = new CCNCFunctions.NotifyTaskCompleteFunction(jobId, taskId, nodeId, statistics);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyTaskFailure(JobId jobId, TaskAttemptId taskId, String nodeId, List<Exception> exceptions) throws Exception {
        CCNCFunctions.NotifyTaskFailureFunction fn = new CCNCFunctions.NotifyTaskFailureFunction(jobId, taskId, nodeId, exceptions);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyJobletCleanup(JobId jobId, String nodeId) throws Exception {
        CCNCFunctions.NotifyJobletCleanupFunction fn = new CCNCFunctions.NotifyJobletCleanupFunction(jobId, nodeId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyDeployBinary(DeploymentId deploymentId, String nodeId, DeploymentStatus status) throws Exception {
        CCNCFunctions.NotifyDeployBinaryFunction fn = new CCNCFunctions.NotifyDeployBinaryFunction(deploymentId, nodeId, status);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void nodeHeartbeat(String id, HeartbeatData hbData, InetSocketAddress ncAddress) throws Exception {
        CCNCFunctions.NodeHeartbeatFunction fn = new CCNCFunctions.NodeHeartbeatFunction(id, hbData, ncAddress);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void reportProfile(String id, List<JobProfile> profiles) throws Exception {
        CCNCFunctions.ReportProfileFunction fn = new CCNCFunctions.ReportProfileFunction(id, profiles);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void registerPartitionProvider(PartitionDescriptor partitionDescriptor) throws Exception {
        CCNCFunctions.RegisterPartitionProviderFunction fn = new CCNCFunctions.RegisterPartitionProviderFunction(partitionDescriptor);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void registerPartitionRequest(PartitionRequest partitionRequest) throws Exception {
        CCNCFunctions.RegisterPartitionRequestFunction fn = new CCNCFunctions.RegisterPartitionRequestFunction(partitionRequest);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void sendApplicationMessageToCC(byte[] data, DeploymentId deploymentId, String nodeId) throws Exception {
        CCNCFunctions.SendApplicationMessageFunction fn = new CCNCFunctions.SendApplicationMessageFunction(data, deploymentId, nodeId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void registerResultPartitionLocation(JobId jobId, ResultSetId rsId, IResultMetadata metadata, boolean emptyResult, int partition, int nPartitions, NetworkAddress networkAddress) throws Exception {
        CCNCFunctions.RegisterResultPartitionLocationFunction fn = new CCNCFunctions.RegisterResultPartitionLocationFunction(jobId, rsId, metadata, emptyResult, partition, nPartitions, networkAddress);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void reportResultPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) throws Exception {
        CCNCFunctions.ReportResultPartitionWriteCompletionFunction fn = new CCNCFunctions.ReportResultPartitionWriteCompletionFunction(jobId, rsId, partition);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyDeployedJobSpecFailure(DeployedJobSpecId deployedJobSpecId, String nodeId) throws Exception {
        CCNCFunctions.ReportDeployedJobSpecFailureFunction fn = new CCNCFunctions.ReportDeployedJobSpecFailureFunction(deployedJobSpecId, nodeId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void getNodeControllerInfos() throws Exception {
        this.ipcHandle.send(-1L, (Object)new CCNCFunctions.GetNodeControllersInfoFunction(), null);
    }

    @Override
    public void notifyStateDump(String nodeId, String stateDumpId, String state) throws Exception {
        CCNCFunctions.StateDumpResponseFunction fn = new CCNCFunctions.StateDumpResponseFunction(nodeId, stateDumpId, state);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyShutdown(String nodeId) throws Exception {
        CCNCFunctions.ShutdownResponseFunction sdrf = new CCNCFunctions.ShutdownResponseFunction(nodeId);
        this.ipcHandle.send(-1L, (Object)sdrf, null);
    }

    @Override
    public void notifyThreadDump(String nodeId, String requestId, String threadDumpJSON) throws Exception {
        CCNCFunctions.ThreadDumpResponseFunction tdrf = new CCNCFunctions.ThreadDumpResponseFunction(nodeId, requestId, threadDumpJSON);
        this.ipcHandle.send(-1L, (Object)tdrf, null);
    }

    @Override
    public void notifyPingResponse(String nodeId) throws Exception {
        CCNCFunctions.PingResponseFunction fn = new CCNCFunctions.PingResponseFunction(nodeId);
        this.ipcHandle.send(-1L, (Object)fn, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.ipcHandle.getRemoteAddress() + "]";
    }
}

