/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.result;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.api.IResponseFieldPrinter;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.translator.SessionOutput;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ResponsePrinter
implements IResponsePrinter {
    private final SessionOutput sessionOutput;
    private final List<IResponseFieldPrinter> headers = new ArrayList<IResponseFieldPrinter>();
    private final List<IResponseFieldPrinter> results = new ArrayList<IResponseFieldPrinter>();
    private final List<IResponseFieldPrinter> footers = new ArrayList<IResponseFieldPrinter>();
    private boolean headersPrinted = false;
    private boolean resultsPrinted = false;

    public ResponsePrinter(SessionOutput sessionOutput) {
        this.sessionOutput = sessionOutput;
    }

    public void begin() {
        this.sessionOutput.hold();
        this.sessionOutput.out().print("{\n");
    }

    public void addHeaderPrinter(IResponseFieldPrinter printer) {
        this.headers.add(printer);
    }

    public void addResultPrinter(IResponseFieldPrinter printer) {
        this.results.add(printer);
    }

    public void addFooterPrinter(IResponseFieldPrinter printer) {
        this.footers.add(printer);
    }

    public void printHeaders() throws HyracksDataException {
        this.print(this.headers);
        this.headersPrinted = !this.headers.isEmpty();
    }

    public void printResults() throws HyracksDataException {
        this.sessionOutput.release();
        this.print(this.results);
        if (!this.resultsPrinted) {
            this.resultsPrinted = !this.results.isEmpty();
        }
        this.results.clear();
    }

    public void printFooters() throws HyracksDataException {
        this.print(this.footers);
    }

    public void end() {
        this.sessionOutput.out().print("\n}\n");
        this.sessionOutput.release();
        this.sessionOutput.out().flush();
    }

    private void print(List<IResponseFieldPrinter> printers) throws HyracksDataException {
        int fieldsCount = printers.size();
        if ((this.headersPrinted || this.resultsPrinted) && fieldsCount > 0) {
            ResponsePrinter.printFieldSeparator(this.sessionOutput.out());
        }
        for (int i = 0; i < printers.size(); ++i) {
            IResponseFieldPrinter printer = printers.get(i);
            printer.print(this.sessionOutput.out());
            if (i + 1 == fieldsCount) continue;
            ResponsePrinter.printFieldSeparator(this.sessionOutput.out());
        }
    }

    public static void printFieldSeparator(PrintWriter pw) {
        pw.print(",\n");
    }
}

