/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.wicket.markup.head.AbstractJavaScriptReferenceHeaderItem;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class JavaScriptUrlReferenceHeaderItem
extends AbstractJavaScriptReferenceHeaderItem {
    private final String url;

    public JavaScriptUrlReferenceHeaderItem(String url, String id) {
        this.url = url;
        this.setId(id);
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void render(Response response) {
        this.internalRenderJavaScriptReference(response, UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get()));
    }

    @Override
    public Iterable<?> getRenderTokens() {
        String url = UrlUtils.rewriteToContextRelative((String)this.getUrl(), (IRequestCycle)RequestCycle.get());
        if (Strings.isEmpty((String)this.getId())) {
            return Collections.singletonList("javascript-" + url);
        }
        return Arrays.asList("javascript-" + this.getId(), "javascript-" + url);
    }

    public String toString() {
        return "JavaScriptUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaScriptUrlReferenceHeaderItem that = (JavaScriptUrlReferenceHeaderItem)o;
        return Objects.equals(this.url, that.url);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }
}

