/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.http2;

import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.http2.markup.head.NoopPushBuilder;
import org.apache.wicket.http2.markup.head.PushBuilder;
import org.apache.wicket.util.lang.Args;

public class Http2Settings {
    private static final MetaDataKey<Http2Settings> KEY = new MetaDataKey<Http2Settings>(){
        private static final long serialVersionUID = 1L;
    };
    private PushBuilder pushBuilder = NoopPushBuilder.INSTANCE;

    public Http2Settings setPushBuilder(PushBuilder pushBuilder) {
        this.pushBuilder = (PushBuilder)Args.notNull((Object)pushBuilder, (String)"pushBuilder");
        return this;
    }

    public PushBuilder getPushBuilder() {
        return this.pushBuilder;
    }

    public static final class Holder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Http2Settings get(Application application) {
            Http2Settings settings = (Http2Settings)application.getMetaData(KEY);
            if (settings == null) {
                Application application2 = application;
                synchronized (application2) {
                    if (settings == null) {
                        settings = new Http2Settings();
                        Holder.set(application, settings);
                    }
                }
            }
            return settings;
        }

        public static void set(Application application, Http2Settings settings) {
            application.setMetaData(KEY, (Object)settings);
        }
    }
}

