/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authroles.authentication;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;

public abstract class AuthenticatedWebApplication
extends WebApplication
implements IRoleCheckingStrategy,
IUnauthorizedComponentInstantiationListener {
    protected void init() {
        super.init();
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy(this));
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)this);
    }

    @Override
    public final boolean hasAnyRole(Roles roles) {
        Roles sessionRoles = AbstractAuthenticatedWebSession.get().getRoles();
        return sessionRoles != null && sessionRoles.hasAnyRole(roles);
    }

    public final void onUnauthorizedInstantiation(Component component) {
        if (component instanceof Page) {
            if (!AbstractAuthenticatedWebSession.get().isSignedIn()) {
                this.restartResponseAtSignInPage();
            } else {
                this.onUnauthorizedPage(component);
            }
        } else {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
    }

    public void restartResponseAtSignInPage() {
        throw new RestartResponseAtInterceptPageException(this.getSignInPageClass());
    }

    public Session newSession(Request request, Response response) {
        Class<? extends AbstractAuthenticatedWebSession> webSessionClass = this.getWebSessionClass();
        try {
            return (Session)webSessionClass.getDeclaredConstructor(Request.class).newInstance(request);
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Unable to instantiate web session " + String.valueOf(webSessionClass), (Throwable)e);
        }
    }

    protected abstract Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass();

    protected abstract Class<? extends WebPage> getSignInPageClass();

    protected void onUnauthorizedPage(Component page) {
        throw new UnauthorizedInstantiationException(page.getClass());
    }
}

