/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.request.IWritableRequestParameters;
import org.apache.wicket.util.string.StringValue;

public class MockRequestParameters
implements IWritableRequestParameters {
    private final Map<String, List<StringValue>> parameters = new HashMap<String, List<StringValue>>();

    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    public StringValue getParameterValue(String name) {
        List<StringValue> values = this.parameters.get(name);
        return values != null && !values.isEmpty() ? values.get(0) : StringValue.valueOf((String)null);
    }

    public List<StringValue> getParameterValues(String name) {
        List<StringValue> values = this.parameters.get(name);
        return values != null ? Collections.unmodifiableList(values) : null;
    }

    public void setParameterValues(String name, List<StringValue> values) {
        this.parameters.put(name, values);
    }

    public void setParameterValue(String name, String value) {
        ArrayList<StringValue> list = new ArrayList<StringValue>(1);
        list.add(StringValue.valueOf((String)value));
        this.parameters.put(name, list);
    }

    public void addParameterValue(String name, String value) {
        List<StringValue> list = this.parameters.get(name);
        if (list == null) {
            list = new ArrayList<StringValue>(1);
            this.parameters.put(name, list);
        }
        list.add(StringValue.valueOf((String)value));
    }

    public void reset() {
        this.parameters.clear();
    }
}

