/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;

public class ClassLoaderOrder {
    private final List<Map.Entry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>> classLoaderOrder = new ArrayList<Map.Entry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>>();
    private final Set<ClassLoader> added = new HashSet<ClassLoader>();
    private final Set<ClassLoader> delegatedTo = new HashSet<ClassLoader>();
    private final Set<ClassLoader> allParentClassLoaders = new HashSet<ClassLoader>();
    private final Map<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> classLoaderToClassLoaderHandlerRegistryEntry = new HashMap<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>();

    public List<Map.Entry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>> getClassLoaderOrder() {
        return this.classLoaderOrder;
    }

    public Set<ClassLoader> getAllParentClassLoaders() {
        return this.allParentClassLoaders;
    }

    private ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry getRegistryEntry(ClassLoader classLoader) {
        ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry entry = this.classLoaderToClassLoaderHandlerRegistryEntry.get(classLoader);
        if (entry == null) {
            for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry handler : ClassLoaderHandlerRegistry.CLASS_LOADER_HANDLERS) {
                if (!handler.canHandle(classLoader)) continue;
                entry = handler;
                break;
            }
            if (entry == null) {
                entry = ClassLoaderHandlerRegistry.FALLBACK_HANDLER;
            }
            this.classLoaderToClassLoaderHandlerRegistryEntry.put(classLoader, entry);
        }
        return entry;
    }

    public void add(ClassLoader classLoader) {
        ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry entry;
        if (classLoader == null) {
            return;
        }
        if (this.added.add(classLoader) && (entry = this.getRegistryEntry(classLoader)) != null) {
            this.classLoaderOrder.add(new AbstractMap.SimpleEntry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry>(classLoader, entry));
        }
    }

    public void delegateTo(ClassLoader classLoader, boolean isParent) {
        if (classLoader == null) {
            return;
        }
        if (isParent) {
            this.allParentClassLoaders.add(classLoader);
        }
        if (this.delegatedTo.add(classLoader)) {
            ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry entry = this.getRegistryEntry(classLoader);
            entry.findClassLoaderOrder(classLoader, this);
        }
    }
}

