/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.zip;

import aQute.lib.exceptions.Exceptions;
import aQute.lib.exceptions.SupplierWithException;
import aQute.lib.hierarchy.Hierarchy;
import aQute.lib.io.IO;
import aQute.lib.zip.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class JarIndex
extends Hierarchy {
    private static final Pattern PATH_SPLITTER = Pattern.compile("/");

    public JarIndex(InputStream in) throws IOException {
        super(JarIndex.buildFromInputStream(in, null));
    }

    public JarIndex(File in) throws IOException {
        super(JarIndex.build(in, null, null));
    }

    public JarIndex(File in, Pattern doNotCopy) throws IOException {
        super(JarIndex.build(in, doNotCopy, null));
    }

    private static Map<String, Object> build(File file, Pattern doNotCopy, Function<NodeInfo, ?> f) throws IOException {
        if (file.isDirectory()) {
            return JarIndex.buildFromDirectory(file.toPath(), doNotCopy, f);
        }
        if (file.isFile()) {
            return JarIndex.buildFromZip(file, f);
        }
        return null;
    }

    private static Map<String, Object> buildFromDirectory(final Path baseDir, final Pattern doNotCopy, final Function<NodeInfo, ?> f) throws IOException {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        Files.walkFileTree(baseDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String name;
                if (doNotCopy != null && doNotCopy.matcher(name = dir.getFileName().toString()).matches()) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String name;
                if (doNotCopy != null && doNotCopy.matcher(name = file.getFileName().toString()).matches()) {
                    return FileVisitResult.CONTINUE;
                }
                String relativePath = IO.normalizePath(baseDir.relativize(file));
                Object payload = f == null ? null : f.apply(JarIndex.getNodeInfo(file.toFile()));
                JarIndex.addFile(map, relativePath, payload);
                return FileVisitResult.CONTINUE;
            }
        });
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> buildFromZip(File file, Function<NodeInfo, ?> f) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry element = entries.nextElement();
                if (element.isDirectory()) continue;
                Object payload = f == null ? null : JarIndex.getPayload(f, JarIndex.getNodeInfo(element, () -> zipFile.getInputStream(element)));
                JarIndex.addFile(map, ZipUtil.cleanPath(element.getName()), payload);
            }
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        catch (ZipException e) {
            ZipException ze = new ZipException("The JAR/ZIP file (" + file.getAbsolutePath() + ") seems corrupted, error: " + e.getMessage());
            ze.initCause(e);
            throw ze;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Problem opening JAR: " + file.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    private static Map<String, Object> buildFromInputStream(InputStream in, Function<NodeInfo, ?> f) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try (ZipInputStream jin = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = jin.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                Object payload = f == null ? null : f.apply(JarIndex.getNodeInfo(entry, () -> jin));
                JarIndex.addFile(map, ZipUtil.cleanPath(entry.getName()), payload);
            }
        }
        return map;
    }

    private static Object getPayload(Function<NodeInfo, ?> f, NodeInfo nodeInfo) {
        Object o = f.apply(nodeInfo);
        assert (!(o instanceof Map));
        return o;
    }

    private static void addFile(Map<String, Object> map, String path, Object payload) {
        if (path.isEmpty()) {
            return;
        }
        String[] parts = PATH_SPLITTER.split(path);
        JarIndex.addFile(map, parts, 0, path, payload);
    }

    private static void addFile(Map<String, Object> map, String[] parts, int i, String path, Object payload) {
        assert (i < parts.length);
        if (i == parts.length - 1) {
            map.put(parts[i], payload);
        } else {
            Map folder = (Map)map.computeIfAbsent(parts[i], k -> new HashMap());
            JarIndex.addFile(folder, parts, i + 1, null, payload);
        }
    }

    private static NodeInfo getNodeInfo(final File in) {
        return new NodeInfo(){

            @Override
            public InputStream open() throws IOException {
                return new FileInputStream(in);
            }

            @Override
            public long lastModified() {
                return in.lastModified();
            }

            @Override
            public long size() {
                return in.length();
            }

            @Override
            public Optional<File> file() {
                return Optional.of(in);
            }
        };
    }

    private static NodeInfo getNodeInfo(final ZipEntry entry, final SupplierWithException<InputStream> open) {
        return new NodeInfo(){

            @Override
            public InputStream open() throws IOException {
                try {
                    return (InputStream)open.get();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }

            @Override
            public long lastModified() {
                return ZipUtil.getModifiedTime(entry);
            }

            @Override
            public long size() {
                return entry.getSize();
            }

            @Override
            public Optional<File> file() {
                return Optional.empty();
            }
        };
    }

    public static interface NodeInfo {
        public InputStream open() throws IOException, Exception;

        public Optional<File> file();

        public long size();

        public long lastModified();
    }
}

