/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.util.Calendar;
import java.util.Map;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;

public interface DDLPlatform {
    public static final FieldDefinition.DatabaseType TYPE_BLOB = new FieldDefinition.DatabaseType("BLOB");
    public static final FieldDefinition.DatabaseType TYPE_CLOB = new FieldDefinition.DatabaseType("CLOB");
    public static final FieldDefinition.DatabaseType TYPE_DATE = new FieldDefinition.DatabaseType("DATE");
    public static final FieldDefinition.DatabaseType TYPE_TIME = new FieldDefinition.DatabaseType("TIME");
    public static final FieldDefinition.DatabaseType TYPE_TIMESTAMP = new FieldDefinition.DatabaseType("TIMESTAMP");
    public static final FieldDefinition.DatabaseType TYPE_CHAR = new FieldDefinition.DatabaseType("CHAR");
    public static final FieldDefinition.DatabaseType TYPE_VARCHAR = new FieldDefinition.DatabaseType("VARCHAR");
    public static final FieldDefinition.DatabaseType TYPE_BOOLEAN = new FieldDefinition.DatabaseType("NUMBER", 1);
    public static final FieldDefinition.DatabaseType TYPE_INTEGER = new FieldDefinition.DatabaseType("NUMBER", 10);
    public static final FieldDefinition.DatabaseType TYPE_LONG = new FieldDefinition.DatabaseType("NUMBER", 19);
    public static final FieldDefinition.DatabaseType TYPE_FLOAT = new FieldDefinition.DatabaseType("NUMBER", 12, 5, 19, 0, 19);
    public static final FieldDefinition.DatabaseType TYPE_DOUBLE = new FieldDefinition.DatabaseType("NUMBER", 10, 5, 19, 0, 19);
    public static final FieldDefinition.DatabaseType TYPE_SHORT = new FieldDefinition.DatabaseType("NUMBER", 5);
    public static final FieldDefinition.DatabaseType TYPE_BYTE = new FieldDefinition.DatabaseType("NUMBER", 3);
    public static final FieldDefinition.DatabaseType TYPE_BIG_DECIMAL = new FieldDefinition.DatabaseType("NUMBER", 19, 0, 19, 0, 19);
    public static final FieldDefinition.DatabaseType TYPE_BIG_INTEGER = new FieldDefinition.DatabaseType("NUMBER", 19);
    public static final Map<Class<?>, FieldDefinition.DatabaseType> DB_TYPES = Map.ofEntries(Map.entry(Boolean.class, TYPE_BOOLEAN), Map.entry(Integer.class, TYPE_INTEGER), Map.entry(Long.class, TYPE_LONG), Map.entry(Float.class, TYPE_FLOAT), Map.entry(Double.class, TYPE_DOUBLE), Map.entry(Short.class, TYPE_SHORT), Map.entry(Byte.class, TYPE_BYTE), Map.entry(Number.class, TYPE_INTEGER), Map.entry(BigDecimal.class, TYPE_BIG_DECIMAL), Map.entry(BigInteger.class, TYPE_BIG_INTEGER), Map.entry(String.class, TYPE_VARCHAR), Map.entry(Character.class, TYPE_CHAR), Map.entry(Byte[].class, TYPE_BLOB), Map.entry(Character[].class, TYPE_CLOB), Map.entry(byte[].class, TYPE_BLOB), Map.entry(char[].class, TYPE_CLOB), Map.entry(Blob.class, TYPE_BLOB), Map.entry(Clob.class, TYPE_CLOB), Map.entry(Date.class, TYPE_DATE), Map.entry(Timestamp.class, TYPE_TIMESTAMP), Map.entry(Time.class, TYPE_TIME), Map.entry(Instant.class, TYPE_TIMESTAMP), Map.entry(LocalDate.class, TYPE_DATE), Map.entry(LocalDateTime.class, TYPE_TIMESTAMP), Map.entry(LocalTime.class, TYPE_TIME), Map.entry(OffsetDateTime.class, TYPE_TIMESTAMP), Map.entry(OffsetTime.class, TYPE_TIME), Map.entry(Year.class, TYPE_INTEGER), Map.entry(Calendar.class, TYPE_TIMESTAMP), Map.entry(java.util.Date.class, TYPE_TIMESTAMP));
    public static final Map<String, Class<?>> CLASS_TYPES = Map.ofEntries(Map.entry("NUMBER", BigInteger.class), Map.entry("DECIMAL", BigDecimal.class), Map.entry("INTEGER", Integer.class), Map.entry("INT", Integer.class), Map.entry("NUMERIC", BigInteger.class), Map.entry("FLOAT(16)", Float.class), Map.entry("FLOAT(32)", Double.class), Map.entry("NUMBER(1) default 0", Boolean.class), Map.entry("SHORT", Short.class), Map.entry("BYTE", Byte.class), Map.entry("DOUBLE", Double.class), Map.entry("FLOAT", Float.class), Map.entry("SMALLINT", Short.class), Map.entry("BIT", Boolean.class), Map.entry("SMALLINT DEFAULT 0", Boolean.class), Map.entry("VARCHAR", String.class), Map.entry("CHAR", Character.class), Map.entry("LONGVARBINARY", Byte[].class), Map.entry("TEXT", Character[].class), Map.entry("LONGTEXT", Character[].class), Map.entry("MEMO", Character[].class), Map.entry("VARCHAR2", String.class), Map.entry("LONG RAW", Byte[].class), Map.entry("LONG", Character[].class), Map.entry("DATE", Date.class), Map.entry("TIMESTAMP", Timestamp.class), Map.entry("TIME", Time.class), Map.entry("DATETIME", Timestamp.class), Map.entry("BIGINT", BigInteger.class), Map.entry("DOUBLE PRECIS", Double.class), Map.entry("IMAGE", Byte[].class), Map.entry("LONGVARCHAR", Character[].class), Map.entry("REAL", Float.class), Map.entry("TINYINT", Short.class), Map.entry("BLOB", Byte[].class), Map.entry("CLOB", Character[].class));

    default public Map<String, Class<?>> getJavaTypes() {
        return CLASS_TYPES;
    }

    default public Map<Class<?>, FieldDefinition.DatabaseType> getDatabaseTypes() {
        return DB_TYPES;
    }

    default public FieldDefinition.DatabaseType getDatabaseType(String typeName) {
        Class<?> typeFromName = this.getJavaTypes().get(typeName);
        if (typeFromName == null) {
            return new FieldDefinition.DatabaseType(typeName);
        }
        return this.getDatabaseType(typeFromName);
    }

    default public FieldDefinition.DatabaseType getDatabaseType(Class<?> type) {
        return this.getDatabaseTypes().get(type);
    }

    default public String buildCreateIndex(String fullTableName, String indexName, String qualifier, boolean isUnique, String ... columnNames) {
        StringBuilder queryString = new StringBuilder();
        if (isUnique) {
            queryString.append("CREATE UNIQUE INDEX ");
        } else {
            queryString.append("CREATE INDEX ");
        }
        if (!qualifier.isEmpty()) {
            queryString.append(qualifier).append(".");
        }
        queryString.append(indexName).append(" ON ").append(fullTableName).append(" (");
        queryString.append(columnNames[0]);
        for (int i = 1; i < columnNames.length; ++i) {
            queryString.append(", ").append(columnNames[i]);
        }
        queryString.append(")");
        return queryString.toString();
    }

    default public String buildDropIndex(String fullTableName, String indexName, String qualifier) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("DROP INDEX ");
        if (!qualifier.isEmpty()) {
            queryString.append(qualifier).append(".");
        }
        queryString.append(indexName);
        if (this.requiresTableInIndexDropDDL()) {
            queryString.append(" ON ").append(fullTableName);
        }
        return queryString.toString();
    }

    default public Writer buildSequenceObjectAlterIncrementWriter(Writer writer, String fullSeqName, int increment) throws IOException {
        writer.write("ALTER SEQUENCE ");
        writer.write(fullSeqName);
        writer.write(" INCREMENT BY " + increment);
        return writer;
    }

    default public Writer buildSequenceObjectCreationWriter(Writer writer, String fullSeqName, int increment, int start) throws IOException {
        writer.write("CREATE SEQUENCE ");
        writer.write(fullSeqName);
        if (increment != 1) {
            writer.write(" INCREMENT BY " + increment);
        }
        writer.write(" START WITH " + start);
        return writer;
    }

    default public Writer buildSequenceObjectDeletionWriter(Writer writer, String fullSeqName) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(fullSeqName);
        return writer;
    }

    default public String getBatchBeginString() {
        return "";
    }

    default public String getBatchDelimiterString() {
        return "; ";
    }

    default public String getBatchEndString() {
        return "";
    }

    default public String getCreateViewString() {
        return "CREATE VIEW ";
    }

    default public String getDropCascadeString() {
        return "";
    }

    default public String getIndexNamePrefix(boolean isUniqueSetOnField) {
        return "IX_";
    }

    default public int getMaxFieldNameSize() {
        return 50;
    }

    default public int getMaxIndexNameSize() {
        return this.getMaxFieldNameSize();
    }

    default public int getMaxUniqueKeyNameSize() {
        return this.getMaxFieldNameSize();
    }

    default public int getMaxForeignKeyNameSize() {
        return this.getMaxFieldNameSize();
    }

    default public String getProcedureAsString() {
        return " AS";
    }

    default public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    default public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    default public String getProcedureOptionList() {
        return "";
    }

    default public String getStoredProcedureTerminationToken() {
        return ";";
    }

    default public boolean isAlterSequenceObjectSupported() {
        return false;
    }

    default public void printFieldIdentityClause(Writer writer) throws IOException {
    }

    default public void printFieldNotNullClause(Writer writer) throws IOException {
        writer.write(" NOT NULL");
    }

    default public void printFieldNullClause(Writer writer) throws IOException {
    }

    default public void printFieldTypeSize(Writer writer, FieldDefinition field, FieldDefinition.DatabaseType databaseType, boolean shouldPrintFieldIdentityClause) throws IOException {
        this.printFieldTypeSize(writer, field, databaseType);
    }

    default public void printFieldTypeSize(Writer writer, FieldDefinition field, FieldDefinition.DatabaseType databaseType) throws IOException {
        writer.write(databaseType.name());
        if (databaseType.allowSize() && (field.getSize() != 0 || databaseType.requireSize())) {
            writer.write("(");
            if (field.getSize() == 0) {
                writer.write(Integer.toString(databaseType.defaultSize()));
            } else {
                writer.write(Integer.toString(field.getSize()));
            }
            if (field.getSubSize() != 0) {
                writer.write(",");
                writer.write(Integer.toString(field.getSubSize()));
            } else if (databaseType.defaultSubSize() != 0) {
                writer.write(",");
                writer.write(Integer.toString(databaseType.defaultSubSize()));
            }
            writer.write(")");
        }
    }

    default public void printFieldUnique(Writer writer, boolean shouldPrintFieldUniqueClause) throws IOException {
        if (this.supportsUniqueKeyConstraints()) {
            writer.write(" UNIQUE");
        }
    }

    default public boolean requiresNamedPrimaryKeyConstraints() {
        return false;
    }

    default public boolean requiresProcedureBrackets() {
        return false;
    }

    default public boolean requiresTableInIndexDropDDL() {
        return false;
    }

    default public boolean requiresUniqueConstraintCreationOnTableCreate() {
        return false;
    }

    default public boolean shouldCreateIndicesForPrimaryKeys() {
        return false;
    }

    default public boolean shouldCreateIndicesOnForeignKeys() {
        return false;
    }

    default public boolean shouldCreateIndicesOnUniqueKeys() {
        return false;
    }

    default public boolean shouldPrintConstraintNameAfter() {
        return false;
    }

    default public boolean shouldPrintStoredProcedureVariablesAfterBeginString() {
        return false;
    }

    default public boolean supportsDeleteOnCascade() {
        return this.supportsForeignKeyConstraints();
    }

    default public boolean supportsForeignKeyConstraints() {
        return true;
    }

    default public boolean supportsUniqueKeyConstraints() {
        return true;
    }

    default public boolean supportsIndexes() {
        return true;
    }

    default public boolean supportsPrimaryKeyConstraint() {
        return true;
    }

    default public boolean supportsStoredFunctions() {
        return false;
    }

    default public boolean supportsUniqueColumns() {
        return true;
    }

    default public void writeTableCreationSuffix(Writer writer, String creationSuffix) throws IOException {
        String defaultTableCreationSuffix;
        if (creationSuffix != null && !creationSuffix.isEmpty()) {
            writer.write(" " + creationSuffix);
        }
        if ((defaultTableCreationSuffix = this.getTableCreationSuffix()) != null && !defaultTableCreationSuffix.isEmpty()) {
            writer.write(" " + defaultTableCreationSuffix);
        }
    }

    default public String getTableCreationSuffix() {
        return "";
    }

    default public String getEndDelimiter() {
        return "";
    }

    default public String getStartDelimiter() {
        return "";
    }

    default public String getCreateDatabaseSchemaString(String schema) {
        return "CREATE SCHEMA " + schema;
    }

    default public String getDropDatabaseSchemaString(String schema) {
        return "DROP SCHEMA " + schema;
    }

    default public boolean shouldPrintOutputTokenBeforeType() {
        return true;
    }

    default public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    default public String getCreationOutputProcedureToken() {
        return this.getOutputProcedureToken();
    }

    default public String getOutputProcedureToken() {
        return "OUT";
    }

    default public String getProcedureArgumentString() {
        return "";
    }

    default public boolean allowsSizeInProcedureArguments() {
        return true;
    }

    default public String getInOutputProcedureToken() {
        return "IN OUT";
    }

    default public String getCreationInOutputProcedureToken() {
        return this.getInOutputProcedureToken();
    }

    default public boolean shouldPrintInputTokenAtStart() {
        return false;
    }

    default public String getInputProcedureToken() {
        return "";
    }
}

