/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.attachment.HeaderSizeExceededException;
import org.apache.cxf.common.logging.LogUtils;

final class AttachmentDeserializerUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(AttachmentDeserializer.class);

    private AttachmentDeserializerUtil() {
    }

    static boolean readTillFirstBoundary(PushbackInputStream pushbackInStream, byte[] boundary) throws IOException {
        int value = pushbackInStream.read();
        pushbackInStream.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pushbackInStream.read();
            if ((byte)value != boundary[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < boundary.length && (byte)value == boundary[boundaryIndex]; ++boundaryIndex) {
                value = pushbackInStream.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End while searching for first Mime Boundary");
            }
            if (boundaryIndex != boundary.length) continue;
            if (value == 13) {
                pushbackInStream.read();
            }
            return true;
        }
        return false;
    }

    static Map<String, List<String>> loadPartHeaders(InputStream in, int maxHeaderLength) throws IOException {
        StringBuilder buffer = new StringBuilder(128);
        StringBuilder b = new StringBuilder(128);
        TreeMap<String, List<String>> heads = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        while (AttachmentDeserializerUtil.readLine(in, b, maxHeaderLength)) {
            char c = b.charAt(0);
            if (c == ' ' || c == '\t') {
                if (buffer.length() == 0) continue;
                buffer.append("\r\n");
                buffer.append((CharSequence)b);
                continue;
            }
            if (buffer.length() > 0) {
                AttachmentDeserializerUtil.addHeaderLine(heads, buffer);
                buffer.setLength(0);
            }
            buffer.append((CharSequence)b);
        }
        if (buffer.length() > 0) {
            AttachmentDeserializerUtil.addHeaderLine(heads, buffer);
        }
        return heads;
    }

    private static boolean readLine(InputStream in, StringBuilder buffer, int maxHeaderLength) throws IOException {
        int c;
        if (buffer.length() != 0) {
            buffer.setLength(0);
        }
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13) continue;
            buffer.append((char)c);
            if (buffer.length() <= maxHeaderLength) continue;
            LOG.fine("The attachment header size has exceeded the configured parameter: " + maxHeaderLength);
            throw new HeaderSizeExceededException();
        }
        return buffer.length() != 0;
    }

    private static void addHeaderLine(Map<String, List<String>> heads, StringBuilder line) {
        String name;
        int size = line.length();
        if (size == 0) {
            return;
        }
        int separator = line.indexOf(":");
        String value = "";
        if (separator == -1) {
            name = line.toString().trim();
        } else {
            char ch;
            name = line.substring(0, separator);
            ++separator;
            while (separator < size && ((ch = line.charAt(separator)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n')) {
                ++separator;
            }
            value = line.substring(separator);
        }
        List v = heads.computeIfAbsent(name, k -> new ArrayList(1));
        v.add(value);
    }
}

