/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.openejb.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -1231831954703408316L;
    private long n;
    private double value;

    public Sum() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Sum(Sum original) {
        Sum.copy(original, this);
    }

    @Override
    public void increment(double d) {
        this.value = this.n == 0L ? d : (this.value += d);
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values, begin, length)) {
            sum = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sum += values[i];
            }
        }
        return sum;
    }

    public double evaluate(double[] values, double[] weights, int begin, int length) {
        double sum = Double.NaN;
        if (this.test(values, weights, begin, length)) {
            sum = 0.0;
            for (int i = begin; i < begin + length; ++i) {
                sum += values[i] * weights[i];
            }
        }
        return sum;
    }

    public double evaluate(double[] values, double[] weights) {
        return this.evaluate(values, weights, 0, values.length);
    }

    @Override
    public Sum copy() {
        Sum result = new Sum();
        Sum.copy(this, result);
        return result;
    }

    public static void copy(Sum source, Sum dest) {
        dest.n = source.n;
        dest.value = source.value;
    }
}

