/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpListenerRegistry;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;

public class FilterListener
implements HttpListener {
    private final String context;
    private final Filter delegate;

    public FilterListener(Filter filter, String contextRoot) {
        this.delegate = filter;
        this.context = contextRoot;
    }

    @Override
    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        HttpServletRequest delegate;
        HttpRequestImpl req = null;
        if (request instanceof HttpRequestImpl) {
            req = (HttpRequestImpl)request;
        } else if (request instanceof ServletRequestAdapter && (delegate = ((ServletRequestAdapter)request).getRequest()) instanceof HttpRequestImpl) {
            req = (HttpRequestImpl)delegate;
        }
        if (req != null) {
            req.initPathFromContext((!this.context.startsWith("/") ? "/" : "") + this.context);
        }
        this.delegate.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new SimpleFilterChain(this));
    }

    public Filter getDelegate() {
        return this.delegate;
    }

    private static class SimpleFilterChain
    implements FilterChain {
        private final FilterListener origin;

        private SimpleFilterChain(FilterListener origin) {
            this.origin = origin;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            HttpListenerRegistry registry = (HttpListenerRegistry)SystemInstance.get().getComponent(HttpListenerRegistry.class);
            registry.setOrigin(this.origin);
            try {
                registry.onMessage(HttpRequest.class.isInstance(request) ? (HttpRequest)HttpRequest.class.cast(request) : new ServletRequestAdapter((HttpServletRequest)HttpServletRequest.class.cast(request)), HttpResponse.class.isInstance(response) ? (HttpResponse)HttpResponse.class.cast(response) : new ServletResponseAdapter((HttpServletResponse)HttpServletResponse.class.cast(response)));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (ServletException e) {
                Throwable cause = e.getCause();
                if (RuntimeException.class.isInstance(cause)) {
                    throw (RuntimeException)RuntimeException.class.cast(cause);
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                registry.setOrigin(this.origin);
            }
        }
    }
}

