/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis;

import jakarta.resource.cci.MappedRecord;
import jakarta.resource.cci.Record;
import java.lang.reflect.Method;
import org.eclipse.persistence.eis.DOMRecord;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.w3c.dom.Element;

public class EISDOMRecord
extends org.eclipse.persistence.oxm.record.DOMRecord
implements DOMRecord,
MappedRecord {
    protected Record record;
    protected String recordName;
    protected String recordShortDescription;
    protected static Method domMethod;

    public EISDOMRecord() {
        this.setRecordName("");
        this.setRecordShortDescription("");
    }

    public EISDOMRecord(Record record, Element dom) {
        super(dom);
        this.record = record;
        this.recordName = record.getRecordName();
        this.recordShortDescription = record.getRecordShortDescription();
        if (record instanceof XMLRecord) {
            this.session = ((XMLRecord)record).getSession();
        }
    }

    public EISDOMRecord(Element dom) {
        super(dom);
        this.recordName = "";
        this.recordShortDescription = "";
    }

    public EISDOMRecord(Record record) {
        this.record = record;
        this.recordName = record.getRecordName();
        this.recordShortDescription = record.getRecordShortDescription();
        if (record instanceof XMLRecord) {
            this.session = ((XMLRecord)record).getSession();
        }
        if (domMethod == null) {
            try {
                domMethod = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(record.getClass(), "getDom", null, false));
            }
            catch (Exception notFound) {
                domMethod = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(record.getClass(), "getDOM", null, false), EISException::new);
            }
        }
        PrivilegedAccessHelper.callDoPrivilegedWithException(() -> {
            this.setDOM((Element)PrivilegedAccessHelper.invokeMethod(domMethod, record, null));
            return null;
        }, EISException::new);
    }

    public Record getRecord() {
        return this.record;
    }

    public void setRecord(Record record) {
        this.record = record;
        this.recordName = record.getRecordName();
        this.recordShortDescription = record.getRecordShortDescription();
        if (record instanceof XMLRecord) {
            this.session = ((XMLRecord)record).getSession();
        }
    }

    public String getRecordShortDescription() {
        return this.recordShortDescription;
    }

    public void setRecordShortDescription(String recordShortDescription) {
        this.recordShortDescription = recordShortDescription;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    @Override
    public XMLRecord buildNestedRow(Element element) {
        if (this.getRecord() != null) {
            return new EISDOMRecord(this.getRecord(), element);
        }
        return new EISDOMRecord(element);
    }
}

