/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.keys;

import java.security.Key;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.tomee.microprofile.jwt.keys.KeyResolver;

public class PublicKeys
implements Supplier<Map<String, Key>> {
    final Optional<String> contents;
    final Optional<String> location;

    public PublicKeys(Optional<String> contents, Optional<String> location) {
        this.contents = contents;
        this.location = location;
    }

    @Override
    public Map<String, Key> get() {
        KeyResolver resolver = new KeyResolver();
        return resolver.resolvePublicKey(this.contents, this.location).orElse(Collections.EMPTY_MAP);
    }

    public String toString() {
        if (this.contents.isPresent()) {
            return "PublicKeys{contents=" + this.contents.get().length() + " bytes}";
        }
        if (this.location.isPresent()) {
            return "PublicKeys{location=" + this.location.get() + "}";
        }
        return "PublicKeys{contents=<empty>, location=<empty>}";
    }
}

