/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractLocationConfigSourceFactory;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.ConfigValidator;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.Converters;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.Expressions;
import io.smallrye.config.ProfileConfigSourceFactory;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertyName;
import io.smallrye.config.SecretKeys;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigSources;
import io.smallrye.config._private.ConfigLogging;
import io.smallrye.config._private.ConfigMessages;
import io.smallrye.config.common.utils.StringUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    public static final String SMALLRYE_CONFIG_PROFILE = "smallrye.config.profile";
    public static final String SMALLRYE_CONFIG_PROFILE_PARENT = "smallrye.config.profile.parent";
    public static final String SMALLRYE_CONFIG_LOCATIONS = "smallrye.config.locations";
    public static final String SMALLRYE_CONFIG_MAPPING_VALIDATE_UNKNOWN = "smallrye.config.mapping.validate-unknown";
    public static final String SMALLRYE_CONFIG_SECRET_HANDLERS = "smallrye.config.secret-handlers";
    public static final String SMALLRYE_CONFIG_LOG_VALUES = "smallrye.config.log.values";
    private static final long serialVersionUID = 8138651532357898263L;
    private final ConfigSources configSources;
    private final Map<Type, Converter<?>> converters;
    private final Map<Type, Converter<Optional<?>>> optionalConverters = new ConcurrentHashMap();
    private final ConfigValidator configValidator;
    private final Map<Class<?>, Map<String, Object>> mappings;

    SmallRyeConfig(SmallRyeConfigBuilder builder) {
        this.configSources = new ConfigSources(builder);
        this.converters = this.buildConverters(builder);
        this.configValidator = builder.getValidator();
        this.mappings = new ConcurrentHashMap(this.buildMappings(builder));
    }

    private Map<Type, Converter<?>> buildConverters(SmallRyeConfigBuilder builder) {
        HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority> convertersToBuild = new HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority>(builder.getConverters());
        if (builder.isAddDiscoveredConverters()) {
            for (Converter<?> converter : builder.discoverConverters()) {
                Type type = Converters.getConverterType(converter.getClass());
                if (type == null) {
                    throw ConfigMessages.msg.unableToAddConverter(converter);
                }
                SmallRyeConfigBuilder.addConverter(type, converter, convertersToBuild);
            }
        }
        ConcurrentHashMap converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        for (Map.Entry entry : convertersToBuild.entrySet()) {
            converters.put((Type)entry.getKey(), ((SmallRyeConfigBuilder.ConverterWithPriority)entry.getValue()).getConverter());
        }
        converters.put((Type)((Object)ConfigValue.class), Converters.CONFIG_VALUE_CONVERTER);
        return converters;
    }

    Map<Class<?>, Map<String, Object>> buildMappings(SmallRyeConfigBuilder builder) throws ConfigValidationException {
        List<ConfigValidationException.Problem> problems;
        final SmallRyeConfigBuilder.MappingBuilder mappingsBuilder = builder.getMappingsBuilder();
        if (mappingsBuilder.isEmpty()) {
            return Collections.emptyMap();
        }
        ConfigMappingContext context = SecretKeys.doUnlocked(new Supplier<ConfigMappingContext>(){

            @Override
            public ConfigMappingContext get() {
                return new ConfigMappingContext(SmallRyeConfig.this, mappingsBuilder);
            }
        });
        if (this.getOptionalValue(SMALLRYE_CONFIG_MAPPING_VALIDATE_UNKNOWN, Boolean.TYPE).orElse(true).booleanValue()) {
            context.reportUnknown(mappingsBuilder.getIgnoredPaths());
        }
        if (!(problems = context.getProblems()).isEmpty()) {
            throw new ConfigValidationException(problems.toArray(ConfigValidationException.Problem.NO_PROBLEMS));
        }
        return context.getMappings();
    }

    public <T> List<T> getValues(String name, Class<T> propertyType) {
        return this.getValues(name, propertyType, ArrayList::new);
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.requireConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> C getValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            return (C)((Collection)this.getValue(name, Converters.newCollectionConverter(converter, collectionFactory)));
        }
        int indexedOrdinality = Integer.MIN_VALUE;
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            ConfigValue indexed = this.getConfigValue(indexedProperty);
            if (indexed.getConfigSourceOrdinal() >= indexedOrdinality) {
                indexedOrdinality = indexed.getConfigSourceOrdinal();
            }
            collection.add(this.convertValue(indexed, converter));
        }
        ConfigValue commaSeparated = this.getConfigValue(name);
        if (commaSeparated.getValue() == null || indexedOrdinality >= commaSeparated.getConfigSourceOrdinal()) {
            return (C)collection;
        }
        return (C)((Collection)this.getValue(name, Converters.newCollectionConverter(converter, collectionFactory)));
    }

    @Deprecated(forRemoval=true)
    public <T, C extends Collection<T>> C getIndexedValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(name));
        }
        return this.getIndexedValues(indexedProperties, converter, collectionFactory);
    }

    @Deprecated(forRemoval=true)
    private <T, C extends Collection<T>> C getIndexedValues(List<String> indexedProperties, Converter<T> converter, IntFunction<C> collectionFactory) {
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            collection.add(this.getValue(indexedProperty, converter));
        }
        return (C)collection;
    }

    public List<String> getIndexedProperties(String property) {
        Map<Integer, String> indexedProperties = this.configSources.getPropertyNames().indexed().get(property);
        return indexedProperties == null ? Collections.emptyList() : indexedProperties.values().stream().toList();
    }

    public List<Integer> getIndexedPropertiesIndexes(String property) {
        Map<Integer, String> indexedProperties = this.configSources.getPropertyNames().indexed().get(property);
        return indexedProperties == null ? Collections.emptyList() : indexedProperties.keySet().stream().toList();
    }

    public <K, V> Map<K, V> getValues(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.getValues(name, this.requireConverter(keyClass), this.requireConverter(valueClass));
    }

    public <K, V> Map<K, V> getValues(String name, Converter<K> keyConverter, Converter<V> valueConverter) {
        return this.getValues(name, keyConverter, valueConverter, HashMap::new);
    }

    public <K, V> Map<K, V> getValues(String name, Converter<K> keyConverter, Converter<V> valueConverter, IntFunction<Map<K, V>> mapFactory) {
        Map<String, String> keys = this.getMapKeys(name);
        if (keys.isEmpty()) {
            return this.getValue(name, Converters.newMapConverter(keyConverter, valueConverter, mapFactory));
        }
        return this.getMapValues(keys, keyConverter, valueConverter, mapFactory);
    }

    public <K, V, C extends Collection<V>> Map<K, C> getValues(String name, Class<K> keyClass, Class<V> valueClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.requireConverter(keyClass), this.requireConverter(valueClass), HashMap::new, collectionFactory);
    }

    public <K, V, C extends Collection<V>> Map<K, C> getValues(String name, Converter<K> keyConverter, Converter<V> valueConverter, IntFunction<Map<K, C>> mapFactory, IntFunction<C> collectionFactory) {
        Map<String, String> keys = this.getMapIndexedKeys(name);
        if (keys.isEmpty()) {
            return this.getValue(name, Converters.newMapConverter(keyConverter, Converters.newCollectionConverter(valueConverter, collectionFactory), mapFactory));
        }
        return this.getMapIndexedValues(keys, keyConverter, valueConverter, mapFactory, collectionFactory);
    }

    public Map<String, String> getMapKeys(String name) {
        HashMap<String, String> keys = new HashMap<String, String>();
        for (String propertyName : this.getPropertyNames()) {
            if (propertyName.length() <= name.length() + 1 || !name.isEmpty() && propertyName.charAt(name.length()) != '.' || !propertyName.startsWith(name)) continue;
            String key = StringUtil.unquoted((String)propertyName, (int)(name.isEmpty() ? 0 : name.length() + 1));
            keys.put(key, propertyName);
        }
        return keys;
    }

    <K, V> Map<K, V> getMapValues(Map<String, String> keys, Converter<K> keyConverter, Converter<V> valueConverter, IntFunction<Map<K, V>> mapFactory) {
        Map<K, V> map = mapFactory.apply(keys.size());
        for (Map.Entry<String, String> entry : keys.entrySet()) {
            K key = this.convertValue(ConfigValue.builder().withName(entry.getKey()).withValue(entry.getKey()).build(), keyConverter);
            V value = this.getValue(entry.getValue(), valueConverter);
            map.put(key, value);
        }
        return map;
    }

    public Map<String, String> getMapIndexedKeys(String name) {
        HashMap<String, String> keys = new HashMap<String, String>();
        for (String propertyName : this.getPropertyNames()) {
            if (propertyName.length() <= name.length() + 1 || !name.isEmpty() && propertyName.charAt(name.length()) != '.' || !propertyName.startsWith(name)) continue;
            String unindexedName = StringUtil.unindexed((String)propertyName);
            String key = StringUtil.unquoted((String)unindexedName, (int)(name.isEmpty() ? 0 : name.length() + 1));
            keys.put(key, unindexedName);
        }
        return keys;
    }

    <K, V, C extends Collection<V>> Map<K, C> getMapIndexedValues(Map<String, String> keys, Converter<K> keyConverter, Converter<V> valueConverter, IntFunction<Map<K, C>> mapFactory, IntFunction<C> collectionFactory) {
        Map<K, C> map = mapFactory.apply(keys.size());
        for (Map.Entry<String, String> entry : keys.entrySet()) {
            K key = this.convertValue(ConfigValue.builder().withName(entry.getKey()).withValue(entry.getKey()).build(), keyConverter);
            C value = this.getValues(entry.getValue(), valueConverter, collectionFactory);
            map.put(key, value);
        }
        return map;
    }

    public <T> T getValue(String name, Class<T> propertyType) {
        if (propertyType.isArray()) {
            List<String> indexedProperties = this.getIndexedProperties(name);
            if (indexedProperties.isEmpty()) {
                return this.getValue(name, this.requireConverter(propertyType));
            }
            int indexedOrdinality = Integer.MIN_VALUE;
            Object array = Array.newInstance(propertyType.getComponentType(), indexedProperties.size());
            for (int i = 0; i < indexedProperties.size(); ++i) {
                String indexedProperty = indexedProperties.get(i);
                ConfigValue indexed = this.getConfigValue(indexedProperty);
                if (indexed.getConfigSourceOrdinal() >= indexedOrdinality) {
                    indexedOrdinality = indexed.getConfigSourceOrdinal();
                }
                Array.set(array, i, this.convertValue(indexed, this.requireConverter(propertyType.getComponentType())));
            }
            ConfigValue commaSeparated = this.getConfigValue(name);
            if (commaSeparated.getValue() == null || indexedOrdinality >= commaSeparated.getConfigSourceOrdinal()) {
                return (T)array;
            }
            return this.convertValue(commaSeparated, this.requireConverter(propertyType));
        }
        return this.getValue(name, this.requireConverter(propertyType));
    }

    public <T> T getValue(String name, Converter<T> converter) {
        ConfigValue configValue = this.getConfigValue(name);
        if (Converters.CONFIG_VALUE_CONVERTER.equals(converter)) {
            return (T)configValue.noProblems();
        }
        if (converter instanceof Converters.OptionalConverter && Converters.CONFIG_VALUE_CONVERTER.equals((Object)((Converters.OptionalConverter)converter).getDelegate())) {
            return (T)Optional.of(configValue.noProblems());
        }
        return this.convertValue(configValue, converter);
    }

    public <T> T convertValue(ConfigValue configValue, Converter<T> converter) {
        Object converted;
        if (configValue.hasProblems()) {
            if (Converters.isOptionalConverter(converter)) {
                configValue = configValue.noProblems();
            } else {
                ConfigValidationException.Problem problem = configValue.getProblems().get(0);
                Optional<RuntimeException> exception = problem.getException();
                if (exception.isPresent()) {
                    throw exception.get();
                }
            }
        }
        if (configValue.getValue() != null) {
            try {
                converted = converter.convert(configValue.getValue());
            }
            catch (IllegalArgumentException e) {
                throw ConfigMessages.msg.converterException(e, configValue.getNameProfiled(), configValue.getValue(), e.getLocalizedMessage());
            }
        }
        try {
            converted = converter.convert("");
        }
        catch (IllegalArgumentException ignored) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(configValue.getNameProfiled()));
        }
        if (converted == null) {
            if (configValue.getValue() == null) {
                throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(configValue.getNameProfiled()));
            }
            if (configValue.getValue().isEmpty()) {
                throw ConfigMessages.msg.propertyEmptyString(configValue.getNameProfiled(), converter.getClass().getTypeName());
            }
            throw ConfigMessages.msg.converterReturnedNull(configValue.getNameProfiled(), configValue.getValue(), converter.getClass().getTypeName());
        }
        return (T)converted;
    }

    public ConfigValue getConfigValue(String name) {
        ConfigValue configValue = this.configSources.getInterceptorChain().proceed(name);
        return configValue != null ? configValue : ConfigValue.builder().withName(name).build();
    }

    @Deprecated
    public String getRawValue(String name) {
        ConfigValue configValue = this.getConfigValue(name);
        return configValue != null ? configValue.getValue() : null;
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> propertyType) {
        if (propertyType.isArray()) {
            List<String> indexedProperties = this.getIndexedProperties(name);
            if (indexedProperties.isEmpty()) {
                return this.getValue(name, this.getOptionalConverter(propertyType));
            }
            int indexedOrdinality = Integer.MIN_VALUE;
            Object array = Array.newInstance(propertyType.getComponentType(), indexedProperties.size());
            for (int i = 0; i < indexedProperties.size(); ++i) {
                String indexedProperty = indexedProperties.get(i);
                ConfigValue indexed = this.getConfigValue(indexedProperty);
                if (indexed.getConfigSourceOrdinal() >= indexedOrdinality) {
                    indexedOrdinality = indexed.getConfigSourceOrdinal();
                }
                Array.set(array, i, this.convertValue(indexed, this.requireConverter(propertyType.getComponentType())));
            }
            ConfigValue commaSeparated = this.getConfigValue(name);
            if (commaSeparated.getValue() == null || indexedOrdinality >= commaSeparated.getConfigSourceOrdinal()) {
                return Optional.of(array);
            }
            return this.getValue(name, this.getOptionalConverter(propertyType));
        }
        return this.getValue(name, this.getOptionalConverter(propertyType));
    }

    public <T> Optional<T> getOptionalValue(String name, Converter<T> converter) {
        return this.getValue(name, Converters.newOptionalConverter(converter));
    }

    public <T> Optional<List<T>> getOptionalValues(String name, Class<T> propertyType) {
        return this.getOptionalValues(name, propertyType, ArrayList::new);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.requireConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            return this.getOptionalValue(name, Converters.newCollectionConverter(converter, collectionFactory));
        }
        int indexedOrdinality = Integer.MIN_VALUE;
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            ConfigValue indexed = this.getConfigValue(indexedProperty);
            if (indexed.getValue() != null && indexed.getConfigSourceOrdinal() >= indexedOrdinality) {
                indexedOrdinality = indexed.getConfigSourceOrdinal();
            }
            this.convertValue(indexed, Converters.newOptionalConverter(converter)).ifPresent(collection::add);
        }
        ConfigValue commaSeparated = this.getConfigValue(name);
        if (commaSeparated.getValue() == null || indexedOrdinality >= commaSeparated.getConfigSourceOrdinal()) {
            return collection.isEmpty() ? Optional.empty() : Optional.of(collection);
        }
        return this.getOptionalValue(name, Converters.newCollectionConverter(converter, collectionFactory));
    }

    @Deprecated(forRemoval=true)
    public <T, C extends Collection<T>> Optional<C> getIndexedOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            return Optional.empty();
        }
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            Optional<Object> optionalValue = this.getOptionalValue(indexedProperty, converter);
            optionalValue.ifPresent(collection::add);
        }
        return collection.isEmpty() ? Optional.empty() : Optional.of(collection);
    }

    public <K, V> Optional<Map<K, V>> getOptionalValues(String name, Class<K> keyClass, Class<V> valueClass) {
        return this.getOptionalValues(name, this.requireConverter(keyClass), this.requireConverter(valueClass));
    }

    public <K, V> Optional<Map<K, V>> getOptionalValues(String name, Converter<K> keyConverter, Converter<V> valueConverter) {
        return this.getOptionalValues(name, keyConverter, valueConverter, HashMap::new);
    }

    public <K, V> Optional<Map<K, V>> getOptionalValues(String name, Converter<K> keyConverter, Converter<V> valueConverter, IntFunction<Map<K, V>> mapFactory) {
        Map<String, String> keys = this.getMapKeys(name);
        if (keys.isEmpty()) {
            return this.getOptionalValue(name, Converters.newMapConverter(keyConverter, valueConverter, mapFactory));
        }
        return Optional.of(this.getMapValues(keys, keyConverter, valueConverter, mapFactory));
    }

    public <K, V, C extends Collection<V>> Optional<Map<K, C>> getOptionalValues(String name, Class<K> keyClass, Class<V> valueClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.requireConverter(keyClass), this.requireConverter(valueClass), HashMap::new, collectionFactory);
    }

    public <K, V, C extends Collection<V>> Optional<Map<K, C>> getOptionalValues(String name, Converter<K> keyConverter, Converter<V> valueConverter, IntFunction<Map<K, C>> mapFactory, IntFunction<C> collectionFactory) {
        Map<String, String> keys = this.getMapIndexedKeys(name);
        if (keys.isEmpty()) {
            return this.getOptionalValue(name, Converters.newMapConverter(keyConverter, Converters.newCollectionConverter(valueConverter, collectionFactory), mapFactory));
        }
        return Optional.of(this.getMapIndexedValues(keys, keyConverter, valueConverter, mapFactory, collectionFactory));
    }

    ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    Map<Class<?>, Map<String, Object>> getMappings() {
        return this.mappings;
    }

    public <T> T getConfigMapping(Class<T> type) {
        ConfigProperties configProperties;
        ConfigMapping configMapping;
        String prefix = type.isInterface() ? ((configMapping = type.getAnnotation(ConfigMapping.class)) != null ? configMapping.prefix() : "") : ((configProperties = type.getAnnotation(ConfigProperties.class)) != null ? configProperties.prefix() : "");
        return this.getConfigMapping(type, prefix);
    }

    public <T> T getConfigMapping(Class<T> type, String prefix) {
        if (prefix == null) {
            return this.getConfigMapping(type);
        }
        Map<String, Object> mappingsForType = this.mappings.get(ConfigMappingLoader.getConfigMappingClass(type));
        if (mappingsForType == null) {
            throw ConfigMessages.msg.mappingNotFound(type.getName());
        }
        Object configMappingObject = mappingsForType.get(prefix);
        if (configMappingObject == null) {
            throw ConfigMessages.msg.mappingPrefixNotFound(type.getName(), prefix);
        }
        return type.cast(configMappingObject);
    }

    public Iterable<String> getPropertyNames() {
        return this.configSources.getPropertyNames().get();
    }

    public Iterable<String> getLatestPropertyNames() {
        return this.configSources.getPropertyNames().latest();
    }

    public boolean isPropertyPresent(String name) {
        return Expressions.withoutExpansion(() -> {
            ConfigValue configValue = this.getConfigValue(name);
            return configValue.getValue() != null && !configValue.getValue().isEmpty();
        });
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources.getSources();
    }

    public Iterable<ConfigSource> getConfigSources(Class<?> type) {
        ArrayList<ConfigSource> configSourcesByType = new ArrayList<ConfigSource>();
        for (ConfigSource configSource : this.getConfigSources()) {
            if (!type.isAssignableFrom(configSource.getClass())) continue;
            configSourcesByType.add(configSource);
        }
        return configSourcesByType;
    }

    public Optional<ConfigSource> getConfigSource(String name) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String configSourceName = configSource.getName();
            if (configSourceName == null || !configSourceName.equals(name)) continue;
            return Optional.of(configSource);
        }
        return Optional.empty();
    }

    DefaultValuesConfigSource getDefaultValues() {
        return this.configSources.defaultValues;
    }

    @Deprecated
    public <T> T convert(String value, Class<T> asType) {
        return (T)(value != null ? this.requireConverter(asType).convert(value) : null);
    }

    private <T> Converter<Optional<T>> getOptionalConverter(Class<T> asType) {
        Converter appearing;
        Converter converter = (Converter)SmallRyeConfig.recast(this.optionalConverters.get(asType));
        if (converter == null && (appearing = (Converter)SmallRyeConfig.recast(this.optionalConverters.putIfAbsent(asType, (Converter)SmallRyeConfig.recast(converter = Converters.newOptionalConverter(this.requireConverter(asType)))))) != null) {
            converter = appearing;
        }
        return converter;
    }

    private static <T> T recast(Object obj) {
        return (T)obj;
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> asType) {
        return Optional.ofNullable(this.getConverterOrNull(asType));
    }

    public <T> Converter<T> requireConverter(Class<T> asType) {
        Converter<T> conv = this.getConverterOrNull(asType);
        if (conv == null) {
            throw ConfigMessages.msg.noRegisteredConverter(asType);
        }
        return conv;
    }

    <T> Converter<T> getConverterOrNull(Class<T> asType) {
        Converter<?> exactConverter = this.converters.get(asType);
        if (exactConverter != null) {
            return exactConverter;
        }
        if (asType.isPrimitive()) {
            return this.getConverterOrNull(Converters.wrapPrimitiveType(asType));
        }
        if (asType.isArray()) {
            Converter<?> conv = this.getConverterOrNull(asType.getComponentType());
            return conv == null ? null : Converters.newArrayConverter(conv, asType);
        }
        return this.converters.computeIfAbsent(asType, clazz -> Converters.Implicit.getConverter((Class)clazz));
    }

    public <T> T unwrap(Class<T> type) {
        if (Config.class.isAssignableFrom(type)) {
            return type.cast(this);
        }
        throw ConfigMessages.msg.getTypeNotSupportedForUnwrapping(type);
    }

    public List<String> getProfiles() {
        return this.configSources.getProfiles();
    }

    private Object writeReplace() throws ObjectStreamException {
        return RegisteredConfig.instance;
    }

    private static class ConfigSources
    implements Serializable {
        private static final long serialVersionUID = 3483018375584151712L;
        private final List<String> profiles;
        private final List<ConfigSource> sources;
        private final DefaultValuesConfigSource defaultValues;
        private final ConfigSourceInterceptorContext interceptorChain;
        private final PropertyNames propertyNames;

        ConfigSources(SmallRyeConfigBuilder builder) {
            ConfigSourceInterceptor interceptor;
            List<ConfigSource> sources = ConfigSources.buildSources(builder);
            final DefaultValuesConfigSource defaultValues = new DefaultValuesConfigSource(builder.getDefaultValues());
            sources.add((ConfigSource)defaultValues);
            ArrayList<ConfigSourceInterceptor> negativeInterceptors = new ArrayList<ConfigSourceInterceptor>();
            ArrayList<ConfigSourceInterceptor> positiveInterceptors = new ArrayList<ConfigSourceInterceptor>();
            SmallRyeConfigSources negativeSources = new SmallRyeConfigSources(ConfigSources.mapSources(sources), true);
            SmallRyeConfigSources positiveSources = new SmallRyeConfigSources(ConfigSources.mapSources(sources), false);
            List<SmallRyeConfigBuilder.InterceptorWithPriority> interceptorWithPriorities = ConfigSources.buildInterceptors(builder);
            SmallRyeConfigSourceInterceptorContext.InterceptorChain chain = new SmallRyeConfigSourceInterceptorContext.InterceptorChain();
            SmallRyeConfigSourceInterceptorContext current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null, chain);
            current = new SmallRyeConfigSourceInterceptorContext(negativeSources, current, chain);
            for (SmallRyeConfigBuilder.InterceptorWithPriority interceptorWithPriority : interceptorWithPriorities) {
                if (interceptorWithPriority.getPriority() >= 0) continue;
                interceptor = interceptorWithPriority.getInterceptor(current);
                negativeInterceptors.add(interceptor);
                current = new SmallRyeConfigSourceInterceptorContext(interceptor, current, chain);
            }
            current = new SmallRyeConfigSourceInterceptorContext(positiveSources, current, chain);
            for (SmallRyeConfigBuilder.InterceptorWithPriority interceptorWithPriority : interceptorWithPriorities) {
                if (interceptorWithPriority.getPriority() < 0) continue;
                interceptor = interceptorWithPriority.getInterceptor(current);
                positiveInterceptors.add(interceptor);
                current = new SmallRyeConfigSourceInterceptorContext(interceptor, current, chain);
            }
            final List<String> profiles = ConfigSources.getProfiles(positiveInterceptors);
            List<ConfigSourceWithPriority> sourcesWithPriorities = ConfigSources.mapLateSources(sources, negativeInterceptors, positiveInterceptors, current, profiles, builder);
            final List<ConfigSource> configSources = ConfigSources.getSources(sourcesWithPriorities);
            current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null, chain);
            current = new SmallRyeConfigSourceInterceptorContext(new SmallRyeConfigSources(sourcesWithPriorities, true), current, chain);
            for (ConfigSourceInterceptor interceptor2 : negativeInterceptors) {
                current = new SmallRyeConfigSourceInterceptorContext(interceptor2, current, chain);
            }
            current = new SmallRyeConfigSourceInterceptorContext(new SmallRyeConfigSources(sourcesWithPriorities, false), current, chain);
            for (ConfigSourceInterceptor interceptor2 : positiveInterceptors) {
                current = new SmallRyeConfigSourceInterceptorContext(interceptor2, current, chain);
            }
            ArrayList<Map.Entry<String, Supplier<Iterator<String>>>> properties = new ArrayList<Map.Entry<String, Supplier<Iterator<String>>>>(builder.getMappingsBuilder().getMappings().size());
            properties.add(Map.entry("", new Supplier<Iterator<String>>(){
                private final List<String> names = new ArrayList<String>();
                {
                    for (ConfigSource configSource : configSources) {
                        Set propertyNames;
                        if (configSource instanceof EnvConfigSource || configSource == defaultValues || (propertyNames = configSource.getPropertyNames()) == null) continue;
                        this.names.addAll(propertyNames.stream().map(new Function<String, String>(){

                            @Override
                            public String apply(String name) {
                                return ProfileConfigSourceInterceptor.activeName(name, profiles);
                            }
                        }).toList());
                    }
                }

                @Override
                public Iterator<String> get() {
                    return this.names.iterator();
                }
            }));
            for (ConfigMappings.ConfigClass mapping : builder.getMappingsBuilder().getMappings()) {
                final Class<?> type = ConfigMappingLoader.getConfigMappingClass(mapping.getType());
                properties.add(Map.entry(mapping.getPrefix(), new Supplier<Iterator<String>>(){
                    private final List<String> names;
                    {
                        this.names = new ArrayList<String>(ConfigMappingLoader.configMappingProperties(type).keySet());
                        this.names.sort(new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                if (PropertyName.equals(o1, o2)) {
                                    return Integer.compare(o1.length(), o2.length()) * -1;
                                }
                                return o1.compareTo(o2);
                            }
                        });
                    }

                    @Override
                    public Iterator<String> get() {
                        return this.names.iterator();
                    }
                }));
            }
            for (ConfigSource source : sources) {
                if (!(source instanceof EnvConfigSource)) continue;
                ((EnvConfigSource)source).matchEnvWithProperties(properties, profiles);
            }
            this.profiles = profiles;
            this.sources = configSources;
            this.defaultValues = defaultValues;
            this.interceptorChain = current;
            this.propertyNames = new PropertyNames(current, builder.getSecretKeys());
        }

        private static List<ConfigSource> buildSources(SmallRyeConfigBuilder builder) {
            ArrayList<ConfigSource> sourcesToBuild = new ArrayList<ConfigSource>(builder.getSources());
            for (ConfigSourceProvider sourceProvider : builder.getSourceProviders()) {
                for (ConfigSource configSource : sourceProvider.getConfigSources(builder.getClassLoader())) {
                    sourcesToBuild.add(configSource);
                }
            }
            if (builder.isAddDiscoveredSources()) {
                sourcesToBuild.addAll(builder.discoverSources());
            }
            if (builder.isAddDefaultSources()) {
                sourcesToBuild.addAll(builder.getDefaultSources());
            } else {
                if (builder.isAddSystemSources()) {
                    sourcesToBuild.addAll(builder.getSystemSources());
                }
                if (builder.isAddPropertiesSources()) {
                    sourcesToBuild.addAll(builder.getPropertiesSources());
                }
            }
            return sourcesToBuild;
        }

        private static List<SmallRyeConfigBuilder.InterceptorWithPriority> buildInterceptors(SmallRyeConfigBuilder builder) {
            ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors = new ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority>(builder.getInterceptors());
            if (builder.isAddDiscoveredInterceptors()) {
                interceptors.addAll(builder.discoverInterceptors());
            }
            if (builder.isAddDefaultInterceptors()) {
                interceptors.addAll(builder.getDefaultInterceptors());
            }
            interceptors.sort(null);
            return interceptors;
        }

        private static List<ConfigSourceWithPriority> mapSources(List<ConfigSource> sources) {
            ArrayList<ConfigSourceWithPriority> sourcesWithPriority = new ArrayList<ConfigSourceWithPriority>();
            for (ConfigSource source : sources) {
                if (source instanceof ConfigurableConfigSource) continue;
                sourcesWithPriority.add(new ConfigSourceWithPriority(source));
            }
            sourcesWithPriority.sort(null);
            Collections.reverse(sourcesWithPriority);
            return sourcesWithPriority;
        }

        private static List<String> getProfiles(List<ConfigSourceInterceptor> interceptors) {
            for (ConfigSourceInterceptor interceptor : interceptors) {
                if (!(interceptor instanceof ProfileConfigSourceInterceptor)) continue;
                return ((ProfileConfigSourceInterceptor)interceptor).getProfiles();
            }
            return Collections.emptyList();
        }

        private static List<ConfigSourceWithPriority> mapLateSources(List<ConfigSource> sources, List<ConfigSourceInterceptor> negativeInterceptors, List<ConfigSourceInterceptor> positiveInterceptors, ConfigSourceInterceptorContext current, List<String> profiles, SmallRyeConfigBuilder builder) {
            ConfigValue locations;
            ConfigSourceWithPriority.resetLoadPriority();
            ArrayList<ConfigSourceWithPriority> currentSources = new ArrayList<ConfigSourceWithPriority>();
            ArrayList<ConfigSource> profileSources = new ArrayList<ConfigSource>();
            SmallRyeConfigSourceContext mainContext = new SmallRyeConfigSourceContext(current, profiles, sources);
            for (ConfigurableConfigSource profileSource : ConfigSources.getConfigurableSources(sources)) {
                if (!(profileSource.getFactory() instanceof ProfileConfigSourceFactory)) continue;
                profileSources.addAll(profileSource.getConfigSources(mainContext));
            }
            currentSources.addAll(ConfigSources.mapSources(profileSources));
            currentSources.addAll(ConfigSources.mapSources(sources));
            currentSources.sort(null);
            Collections.reverse(currentSources);
            SmallRyeConfigSourceInterceptorContext.InterceptorChain chain = new SmallRyeConfigSourceInterceptorContext.InterceptorChain();
            SmallRyeConfigSourceInterceptorContext context = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null, chain);
            context = new SmallRyeConfigSourceInterceptorContext(new SmallRyeConfigSources(currentSources, true), context, chain);
            for (ConfigSourceInterceptor interceptor : negativeInterceptors) {
                context = new SmallRyeConfigSourceInterceptorContext(interceptor, context, chain);
            }
            context = new SmallRyeConfigSourceInterceptorContext(new SmallRyeConfigSources(currentSources, false), context, chain);
            for (ConfigSourceInterceptor interceptor : positiveInterceptors) {
                context = new SmallRyeConfigSourceInterceptorContext(interceptor, context, chain);
            }
            int countSourcesFromLocations = 0;
            ArrayList<ConfigSource> lateSources = new ArrayList<ConfigSource>();
            SmallRyeConfigSourceContext profileContext = new SmallRyeConfigSourceContext(context, profiles, currentSources.stream().map(ConfigSourceWithPriority::getSource).collect(Collectors.toList()));
            for (ConfigurableConfigSource lateSource : ConfigSources.getConfigurableSources(sources)) {
                if (lateSource.getFactory() instanceof ProfileConfigSourceFactory) continue;
                List<ConfigSource> configSources = lateSource.getConfigSources(profileContext);
                if (lateSource.getFactory() instanceof AbstractLocationConfigSourceFactory) {
                    countSourcesFromLocations += configSources.size();
                }
                lateSources.addAll(configSources);
            }
            if (countSourcesFromLocations == 0 && builder.isAddDiscoveredSources() && (locations = profileContext.getValue(SmallRyeConfig.SMALLRYE_CONFIG_LOCATIONS)) != null && locations.getValue() != null) {
                ConfigLogging.log.configLocationsNotFound(SmallRyeConfig.SMALLRYE_CONFIG_LOCATIONS, locations.getValue());
            }
            currentSources.clear();
            currentSources.addAll(ConfigSources.mapSources(lateSources));
            currentSources.addAll(ConfigSources.mapSources(profileSources));
            currentSources.addAll(ConfigSources.mapSources(sources));
            currentSources.sort(null);
            Collections.reverse(currentSources);
            return currentSources;
        }

        private static List<ConfigSource> getSources(List<ConfigSourceWithPriority> sourceWithPriorities) {
            ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
            for (ConfigSourceWithPriority configSourceWithPriority : sourceWithPriorities) {
                ConfigSource source = configSourceWithPriority.getSource();
                configSources.add(source);
                if (!ConfigLogging.log.isDebugEnabled()) continue;
                ConfigLogging.log.loadedConfigSource(source.getName(), source.getOrdinal());
            }
            return Collections.unmodifiableList(configSources);
        }

        private static List<ConfigurableConfigSource> getConfigurableSources(List<ConfigSource> sources) {
            ArrayList<ConfigurableConfigSource> configurableConfigSources = new ArrayList<ConfigurableConfigSource>();
            for (ConfigSource source : sources) {
                if (!(source instanceof ConfigurableConfigSource)) continue;
                configurableConfigSources.add((ConfigurableConfigSource)source);
            }
            configurableConfigSources.sort(Comparator.comparingInt(ConfigurableConfigSource::getOrdinal).reversed());
            return Collections.unmodifiableList(configurableConfigSources);
        }

        List<String> getProfiles() {
            return this.profiles;
        }

        List<ConfigSource> getSources() {
            return this.sources;
        }

        ConfigSourceInterceptorContext getInterceptorChain() {
            return this.interceptorChain;
        }

        PropertyNames getPropertyNames() {
            return this.propertyNames;
        }

        private static class PropertyNames
        implements Serializable {
            private static final long serialVersionUID = 4193517748286869745L;
            private final SmallRyeConfigSourceInterceptorContext interceptorChain;
            private final Set<PropertyName> secretKeys;
            private final Set<String> names = new HashSet<String>();
            private final Set<String> secretNames = new HashSet<String>();
            private final Map<String, Map<Integer, String>> indexed = new HashMap<String, Map<Integer, String>>();

            public PropertyNames(SmallRyeConfigSourceInterceptorContext interceptorChain, Set<PropertyName> secretKeys) {
                this.interceptorChain = interceptorChain;
                this.secretKeys = secretKeys;
            }

            Iterable<String> get() {
                if (this.names.isEmpty() && this.secretNames.isEmpty()) {
                    return this.latest();
                }
                return new Names();
            }

            Map<String, Map<Integer, String>> indexed() {
                this.get();
                return this.indexed;
            }

            Iterable<String> latest() {
                this.names.clear();
                this.secretNames.clear();
                Iterator<String> namesIterator = this.interceptorChain.iterateNames();
                while (namesIterator.hasNext()) {
                    final String name = namesIterator.next();
                    if (this.secretKeys.contains(PropertyName.unprofiled(name))) {
                        this.secretNames.add(name);
                    } else {
                        this.names.add(name);
                    }
                    for (int i = 0; i < name.length(); ++i) {
                        int indexEnd;
                        if (name.charAt(i) != '[' || !StringUtil.isNumeric((CharSequence)name, (int)(i + 1), (int)((indexEnd = name.indexOf(93, i)) - 1 - i))) continue;
                        if (indexEnd == name.length() - 1 || name.charAt(indexEnd + 1) == '.' && indexEnd + 2 < name.length()) {
                            Integer index = Integer.valueOf(name.substring(i + 1, indexEnd));
                            String parentKey = name.substring(0, i);
                            this.indexed.computeIfAbsent(parentKey, key -> new TreeMap()).compute(index, new BiFunction<Integer, String, String>(){

                                @Override
                                public String apply(Integer key, String value) {
                                    if (value != null && indexEnd == value.length() - 1) {
                                        return value;
                                    }
                                    return name;
                                }
                            });
                        }
                        i = indexEnd + 1;
                    }
                }
                this.names.remove("config_ordinal");
                return new Names();
            }

            private class Names
            implements Iterable<String> {
                private final Iterator<Set<String>> names;

                public Names() {
                    this.names = SecretKeys.isLocked() ? List.of(PropertyNames.this.names).iterator() : List.of(PropertyNames.this.names, PropertyNames.this.secretNames).iterator();
                }

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<String> current;
                        {
                            this.current = Names.this.names.next().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.current.hasNext()) {
                                return true;
                            }
                            if (Names.this.names.hasNext()) {
                                this.current = Names.this.names.next().iterator();
                                return this.current.hasNext();
                            }
                            return false;
                        }

                        @Override
                        public String next() {
                            return this.current.next();
                        }
                    };
                }
            }
        }
    }

    private static class RegisteredConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final RegisteredConfig instance = new RegisteredConfig();

        private RegisteredConfig() {
        }

        private Object readResolve() throws ObjectStreamException {
            return ConfigProvider.getConfig();
        }
    }

    private static class SmallRyeConfigSourceInterceptorContext
    implements ConfigSourceInterceptorContext {
        private static final long serialVersionUID = 6654406739008729337L;
        private final ConfigSourceInterceptor interceptor;
        private final ConfigSourceInterceptorContext next;
        private final InterceptorChain chain;
        private static final ThreadLocal<RecursionCount> rcHolder = ThreadLocal.withInitial(RecursionCount::new);

        SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor interceptor, ConfigSourceInterceptorContext next, InterceptorChain chain) {
            this.interceptor = interceptor;
            this.next = next;
            this.chain = chain.setChain(this);
        }

        @Override
        public ConfigValue proceed(String name) {
            return this.interceptor.getValue(this.next, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConfigValue restart(String name) {
            RecursionCount rc = rcHolder.get();
            rc.increment();
            try {
                ConfigValue configValue = this.chain.get().proceed(name);
                return configValue;
            }
            finally {
                if (rc.decrement()) {
                    rcHolder.remove();
                }
            }
        }

        @Override
        public Iterator<String> iterateNames() {
            return this.interceptor.iterateNames(this.next);
        }

        static class InterceptorChain
        implements Supplier<ConfigSourceInterceptorContext>,
        Serializable {
            private static final long serialVersionUID = 7387475787257736307L;
            private ConfigSourceInterceptorContext chain;

            InterceptorChain() {
            }

            @Override
            public ConfigSourceInterceptorContext get() {
                return this.chain;
            }

            public InterceptorChain setChain(ConfigSourceInterceptorContext chain) {
                this.chain = chain;
                return this;
            }
        }

        static final class RecursionCount {
            int count;

            RecursionCount() {
            }

            void increment() {
                int old = this.count;
                if (old == 20) {
                    throw new IllegalStateException("Too many recursive interceptor actions");
                }
                this.count = old + 1;
            }

            boolean decrement() {
                return --this.count == 0;
            }
        }
    }

    private static class SmallRyeConfigSourceContext
    implements ConfigSourceContext {
        private final ConfigSourceInterceptorContext context;
        private final List<String> profiles;
        private final List<ConfigSource> sources;

        public SmallRyeConfigSourceContext(ConfigSourceInterceptorContext context, List<String> profiles, List<ConfigSource> sources) {
            this.context = context;
            this.profiles = profiles;
            this.sources = sources;
        }

        @Override
        public ConfigValue getValue(String name) {
            ConfigValue value = this.context.proceed(name);
            return value != null ? value : ConfigValue.builder().withName(name).build();
        }

        @Override
        public List<String> getProfiles() {
            return this.profiles;
        }

        @Override
        public List<ConfigSource> getConfigSources() {
            return this.sources;
        }

        @Override
        public Iterator<String> iterateNames() {
            return this.context.iterateNames();
        }
    }

    static class ConfigSourceWithPriority
    implements Comparable<ConfigSourceWithPriority>,
    Serializable {
        private static final long serialVersionUID = 3709554647398262957L;
        private final ConfigSource source;
        private final int priority;
        private final int loadPriority = loadPrioritySequence++;
        private static int loadPrioritySequence = 0;

        ConfigSourceWithPriority(ConfigSource source) {
            this.source = source;
            this.priority = source.getOrdinal();
        }

        ConfigSource getSource() {
            return this.source;
        }

        int priority() {
            return this.priority;
        }

        @Override
        public int compareTo(ConfigSourceWithPriority other) {
            int res = Integer.compare(this.priority, other.priority);
            return res != 0 ? res : Integer.compare(other.loadPriority, this.loadPriority);
        }

        static void resetLoadPriority() {
            loadPrioritySequence = 0;
        }
    }
}

