/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ConnectedComponentVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.PageRankVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.PeerPressureVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ProgramVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.computer.traversal.step.map.ShortestPathVertexProgramStep;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.GraphOp;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.ChooseStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.LocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.OptionalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.UnionStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AllStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AnyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.CoinStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DiscardStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.IsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.LambdaFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NoneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.NotStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.PathFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.SampleGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TailGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TimeLimitStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WherePredicateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.WhereTraversalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AsBoolStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AsDateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AsNumberStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AsStringGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AsStringLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CallStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CoalesceStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CombineStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ConcatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ConjoinStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ConstantStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.DateAddStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.DateDiffStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.DedupLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.DifferenceStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.DisjunctStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ElementStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FormatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupCountStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GroupStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IndexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IntersectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LTrimGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LTrimLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LabelStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaCollectingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LengthGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LengthLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LoopsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MatchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MergeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MinGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.OrderLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PathStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ProductStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ProjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyKeyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RTrimGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RTrimLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.RangeLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ReplaceGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ReplaceLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ReverseStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SackStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SampleLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectOneStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SplitGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SplitLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SubstringGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TailLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ToLowerGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ToLowerLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ToUpperGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ToUpperLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalFlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TraversalSelectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TreeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TrimGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.TrimLocalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.UnfoldStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AggregateStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.FailStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupCountSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.InjectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IoStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.LambdaSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SackValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectCapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SubgraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TraversalSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.TreeSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.TraversalStrategyProxy;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class BytecodeHelper {
    private static final Map<String, List<Class<? extends Step>>> byteCodeSymbolStepMap;

    private BytecodeHelper() {
    }

    public static <A extends TraversalStrategy> Iterator<A> findStrategies(Bytecode bytecode, Class<A> clazz) {
        return IteratorUtils.map(IteratorUtils.filter(bytecode.getSourceInstructions().iterator(), s -> s.getOperator().equals("withStrategies") && clazz.isAssignableFrom(s.getArguments()[0].getClass())), os -> (TraversalStrategy)os.getArguments()[0]);
    }

    public static boolean removeStrategies(Bytecode bytecode, String operator, Class<TraversalStrategy>[] clazzes) {
        return bytecode.getSourceInstructions().removeIf(s -> {
            if (!operator.equals(s.getOperator()) || clazzes.length != s.getArguments().length) {
                return false;
            }
            for (int i = 0; i < clazzes.length; ++i) {
                Class<?> sClass;
                Class<?> clazz = s.getArguments()[i] instanceof TraversalStrategyProxy ? ((TraversalStrategyProxy)s.getArguments()[i]).getStrategyClass() : (sClass = s.getArguments()[i] instanceof Class ? (Class<?>)s.getArguments()[i] : s.getArguments()[i].getClass());
                if (clazzes[i].isAssignableFrom(sClass)) continue;
                return false;
            }
            return true;
        });
    }

    public static Bytecode filterInstructions(Bytecode bytecode, Predicate<Bytecode.Instruction> predicate) {
        Bytecode clone = new Bytecode();
        for (Bytecode.Instruction instruction : bytecode.getSourceInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone.addSource(instruction.getOperator(), instruction.getArguments());
        }
        for (Bytecode.Instruction instruction : bytecode.getStepInstructions()) {
            if (!predicate.test(instruction)) continue;
            clone.addStep(instruction.getOperator(), instruction.getArguments());
        }
        return clone;
    }

    public static boolean isGraphOperation(Bytecode bytecode) {
        return Stream.of(GraphOp.values()).anyMatch(op -> op.equals(bytecode));
    }

    public static Optional<String> getLambdaLanguage(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            for (Object object : instruction.getArguments()) {
                Optional<String> temp;
                if (object instanceof Lambda) {
                    return Optional.of(((Lambda)object).getLambdaLanguage());
                }
                if (!(object instanceof Bytecode) || !(temp = BytecodeHelper.getLambdaLanguage((Bytecode)object)).isPresent()) continue;
                return temp;
            }
        }
        return Optional.empty();
    }

    public static void removeBindings(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            Object[] arguments = instruction.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof Bytecode.Binding) {
                    arguments[i] = ((Bytecode.Binding)arguments[i]).value();
                    continue;
                }
                if (!(arguments[i] instanceof Bytecode)) continue;
                BytecodeHelper.removeBindings((Bytecode)arguments[i]);
            }
        }
    }

    public static void detachElements(Bytecode bytecode) {
        for (Bytecode.Instruction instruction : bytecode.getInstructions()) {
            Object[] arguments = instruction.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof Bytecode) {
                    BytecodeHelper.detachElements((Bytecode)arguments[i]);
                    continue;
                }
                if (arguments[i] instanceof List) {
                    ArrayList list = new ArrayList();
                    for (Object object : (List)arguments[i]) {
                        list.add(DetachedFactory.detach(object, false));
                    }
                    arguments[i] = list;
                    continue;
                }
                arguments[i] = DetachedFactory.detach(arguments[i], false);
            }
        }
    }

    public static List<Class<? extends Step>> findPossibleTraversalSteps(String operator) {
        if (!byteCodeSymbolStepMap.containsKey(operator)) {
            throw new IllegalArgumentException("Unable to find Traversal steps for the graph operator: " + operator);
        }
        return byteCodeSymbolStepMap.get(operator);
    }

    static {
        HashMap<String, List<Class<? extends Step>>> operationStepMap = new HashMap<String, List<Class<? extends Step>>>(){
            {
                this.put("map", Arrays.asList(LambdaMapStep.class, TraversalMapStep.class));
                this.put("flatMap", Arrays.asList(LambdaFlatMapStep.class, TraversalFlatMapStep.class));
                this.put("id", Collections.singletonList(IdStep.class));
                this.put("label", Collections.singletonList(LabelStep.class));
                this.put("identity", Collections.singletonList(IdentityStep.class));
                this.put("constant", Collections.singletonList(ConstantStep.class));
                this.put("V", Collections.singletonList(GraphStep.class));
                this.put("E", Collections.singletonList(GraphStep.class));
                this.put("to", Collections.emptyList());
                this.put("out", Collections.singletonList(VertexStep.class));
                this.put("in", Collections.singletonList(VertexStep.class));
                this.put("both", Collections.singletonList(VertexStep.class));
                this.put("toE", Collections.singletonList(VertexStep.class));
                this.put("outE", Collections.singletonList(VertexStep.class));
                this.put("inE", Collections.singletonList(VertexStep.class));
                this.put("bothE", Collections.singletonList(VertexStep.class));
                this.put("toV", Collections.singletonList(EdgeVertexStep.class));
                this.put("outV", Collections.singletonList(EdgeVertexStep.class));
                this.put("inV", Collections.singletonList(EdgeVertexStep.class));
                this.put("bothV", Collections.singletonList(EdgeVertexStep.class));
                this.put("otherV", Collections.singletonList(EdgeVertexStep.class));
                this.put("order", Arrays.asList(OrderGlobalStep.class, OrderLocalStep.class));
                this.put("properties", Collections.singletonList(PropertiesStep.class));
                this.put("values", Collections.singletonList(PropertiesStep.class));
                this.put("propertyMap", Collections.singletonList(PropertyMapStep.class));
                this.put("valueMap", Collections.singletonList(PropertyMapStep.class));
                this.put("elementMap", Collections.singletonList(ElementMapStep.class));
                this.put("select", Arrays.asList(SelectStep.class, SelectOneStep.class, TraversalSelectStep.class, TraversalMapStep.class));
                this.put("key", Collections.singletonList(PropertyKeyStep.class));
                this.put("value", Collections.singletonList(PropertyValueStep.class));
                this.put("path", Collections.singletonList(PathStep.class));
                this.put("match", Collections.singletonList(MatchStep.class));
                this.put("math", Collections.singletonList(MathStep.class));
                this.put("sack", Arrays.asList(SackStep.class, SackValueStep.class));
                this.put("loops", Collections.singletonList(LoopsStep.class));
                this.put("project", Collections.singletonList(ProjectStep.class));
                this.put("unfold", Collections.singletonList(UnfoldStep.class));
                this.put("fold", Collections.singletonList(FoldStep.class));
                this.put("count", Arrays.asList(CountGlobalStep.class, CountLocalStep.class));
                this.put("sum", Arrays.asList(SumGlobalStep.class, SumLocalStep.class));
                this.put("max", Arrays.asList(MaxGlobalStep.class, MaxLocalStep.class));
                this.put("min", Arrays.asList(MinGlobalStep.class, MinGlobalStep.class));
                this.put("mean", Arrays.asList(MeanGlobalStep.class, MeanLocalStep.class));
                this.put("concat", Collections.singletonList(ConcatStep.class));
                this.put("format", Collections.singletonList(FormatStep.class));
                this.put("asString", Arrays.asList(AsStringGlobalStep.class, AsStringLocalStep.class));
                this.put("length", Arrays.asList(LengthGlobalStep.class, LengthLocalStep.class));
                this.put("toLower", Arrays.asList(ToLowerGlobalStep.class, ToLowerLocalStep.class));
                this.put("toUpper", Arrays.asList(ToUpperGlobalStep.class, ToUpperLocalStep.class));
                this.put("trim", Arrays.asList(TrimGlobalStep.class, TrimLocalStep.class));
                this.put("lTrim", Arrays.asList(LTrimGlobalStep.class, LTrimLocalStep.class));
                this.put("rTrim", Arrays.asList(RTrimGlobalStep.class, RTrimLocalStep.class));
                this.put("reverse", Collections.singletonList(ReverseStep.class));
                this.put("replace", Arrays.asList(ReplaceGlobalStep.class, ReplaceLocalStep.class));
                this.put("substring", Arrays.asList(SubstringGlobalStep.class, ReplaceLocalStep.class));
                this.put("split", Arrays.asList(SplitGlobalStep.class, SplitLocalStep.class));
                this.put("asBool", Collections.singletonList(AsBoolStep.class));
                this.put("asDate", Collections.singletonList(AsDateStep.class));
                this.put("dateAdd", Collections.singletonList(DateAddStep.class));
                this.put("dateDiff", Collections.singletonList(DateDiffStep.class));
                this.put("asNumber", Collections.singletonList(AsNumberStep.class));
                this.put("all", Collections.singletonList(AllStep.class));
                this.put("any", Collections.singletonList(AnyStep.class));
                this.put("none", Collections.singletonList(NoneStep.class));
                this.put("combine", Collections.singletonList(CombineStep.class));
                this.put("difference", Collections.singletonList(DifferenceStep.class));
                this.put("disjunct", Collections.singletonList(DisjunctStep.class));
                this.put("merge", Collections.singletonList(MergeStep.class));
                this.put("conjoin", Collections.singletonList(ConjoinStep.class));
                this.put("product", Collections.singletonList(ProductStep.class));
                this.put("intersect", Collections.singletonList(IntersectStep.class));
                this.put("group", Arrays.asList(GroupStep.class, GroupSideEffectStep.class));
                this.put("groupCount", Arrays.asList(GroupCountStep.class, GroupCountSideEffectStep.class));
                this.put("tree", Arrays.asList(TreeStep.class, TreeSideEffectStep.class));
                this.put("addV", Collections.singletonList(AddVertexStep.class));
                this.put("addE", Collections.singletonList(AddEdgeStep.class));
                this.put("mergeV", Collections.singletonList(MergeVertexStep.class));
                this.put("mergeE", Collections.singletonList(MergeEdgeStep.class));
                this.put("from", Collections.emptyList());
                this.put("filter", Arrays.asList(LambdaFilterStep.class, TraversalFilterStep.class));
                this.put("or", Collections.singletonList(OrStep.class));
                this.put("and", Collections.singletonList(AndStep.class));
                this.put("inject", Collections.singletonList(InjectStep.class));
                this.put("dedup", Arrays.asList(DedupGlobalStep.class, DedupLocalStep.class));
                this.put("where", Arrays.asList(WherePredicateStep.class, WhereTraversalStep.class, TraversalFilterStep.class));
                this.put("has", Collections.singletonList(HasStep.class));
                this.put("hasNot", Collections.singletonList(NotStep.class));
                this.put("hasLabel", Collections.singletonList(HasStep.class));
                this.put("hasId", Collections.singletonList(HasStep.class));
                this.put("hasKey", Collections.singletonList(HasStep.class));
                this.put("hasValue", Collections.singletonList(HasStep.class));
                this.put("is", Collections.singletonList(IsStep.class));
                this.put("not", Collections.singletonList(NotStep.class));
                this.put("range", Arrays.asList(RangeGlobalStep.class, RangeLocalStep.class));
                this.put("limit", Arrays.asList(RangeGlobalStep.class, RangeLocalStep.class));
                this.put("skip", Arrays.asList(RangeGlobalStep.class, RangeLocalStep.class));
                this.put("tail", Arrays.asList(TailGlobalStep.class, TailLocalStep.class));
                this.put("coin", Collections.singletonList(CoinStep.class));
                this.put("io", Collections.singletonList(IoStep.class));
                this.put("read", Collections.emptyList());
                this.put("write", Collections.emptyList());
                this.put("call", Collections.singletonList(CallStep.class));
                this.put("element", Collections.singletonList(ElementStep.class));
                this.put("timeLimit", Collections.singletonList(TimeLimitStep.class));
                this.put("simplePath", Collections.singletonList(PathFilterStep.class));
                this.put("cyclicPath", Collections.singletonList(PathFilterStep.class));
                this.put("sample", Arrays.asList(SampleGlobalStep.class, SampleLocalStep.class));
                this.put("drop", Collections.singletonList(DropStep.class));
                this.put("sideEffect", Arrays.asList(LambdaSideEffectStep.class, TraversalSideEffectStep.class));
                this.put("cap", Collections.singletonList(SideEffectCapStep.class));
                this.put("property", Collections.singletonList(AddPropertyStep.class));
                this.put("aggregate", Collections.singletonList(AggregateStep.class));
                this.put("fail", Collections.singletonList(FailStep.class));
                this.put("subgraph", Collections.singletonList(SubgraphStep.class));
                this.put("barrier", Arrays.asList(NoOpBarrierStep.class, LambdaCollectingBarrierStep.class));
                this.put("index", Collections.singletonList(IndexStep.class));
                this.put("local", Collections.singletonList(LocalStep.class));
                this.put("emit", Collections.emptyList());
                this.put("repeat", Collections.singletonList(RepeatStep.class));
                this.put("until", Collections.emptyList());
                this.put("branch", Collections.singletonList(BranchStep.class));
                this.put("union", Collections.singletonList(UnionStep.class));
                this.put("coalesce", Collections.singletonList(CoalesceStep.class));
                this.put("choose", Collections.singletonList(ChooseStep.class));
                this.put("optional", Collections.singletonList(OptionalStep.class));
                this.put("pageRank", Collections.singletonList(PageRankVertexProgramStep.class));
                this.put("peerPressure", Collections.singletonList(PeerPressureVertexProgramStep.class));
                this.put("connectedComponent", Collections.singletonList(ConnectedComponentVertexProgramStep.class));
                this.put("shortestPath", Collections.singletonList(ShortestPathVertexProgramStep.class));
                this.put("program", Collections.singletonList(ProgramVertexProgramStep.class));
                this.put("by", Collections.emptyList());
                this.put("with", Collections.emptyList());
                this.put("times", Collections.emptyList());
                this.put("as", Collections.emptyList());
                this.put("option", Collections.emptyList());
                this.put("profile", Collections.singletonList(ProfileStep.class));
                this.put("discard", Collections.singletonList(DiscardStep.class));
                this.put("withSack", Collections.emptyList());
                this.put("withoutStrategies", Collections.emptyList());
                this.put("withStrategies", Collections.emptyList());
                this.put("withSideEffect", Collections.emptyList());
                this.put("withRemote", Collections.emptyList());
                this.put("withComputer", Collections.emptyList());
                this.put("withBulk", Collections.emptyList());
                this.put("withPath", Collections.emptyList());
                this.put("tx", Collections.emptyList());
            }
        };
        byteCodeSymbolStepMap = Collections.unmodifiableMap(operationStepMap);
    }
}

