/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.cinrad;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.cinrad.Cinrad2Record;
import ucar.nc2.iosp.nexrad2.NexradStationDB;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.bzip2.BZip2ReadException;
import ucar.unidata.io.bzip2.CBZip2InputStream;

public class Cinrad2VolumeScan {
    public static final String ARCHIVE2 = "ARCHIVE2";
    public static final String AR2V0001 = "AR2V0001";
    private static Logger log = LoggerFactory.getLogger(Cinrad2VolumeScan.class);
    RandomAccessFile raf;
    private String dataFormat = null;
    private String volumeNo = null;
    private int title_julianDay;
    private int title_msecs;
    private String stationId;
    private NexradStationDB.Station station;
    private Cinrad2Record first;
    private Cinrad2Record last;
    private int vcp = 0;
    private int max_radials = 0;
    private int min_radials = Integer.MAX_VALUE;
    private int dopplarResolution;
    private boolean hasDifferentDopplarResolutions;
    private ArrayList reflectivityGroups;
    private ArrayList dopplerGroups;
    private boolean showMessages = false;
    private boolean showData = false;
    private boolean debugScans = false;
    private boolean debugGroups2 = false;
    private boolean debugRadials = false;
    private int MAX_RADIAL = 401;
    private int[] radial = new int[this.MAX_RADIAL];

    Cinrad2VolumeScan(RandomAccessFile orgRaf, CancelTask cancelTask) throws IOException {
        Cinrad2Record r;
        this.raf = orgRaf;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("Cinrad2VolumeScan on " + this.raf.getLocation());
        }
        this.raf.seek(0L);
        this.raf.order(1);
        String loc = this.raf.getLocation();
        this.stationId = this.getStationID(loc);
        this.dataFormat = this.raf.readString(8);
        this.raf.skipBytes(1);
        this.volumeNo = this.raf.readString(3);
        this.title_julianDay = this.raf.readInt();
        this.title_msecs = this.raf.readInt();
        if (debug) {
            log.debug(" dataFormat= " + this.dataFormat + " stationId= " + this.stationId);
        }
        if (this.stationId.length() == 0) {
            this.stationId = null;
        }
        if (this.stationId != null) {
            this.station = NexradStationDB.get("K" + this.stationId);
            this.dataFormat = "CINRAD-SA";
        }
        if (this.dataFormat.equals(AR2V0001)) {
            this.raf.skipBytes(4);
            String BZ = this.raf.readString(2);
            if (BZ.equals("BZ")) {
                RandomAccessFile uraf = null;
                File uncompressedFile = DiskCache.getFileStandardPolicy(this.raf.getLocation() + ".uncompress");
                if (uncompressedFile.exists()) {
                    uraf = new RandomAccessFile(uncompressedFile.getPath(), "r");
                } else {
                    uraf = this.uncompress(this.raf, uncompressedFile.getPath(), debug);
                    try {
                        uraf.flush();
                    }
                    catch (IOException e) {
                        uraf.close();
                        throw e;
                    }
                    if (debug) {
                        log.debug("flushed uncompressed file= " + uncompressedFile.getPath());
                    }
                }
                this.raf.close();
                this.raf = uraf;
                this.raf.order(0);
            }
            this.raf.seek(0L);
        }
        ArrayList<Cinrad2Record> reflectivity = new ArrayList<Cinrad2Record>();
        ArrayList<Cinrad2Record> doppler = new ArrayList<Cinrad2Record>();
        int recno = 0;
        while ((r = Cinrad2Record.factory(this.raf, recno++)) != null) {
            if (r.message_type != 1) {
                if (!this.showMessages) continue;
                r.dumpMessage(System.out, null);
                continue;
            }
            if (this.showData) {
                r.dump2(System.out);
            }
            if (this.vcp == 0) {
                this.vcp = r.vcp;
            }
            if (this.first == null) {
                this.first = r;
            }
            this.last = r;
            if (!r.checkOk()) continue;
            if (r.hasReflectData) {
                reflectivity.add(r);
            }
            if (r.hasDopplerData) {
                doppler.add(r);
            }
            if (cancelTask == null || !cancelTask.isCancel()) continue;
            return;
        }
        if (this.debugRadials) {
            System.out.println(" reflect ok= " + reflectivity.size() + " doppler ok= " + doppler.size());
        }
        this.reflectivityGroups = this.sortScans("reflect", reflectivity);
        this.dopplerGroups = this.sortScans("doppler", doppler);
    }

    public String getStationID(String location) {
        int posFirst = location.lastIndexOf(47) + 1;
        if (posFirst < 0) {
            posFirst = 0;
        }
        String stationID = location.substring(posFirst, posFirst + 4);
        return stationID;
    }

    private static double parseDegree(String s) {
        StringTokenizer stoke = new StringTokenizer(s, ":");
        String degS = stoke.nextToken();
        String minS = stoke.nextToken();
        String secS = stoke.nextToken();
        try {
            double deg = Double.parseDouble(degS);
            double min = Double.parseDouble(minS);
            double sec = Double.parseDouble(secS);
            if (deg < 0.0) {
                return deg - min / 60.0 - sec / 3600.0;
            }
            return deg + min / 60.0 + sec / 3600.0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private ArrayList sortScans(String name, List scans) {
        ArrayList group;
        int i;
        HashMap<Integer, ArrayList<Cinrad2Record>> groupHash = new HashMap<Integer, ArrayList<Cinrad2Record>>(600);
        for (int i2 = 0; i2 < scans.size(); ++i2) {
            Cinrad2Record record = (Cinrad2Record)scans.get(i2);
            Integer groupNo = new Integer(record.elevation_num);
            ArrayList<Cinrad2Record> group2 = (ArrayList<Cinrad2Record>)groupHash.get(groupNo);
            if (null == group2) {
                group2 = new ArrayList<Cinrad2Record>();
                groupHash.put(groupNo, group2);
            }
            group2.add(record);
        }
        ArrayList groups = new ArrayList(groupHash.values());
        Collections.sort(groups, new GroupComparator());
        for (i = 0; i < groups.size(); ++i) {
            group = (ArrayList)groups.get(i);
            this.testScan(name, group);
            this.max_radials = Math.max(this.max_radials, group.size());
            this.min_radials = Math.min(this.min_radials, group.size());
        }
        if (this.debugRadials) {
            System.out.println(name + " min_radials= " + this.min_radials + " max_radials= " + this.max_radials);
            for (i = 0; i < groups.size(); ++i) {
                group = (ArrayList)groups.get(i);
                Cinrad2Record lastr = (Cinrad2Record)group.get(0);
                for (int j = 1; j < group.size(); ++j) {
                    Cinrad2Record r = (Cinrad2Record)group.get(j);
                    if (r.data_msecs < lastr.data_msecs) {
                        System.out.println(" out of order " + j);
                    }
                    lastr = r;
                }
            }
        }
        this.testVariable(name, groups);
        if (this.debugScans) {
            System.out.println("-----------------------------");
        }
        return groups;
    }

    public int getMaxRadials() {
        return this.max_radials;
    }

    public int getMinRadials() {
        return this.min_radials;
    }

    public int getDopplarResolution() {
        return this.dopplarResolution;
    }

    public boolean hasDifferentDopplarResolutions() {
        return this.hasDifferentDopplarResolutions;
    }

    private boolean testScan(String name, ArrayList group) {
        int i;
        int datatype = name.equals("reflect") ? 1 : 2;
        Cinrad2Record first = (Cinrad2Record)group.get(0);
        int n = group.size();
        if (this.debugScans) {
            boolean hasBoth = first.hasDopplerData && first.hasReflectData;
            System.out.println(name + " " + first + " has " + n + " radials resolution= " + first.resolution + " has both = " + hasBoth);
        }
        boolean ok = true;
        double sum = 0.0;
        double sum2 = 0.0;
        for (i = 0; i < this.MAX_RADIAL; ++i) {
            this.radial[i] = 0;
        }
        for (i = 0; i < group.size(); ++i) {
            Cinrad2Record r = (Cinrad2Record)group.get(i);
            if (r.getGateSize(datatype) != first.getGateSize(datatype)) {
                log.warn(this.raf.getLocation() + " different gate size (" + r.getGateSize(datatype) + ") in record " + name + " " + r);
                ok = false;
            }
            if (r.getGateStart(datatype) != first.getGateStart(datatype)) {
                log.warn(this.raf.getLocation() + " different gate start (" + r.getGateStart(datatype) + ") in record " + name + " " + r);
                ok = false;
            }
            if (r.resolution != first.resolution) {
                log.warn(this.raf.getLocation() + " different resolution (" + r.resolution + ") in record " + name + " " + r);
                ok = false;
            }
            if (r.radial_num < 0 || r.radial_num >= this.MAX_RADIAL) {
                log.info(this.raf.getLocation() + " radial out of range= " + r.radial_num + " in record " + name + " " + r);
                continue;
            }
            if (this.radial[r.radial_num] > 0) {
                log.warn(this.raf.getLocation() + " duplicate radial = " + r.radial_num + " in record " + name + " " + r);
                ok = false;
            }
            this.radial[r.radial_num] = r.recno + 1;
            sum += (double)r.getElevation();
            sum2 += (double)(r.getElevation() * r.getElevation());
        }
        for (i = 1; i < this.radial.length; ++i) {
            if (0 != this.radial[i]) continue;
            if (n == i - 1) break;
            log.warn(" missing radial(s)");
            ok = false;
            break;
        }
        return ok;
    }

    private boolean testVariable(String name, List scans) {
        int datatype;
        int n = datatype = name.equals("reflect") ? 1 : 2;
        if (scans.size() == 0) {
            log.warn(" No data for = " + name);
            return false;
        }
        boolean ok = true;
        List firstScan = (List)scans.get(0);
        Cinrad2Record firstRecord = (Cinrad2Record)firstScan.get(0);
        this.dopplarResolution = firstRecord.resolution;
        if (this.debugGroups2) {
            System.out.println("Group " + Cinrad2Record.getDatatypeName(datatype) + " ngates = " + firstRecord.getGateCount(datatype) + " start = " + firstRecord.getGateStart(datatype) + " size = " + firstRecord.getGateSize(datatype));
        }
        for (int i = 1; i < scans.size(); ++i) {
            List scan = (List)scans.get(i);
            Cinrad2Record record = (Cinrad2Record)scan.get(0);
            if (datatype == 2 && record.resolution != firstRecord.resolution) {
                log.warn(name + " scan " + i + " diff resolutions = " + record.resolution + ", " + firstRecord.resolution + " elev= " + record.elevation_num + " " + record.getElevation());
                ok = false;
                this.hasDifferentDopplarResolutions = true;
            }
            if (record.getGateSize(datatype) != firstRecord.getGateSize(datatype)) {
                log.warn(name + " scan " + i + " diff gates size = " + record.getGateSize(datatype) + " " + firstRecord.getGateSize(datatype) + " elev= " + record.elevation_num + " " + record.getElevation());
                ok = false;
            } else if (this.debugGroups2) {
                System.out.println(" ok gates size elev= " + record.elevation_num + " " + record.getElevation());
            }
            if (record.getGateStart(datatype) != firstRecord.getGateStart(datatype)) {
                log.warn(name + " scan " + i + " diff gates start = " + record.getGateStart(datatype) + " " + firstRecord.getGateStart(datatype) + " elev= " + record.elevation_num + " " + record.getElevation());
                ok = false;
                continue;
            }
            if (!this.debugGroups2) continue;
            System.out.println(" ok gates start elev= " + record.elevation_num + " " + record.getElevation());
        }
        return ok;
    }

    public List getReflectivityGroups() {
        return this.reflectivityGroups;
    }

    public List getVelocityGroups() {
        return this.dopplerGroups;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public int getTitleJulianDays() {
        return this.title_julianDay;
    }

    public int getTitleMsecs() {
        return this.title_msecs;
    }

    public int getVCP() {
        return this.vcp;
    }

    public String getStationId() {
        return this.stationId;
    }

    public String getStationName() {
        return this.station == null ? "unknown" : this.station.name;
    }

    public double getStationLatitude() {
        return this.station == null ? 0.0 : this.station.lat;
    }

    public double getStationLongitude() {
        return this.station == null ? 0.0 : this.station.lon;
    }

    public double getStationElevation() {
        return this.station == null ? 0.0 : this.station.elev;
    }

    public Date getStartDate() {
        return this.first.getDate();
    }

    public Date getEndDate() {
        return this.last.getDate();
    }

    private RandomAccessFile uncompress(RandomAccessFile raf2, String ufilename, boolean debug) throws IOException {
        raf2.seek(0L);
        byte[] header = new byte[]{};
        int bytesRead = raf2.read(header);
        if (bytesRead != header.length) {
            throw new IOException("Error reading CINRAD header -- got " + bytesRead + " rather than" + header.length);
        }
        RandomAccessFile dout2 = new RandomAccessFile(ufilename, "rw");
        boolean eof = false;
        byte[] ubuff = new byte[40000];
        byte[] obuff = new byte[40000];
        try {
            dout2.write(header);
            CBZip2InputStream cbzip2 = new CBZip2InputStream();
            while (!eof) {
                int numCompBytes;
                block16: {
                    try {
                        numCompBytes = raf2.readInt();
                        if (numCompBytes == -1) {
                            if (!debug) break;
                            log.debug("  done: numCompBytes=-1 ");
                        }
                        break block16;
                    }
                    catch (EOFException ee) {
                        if (!debug) break;
                        log.debug("  got EOFException ");
                    }
                    break;
                }
                if (debug) {
                    log.debug("reading compressed bytes " + numCompBytes + " input starts at " + raf2.getFilePointer() + "; output starts at " + dout2.getFilePointer());
                }
                if (numCompBytes < 0) {
                    if (debug) {
                        log.debug("last block?" + numCompBytes);
                    }
                    numCompBytes = -numCompBytes;
                    eof = true;
                }
                byte[] buf = new byte[numCompBytes];
                raf2.readFully(buf);
                ByteArrayInputStream bis = new ByteArrayInputStream(buf, 2, numCompBytes - 2);
                cbzip2.setStream(bis);
                int total = 0;
                try {
                    int nread;
                    while ((nread = cbzip2.read(ubuff)) != -1) {
                        if (total + nread > obuff.length) {
                            byte[] temp = obuff;
                            obuff = new byte[temp.length * 2];
                            System.arraycopy(temp, 0, obuff, 0, temp.length);
                        }
                        System.arraycopy(ubuff, 0, obuff, total, nread);
                        total += nread;
                    }
                    if (obuff.length >= 0) {
                        dout2.write(obuff, 0, total);
                    }
                }
                catch (BZip2ReadException ioe) {
                    log.debug("Cinrad2IOSP.uncompress ", ioe);
                }
                float nrecords = (float)((double)total / 2432.0);
                if (!debug) continue;
                log.debug("  unpacked " + total + " num bytes " + nrecords + " records; ouput ends at " + dout2.getFilePointer());
            }
            dout2.flush();
        }
        catch (EOFException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            dout2.close();
            throw e;
        }
        return dout2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long testValid(String ufilename) throws IOException {
        boolean lookForHeader = false;
        try (RandomAccessFile raf = new RandomAccessFile(ufilename, "r");){
            raf.order(1);
            raf.seek(0L);
            String test = raf.readString(8);
            if (test.equals(ARCHIVE2) || test.equals(AR2V0001)) {
                System.out.println("--Good header= " + test);
                raf.seek(24L);
            } else {
                System.out.println("--No header ");
                lookForHeader = true;
                raf.seek(0L);
            }
            boolean eof = false;
            while (!eof) {
                int numCompBytes;
                block25: {
                    if (lookForHeader) {
                        test = raf.readString(8);
                        if (test.equals(ARCHIVE2) || test.equals(AR2V0001)) {
                            System.out.println("  found header= " + test);
                            raf.skipBytes(16);
                            lookForHeader = false;
                        } else {
                            raf.skipBytes(-8);
                        }
                    }
                    try {
                        numCompBytes = raf.readInt();
                        if (numCompBytes == -1) {
                            System.out.println("\n--done: numCompBytes=-1 ");
                        }
                        break block25;
                    }
                    catch (EOFException ee) {
                        System.out.println("\n--got EOFException ");
                    }
                    break;
                }
                System.out.print(" " + numCompBytes + ",");
                if (numCompBytes < 0) {
                    System.out.println("\n--last block " + numCompBytes);
                    numCompBytes = -numCompBytes;
                    if (!lookForHeader) {
                        eof = true;
                    }
                }
                raf.skipBytes(numCompBytes);
            }
            long l = raf.getFilePointer();
            return l;
        }
        catch (EOFException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static void main2(String[] args) throws IOException {
        File testDir = new File("/share/testdata/radar/problem");
        File[] files = testDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getPath().endsWith(".ar2v")) continue;
            System.out.println(file.getPath() + " " + file.length());
            long pos = Cinrad2VolumeScan.testValid(file.getPath());
            if (pos == file.length()) {
                System.out.println("OK");
                try {
                    NetcdfFile.open(file.getPath());
                }
                catch (Throwable t) {
                    System.out.println("ERROR=  " + t);
                }
            } else {
                System.out.println("NOT pos=" + pos);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws IOException {
        NexradStationDB.init();
        RandomAccessFile raf = new RandomAccessFile("R:/testdata/radar/nexrad/Cinrad2/problem/KCCX_20060627_1701", "r");
        new Cinrad2VolumeScan(raf, null);
    }

    private static class GroupComparator
    implements Comparator {
        private GroupComparator() {
        }

        public int compare(Object o1, Object o2) {
            List group1 = (List)o1;
            List group2 = (List)o2;
            Cinrad2Record record1 = (Cinrad2Record)group1.get(0);
            Cinrad2Record record2 = (Cinrad2Record)group2.get(0);
            return record1.elevation_num - record2.elevation_num;
        }
    }
}

