/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.referencing.internal.Arithmetic;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConstantTransform1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.util.ExtendedPrecisionMatrix;
import org.apache.sis.util.ComparisonMode;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class LinearTransform1D
extends AbstractMathTransform1D
implements LinearTransform,
ExtendedPrecisionMatrix,
Serializable {
    private static final long serialVersionUID = 4507255773105057855L;
    static final LinearTransform1D NEGATE = new LinearTransform1D(-1, 0);
    final double scale;
    final double offset;
    private final Number scaleNumber;
    private final Number offsetNumber;
    private transient LinearTransform1D inverse;

    LinearTransform1D(Number scale, Number offset) {
        this.scale = scale.doubleValue();
        this.offset = offset.doubleValue();
        this.scaleNumber = this.scale == 0.0 ? (Number)null : (Number)scale;
        this.offsetNumber = this.offset == 0.0 ? (Number)null : (Number)offset;
    }

    static LinearTransform1D create(Number scale, Number offset) {
        if (ExtendedPrecisionMatrix.isZero(scale)) {
            if (ExtendedPrecisionMatrix.isZero(offset)) {
                return ConstantTransform1D.ZERO;
            }
            if (Arithmetic.isOne(offset)) {
                return ConstantTransform1D.ONE;
            }
            return new ConstantTransform1D(offset);
        }
        if (ExtendedPrecisionMatrix.isZero(offset)) {
            double s = scale.doubleValue();
            if (s == 1.0) {
                return IdentityTransform1D.INSTANCE;
            }
            if (s == -1.0) {
                return NEGATE;
            }
            if (offset == null) {
                offset = 0;
            }
        }
        return new LinearTransform1D(scale, offset);
    }

    static LinearTransform1D constant(double x, double y) {
        LinearTransform1D tr = LinearTransform1D.create(null, y);
        if (!Double.isNaN(x)) {
            tr.inverse = LinearTransform1D.create(null, x);
        }
        return tr;
    }

    @Override
    public final Matrix clone() {
        return this;
    }

    @Override
    public final Matrix getMatrix() {
        return this;
    }

    @Override
    public final int getNumRow() {
        return 2;
    }

    @Override
    public final int getNumCol() {
        return 2;
    }

    @Override
    public final Number getElementOrNull(int row, int column) {
        if (((row | column) & 0xFFFFFFFE) == 0) {
            switch (row << 1 | column) {
                case 0: {
                    return this.scaleNumber;
                }
                case 1: {
                    return this.offsetNumber;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return 1;
                }
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final Number[] getElementAsNumbers(boolean writable) {
        return new Number[]{this.scaleNumber, this.offsetNumber, null, 1};
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.provider(1, 1, true).getParameters();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return Affine.parameters(this.getMatrix());
    }

    @Override
    public synchronized LinearTransform1D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.scale != 0.0) {
                Number n = Arithmetic.negate(this.offsetNumber);
                LinearTransform1D inverse = LinearTransform1D.create(Arithmetic.inverse(this.scaleNumber), Arithmetic.divide(n, this.scaleNumber));
                inverse.inverse = this;
                this.inverse = inverse;
            } else {
                this.inverse = (LinearTransform1D)super.inverse();
            }
        }
        return this.inverse;
    }

    @Override
    public final boolean isAffine() {
        return true;
    }

    @Override
    public final boolean isIdentity() {
        return this.offset == 0.0 && this.scale == 1.0;
    }

    @Override
    public final Matrix derivative(DirectPosition point) throws TransformException {
        return new Matrix1(this.scale);
    }

    @Override
    public final double derivative(double value) {
        return this.scale;
    }

    @Override
    public double transform(double value) {
        return this.offset + this.scale * value;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        if (dstPts != null) {
            dstPts[dstOff] = this.offset + this.scale * srcPts[srcOff];
        }
        return derivate ? new Matrix1(this.scale) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.offset + this.scale * srcPts[srcOff++];
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.offset + this.scale * srcPts[--srcOff];
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(this.offset + this.scale * (double)srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(this.offset + this.scale * (double)srcPts[--srcOff]);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)(this.offset + this.scale * srcPts[srcOff++]);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = this.offset + this.scale * (double)srcPts[srcOff++];
        }
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.scale * srcPts[srcOff++];
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.scale * srcPts[--srcOff];
            }
        }
    }

    @Override
    protected int computeHashCode() {
        return Long.hashCode((long)super.computeHashCode() ^ Double.doubleToRawLongBits(this.offset) + Double.doubleToRawLongBits(this.scale) * 31L + (long)(Objects.hashCode(this.offsetNumber) * 37) + (long)(Objects.hashCode(this.scaleNumber) * 7));
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (mode != ComparisonMode.STRICT) {
            if (object instanceof LinearTransform) {
                return Matrices.equals(this.getMatrix(), ((LinearTransform)object).getMatrix(), mode);
            }
        } else if (super.equals(object, mode)) {
            LinearTransform1D that = (LinearTransform1D)object;
            return Double.doubleToRawLongBits(this.scale) == Double.doubleToRawLongBits(that.scale) && Double.doubleToRawLongBits(this.offset) == Double.doubleToRawLongBits(that.offset) && Objects.equals(this.scaleNumber, that.scaleNumber) && Objects.equals(this.offsetNumber, that.offsetNumber);
        }
        return false;
    }

    @Override
    public String toString() {
        return Matrices.toString(this.getMatrix());
    }
}

