/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.GeodeticOperation;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.EllipsoidToCentricTransform;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

public final class GeographicToGeocentric
extends GeodeticOperation {
    private static final long serialVersionUID = -5690807111952562344L;
    public static final String NAME = "Ellipsoid_To_Geocentric";
    public static final ParameterDescriptor<Integer> DIMENSION;
    public static final ParameterDescriptorGroup PARAMETERS;
    private static final GeographicToGeocentric[] REDIMENSIONED;

    @Override
    final GeodeticOperation redimensioned(int indexOfDim) {
        return REDIMENSIONED[indexOfDim];
    }

    @Deprecated
    public GeographicToGeocentric() {
        super(REDIMENSIONED[3]);
    }

    private GeographicToGeocentric(int indexOfDim) {
        super(Conversion.class, PARAMETERS, indexOfDim, EllipsoidalCS.class, true, CartesianCS.class, false);
    }

    @Override
    public String resolveAmbiguity(DefaultMathTransformFactory.Context context) {
        if (context.getSourceCS() instanceof CartesianCS && context.getTargetCS() instanceof EllipsoidalCS) {
            return "Geocentric_To_Ellipsoid";
        }
        return super.resolveAmbiguity(context);
    }

    @Override
    public AbstractProvider inverse() {
        return null;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        return GeographicToGeocentric.create(factory, Parameters.castOrWrap(values));
    }

    static MathTransform create(MathTransformFactory factory, Parameters values) throws FactoryException {
        ParameterValue<?> semiMajor = values.parameter("semi_major");
        Unit<Length> unit = semiMajor.getUnit().asType(Length.class);
        return EllipsoidToCentricTransform.createGeodeticConversion(factory, semiMajor.doubleValue(), values.parameter("semi_minor").doubleValue(unit), unit, values.intValue(DIMENSION) >= 3, EllipsoidToCentricTransform.TargetType.CARTESIAN);
    }

    static {
        ParameterBuilder builder = GeographicToGeocentric.builder();
        DIMENSION = ((ParameterBuilder)builder.addName(Citations.SIS, "dim")).setRequired(false).createBounded(Integer.class, Integer.valueOf(2), Integer.valueOf(3), 3);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9602")).addName("Geographic/geocentric conversions")).addName(Citations.OGC, NAME)).createGroupForMapProjection(DIMENSION);
        REDIMENSIONED = new GeographicToGeocentric[4];
        GeographicToGeocentric.REDIMENSIONED[1] = new GeographicToGeocentric(1);
        GeographicToGeocentric.REDIMENSIONED[3] = new GeographicToGeocentric(3);
    }
}

