/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRCompilationUnit;

public class CompilationUnits {
    private JRCompilationUnit[] reportUnits;
    private JRCompilationUnit[] sourceUnits;
    private int[] sourceUnitIndexes;

    public CompilationUnits(JRCompilationUnit[] reportUnits) {
        this.reportUnits = reportUnits;
        this.initSourceUnits();
    }

    private void initSourceUnits() {
        this.sourceUnitIndexes = new int[this.reportUnits.length];
        ArrayList<JRCompilationUnit> sourceUnitList = new ArrayList<JRCompilationUnit>(this.reportUnits.length);
        for (int i = 0; i < this.reportUnits.length; ++i) {
            JRCompilationUnit unit = this.reportUnits[i];
            if (unit.hasSource()) {
                this.sourceUnitIndexes[i] = sourceUnitList.size();
                sourceUnitList.add(unit);
                continue;
            }
            this.sourceUnitIndexes[i] = -1;
        }
        this.sourceUnits = sourceUnitList.toArray(new JRCompilationUnit[sourceUnitList.size()]);
    }

    public JRCompilationUnit[] getSourceUnits() {
        return this.sourceUnits;
    }

    public JRCompilationUnit getCompiledUnit(int index) {
        int sourceUnitIndex = this.sourceUnitIndexes[index];
        return sourceUnitIndex >= 0 ? this.sourceUnits[sourceUnitIndex] : this.reportUnits[index];
    }
}

