/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandleStreamImpl;
import org.apache.flink.runtime.state.changelog.StateChange;
import org.apache.flink.runtime.state.changelog.StateChangelogHandleReader;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StateChangelogHandleStreamHandleReader
implements StateChangelogHandleReader<ChangelogStateHandleStreamImpl> {
    private static final Logger LOG = LoggerFactory.getLogger(StateChangelogHandleStreamHandleReader.class);
    private final StateChangeIterator changeIterator;

    public StateChangelogHandleStreamHandleReader(StateChangeIterator changeIterator) {
        this.changeIterator = changeIterator;
    }

    @Override
    public CloseableIterator<StateChange> getChanges(final ChangelogStateHandleStreamImpl handle) throws IOException {
        return new CloseableIterator<StateChange>(){
            private final Iterator<Tuple2<StreamStateHandle, Long>> handleIterator;
            private CloseableIterator<StateChange> current;
            {
                this.handleIterator = handle.getHandlesAndOffsets().iterator();
                this.current = CloseableIterator.empty();
            }

            public boolean hasNext() {
                this.advance();
                return this.current.hasNext();
            }

            public StateChange next() {
                this.advance();
                return (StateChange)this.current.next();
            }

            private void advance() {
                while (!this.current.hasNext() && this.handleIterator.hasNext()) {
                    try {
                        this.current.close();
                        Tuple2<StreamStateHandle, Long> tuple2 = this.handleIterator.next();
                        LOG.debug("read at {} from {}", tuple2.f1, tuple2.f0);
                        this.current = StateChangelogHandleStreamHandleReader.this.changeIterator.read((StreamStateHandle)tuple2.f0, (Long)tuple2.f1);
                    }
                    catch (Exception e) {
                        ExceptionUtils.rethrow((Throwable)e);
                    }
                }
            }

            public void close() throws Exception {
                this.current.close();
            }
        };
    }

    public static interface StateChangeIterator {
        public CloseableIterator<StateChange> read(StreamStateHandle var1, long var2) throws IOException;
    }
}

