/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.concurrent.FutureUtils;

public class RpcUtils {
    public static final Time INF_TIMEOUT = Time.seconds((long)21474835L);
    public static final Duration INF_DURATION = Duration.ofSeconds(21474835L);

    public static Set<Class<? extends RpcGateway>> extractImplementedRpcGateways(Class<?> clazz) {
        HashSet<Class<? extends RpcGateway>> interfaces = new HashSet<Class<? extends RpcGateway>>();
        while (clazz != null) {
            for (Class<?> interfaze : clazz.getInterfaces()) {
                if (!RpcGateway.class.isAssignableFrom(interfaze)) continue;
                interfaces.add(interfaze);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static void terminateRpcEndpoint(RpcEndpoint rpcEndpoint, Time timeout) throws ExecutionException, InterruptedException, TimeoutException {
        rpcEndpoint.closeAsync().get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public static void terminateRpcEndpoints(Time timeout, RpcEndpoint ... rpcEndpoints) throws InterruptedException, ExecutionException, TimeoutException {
        RpcUtils.terminateAsyncCloseables(Arrays.asList(rpcEndpoints), timeout);
    }

    public static void terminateRpcService(RpcService rpcService, Time timeout) throws InterruptedException, ExecutionException, TimeoutException {
        rpcService.stopService().get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public static void terminateRpcServices(Time timeout, RpcService ... rpcServices) throws InterruptedException, ExecutionException, TimeoutException {
        RpcUtils.terminateAsyncCloseables(Arrays.stream(rpcServices).map(rpcService -> rpcService::stopService).collect(Collectors.toList()), timeout);
    }

    private static void terminateAsyncCloseables(Collection<? extends AutoCloseableAsync> closeables, Time timeout) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<CompletableFuture> terminationFutures = new ArrayList<CompletableFuture>(closeables.size());
        for (AutoCloseableAsync autoCloseableAsync : closeables) {
            if (autoCloseableAsync == null) continue;
            terminationFutures.add(autoCloseableAsync.closeAsync());
        }
        FutureUtils.waitForAll(terminationFutures).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public static String getHostname(RpcService rpcService) {
        String rpcServiceAddress = rpcService.getAddress();
        return rpcServiceAddress != null && rpcServiceAddress.isEmpty() ? "localhost" : rpcServiceAddress;
    }

    public static RpcSystem.ForkJoinExecutorConfiguration getTestForkJoinExecutorConfiguration() {
        return new RpcSystem.ForkJoinExecutorConfiguration(1.0, 2, 4);
    }

    public static RpcService createRemoteRpcService(RpcSystem rpcSystem, Configuration configuration, @Nullable String externalAddress, String externalPortRange, @Nullable String bindAddress, Optional<Integer> bindPort) throws Exception {
        RpcSystem.RpcServiceBuilder rpcServiceBuilder = rpcSystem.remoteServiceBuilder(configuration, externalAddress, externalPortRange);
        if (bindAddress != null) {
            rpcServiceBuilder = rpcServiceBuilder.withBindAddress(bindAddress);
        }
        if (bindPort.isPresent()) {
            rpcServiceBuilder = rpcServiceBuilder.withBindPort(bindPort.get());
        }
        return rpcServiceBuilder.createAndStart();
    }

    private RpcUtils() {
    }
}

