/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Locale;
import org.apache.maven.wrapper.Logger;
import org.apache.maven.wrapper.Verifier;

public class HashAlgorithmVerifier
implements Verifier {
    @Override
    public void verify(Path file, String property, String algorithm, String expectedSum) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = inputStream.read(buffer)) != -1) {
                digest.update(buffer, 0, length);
            }
        }
        byte[] hash = digest.digest();
        StringBuilder actualSum = new StringBuilder(hash.length * 2);
        for (byte aByte : hash) {
            actualSum.append(String.format("%02x", aByte));
        }
        if (!expectedSum.contentEquals(actualSum)) {
            throw new RuntimeException(String.format(Locale.ROOT, "Failed to validate Maven distribution %s, your Maven distribution might be compromised. If you updated your Maven version, you need to update the specified %s property.", algorithm, property));
        }
        Logger.info(String.format(Locale.ROOT, "Validated %s hash for %s to be equal (%s)", algorithm, file, expectedSum));
    }
}

