/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.http.client.config.RequestConfig;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.enums.ClusterState;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.enums.FlinkK8sRestExposedType;
import org.apache.streampark.common.enums.ResolveOrder;
import org.apache.streampark.common.util.HttpClientUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.core.metrics.flink.Overview;
import org.apache.streampark.console.core.utils.YarnQueueLabelExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TableName(value="t_flink_cluster")
public class FlinkCluster
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FlinkCluster.class);
    @TableId(type=IdType.AUTO)
    private Long id;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String address;
    private String clusterId;
    private String clusterName;
    private Integer executionMode;
    private Long versionId;
    private String k8sNamespace;
    private String serviceAccount;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String description;
    private Long userId;
    private String flinkImage;
    private String options;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String yarnQueue;
    private Boolean k8sHadoopIntegration;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String dynamicProperties;
    private Integer k8sRestExposedType;
    private String k8sConf;
    private Integer resolveOrder;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String exception;
    private Integer clusterState;
    private Date createTime;

    @JsonIgnore
    public FlinkK8sRestExposedType getK8sRestExposedTypeEnum() {
        return FlinkK8sRestExposedType.of((Integer)this.k8sRestExposedType);
    }

    public ExecutionMode getExecutionModeEnum() {
        return ExecutionMode.of((Integer)this.executionMode);
    }

    public ClusterState getClusterStateEnum() {
        return ClusterState.of((Integer)this.clusterState);
    }

    @JsonIgnore
    public Map<String, Object> getOptionMap() {
        if (StringUtils.isBlank((CharSequence)this.options)) {
            return Collections.emptyMap();
        }
        Map map = JacksonUtils.read(this.options, Map.class);
        if (ExecutionMode.YARN_SESSION.equals((Object)this.getExecutionModeEnum())) {
            map.put(ConfigConst.KEY_YARN_APP_NAME(), this.clusterName);
            map.putAll(YarnQueueLabelExpression.getQueueLabelMap(this.yarnQueue));
        }
        map.entrySet().removeIf(entry -> entry.getValue() == null);
        return map;
    }

    @JsonIgnore
    public URI getRemoteURI() {
        try {
            HttpClientUtils.httpGetRequest((String)this.address, (RequestConfig)RequestConfig.custom().setSocketTimeout(2000).build());
            return new URI(this.address);
        }
        catch (Exception e) {
            log.error("Get remote URI failed!", (Throwable)e);
            return null;
        }
    }

    public boolean verifyClusterConnection() {
        if (ExecutionMode.REMOTE.equals((Object)this.getExecutionModeEnum())) {
            if (this.address == null) {
                return false;
            }
            if (!CommonUtils.isLegalUrl(this.address)) {
                return false;
            }
            try {
                String restUrl = this.address + "/overview";
                String result = HttpClientUtils.httpGetRequest((String)restUrl, (RequestConfig)RequestConfig.custom().setConnectTimeout(2000).build());
                JacksonUtils.read(result, Overview.class);
                return true;
            }
            catch (Exception e) {
                log.error("Verify cluster {} connection failed!", (Object)this.address, (Object)e);
                return false;
            }
        }
        if (ExecutionMode.YARN_SESSION.equals((Object)this.getExecutionModeEnum())) {
            try {
                String restUrl = YarnUtils.getRMWebAppURL((boolean)true) + "/proxy/" + this.clusterId + "/overview";
                String result = YarnUtils.restRequest((String)restUrl, (int)2000);
                JacksonUtils.read(result, Overview.class);
                return true;
            }
            catch (Exception e) {
                log.error("Verify cluster connection failed!", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @JsonIgnore
    public Map<String, String> getFlinkConfig() throws JsonProcessingException {
        String restUrl = this.address + "/jobmanager/config";
        String json = HttpClientUtils.httpGetRequest((String)restUrl, (RequestConfig)RequestConfig.custom().setConnectTimeout(2000).build());
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyMap();
        }
        List<Map<String, String>> confList = JacksonUtils.read(json, new TypeReference<List<Map<String, String>>>(){});
        HashMap<String, String> config = new HashMap<String, String>(0);
        confList.forEach(k -> {
            String cfr_ignored_0 = (String)config.put((String)k.get("key"), (String)k.get("value"));
        });
        return config;
    }

    @JsonIgnore
    public Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap dynamicProperties = PropertiesUtils.extractDynamicPropertiesAsJava((String)this.getDynamicProperties());
        map.putAll(this.getOptionMap());
        map.putAll(dynamicProperties);
        ResolveOrder resolveOrder = ResolveOrder.of((Integer)this.getResolveOrder());
        if (resolveOrder != null) {
            map.put(CoreOptions.CLASSLOADER_RESOLVE_ORDER.key(), resolveOrder.getName());
        }
        return map;
    }

    public Long getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getExecutionMode() {
        return this.executionMode;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public String getK8sNamespace() {
        return this.k8sNamespace;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getFlinkImage() {
        return this.flinkImage;
    }

    public String getOptions() {
        return this.options;
    }

    public String getYarnQueue() {
        return this.yarnQueue;
    }

    public Boolean getK8sHadoopIntegration() {
        return this.k8sHadoopIntegration;
    }

    public String getDynamicProperties() {
        return this.dynamicProperties;
    }

    public Integer getK8sRestExposedType() {
        return this.k8sRestExposedType;
    }

    public String getK8sConf() {
        return this.k8sConf;
    }

    public Integer getResolveOrder() {
        return this.resolveOrder;
    }

    public String getException() {
        return this.exception;
    }

    public Integer getClusterState() {
        return this.clusterState;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setExecutionMode(Integer executionMode) {
        this.executionMode = executionMode;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public void setK8sNamespace(String k8sNamespace) {
        this.k8sNamespace = k8sNamespace;
    }

    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setFlinkImage(String flinkImage) {
        this.flinkImage = flinkImage;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setYarnQueue(String yarnQueue) {
        this.yarnQueue = yarnQueue;
    }

    public void setK8sHadoopIntegration(Boolean k8sHadoopIntegration) {
        this.k8sHadoopIntegration = k8sHadoopIntegration;
    }

    public void setDynamicProperties(String dynamicProperties) {
        this.dynamicProperties = dynamicProperties;
    }

    public void setK8sRestExposedType(Integer k8sRestExposedType) {
        this.k8sRestExposedType = k8sRestExposedType;
    }

    public void setK8sConf(String k8sConf) {
        this.k8sConf = k8sConf;
    }

    public void setResolveOrder(Integer resolveOrder) {
        this.resolveOrder = resolveOrder;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public void setClusterState(Integer clusterState) {
        this.clusterState = clusterState;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}

