/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.udf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.util.Collector;

public class RangeBoundaryBuilder<T>
extends RichMapPartitionFunction<T, Object[][]> {
    private int parallelism;
    private final TypeComparatorFactory<T> comparatorFactory;

    public RangeBoundaryBuilder(TypeComparatorFactory<T> comparator, int parallelism) {
        this.comparatorFactory = comparator;
        this.parallelism = parallelism;
    }

    public void mapPartition(Iterable<T> values, Collector<Object[][]> out) throws Exception {
        final TypeComparator comparator = this.comparatorFactory.createComparator();
        ArrayList<T> sampledData = new ArrayList<T>();
        for (T value : values) {
            sampledData.add(value);
        }
        Collections.sort(sampledData, new Comparator<T>(){

            @Override
            public int compare(T first, T second) {
                return comparator.compare(first, second);
            }
        });
        int boundarySize = this.parallelism - 1;
        Object[][] boundaries = new Object[boundarySize][];
        if (sampledData.size() > 0) {
            double avgRange = (double)sampledData.size() / (double)this.parallelism;
            int numKey = comparator.getFlatComparators().length;
            for (int i = 1; i < this.parallelism; ++i) {
                Object record = sampledData.get((int)((double)i * avgRange));
                Object[] keys = new Object[numKey];
                comparator.extractKeys(record, keys, 0);
                boundaries[i - 1] = keys;
            }
        }
        out.collect((Object)boundaries);
    }
}

