// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: spark/connect/base.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// A [[Plan]] is the structure that carries the runtime information for the execution from the
/// client to the server. A [[Plan]] can either be of the type [[Relation]] which is a reference
/// to the underlying logical plan or it can be of the [[Command]] type that is used to execute
/// commands on the server.
struct Spark_Connect_Plan: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var opType: Spark_Connect_Plan.OneOf_OpType? = nil

  var root: Spark_Connect_Relation {
    get {
      if case .root(let v)? = opType {return v}
      return Spark_Connect_Relation()
    }
    set {opType = .root(newValue)}
  }

  var command: Spark_Connect_Command {
    get {
      if case .command(let v)? = opType {return v}
      return Spark_Connect_Command()
    }
    set {opType = .command(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_OpType: Equatable, Sendable {
    case root(Spark_Connect_Relation)
    case command(Spark_Connect_Command)

  }

  init() {}
}

/// User Context is used to refer to one particular user session that is executing
/// queries in the backend.
struct Spark_Connect_UserContext: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var userID: String = String()

  var userName: String = String()

  /// To extend the existing user context message that is used to identify incoming requests,
  /// Spark Connect leverages the Any protobuf type that can be used to inject arbitrary other
  /// messages into this message. Extensions are stored as a `repeated` type to be able to
  /// handle multiple active extensions.
  var extensions: [SwiftProtobuf.Google_Protobuf_Any] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Request to perform plan analyze, optionally to explain the plan.
struct Spark_Connect_AnalyzePlanRequest: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id specifies a spark session for a user id (which is specified
  /// by user_context.user_id). The session_id is set by the client to be able to
  /// collate streaming responses from different queries within the dedicated session.
  /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var sessionID: String {
    get {return _storage._sessionID}
    set {_uniqueStorage()._sessionID = newValue}
  }

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _storage._clientObservedServerSideSessionID ?? String()}
    set {_uniqueStorage()._clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return _storage._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {_uniqueStorage()._clientObservedServerSideSessionID = nil}

  /// (Required) User context
  var userContext: Spark_Connect_UserContext {
    get {return _storage._userContext ?? Spark_Connect_UserContext()}
    set {_uniqueStorage()._userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return _storage._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {_uniqueStorage()._userContext = nil}

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _storage._clientType ?? String()}
    set {_uniqueStorage()._clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return _storage._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {_uniqueStorage()._clientType = nil}

  var analyze: OneOf_Analyze? {
    get {return _storage._analyze}
    set {_uniqueStorage()._analyze = newValue}
  }

  var schema: Spark_Connect_AnalyzePlanRequest.Schema {
    get {
      if case .schema(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.Schema()
    }
    set {_uniqueStorage()._analyze = .schema(newValue)}
  }

  var explain: Spark_Connect_AnalyzePlanRequest.Explain {
    get {
      if case .explain(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.Explain()
    }
    set {_uniqueStorage()._analyze = .explain(newValue)}
  }

  var treeString: Spark_Connect_AnalyzePlanRequest.TreeString {
    get {
      if case .treeString(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.TreeString()
    }
    set {_uniqueStorage()._analyze = .treeString(newValue)}
  }

  var isLocal: Spark_Connect_AnalyzePlanRequest.IsLocal {
    get {
      if case .isLocal(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.IsLocal()
    }
    set {_uniqueStorage()._analyze = .isLocal(newValue)}
  }

  var isStreaming: Spark_Connect_AnalyzePlanRequest.IsStreaming {
    get {
      if case .isStreaming(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.IsStreaming()
    }
    set {_uniqueStorage()._analyze = .isStreaming(newValue)}
  }

  var inputFiles: Spark_Connect_AnalyzePlanRequest.InputFiles {
    get {
      if case .inputFiles(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.InputFiles()
    }
    set {_uniqueStorage()._analyze = .inputFiles(newValue)}
  }

  var sparkVersion: Spark_Connect_AnalyzePlanRequest.SparkVersion {
    get {
      if case .sparkVersion(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.SparkVersion()
    }
    set {_uniqueStorage()._analyze = .sparkVersion(newValue)}
  }

  var ddlParse: Spark_Connect_AnalyzePlanRequest.DDLParse {
    get {
      if case .ddlParse(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.DDLParse()
    }
    set {_uniqueStorage()._analyze = .ddlParse(newValue)}
  }

  var sameSemantics: Spark_Connect_AnalyzePlanRequest.SameSemantics {
    get {
      if case .sameSemantics(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.SameSemantics()
    }
    set {_uniqueStorage()._analyze = .sameSemantics(newValue)}
  }

  var semanticHash: Spark_Connect_AnalyzePlanRequest.SemanticHash {
    get {
      if case .semanticHash(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.SemanticHash()
    }
    set {_uniqueStorage()._analyze = .semanticHash(newValue)}
  }

  var persist: Spark_Connect_AnalyzePlanRequest.Persist {
    get {
      if case .persist(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.Persist()
    }
    set {_uniqueStorage()._analyze = .persist(newValue)}
  }

  var unpersist: Spark_Connect_AnalyzePlanRequest.Unpersist {
    get {
      if case .unpersist(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.Unpersist()
    }
    set {_uniqueStorage()._analyze = .unpersist(newValue)}
  }

  var getStorageLevel: Spark_Connect_AnalyzePlanRequest.GetStorageLevel {
    get {
      if case .getStorageLevel(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.GetStorageLevel()
    }
    set {_uniqueStorage()._analyze = .getStorageLevel(newValue)}
  }

  var jsonToDdl: Spark_Connect_AnalyzePlanRequest.JsonToDDL {
    get {
      if case .jsonToDdl(let v)? = _storage._analyze {return v}
      return Spark_Connect_AnalyzePlanRequest.JsonToDDL()
    }
    set {_uniqueStorage()._analyze = .jsonToDdl(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Analyze: Equatable, Sendable {
    case schema(Spark_Connect_AnalyzePlanRequest.Schema)
    case explain(Spark_Connect_AnalyzePlanRequest.Explain)
    case treeString(Spark_Connect_AnalyzePlanRequest.TreeString)
    case isLocal(Spark_Connect_AnalyzePlanRequest.IsLocal)
    case isStreaming(Spark_Connect_AnalyzePlanRequest.IsStreaming)
    case inputFiles(Spark_Connect_AnalyzePlanRequest.InputFiles)
    case sparkVersion(Spark_Connect_AnalyzePlanRequest.SparkVersion)
    case ddlParse(Spark_Connect_AnalyzePlanRequest.DDLParse)
    case sameSemantics(Spark_Connect_AnalyzePlanRequest.SameSemantics)
    case semanticHash(Spark_Connect_AnalyzePlanRequest.SemanticHash)
    case persist(Spark_Connect_AnalyzePlanRequest.Persist)
    case unpersist(Spark_Connect_AnalyzePlanRequest.Unpersist)
    case getStorageLevel(Spark_Connect_AnalyzePlanRequest.GetStorageLevel)
    case jsonToDdl(Spark_Connect_AnalyzePlanRequest.JsonToDDL)

  }

  struct Schema: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to be analyzed.
    var plan: Spark_Connect_Plan {
      get {return _plan ?? Spark_Connect_Plan()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _plan: Spark_Connect_Plan? = nil
  }

  /// Explains the input plan based on a configurable mode.
  struct Explain: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to be analyzed.
    var plan: Spark_Connect_Plan {
      get {return _plan ?? Spark_Connect_Plan()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    /// (Required) For analyzePlan rpc calls, configure the mode to explain plan in strings.
    var explainMode: Spark_Connect_AnalyzePlanRequest.Explain.ExplainMode = .unspecified

    var unknownFields = SwiftProtobuf.UnknownStorage()

    /// Plan explanation mode.
    enum ExplainMode: SwiftProtobuf.Enum, Swift.CaseIterable {
      typealias RawValue = Int
      case unspecified // = 0

      /// Generates only physical plan.
      case simple // = 1

      /// Generates parsed logical plan, analyzed logical plan, optimized logical plan and physical plan.
      /// Parsed Logical plan is a unresolved plan that extracted from the query. Analyzed logical plans
      /// transforms which translates unresolvedAttribute and unresolvedRelation into fully typed objects.
      /// The optimized logical plan transforms through a set of optimization rules, resulting in the
      /// physical plan.
      case extended // = 2

      /// Generates code for the statement, if any and a physical plan.
      case codegen // = 3

      /// If plan node statistics are available, generates a logical plan and also the statistics.
      case cost // = 4

      /// Generates a physical plan outline and also node details.
      case formatted // = 5
      case UNRECOGNIZED(Int)

      init() {
        self = .unspecified
      }

      init?(rawValue: Int) {
        switch rawValue {
        case 0: self = .unspecified
        case 1: self = .simple
        case 2: self = .extended
        case 3: self = .codegen
        case 4: self = .cost
        case 5: self = .formatted
        default: self = .UNRECOGNIZED(rawValue)
        }
      }

      var rawValue: Int {
        switch self {
        case .unspecified: return 0
        case .simple: return 1
        case .extended: return 2
        case .codegen: return 3
        case .cost: return 4
        case .formatted: return 5
        case .UNRECOGNIZED(let i): return i
        }
      }

      // The compiler won't synthesize support with the UNRECOGNIZED case.
      static let allCases: [Spark_Connect_AnalyzePlanRequest.Explain.ExplainMode] = [
        .unspecified,
        .simple,
        .extended,
        .codegen,
        .cost,
        .formatted,
      ]

    }

    init() {}

    fileprivate var _plan: Spark_Connect_Plan? = nil
  }

  struct TreeString: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to be analyzed.
    var plan: Spark_Connect_Plan {
      get {return _plan ?? Spark_Connect_Plan()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    /// (Optional) Max level of the schema.
    var level: Int32 {
      get {return _level ?? 0}
      set {_level = newValue}
    }
    /// Returns true if `level` has been explicitly set.
    var hasLevel: Bool {return self._level != nil}
    /// Clears the value of `level`. Subsequent reads from it will return its default value.
    mutating func clearLevel() {self._level = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _plan: Spark_Connect_Plan? = nil
    fileprivate var _level: Int32? = nil
  }

  struct IsLocal: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to be analyzed.
    var plan: Spark_Connect_Plan {
      get {return _plan ?? Spark_Connect_Plan()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _plan: Spark_Connect_Plan? = nil
  }

  struct IsStreaming: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to be analyzed.
    var plan: Spark_Connect_Plan {
      get {return _plan ?? Spark_Connect_Plan()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _plan: Spark_Connect_Plan? = nil
  }

  struct InputFiles: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to be analyzed.
    var plan: Spark_Connect_Plan {
      get {return _plan ?? Spark_Connect_Plan()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _plan: Spark_Connect_Plan? = nil
  }

  struct SparkVersion: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct DDLParse: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The DDL formatted string to be parsed.
    var ddlString: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  /// Returns `true` when the logical query plans  are equal and therefore return same results.
  struct SameSemantics: @unchecked Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The plan to be compared.
    var targetPlan: Spark_Connect_Plan {
      get {return _storage._targetPlan ?? Spark_Connect_Plan()}
      set {_uniqueStorage()._targetPlan = newValue}
    }
    /// Returns true if `targetPlan` has been explicitly set.
    var hasTargetPlan: Bool {return _storage._targetPlan != nil}
    /// Clears the value of `targetPlan`. Subsequent reads from it will return its default value.
    mutating func clearTargetPlan() {_uniqueStorage()._targetPlan = nil}

    /// (Required) The other plan to be compared.
    var otherPlan: Spark_Connect_Plan {
      get {return _storage._otherPlan ?? Spark_Connect_Plan()}
      set {_uniqueStorage()._otherPlan = newValue}
    }
    /// Returns true if `otherPlan` has been explicitly set.
    var hasOtherPlan: Bool {return _storage._otherPlan != nil}
    /// Clears the value of `otherPlan`. Subsequent reads from it will return its default value.
    mutating func clearOtherPlan() {_uniqueStorage()._otherPlan = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _storage = _StorageClass.defaultInstance
  }

  struct SemanticHash: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to get a hashCode.
    var plan: Spark_Connect_Plan {
      get {return _plan ?? Spark_Connect_Plan()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _plan: Spark_Connect_Plan? = nil
  }

  struct Persist: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to persist.
    var relation: Spark_Connect_Relation {
      get {return _relation ?? Spark_Connect_Relation()}
      set {_relation = newValue}
    }
    /// Returns true if `relation` has been explicitly set.
    var hasRelation: Bool {return self._relation != nil}
    /// Clears the value of `relation`. Subsequent reads from it will return its default value.
    mutating func clearRelation() {self._relation = nil}

    /// (Optional) The storage level.
    var storageLevel: Spark_Connect_StorageLevel {
      get {return _storageLevel ?? Spark_Connect_StorageLevel()}
      set {_storageLevel = newValue}
    }
    /// Returns true if `storageLevel` has been explicitly set.
    var hasStorageLevel: Bool {return self._storageLevel != nil}
    /// Clears the value of `storageLevel`. Subsequent reads from it will return its default value.
    mutating func clearStorageLevel() {self._storageLevel = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _relation: Spark_Connect_Relation? = nil
    fileprivate var _storageLevel: Spark_Connect_StorageLevel? = nil
  }

  struct Unpersist: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to unpersist.
    var relation: Spark_Connect_Relation {
      get {return _relation ?? Spark_Connect_Relation()}
      set {_relation = newValue}
    }
    /// Returns true if `relation` has been explicitly set.
    var hasRelation: Bool {return self._relation != nil}
    /// Clears the value of `relation`. Subsequent reads from it will return its default value.
    mutating func clearRelation() {self._relation = nil}

    /// (Optional) Whether to block until all blocks are deleted.
    var blocking: Bool {
      get {return _blocking ?? false}
      set {_blocking = newValue}
    }
    /// Returns true if `blocking` has been explicitly set.
    var hasBlocking: Bool {return self._blocking != nil}
    /// Clears the value of `blocking`. Subsequent reads from it will return its default value.
    mutating func clearBlocking() {self._blocking = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _relation: Spark_Connect_Relation? = nil
    fileprivate var _blocking: Bool? = nil
  }

  struct GetStorageLevel: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The logical plan to get the storage level.
    var relation: Spark_Connect_Relation {
      get {return _relation ?? Spark_Connect_Relation()}
      set {_relation = newValue}
    }
    /// Returns true if `relation` has been explicitly set.
    var hasRelation: Bool {return self._relation != nil}
    /// Clears the value of `relation`. Subsequent reads from it will return its default value.
    mutating func clearRelation() {self._relation = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _relation: Spark_Connect_Relation? = nil
  }

  struct JsonToDDL: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The JSON formatted string to be converted to DDL.
    var jsonString: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// Response to performing analysis of the query. Contains relevant metadata to be able to
/// reason about the performance.
/// Next ID: 16
struct Spark_Connect_AnalyzePlanResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  var result: Spark_Connect_AnalyzePlanResponse.OneOf_Result? = nil

  var schema: Spark_Connect_AnalyzePlanResponse.Schema {
    get {
      if case .schema(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.Schema()
    }
    set {result = .schema(newValue)}
  }

  var explain: Spark_Connect_AnalyzePlanResponse.Explain {
    get {
      if case .explain(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.Explain()
    }
    set {result = .explain(newValue)}
  }

  var treeString: Spark_Connect_AnalyzePlanResponse.TreeString {
    get {
      if case .treeString(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.TreeString()
    }
    set {result = .treeString(newValue)}
  }

  var isLocal: Spark_Connect_AnalyzePlanResponse.IsLocal {
    get {
      if case .isLocal(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.IsLocal()
    }
    set {result = .isLocal(newValue)}
  }

  var isStreaming: Spark_Connect_AnalyzePlanResponse.IsStreaming {
    get {
      if case .isStreaming(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.IsStreaming()
    }
    set {result = .isStreaming(newValue)}
  }

  var inputFiles: Spark_Connect_AnalyzePlanResponse.InputFiles {
    get {
      if case .inputFiles(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.InputFiles()
    }
    set {result = .inputFiles(newValue)}
  }

  var sparkVersion: Spark_Connect_AnalyzePlanResponse.SparkVersion {
    get {
      if case .sparkVersion(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.SparkVersion()
    }
    set {result = .sparkVersion(newValue)}
  }

  var ddlParse: Spark_Connect_AnalyzePlanResponse.DDLParse {
    get {
      if case .ddlParse(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.DDLParse()
    }
    set {result = .ddlParse(newValue)}
  }

  var sameSemantics: Spark_Connect_AnalyzePlanResponse.SameSemantics {
    get {
      if case .sameSemantics(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.SameSemantics()
    }
    set {result = .sameSemantics(newValue)}
  }

  var semanticHash: Spark_Connect_AnalyzePlanResponse.SemanticHash {
    get {
      if case .semanticHash(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.SemanticHash()
    }
    set {result = .semanticHash(newValue)}
  }

  var persist: Spark_Connect_AnalyzePlanResponse.Persist {
    get {
      if case .persist(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.Persist()
    }
    set {result = .persist(newValue)}
  }

  var unpersist: Spark_Connect_AnalyzePlanResponse.Unpersist {
    get {
      if case .unpersist(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.Unpersist()
    }
    set {result = .unpersist(newValue)}
  }

  var getStorageLevel: Spark_Connect_AnalyzePlanResponse.GetStorageLevel {
    get {
      if case .getStorageLevel(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.GetStorageLevel()
    }
    set {result = .getStorageLevel(newValue)}
  }

  var jsonToDdl: Spark_Connect_AnalyzePlanResponse.JsonToDDL {
    get {
      if case .jsonToDdl(let v)? = result {return v}
      return Spark_Connect_AnalyzePlanResponse.JsonToDDL()
    }
    set {result = .jsonToDdl(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Result: Equatable, Sendable {
    case schema(Spark_Connect_AnalyzePlanResponse.Schema)
    case explain(Spark_Connect_AnalyzePlanResponse.Explain)
    case treeString(Spark_Connect_AnalyzePlanResponse.TreeString)
    case isLocal(Spark_Connect_AnalyzePlanResponse.IsLocal)
    case isStreaming(Spark_Connect_AnalyzePlanResponse.IsStreaming)
    case inputFiles(Spark_Connect_AnalyzePlanResponse.InputFiles)
    case sparkVersion(Spark_Connect_AnalyzePlanResponse.SparkVersion)
    case ddlParse(Spark_Connect_AnalyzePlanResponse.DDLParse)
    case sameSemantics(Spark_Connect_AnalyzePlanResponse.SameSemantics)
    case semanticHash(Spark_Connect_AnalyzePlanResponse.SemanticHash)
    case persist(Spark_Connect_AnalyzePlanResponse.Persist)
    case unpersist(Spark_Connect_AnalyzePlanResponse.Unpersist)
    case getStorageLevel(Spark_Connect_AnalyzePlanResponse.GetStorageLevel)
    case jsonToDdl(Spark_Connect_AnalyzePlanResponse.JsonToDDL)

  }

  struct Schema: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var schema: Spark_Connect_DataType {
      get {return _schema ?? Spark_Connect_DataType()}
      set {_schema = newValue}
    }
    /// Returns true if `schema` has been explicitly set.
    var hasSchema: Bool {return self._schema != nil}
    /// Clears the value of `schema`. Subsequent reads from it will return its default value.
    mutating func clearSchema() {self._schema = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _schema: Spark_Connect_DataType? = nil
  }

  struct Explain: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var explainString: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct TreeString: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var treeString: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct IsLocal: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var isLocal: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct IsStreaming: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var isStreaming: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct InputFiles: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// A best-effort snapshot of the files that compose this Dataset
    var files: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct SparkVersion: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var version: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct DDLParse: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var parsed: Spark_Connect_DataType {
      get {return _parsed ?? Spark_Connect_DataType()}
      set {_parsed = newValue}
    }
    /// Returns true if `parsed` has been explicitly set.
    var hasParsed: Bool {return self._parsed != nil}
    /// Clears the value of `parsed`. Subsequent reads from it will return its default value.
    mutating func clearParsed() {self._parsed = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _parsed: Spark_Connect_DataType? = nil
  }

  struct SameSemantics: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var result: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct SemanticHash: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var result: Int32 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct Persist: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct Unpersist: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct GetStorageLevel: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The StorageLevel as a result of get_storage_level request.
    var storageLevel: Spark_Connect_StorageLevel {
      get {return _storageLevel ?? Spark_Connect_StorageLevel()}
      set {_storageLevel = newValue}
    }
    /// Returns true if `storageLevel` has been explicitly set.
    var hasStorageLevel: Bool {return self._storageLevel != nil}
    /// Clears the value of `storageLevel`. Subsequent reads from it will return its default value.
    mutating func clearStorageLevel() {self._storageLevel = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _storageLevel: Spark_Connect_StorageLevel? = nil
  }

  struct JsonToDDL: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var ddlString: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

/// A request to be executed by the service.
struct Spark_Connect_ExecutePlanRequest: @unchecked Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id specifies a spark session for a user id (which is specified
  /// by user_context.user_id). The session_id is set by the client to be able to
  /// collate streaming responses from different queries within the dedicated session.
  /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var sessionID: String {
    get {return _storage._sessionID}
    set {_uniqueStorage()._sessionID = newValue}
  }

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _storage._clientObservedServerSideSessionID ?? String()}
    set {_uniqueStorage()._clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return _storage._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {_uniqueStorage()._clientObservedServerSideSessionID = nil}

  /// (Required) User context
  ///
  /// user_context.user_id and session+id both identify a unique remote spark session on the
  /// server side.
  var userContext: Spark_Connect_UserContext {
    get {return _storage._userContext ?? Spark_Connect_UserContext()}
    set {_uniqueStorage()._userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return _storage._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {_uniqueStorage()._userContext = nil}

  /// (Optional)
  /// Provide an id for this request. If not provided, it will be generated by the server.
  /// It is returned in every ExecutePlanResponse.operation_id of the ExecutePlan response stream.
  /// The id must be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var operationID: String {
    get {return _storage._operationID ?? String()}
    set {_uniqueStorage()._operationID = newValue}
  }
  /// Returns true if `operationID` has been explicitly set.
  var hasOperationID: Bool {return _storage._operationID != nil}
  /// Clears the value of `operationID`. Subsequent reads from it will return its default value.
  mutating func clearOperationID() {_uniqueStorage()._operationID = nil}

  /// (Required) The logical plan to be executed / analyzed.
  var plan: Spark_Connect_Plan {
    get {return _storage._plan ?? Spark_Connect_Plan()}
    set {_uniqueStorage()._plan = newValue}
  }
  /// Returns true if `plan` has been explicitly set.
  var hasPlan: Bool {return _storage._plan != nil}
  /// Clears the value of `plan`. Subsequent reads from it will return its default value.
  mutating func clearPlan() {_uniqueStorage()._plan = nil}

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _storage._clientType ?? String()}
    set {_uniqueStorage()._clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return _storage._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {_uniqueStorage()._clientType = nil}

  /// Repeated element for options that can be passed to the request. This element is currently
  /// unused but allows to pass in an extension value used for arbitrary options.
  var requestOptions: [Spark_Connect_ExecutePlanRequest.RequestOption] {
    get {return _storage._requestOptions}
    set {_uniqueStorage()._requestOptions = newValue}
  }

  /// Tags to tag the given execution with.
  /// Tags cannot contain ',' character and cannot be empty strings.
  /// Used by Interrupt with interrupt.tag.
  var tags: [String] {
    get {return _storage._tags}
    set {_uniqueStorage()._tags = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct RequestOption: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var requestOption: Spark_Connect_ExecutePlanRequest.RequestOption.OneOf_RequestOption? = nil

    var reattachOptions: Spark_Connect_ReattachOptions {
      get {
        if case .reattachOptions(let v)? = requestOption {return v}
        return Spark_Connect_ReattachOptions()
      }
      set {requestOption = .reattachOptions(newValue)}
    }

    /// Extension type for request options
    var `extension`: SwiftProtobuf.Google_Protobuf_Any {
      get {
        if case .extension(let v)? = requestOption {return v}
        return SwiftProtobuf.Google_Protobuf_Any()
      }
      set {requestOption = .extension(newValue)}
    }

    var unknownFields = SwiftProtobuf.UnknownStorage()

    enum OneOf_RequestOption: Equatable, Sendable {
      case reattachOptions(Spark_Connect_ReattachOptions)
      /// Extension type for request options
      case `extension`(SwiftProtobuf.Google_Protobuf_Any)

    }

    init() {}
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// The response of a query, can be one or more for each request. Responses belonging to the
/// same input query, carry the same `session_id`.
/// Next ID: 17
struct Spark_Connect_ExecutePlanResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  /// Identifies the ExecutePlan execution.
  /// If set by the client in ExecutePlanRequest.operationId, that value is returned.
  /// Otherwise generated by the server.
  /// It is an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var operationID: String = String()

  /// Identified the response in the stream.
  /// The id is an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var responseID: String = String()

  /// Union type for the different response messages.
  var responseType: Spark_Connect_ExecutePlanResponse.OneOf_ResponseType? = nil

  var arrowBatch: Spark_Connect_ExecutePlanResponse.ArrowBatch {
    get {
      if case .arrowBatch(let v)? = responseType {return v}
      return Spark_Connect_ExecutePlanResponse.ArrowBatch()
    }
    set {responseType = .arrowBatch(newValue)}
  }

  /// Special case for executing SQL commands.
  var sqlCommandResult: Spark_Connect_ExecutePlanResponse.SqlCommandResult {
    get {
      if case .sqlCommandResult(let v)? = responseType {return v}
      return Spark_Connect_ExecutePlanResponse.SqlCommandResult()
    }
    set {responseType = .sqlCommandResult(newValue)}
  }

  /// Response for a streaming query.
  var writeStreamOperationStartResult: Spark_Connect_WriteStreamOperationStartResult {
    get {
      if case .writeStreamOperationStartResult(let v)? = responseType {return v}
      return Spark_Connect_WriteStreamOperationStartResult()
    }
    set {responseType = .writeStreamOperationStartResult(newValue)}
  }

  /// Response for commands on a streaming query.
  var streamingQueryCommandResult: Spark_Connect_StreamingQueryCommandResult {
    get {
      if case .streamingQueryCommandResult(let v)? = responseType {return v}
      return Spark_Connect_StreamingQueryCommandResult()
    }
    set {responseType = .streamingQueryCommandResult(newValue)}
  }

  /// Response for 'SparkContext.resources'.
  var getResourcesCommandResult: Spark_Connect_GetResourcesCommandResult {
    get {
      if case .getResourcesCommandResult(let v)? = responseType {return v}
      return Spark_Connect_GetResourcesCommandResult()
    }
    set {responseType = .getResourcesCommandResult(newValue)}
  }

  /// Response for commands on the streaming query manager.
  var streamingQueryManagerCommandResult: Spark_Connect_StreamingQueryManagerCommandResult {
    get {
      if case .streamingQueryManagerCommandResult(let v)? = responseType {return v}
      return Spark_Connect_StreamingQueryManagerCommandResult()
    }
    set {responseType = .streamingQueryManagerCommandResult(newValue)}
  }

  /// Response for commands on the client side streaming query listener.
  var streamingQueryListenerEventsResult: Spark_Connect_StreamingQueryListenerEventsResult {
    get {
      if case .streamingQueryListenerEventsResult(let v)? = responseType {return v}
      return Spark_Connect_StreamingQueryListenerEventsResult()
    }
    set {responseType = .streamingQueryListenerEventsResult(newValue)}
  }

  /// Response type informing if the stream is complete in reattachable execution.
  var resultComplete: Spark_Connect_ExecutePlanResponse.ResultComplete {
    get {
      if case .resultComplete(let v)? = responseType {return v}
      return Spark_Connect_ExecutePlanResponse.ResultComplete()
    }
    set {responseType = .resultComplete(newValue)}
  }

  /// Response for command that creates ResourceProfile.
  var createResourceProfileCommandResult: Spark_Connect_CreateResourceProfileCommandResult {
    get {
      if case .createResourceProfileCommandResult(let v)? = responseType {return v}
      return Spark_Connect_CreateResourceProfileCommandResult()
    }
    set {responseType = .createResourceProfileCommandResult(newValue)}
  }

  /// (Optional) Intermediate query progress reports.
  var executionProgress: Spark_Connect_ExecutePlanResponse.ExecutionProgress {
    get {
      if case .executionProgress(let v)? = responseType {return v}
      return Spark_Connect_ExecutePlanResponse.ExecutionProgress()
    }
    set {responseType = .executionProgress(newValue)}
  }

  /// Response for command that checkpoints a DataFrame.
  var checkpointCommandResult: Spark_Connect_CheckpointCommandResult {
    get {
      if case .checkpointCommandResult(let v)? = responseType {return v}
      return Spark_Connect_CheckpointCommandResult()
    }
    set {responseType = .checkpointCommandResult(newValue)}
  }

  /// ML command response
  var mlCommandResult: Spark_Connect_MlCommandResult {
    get {
      if case .mlCommandResult(let v)? = responseType {return v}
      return Spark_Connect_MlCommandResult()
    }
    set {responseType = .mlCommandResult(newValue)}
  }

  /// Response containing pipeline event that is streamed back to the client during a pipeline run
  var pipelineEventResult: Spark_Connect_PipelineEventResult {
    get {
      if case .pipelineEventResult(let v)? = responseType {return v}
      return Spark_Connect_PipelineEventResult()
    }
    set {responseType = .pipelineEventResult(newValue)}
  }

  /// Pipeline command response
  var pipelineCommandResult: Spark_Connect_PipelineCommandResult {
    get {
      if case .pipelineCommandResult(let v)? = responseType {return v}
      return Spark_Connect_PipelineCommandResult()
    }
    set {responseType = .pipelineCommandResult(newValue)}
  }

  /// Support arbitrary result objects.
  var `extension`: SwiftProtobuf.Google_Protobuf_Any {
    get {
      if case .extension(let v)? = responseType {return v}
      return SwiftProtobuf.Google_Protobuf_Any()
    }
    set {responseType = .extension(newValue)}
  }

  /// Metrics for the query execution. Typically, this field is only present in the last
  /// batch of results and then represent the overall state of the query execution.
  var metrics: Spark_Connect_ExecutePlanResponse.Metrics {
    get {return _metrics ?? Spark_Connect_ExecutePlanResponse.Metrics()}
    set {_metrics = newValue}
  }
  /// Returns true if `metrics` has been explicitly set.
  var hasMetrics: Bool {return self._metrics != nil}
  /// Clears the value of `metrics`. Subsequent reads from it will return its default value.
  mutating func clearMetrics() {self._metrics = nil}

  /// The metrics observed during the execution of the query plan.
  var observedMetrics: [Spark_Connect_ExecutePlanResponse.ObservedMetrics] = []

  /// (Optional) The Spark schema. This field is available when `collect` is called.
  var schema: Spark_Connect_DataType {
    get {return _schema ?? Spark_Connect_DataType()}
    set {_schema = newValue}
  }
  /// Returns true if `schema` has been explicitly set.
  var hasSchema: Bool {return self._schema != nil}
  /// Clears the value of `schema`. Subsequent reads from it will return its default value.
  mutating func clearSchema() {self._schema = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// Union type for the different response messages.
  enum OneOf_ResponseType: Equatable, Sendable {
    case arrowBatch(Spark_Connect_ExecutePlanResponse.ArrowBatch)
    /// Special case for executing SQL commands.
    case sqlCommandResult(Spark_Connect_ExecutePlanResponse.SqlCommandResult)
    /// Response for a streaming query.
    case writeStreamOperationStartResult(Spark_Connect_WriteStreamOperationStartResult)
    /// Response for commands on a streaming query.
    case streamingQueryCommandResult(Spark_Connect_StreamingQueryCommandResult)
    /// Response for 'SparkContext.resources'.
    case getResourcesCommandResult(Spark_Connect_GetResourcesCommandResult)
    /// Response for commands on the streaming query manager.
    case streamingQueryManagerCommandResult(Spark_Connect_StreamingQueryManagerCommandResult)
    /// Response for commands on the client side streaming query listener.
    case streamingQueryListenerEventsResult(Spark_Connect_StreamingQueryListenerEventsResult)
    /// Response type informing if the stream is complete in reattachable execution.
    case resultComplete(Spark_Connect_ExecutePlanResponse.ResultComplete)
    /// Response for command that creates ResourceProfile.
    case createResourceProfileCommandResult(Spark_Connect_CreateResourceProfileCommandResult)
    /// (Optional) Intermediate query progress reports.
    case executionProgress(Spark_Connect_ExecutePlanResponse.ExecutionProgress)
    /// Response for command that checkpoints a DataFrame.
    case checkpointCommandResult(Spark_Connect_CheckpointCommandResult)
    /// ML command response
    case mlCommandResult(Spark_Connect_MlCommandResult)
    /// Response containing pipeline event that is streamed back to the client during a pipeline run
    case pipelineEventResult(Spark_Connect_PipelineEventResult)
    /// Pipeline command response
    case pipelineCommandResult(Spark_Connect_PipelineCommandResult)
    /// Support arbitrary result objects.
    case `extension`(SwiftProtobuf.Google_Protobuf_Any)

  }

  /// A SQL command returns an opaque Relation that can be directly used as input for the next
  /// call.
  struct SqlCommandResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var relation: Spark_Connect_Relation {
      get {return _relation ?? Spark_Connect_Relation()}
      set {_relation = newValue}
    }
    /// Returns true if `relation` has been explicitly set.
    var hasRelation: Bool {return self._relation != nil}
    /// Clears the value of `relation`. Subsequent reads from it will return its default value.
    mutating func clearRelation() {self._relation = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _relation: Spark_Connect_Relation? = nil
  }

  /// Batch results of metrics.
  struct ArrowBatch: @unchecked Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Count rows in `data`. Must match the number of rows inside `data`.
    var rowCount: Int64 = 0

    /// Serialized Arrow data.
    var data: Data = Data()

    /// If set, row offset of the start of this ArrowBatch in execution results.
    var startOffset: Int64 {
      get {return _startOffset ?? 0}
      set {_startOffset = newValue}
    }
    /// Returns true if `startOffset` has been explicitly set.
    var hasStartOffset: Bool {return self._startOffset != nil}
    /// Clears the value of `startOffset`. Subsequent reads from it will return its default value.
    mutating func clearStartOffset() {self._startOffset = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _startOffset: Int64? = nil
  }

  struct Metrics: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var metrics: [Spark_Connect_ExecutePlanResponse.Metrics.MetricObject] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    struct MetricObject: Sendable {
      // SwiftProtobuf.Message conformance is added in an extension below. See the
      // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
      // methods supported on all messages.

      var name: String = String()

      var planID: Int64 = 0

      var parent: Int64 = 0

      var executionMetrics: Dictionary<String,Spark_Connect_ExecutePlanResponse.Metrics.MetricValue> = [:]

      var unknownFields = SwiftProtobuf.UnknownStorage()

      init() {}
    }

    struct MetricValue: Sendable {
      // SwiftProtobuf.Message conformance is added in an extension below. See the
      // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
      // methods supported on all messages.

      var name: String = String()

      var value: Int64 = 0

      var metricType: String = String()

      var unknownFields = SwiftProtobuf.UnknownStorage()

      init() {}
    }

    init() {}
  }

  struct ObservedMetrics: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var name: String = String()

    var values: [Spark_Connect_Expression.Literal] = []

    var keys: [String] = []

    var planID: Int64 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  /// If present, in a reattachable execution this means that after server sends onComplete,
  /// the execution is complete. If the server sends onComplete without sending a ResultComplete,
  /// it means that there is more, and the client should use ReattachExecute RPC to continue.
  struct ResultComplete: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  /// This message is used to communicate progress about the query progress during the execution.
  struct ExecutionProgress: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Captures the progress of each individual stage.
    var stages: [Spark_Connect_ExecutePlanResponse.ExecutionProgress.StageInfo] = []

    /// Captures the currently in progress tasks.
    var numInflightTasks: Int64 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    struct StageInfo: Sendable {
      // SwiftProtobuf.Message conformance is added in an extension below. See the
      // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
      // methods supported on all messages.

      var stageID: Int64 = 0

      var numTasks: Int64 = 0

      var numCompletedTasks: Int64 = 0

      var inputBytesRead: Int64 = 0

      var done: Bool = false

      var unknownFields = SwiftProtobuf.UnknownStorage()

      init() {}
    }

    init() {}
  }

  init() {}

  fileprivate var _metrics: Spark_Connect_ExecutePlanResponse.Metrics? = nil
  fileprivate var _schema: Spark_Connect_DataType? = nil
}

/// The key-value pair for the config request and response.
struct Spark_Connect_KeyValue: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The key.
  var key: String = String()

  /// (Optional) The value.
  var value: String {
    get {return _value ?? String()}
    set {_value = newValue}
  }
  /// Returns true if `value` has been explicitly set.
  var hasValue: Bool {return self._value != nil}
  /// Clears the value of `value`. Subsequent reads from it will return its default value.
  mutating func clearValue() {self._value = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _value: String? = nil
}

/// Request to update or fetch the configurations.
struct Spark_Connect_ConfigRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id specifies a spark session for a user id (which is specified
  /// by user_context.user_id). The session_id is set by the client to be able to
  /// collate streaming responses from different queries within the dedicated session.
  /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var sessionID: String = String()

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _clientObservedServerSideSessionID ?? String()}
    set {_clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return self._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {self._clientObservedServerSideSessionID = nil}

  /// (Required) User context
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// (Required) The operation for the config.
  var operation: Spark_Connect_ConfigRequest.Operation {
    get {return _operation ?? Spark_Connect_ConfigRequest.Operation()}
    set {_operation = newValue}
  }
  /// Returns true if `operation` has been explicitly set.
  var hasOperation: Bool {return self._operation != nil}
  /// Clears the value of `operation`. Subsequent reads from it will return its default value.
  mutating func clearOperation() {self._operation = nil}

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct Operation: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var opType: Spark_Connect_ConfigRequest.Operation.OneOf_OpType? = nil

    var set: Spark_Connect_ConfigRequest.Set {
      get {
        if case .set(let v)? = opType {return v}
        return Spark_Connect_ConfigRequest.Set()
      }
      set {opType = .set(newValue)}
    }

    var get: Spark_Connect_ConfigRequest.Get {
      get {
        if case .get(let v)? = opType {return v}
        return Spark_Connect_ConfigRequest.Get()
      }
      set {opType = .get(newValue)}
    }

    var getWithDefault: Spark_Connect_ConfigRequest.GetWithDefault {
      get {
        if case .getWithDefault(let v)? = opType {return v}
        return Spark_Connect_ConfigRequest.GetWithDefault()
      }
      set {opType = .getWithDefault(newValue)}
    }

    var getOption: Spark_Connect_ConfigRequest.GetOption {
      get {
        if case .getOption(let v)? = opType {return v}
        return Spark_Connect_ConfigRequest.GetOption()
      }
      set {opType = .getOption(newValue)}
    }

    var getAll: Spark_Connect_ConfigRequest.GetAll {
      get {
        if case .getAll(let v)? = opType {return v}
        return Spark_Connect_ConfigRequest.GetAll()
      }
      set {opType = .getAll(newValue)}
    }

    var unset: Spark_Connect_ConfigRequest.Unset {
      get {
        if case .unset(let v)? = opType {return v}
        return Spark_Connect_ConfigRequest.Unset()
      }
      set {opType = .unset(newValue)}
    }

    var isModifiable: Spark_Connect_ConfigRequest.IsModifiable {
      get {
        if case .isModifiable(let v)? = opType {return v}
        return Spark_Connect_ConfigRequest.IsModifiable()
      }
      set {opType = .isModifiable(newValue)}
    }

    var unknownFields = SwiftProtobuf.UnknownStorage()

    enum OneOf_OpType: Equatable, Sendable {
      case set(Spark_Connect_ConfigRequest.Set)
      case get(Spark_Connect_ConfigRequest.Get)
      case getWithDefault(Spark_Connect_ConfigRequest.GetWithDefault)
      case getOption(Spark_Connect_ConfigRequest.GetOption)
      case getAll(Spark_Connect_ConfigRequest.GetAll)
      case unset(Spark_Connect_ConfigRequest.Unset)
      case isModifiable(Spark_Connect_ConfigRequest.IsModifiable)

    }

    init() {}
  }

  struct Set: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The config key-value pairs to set.
    var pairs: [Spark_Connect_KeyValue] = []

    /// (Optional) Whether to ignore failures.
    var silent: Bool {
      get {return _silent ?? false}
      set {_silent = newValue}
    }
    /// Returns true if `silent` has been explicitly set.
    var hasSilent: Bool {return self._silent != nil}
    /// Clears the value of `silent`. Subsequent reads from it will return its default value.
    mutating func clearSilent() {self._silent = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _silent: Bool? = nil
  }

  struct Get: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The config keys to get.
    var keys: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct GetWithDefault: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The config key-value pairs to get. The value will be used as the default value.
    var pairs: [Spark_Connect_KeyValue] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct GetOption: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The config keys to get optionally.
    var keys: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct GetAll: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Optional) The prefix of the config key to get.
    var prefix: String {
      get {return _prefix ?? String()}
      set {_prefix = newValue}
    }
    /// Returns true if `prefix` has been explicitly set.
    var hasPrefix: Bool {return self._prefix != nil}
    /// Clears the value of `prefix`. Subsequent reads from it will return its default value.
    mutating func clearPrefix() {self._prefix = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _prefix: String? = nil
  }

  struct Unset: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The config keys to unset.
    var keys: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct IsModifiable: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// (Required) The config keys to check the config is modifiable.
    var keys: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _clientObservedServerSideSessionID: String? = nil
  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _operation: Spark_Connect_ConfigRequest.Operation? = nil
  fileprivate var _clientType: String? = nil
}

/// Response to the config request.
/// Next ID: 5
struct Spark_Connect_ConfigResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  /// (Optional) The result key-value pairs.
  ///
  /// Available when the operation is 'Get', 'GetWithDefault', 'GetOption', 'GetAll'.
  /// Also available for the operation 'IsModifiable' with boolean string "true" and "false".
  var pairs: [Spark_Connect_KeyValue] = []

  /// (Optional)
  ///
  /// Warning messages for deprecated or unsupported configurations.
  var warnings: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Request to transfer client-local artifacts.
struct Spark_Connect_AddArtifactsRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id specifies a spark session for a user id (which is specified
  /// by user_context.user_id). The session_id is set by the client to be able to
  /// collate streaming responses from different queries within the dedicated session.
  /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var sessionID: String = String()

  /// User context
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _clientObservedServerSideSessionID ?? String()}
    set {_clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return self._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {self._clientObservedServerSideSessionID = nil}

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  /// The payload is either a batch of artifacts or a partial chunk of a large artifact.
  var payload: Spark_Connect_AddArtifactsRequest.OneOf_Payload? = nil

  var batch: Spark_Connect_AddArtifactsRequest.Batch {
    get {
      if case .batch(let v)? = payload {return v}
      return Spark_Connect_AddArtifactsRequest.Batch()
    }
    set {payload = .batch(newValue)}
  }

  /// The metadata and the initial chunk of a large artifact chunked into multiple requests.
  /// The server side is notified about the total size of the large artifact as well as the
  /// number of chunks to expect.
  var beginChunk: Spark_Connect_AddArtifactsRequest.BeginChunkedArtifact {
    get {
      if case .beginChunk(let v)? = payload {return v}
      return Spark_Connect_AddArtifactsRequest.BeginChunkedArtifact()
    }
    set {payload = .beginChunk(newValue)}
  }

  /// A chunk of an artifact excluding metadata. This can be any chunk of a large artifact
  /// excluding the first chunk (which is included in `BeginChunkedArtifact`).
  var chunk: Spark_Connect_AddArtifactsRequest.ArtifactChunk {
    get {
      if case .chunk(let v)? = payload {return v}
      return Spark_Connect_AddArtifactsRequest.ArtifactChunk()
    }
    set {payload = .chunk(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// The payload is either a batch of artifacts or a partial chunk of a large artifact.
  enum OneOf_Payload: Equatable, Sendable {
    case batch(Spark_Connect_AddArtifactsRequest.Batch)
    /// The metadata and the initial chunk of a large artifact chunked into multiple requests.
    /// The server side is notified about the total size of the large artifact as well as the
    /// number of chunks to expect.
    case beginChunk(Spark_Connect_AddArtifactsRequest.BeginChunkedArtifact)
    /// A chunk of an artifact excluding metadata. This can be any chunk of a large artifact
    /// excluding the first chunk (which is included in `BeginChunkedArtifact`).
    case chunk(Spark_Connect_AddArtifactsRequest.ArtifactChunk)

  }

  /// A chunk of an Artifact.
  struct ArtifactChunk: @unchecked Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Data chunk.
    var data: Data = Data()

    /// CRC to allow server to verify integrity of the chunk.
    var crc: Int64 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  /// An artifact that is contained in a single `ArtifactChunk`.
  /// Generally, this message represents tiny artifacts such as REPL-generated class files.
  struct SingleChunkArtifact: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The name of the artifact is expected in the form of a "Relative Path" that is made up of a
    /// sequence of directories and the final file element.
    /// Examples of "Relative Path"s: "jars/test.jar", "classes/xyz.class", "abc.xyz", "a/b/X.jar".
    /// The server is expected to maintain the hierarchy of files as defined by their name. (i.e
    /// The relative path of the file on the server's filesystem will be the same as the name of
    /// the provided artifact)
    var name: String = String()

    /// A single data chunk.
    var data: Spark_Connect_AddArtifactsRequest.ArtifactChunk {
      get {return _data ?? Spark_Connect_AddArtifactsRequest.ArtifactChunk()}
      set {_data = newValue}
    }
    /// Returns true if `data` has been explicitly set.
    var hasData: Bool {return self._data != nil}
    /// Clears the value of `data`. Subsequent reads from it will return its default value.
    mutating func clearData() {self._data = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _data: Spark_Connect_AddArtifactsRequest.ArtifactChunk? = nil
  }

  /// A number of `SingleChunkArtifact` batched into a single RPC.
  struct Batch: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var artifacts: [Spark_Connect_AddArtifactsRequest.SingleChunkArtifact] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  /// Signals the beginning/start of a chunked artifact.
  /// A large artifact is transferred through a payload of `BeginChunkedArtifact` followed by a
  /// sequence of `ArtifactChunk`s.
  struct BeginChunkedArtifact: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Name of the artifact undergoing chunking. Follows the same conventions as the `name` in
    /// the `Artifact` message.
    var name: String = String()

    /// Total size of the artifact in bytes.
    var totalBytes: Int64 = 0

    /// Number of chunks the artifact is split into.
    /// This includes the `initial_chunk`.
    var numChunks: Int64 = 0

    /// The first/initial chunk.
    var initialChunk: Spark_Connect_AddArtifactsRequest.ArtifactChunk {
      get {return _initialChunk ?? Spark_Connect_AddArtifactsRequest.ArtifactChunk()}
      set {_initialChunk = newValue}
    }
    /// Returns true if `initialChunk` has been explicitly set.
    var hasInitialChunk: Bool {return self._initialChunk != nil}
    /// Clears the value of `initialChunk`. Subsequent reads from it will return its default value.
    mutating func clearInitialChunk() {self._initialChunk = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _initialChunk: Spark_Connect_AddArtifactsRequest.ArtifactChunk? = nil
  }

  init() {}

  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _clientObservedServerSideSessionID: String? = nil
  fileprivate var _clientType: String? = nil
}

/// Response to adding an artifact. Contains relevant metadata to verify successful transfer of
/// artifact(s).
/// Next ID: 4
struct Spark_Connect_AddArtifactsResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Session id in which the AddArtifact was running.
  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  /// The list of artifact(s) seen by the server.
  var artifacts: [Spark_Connect_AddArtifactsResponse.ArtifactSummary] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// Metadata of an artifact.
  struct ArtifactSummary: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var name: String = String()

    /// Whether the CRC (Cyclic Redundancy Check) is successful on server verification.
    /// The server discards any artifact that fails the CRC.
    /// If false, the client may choose to resend the artifact specified by `name`.
    var isCrcSuccessful: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

/// Request to get current statuses of artifacts at the server side.
struct Spark_Connect_ArtifactStatusesRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id specifies a spark session for a user id (which is specified
  /// by user_context.user_id). The session_id is set by the client to be able to
  /// collate streaming responses from different queries within the dedicated session.
  /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var sessionID: String = String()

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _clientObservedServerSideSessionID ?? String()}
    set {_clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return self._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {self._clientObservedServerSideSessionID = nil}

  /// User context
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  /// The name of the artifact is expected in the form of a "Relative Path" that is made up of a
  /// sequence of directories and the final file element.
  /// Examples of "Relative Path"s: "jars/test.jar", "classes/xyz.class", "abc.xyz", "a/b/X.jar".
  /// The server is expected to maintain the hierarchy of files as defined by their name. (i.e
  /// The relative path of the file on the server's filesystem will be the same as the name of
  /// the provided artifact)
  var names: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _clientObservedServerSideSessionID: String? = nil
  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _clientType: String? = nil
}

/// Response to checking artifact statuses.
/// Next ID: 4
struct Spark_Connect_ArtifactStatusesResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Session id in which the ArtifactStatus was running.
  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  /// A map of artifact names to their statuses.
  var statuses: Dictionary<String,Spark_Connect_ArtifactStatusesResponse.ArtifactStatus> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct ArtifactStatus: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Exists or not particular artifact at the server.
    var exists: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

struct Spark_Connect_InterruptRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id specifies a spark session for a user id (which is specified
  /// by user_context.user_id). The session_id is set by the client to be able to
  /// collate streaming responses from different queries within the dedicated session.
  /// The id should be an UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`
  var sessionID: String = String()

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _clientObservedServerSideSessionID ?? String()}
    set {_clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return self._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {self._clientObservedServerSideSessionID = nil}

  /// (Required) User context
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  /// (Required) The type of interrupt to execute.
  var interruptType: Spark_Connect_InterruptRequest.InterruptType = .unspecified

  var interrupt: Spark_Connect_InterruptRequest.OneOf_Interrupt? = nil

  /// if interrupt_tag == INTERRUPT_TYPE_TAG, interrupt operation with this tag.
  var operationTag: String {
    get {
      if case .operationTag(let v)? = interrupt {return v}
      return String()
    }
    set {interrupt = .operationTag(newValue)}
  }

  /// if interrupt_tag == INTERRUPT_TYPE_OPERATION_ID, interrupt operation with this operation_id.
  var operationID: String {
    get {
      if case .operationID(let v)? = interrupt {return v}
      return String()
    }
    set {interrupt = .operationID(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Interrupt: Equatable, Sendable {
    /// if interrupt_tag == INTERRUPT_TYPE_TAG, interrupt operation with this tag.
    case operationTag(String)
    /// if interrupt_tag == INTERRUPT_TYPE_OPERATION_ID, interrupt operation with this operation_id.
    case operationID(String)

  }

  enum InterruptType: SwiftProtobuf.Enum, Swift.CaseIterable {
    typealias RawValue = Int
    case unspecified // = 0

    /// Interrupt all running executions within the session with the provided session_id.
    case all // = 1

    /// Interrupt all running executions within the session with the provided operation_tag.
    case tag // = 2

    /// Interrupt the running execution within the session with the provided operation_id.
    case operationID // = 3
    case UNRECOGNIZED(Int)

    init() {
      self = .unspecified
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unspecified
      case 1: self = .all
      case 2: self = .tag
      case 3: self = .operationID
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unspecified: return 0
      case .all: return 1
      case .tag: return 2
      case .operationID: return 3
      case .UNRECOGNIZED(let i): return i
      }
    }

    // The compiler won't synthesize support with the UNRECOGNIZED case.
    static let allCases: [Spark_Connect_InterruptRequest.InterruptType] = [
      .unspecified,
      .all,
      .tag,
      .operationID,
    ]

  }

  init() {}

  fileprivate var _clientObservedServerSideSessionID: String? = nil
  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _clientType: String? = nil
}

/// Next ID: 4
struct Spark_Connect_InterruptResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Session id in which the interrupt was running.
  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  /// Operation ids of the executions which were interrupted.
  var interruptedIds: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_ReattachOptions: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// If true, the request can be reattached to using ReattachExecute.
  /// ReattachExecute can be used either if the stream broke with a GRPC network error,
  /// or if the server closed the stream without sending a response with StreamStatus.complete=true.
  /// The server will keep a buffer of responses in case a response is lost, and
  /// ReattachExecute needs to back-track.
  ///
  /// If false, the execution response stream will will not be reattachable, and all responses are
  /// immediately released by the server after being sent.
  var reattachable: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_ReattachExecuteRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id of the request to reattach to.
  /// This must be an id of existing session.
  var sessionID: String = String()

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _clientObservedServerSideSessionID ?? String()}
    set {_clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return self._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {self._clientObservedServerSideSessionID = nil}

  /// (Required) User context
  ///
  /// user_context.user_id and session+id both identify a unique remote spark session on the
  /// server side.
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// (Required)
  /// Provide an id of the request to reattach to.
  /// This must be an id of existing operation.
  var operationID: String = String()

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  /// (Optional)
  /// Last already processed response id from the response stream.
  /// After reattach, server will resume the response stream after that response.
  /// If not specified, server will restart the stream from the start.
  ///
  /// Note: server controls the amount of responses that it buffers and it may drop responses,
  /// that are far behind the latest returned response, so this can't be used to arbitrarily
  /// scroll back the cursor. If the response is no longer available, this will result in an error.
  var lastResponseID: String {
    get {return _lastResponseID ?? String()}
    set {_lastResponseID = newValue}
  }
  /// Returns true if `lastResponseID` has been explicitly set.
  var hasLastResponseID: Bool {return self._lastResponseID != nil}
  /// Clears the value of `lastResponseID`. Subsequent reads from it will return its default value.
  mutating func clearLastResponseID() {self._lastResponseID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _clientObservedServerSideSessionID: String? = nil
  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _clientType: String? = nil
  fileprivate var _lastResponseID: String? = nil
}

struct Spark_Connect_ReleaseExecuteRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id of the request to reattach to.
  /// This must be an id of existing session.
  var sessionID: String = String()

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _clientObservedServerSideSessionID ?? String()}
    set {_clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return self._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {self._clientObservedServerSideSessionID = nil}

  /// (Required) User context
  ///
  /// user_context.user_id and session+id both identify a unique remote spark session on the
  /// server side.
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// (Required)
  /// Provide an id of the request to reattach to.
  /// This must be an id of existing operation.
  var operationID: String = String()

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  var release: Spark_Connect_ReleaseExecuteRequest.OneOf_Release? = nil

  var releaseAll: Spark_Connect_ReleaseExecuteRequest.ReleaseAll {
    get {
      if case .releaseAll(let v)? = release {return v}
      return Spark_Connect_ReleaseExecuteRequest.ReleaseAll()
    }
    set {release = .releaseAll(newValue)}
  }

  var releaseUntil: Spark_Connect_ReleaseExecuteRequest.ReleaseUntil {
    get {
      if case .releaseUntil(let v)? = release {return v}
      return Spark_Connect_ReleaseExecuteRequest.ReleaseUntil()
    }
    set {release = .releaseUntil(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Release: Equatable, Sendable {
    case releaseAll(Spark_Connect_ReleaseExecuteRequest.ReleaseAll)
    case releaseUntil(Spark_Connect_ReleaseExecuteRequest.ReleaseUntil)

  }

  /// Release and close operation completely.
  /// This will also interrupt the query if it is running execution, and wait for it to be torn down.
  struct ReleaseAll: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  /// Release all responses from the operation response stream up to and including
  /// the response with the given by response_id.
  /// While server determines by itself how much of a buffer of responses to keep, client providing
  /// explicit release calls will help reduce resource consumption.
  /// Noop if response_id not found in cached responses.
  struct ReleaseUntil: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var responseID: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _clientObservedServerSideSessionID: String? = nil
  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _clientType: String? = nil
}

/// Next ID: 4
struct Spark_Connect_ReleaseExecuteResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Session id in which the release was running.
  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  /// Operation id of the operation on which the release executed.
  /// If the operation couldn't be found (because e.g. it was concurrently released), will be unset.
  /// Otherwise, it will be equal to the operation_id from request.
  var operationID: String {
    get {return _operationID ?? String()}
    set {_operationID = newValue}
  }
  /// Returns true if `operationID` has been explicitly set.
  var hasOperationID: Bool {return self._operationID != nil}
  /// Clears the value of `operationID`. Subsequent reads from it will return its default value.
  mutating func clearOperationID() {self._operationID = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _operationID: String? = nil
}

struct Spark_Connect_ReleaseSessionRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  ///
  /// The session_id of the request to reattach to.
  /// This must be an id of existing session.
  var sessionID: String = String()

  /// (Required) User context
  ///
  /// user_context.user_id and session+id both identify a unique remote spark session on the
  /// server side.
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  /// Signals the server to allow the client to reconnect to the session after it is released.
  ///
  /// By default, the server tombstones the session upon release, preventing reconnections and
  /// fully cleaning the session state.
  ///
  /// If this flag is set to true, the server may permit the client to reconnect to the session
  /// post-release, even if the session state has been cleaned. This can result in missing state,
  /// such as Temporary Views, Temporary UDFs, or the Current Catalog, in the reconnected session.
  ///
  /// Use this option sparingly and only when the client fully understands the implications of
  /// reconnecting to a released session. The client must ensure that any queries executed do not
  /// rely on the session state prior to its release.
  var allowReconnect: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _clientType: String? = nil
}

/// Next ID: 3
struct Spark_Connect_ReleaseSessionResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Session id of the session on which the release executed.
  var sessionID: String = String()

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_FetchErrorDetailsRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required)
  /// The session_id specifies a Spark session for a user identified by user_context.user_id.
  /// The id should be a UUID string of the format `00112233-4455-6677-8899-aabbccddeeff`.
  var sessionID: String = String()

  /// (Optional)
  ///
  /// Server-side generated idempotency key from the previous responses (if any). Server
  /// can use this to validate that the server side session has not changed.
  var clientObservedServerSideSessionID: String {
    get {return _clientObservedServerSideSessionID ?? String()}
    set {_clientObservedServerSideSessionID = newValue}
  }
  /// Returns true if `clientObservedServerSideSessionID` has been explicitly set.
  var hasClientObservedServerSideSessionID: Bool {return self._clientObservedServerSideSessionID != nil}
  /// Clears the value of `clientObservedServerSideSessionID`. Subsequent reads from it will return its default value.
  mutating func clearClientObservedServerSideSessionID() {self._clientObservedServerSideSessionID = nil}

  /// User context
  var userContext: Spark_Connect_UserContext {
    get {return _userContext ?? Spark_Connect_UserContext()}
    set {_userContext = newValue}
  }
  /// Returns true if `userContext` has been explicitly set.
  var hasUserContext: Bool {return self._userContext != nil}
  /// Clears the value of `userContext`. Subsequent reads from it will return its default value.
  mutating func clearUserContext() {self._userContext = nil}

  /// (Required)
  /// The id of the error.
  var errorID: String = String()

  /// Provides optional information about the client sending the request. This field
  /// can be used for language or version specific information and is only intended for
  /// logging purposes and will not be interpreted by the server.
  var clientType: String {
    get {return _clientType ?? String()}
    set {_clientType = newValue}
  }
  /// Returns true if `clientType` has been explicitly set.
  var hasClientType: Bool {return self._clientType != nil}
  /// Clears the value of `clientType`. Subsequent reads from it will return its default value.
  mutating func clearClientType() {self._clientType = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _clientObservedServerSideSessionID: String? = nil
  fileprivate var _userContext: Spark_Connect_UserContext? = nil
  fileprivate var _clientType: String? = nil
}

/// Next ID: 5
struct Spark_Connect_FetchErrorDetailsResponse: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Server-side generated idempotency key that the client can use to assert that the server side
  /// session has not changed.
  var serverSideSessionID: String = String()

  var sessionID: String = String()

  /// The index of the root error in errors. The field will not be set if the error is not found.
  var rootErrorIdx: Int32 {
    get {return _rootErrorIdx ?? 0}
    set {_rootErrorIdx = newValue}
  }
  /// Returns true if `rootErrorIdx` has been explicitly set.
  var hasRootErrorIdx: Bool {return self._rootErrorIdx != nil}
  /// Clears the value of `rootErrorIdx`. Subsequent reads from it will return its default value.
  mutating func clearRootErrorIdx() {self._rootErrorIdx = nil}

  /// A list of errors.
  var errors: [Spark_Connect_FetchErrorDetailsResponse.Error] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct StackTraceElement: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The fully qualified name of the class containing the execution point.
    var declaringClass: String = String()

    /// The name of the method containing the execution point.
    var methodName: String = String()

    /// The name of the file containing the execution point.
    var fileName: String {
      get {return _fileName ?? String()}
      set {_fileName = newValue}
    }
    /// Returns true if `fileName` has been explicitly set.
    var hasFileName: Bool {return self._fileName != nil}
    /// Clears the value of `fileName`. Subsequent reads from it will return its default value.
    mutating func clearFileName() {self._fileName = nil}

    /// The line number of the source line containing the execution point.
    var lineNumber: Int32 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _fileName: String? = nil
  }

  /// QueryContext defines the schema for the query context of a SparkThrowable.
  /// It helps users understand where the error occurs while executing queries.
  struct QueryContext: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var contextType: Spark_Connect_FetchErrorDetailsResponse.QueryContext.ContextType = .sql

    /// The object type of the query which throws the exception.
    /// If the exception is directly from the main query, it should be an empty string.
    /// Otherwise, it should be the exact object type in upper case. For example, a "VIEW".
    var objectType: String = String()

    /// The object name of the query which throws the exception.
    /// If the exception is directly from the main query, it should be an empty string.
    /// Otherwise, it should be the object name. For example, a view name "V1".
    var objectName: String = String()

    /// The starting index in the query text which throws the exception. The index starts from 0.
    var startIndex: Int32 = 0

    /// The stopping index in the query which throws the exception. The index starts from 0.
    var stopIndex: Int32 = 0

    /// The corresponding fragment of the query which throws the exception.
    var fragment: String = String()

    /// The user code (call site of the API) that caused throwing the exception.
    var callSite: String = String()

    /// Summary of the exception cause.
    var summary: String = String()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    /// The type of this query context.
    enum ContextType: SwiftProtobuf.Enum, Swift.CaseIterable {
      typealias RawValue = Int
      case sql // = 0
      case dataframe // = 1
      case UNRECOGNIZED(Int)

      init() {
        self = .sql
      }

      init?(rawValue: Int) {
        switch rawValue {
        case 0: self = .sql
        case 1: self = .dataframe
        default: self = .UNRECOGNIZED(rawValue)
        }
      }

      var rawValue: Int {
        switch self {
        case .sql: return 0
        case .dataframe: return 1
        case .UNRECOGNIZED(let i): return i
        }
      }

      // The compiler won't synthesize support with the UNRECOGNIZED case.
      static let allCases: [Spark_Connect_FetchErrorDetailsResponse.QueryContext.ContextType] = [
        .sql,
        .dataframe,
      ]

    }

    init() {}
  }

  /// SparkThrowable defines the schema for SparkThrowable exceptions.
  struct SparkThrowable: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// Succinct, human-readable, unique, and consistent representation of the error category.
    var errorClass: String {
      get {return _errorClass ?? String()}
      set {_errorClass = newValue}
    }
    /// Returns true if `errorClass` has been explicitly set.
    var hasErrorClass: Bool {return self._errorClass != nil}
    /// Clears the value of `errorClass`. Subsequent reads from it will return its default value.
    mutating func clearErrorClass() {self._errorClass = nil}

    /// The message parameters for the error framework.
    var messageParameters: Dictionary<String,String> = [:]

    /// The query context of a SparkThrowable.
    var queryContexts: [Spark_Connect_FetchErrorDetailsResponse.QueryContext] = []

    /// Portable error identifier across SQL engines
    /// If null, error class or SQLSTATE is not set.
    var sqlState: String {
      get {return _sqlState ?? String()}
      set {_sqlState = newValue}
    }
    /// Returns true if `sqlState` has been explicitly set.
    var hasSqlState: Bool {return self._sqlState != nil}
    /// Clears the value of `sqlState`. Subsequent reads from it will return its default value.
    mutating func clearSqlState() {self._sqlState = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _errorClass: String? = nil
    fileprivate var _sqlState: String? = nil
  }

  /// Error defines the schema for the representing exception.
  struct Error: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The fully qualified names of the exception class and its parent classes.
    var errorTypeHierarchy: [String] = []

    /// The detailed message of the exception.
    var message: String = String()

    /// The stackTrace of the exception. It will be set
    /// if the SQLConf spark.sql.connect.serverStacktrace.enabled is true.
    var stackTrace: [Spark_Connect_FetchErrorDetailsResponse.StackTraceElement] = []

    /// The index of the cause error in errors.
    var causeIdx: Int32 {
      get {return _causeIdx ?? 0}
      set {_causeIdx = newValue}
    }
    /// Returns true if `causeIdx` has been explicitly set.
    var hasCauseIdx: Bool {return self._causeIdx != nil}
    /// Clears the value of `causeIdx`. Subsequent reads from it will return its default value.
    mutating func clearCauseIdx() {self._causeIdx = nil}

    /// The structured data of a SparkThrowable exception.
    var sparkThrowable: Spark_Connect_FetchErrorDetailsResponse.SparkThrowable {
      get {return _sparkThrowable ?? Spark_Connect_FetchErrorDetailsResponse.SparkThrowable()}
      set {_sparkThrowable = newValue}
    }
    /// Returns true if `sparkThrowable` has been explicitly set.
    var hasSparkThrowable: Bool {return self._sparkThrowable != nil}
    /// Clears the value of `sparkThrowable`. Subsequent reads from it will return its default value.
    mutating func clearSparkThrowable() {self._sparkThrowable = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _causeIdx: Int32? = nil
    fileprivate var _sparkThrowable: Spark_Connect_FetchErrorDetailsResponse.SparkThrowable? = nil
  }

  init() {}

  fileprivate var _rootErrorIdx: Int32? = nil
}

struct Spark_Connect_CheckpointCommandResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The logical plan checkpointed.
  var relation: Spark_Connect_CachedRemoteRelation {
    get {return _relation ?? Spark_Connect_CachedRemoteRelation()}
    set {_relation = newValue}
  }
  /// Returns true if `relation` has been explicitly set.
  var hasRelation: Bool {return self._relation != nil}
  /// Clears the value of `relation`. Subsequent reads from it will return its default value.
  mutating func clearRelation() {self._relation = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _relation: Spark_Connect_CachedRemoteRelation? = nil
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "spark.connect"

extension Spark_Connect_Plan: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Plan"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "root"),
    2: .same(proto: "command"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_Relation?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .root(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .root(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_Command?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .command(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .command(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.opType {
    case .root?: try {
      guard case .root(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .command?: try {
      guard case .command(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Plan, rhs: Spark_Connect_Plan) -> Bool {
    if lhs.opType != rhs.opType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_UserContext: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".UserContext"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "user_id"),
    2: .standard(proto: "user_name"),
    999: .same(proto: "extensions"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.userID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.userName) }()
      case 999: try { try decoder.decodeRepeatedMessageField(value: &self.extensions) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.userID.isEmpty {
      try visitor.visitSingularStringField(value: self.userID, fieldNumber: 1)
    }
    if !self.userName.isEmpty {
      try visitor.visitSingularStringField(value: self.userName, fieldNumber: 2)
    }
    if !self.extensions.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.extensions, fieldNumber: 999)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_UserContext, rhs: Spark_Connect_UserContext) -> Bool {
    if lhs.userID != rhs.userID {return false}
    if lhs.userName != rhs.userName {return false}
    if lhs.extensions != rhs.extensions {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AnalyzePlanRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    17: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    3: .standard(proto: "client_type"),
    4: .same(proto: "schema"),
    5: .same(proto: "explain"),
    6: .standard(proto: "tree_string"),
    7: .standard(proto: "is_local"),
    8: .standard(proto: "is_streaming"),
    9: .standard(proto: "input_files"),
    10: .standard(proto: "spark_version"),
    11: .standard(proto: "ddl_parse"),
    12: .standard(proto: "same_semantics"),
    13: .standard(proto: "semantic_hash"),
    14: .same(proto: "persist"),
    15: .same(proto: "unpersist"),
    16: .standard(proto: "get_storage_level"),
    18: .standard(proto: "json_to_ddl"),
  ]

  fileprivate class _StorageClass {
    var _sessionID: String = String()
    var _clientObservedServerSideSessionID: String? = nil
    var _userContext: Spark_Connect_UserContext? = nil
    var _clientType: String? = nil
    var _analyze: Spark_Connect_AnalyzePlanRequest.OneOf_Analyze?

      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _sessionID = source._sessionID
      _clientObservedServerSideSessionID = source._clientObservedServerSideSessionID
      _userContext = source._userContext
      _clientType = source._clientType
      _analyze = source._analyze
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularStringField(value: &_storage._sessionID) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._userContext) }()
        case 3: try { try decoder.decodeSingularStringField(value: &_storage._clientType) }()
        case 4: try {
          var v: Spark_Connect_AnalyzePlanRequest.Schema?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .schema(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .schema(v)
          }
        }()
        case 5: try {
          var v: Spark_Connect_AnalyzePlanRequest.Explain?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .explain(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .explain(v)
          }
        }()
        case 6: try {
          var v: Spark_Connect_AnalyzePlanRequest.TreeString?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .treeString(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .treeString(v)
          }
        }()
        case 7: try {
          var v: Spark_Connect_AnalyzePlanRequest.IsLocal?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .isLocal(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .isLocal(v)
          }
        }()
        case 8: try {
          var v: Spark_Connect_AnalyzePlanRequest.IsStreaming?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .isStreaming(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .isStreaming(v)
          }
        }()
        case 9: try {
          var v: Spark_Connect_AnalyzePlanRequest.InputFiles?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .inputFiles(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .inputFiles(v)
          }
        }()
        case 10: try {
          var v: Spark_Connect_AnalyzePlanRequest.SparkVersion?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .sparkVersion(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .sparkVersion(v)
          }
        }()
        case 11: try {
          var v: Spark_Connect_AnalyzePlanRequest.DDLParse?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .ddlParse(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .ddlParse(v)
          }
        }()
        case 12: try {
          var v: Spark_Connect_AnalyzePlanRequest.SameSemantics?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .sameSemantics(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .sameSemantics(v)
          }
        }()
        case 13: try {
          var v: Spark_Connect_AnalyzePlanRequest.SemanticHash?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .semanticHash(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .semanticHash(v)
          }
        }()
        case 14: try {
          var v: Spark_Connect_AnalyzePlanRequest.Persist?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .persist(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .persist(v)
          }
        }()
        case 15: try {
          var v: Spark_Connect_AnalyzePlanRequest.Unpersist?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .unpersist(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .unpersist(v)
          }
        }()
        case 16: try {
          var v: Spark_Connect_AnalyzePlanRequest.GetStorageLevel?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .getStorageLevel(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .getStorageLevel(v)
          }
        }()
        case 17: try { try decoder.decodeSingularStringField(value: &_storage._clientObservedServerSideSessionID) }()
        case 18: try {
          var v: Spark_Connect_AnalyzePlanRequest.JsonToDDL?
          var hadOneofValue = false
          if let current = _storage._analyze {
            hadOneofValue = true
            if case .jsonToDdl(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._analyze = .jsonToDdl(v)
          }
        }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._sessionID.isEmpty {
        try visitor.visitSingularStringField(value: _storage._sessionID, fieldNumber: 1)
      }
      try { if let v = _storage._userContext {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._clientType {
        try visitor.visitSingularStringField(value: v, fieldNumber: 3)
      } }()
      switch _storage._analyze {
      case .schema?: try {
        guard case .schema(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      }()
      case .explain?: try {
        guard case .explain(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      }()
      case .treeString?: try {
        guard case .treeString(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
      }()
      case .isLocal?: try {
        guard case .isLocal(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
      }()
      case .isStreaming?: try {
        guard case .isStreaming(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
      }()
      case .inputFiles?: try {
        guard case .inputFiles(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
      }()
      case .sparkVersion?: try {
        guard case .sparkVersion(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
      }()
      case .ddlParse?: try {
        guard case .ddlParse(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
      }()
      case .sameSemantics?: try {
        guard case .sameSemantics(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 12)
      }()
      case .semanticHash?: try {
        guard case .semanticHash(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 13)
      }()
      case .persist?: try {
        guard case .persist(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 14)
      }()
      case .unpersist?: try {
        guard case .unpersist(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 15)
      }()
      case .getStorageLevel?: try {
        guard case .getStorageLevel(let v)? = _storage._analyze else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 16)
      }()
      default: break
      }
      try { if let v = _storage._clientObservedServerSideSessionID {
        try visitor.visitSingularStringField(value: v, fieldNumber: 17)
      } }()
      try { if case .jsonToDdl(let v)? = _storage._analyze {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 18)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest, rhs: Spark_Connect_AnalyzePlanRequest) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._sessionID != rhs_storage._sessionID {return false}
        if _storage._clientObservedServerSideSessionID != rhs_storage._clientObservedServerSideSessionID {return false}
        if _storage._userContext != rhs_storage._userContext {return false}
        if _storage._clientType != rhs_storage._clientType {return false}
        if _storage._analyze != rhs_storage._analyze {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.Schema: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".Schema"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.Schema, rhs: Spark_Connect_AnalyzePlanRequest.Schema) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.Explain: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".Explain"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
    2: .standard(proto: "explain_mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.explainMode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if self.explainMode != .unspecified {
      try visitor.visitSingularEnumField(value: self.explainMode, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.Explain, rhs: Spark_Connect_AnalyzePlanRequest.Explain) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs.explainMode != rhs.explainMode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.Explain.ExplainMode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "EXPLAIN_MODE_UNSPECIFIED"),
    1: .same(proto: "EXPLAIN_MODE_SIMPLE"),
    2: .same(proto: "EXPLAIN_MODE_EXTENDED"),
    3: .same(proto: "EXPLAIN_MODE_CODEGEN"),
    4: .same(proto: "EXPLAIN_MODE_COST"),
    5: .same(proto: "EXPLAIN_MODE_FORMATTED"),
  ]
}

extension Spark_Connect_AnalyzePlanRequest.TreeString: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".TreeString"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
    2: .same(proto: "level"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      case 2: try { try decoder.decodeSingularInt32Field(value: &self._level) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._level {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.TreeString, rhs: Spark_Connect_AnalyzePlanRequest.TreeString) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs._level != rhs._level {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.IsLocal: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".IsLocal"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.IsLocal, rhs: Spark_Connect_AnalyzePlanRequest.IsLocal) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.IsStreaming: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".IsStreaming"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.IsStreaming, rhs: Spark_Connect_AnalyzePlanRequest.IsStreaming) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.InputFiles: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".InputFiles"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.InputFiles, rhs: Spark_Connect_AnalyzePlanRequest.InputFiles) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.SparkVersion: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".SparkVersion"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.SparkVersion, rhs: Spark_Connect_AnalyzePlanRequest.SparkVersion) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.DDLParse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".DDLParse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "ddl_string"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.ddlString) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.ddlString.isEmpty {
      try visitor.visitSingularStringField(value: self.ddlString, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.DDLParse, rhs: Spark_Connect_AnalyzePlanRequest.DDLParse) -> Bool {
    if lhs.ddlString != rhs.ddlString {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.SameSemantics: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".SameSemantics"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "target_plan"),
    2: .standard(proto: "other_plan"),
  ]

  fileprivate class _StorageClass {
    var _targetPlan: Spark_Connect_Plan? = nil
    var _otherPlan: Spark_Connect_Plan? = nil

      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _targetPlan = source._targetPlan
      _otherPlan = source._otherPlan
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._targetPlan) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._otherPlan) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._targetPlan {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._otherPlan {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.SameSemantics, rhs: Spark_Connect_AnalyzePlanRequest.SameSemantics) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._targetPlan != rhs_storage._targetPlan {return false}
        if _storage._otherPlan != rhs_storage._otherPlan {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.SemanticHash: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".SemanticHash"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "plan"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.SemanticHash, rhs: Spark_Connect_AnalyzePlanRequest.SemanticHash) -> Bool {
    if lhs._plan != rhs._plan {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.Persist: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".Persist"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "relation"),
    2: .standard(proto: "storage_level"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._relation) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._storageLevel) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._relation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._storageLevel {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.Persist, rhs: Spark_Connect_AnalyzePlanRequest.Persist) -> Bool {
    if lhs._relation != rhs._relation {return false}
    if lhs._storageLevel != rhs._storageLevel {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.Unpersist: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".Unpersist"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "relation"),
    2: .same(proto: "blocking"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._relation) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self._blocking) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._relation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._blocking {
      try visitor.visitSingularBoolField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.Unpersist, rhs: Spark_Connect_AnalyzePlanRequest.Unpersist) -> Bool {
    if lhs._relation != rhs._relation {return false}
    if lhs._blocking != rhs._blocking {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.GetStorageLevel: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".GetStorageLevel"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "relation"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._relation) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._relation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.GetStorageLevel, rhs: Spark_Connect_AnalyzePlanRequest.GetStorageLevel) -> Bool {
    if lhs._relation != rhs._relation {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanRequest.JsonToDDL: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanRequest.protoMessageName + ".JsonToDDL"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "json_string"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.jsonString) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.jsonString.isEmpty {
      try visitor.visitSingularStringField(value: self.jsonString, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanRequest.JsonToDDL, rhs: Spark_Connect_AnalyzePlanRequest.JsonToDDL) -> Bool {
    if lhs.jsonString != rhs.jsonString {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AnalyzePlanResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    15: .standard(proto: "server_side_session_id"),
    2: .same(proto: "schema"),
    3: .same(proto: "explain"),
    4: .standard(proto: "tree_string"),
    5: .standard(proto: "is_local"),
    6: .standard(proto: "is_streaming"),
    7: .standard(proto: "input_files"),
    8: .standard(proto: "spark_version"),
    9: .standard(proto: "ddl_parse"),
    10: .standard(proto: "same_semantics"),
    11: .standard(proto: "semantic_hash"),
    12: .same(proto: "persist"),
    13: .same(proto: "unpersist"),
    14: .standard(proto: "get_storage_level"),
    16: .standard(proto: "json_to_ddl"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try {
        var v: Spark_Connect_AnalyzePlanResponse.Schema?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .schema(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .schema(v)
        }
      }()
      case 3: try {
        var v: Spark_Connect_AnalyzePlanResponse.Explain?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .explain(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .explain(v)
        }
      }()
      case 4: try {
        var v: Spark_Connect_AnalyzePlanResponse.TreeString?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .treeString(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .treeString(v)
        }
      }()
      case 5: try {
        var v: Spark_Connect_AnalyzePlanResponse.IsLocal?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .isLocal(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .isLocal(v)
        }
      }()
      case 6: try {
        var v: Spark_Connect_AnalyzePlanResponse.IsStreaming?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .isStreaming(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .isStreaming(v)
        }
      }()
      case 7: try {
        var v: Spark_Connect_AnalyzePlanResponse.InputFiles?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .inputFiles(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .inputFiles(v)
        }
      }()
      case 8: try {
        var v: Spark_Connect_AnalyzePlanResponse.SparkVersion?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .sparkVersion(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .sparkVersion(v)
        }
      }()
      case 9: try {
        var v: Spark_Connect_AnalyzePlanResponse.DDLParse?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .ddlParse(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .ddlParse(v)
        }
      }()
      case 10: try {
        var v: Spark_Connect_AnalyzePlanResponse.SameSemantics?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .sameSemantics(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .sameSemantics(v)
        }
      }()
      case 11: try {
        var v: Spark_Connect_AnalyzePlanResponse.SemanticHash?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .semanticHash(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .semanticHash(v)
        }
      }()
      case 12: try {
        var v: Spark_Connect_AnalyzePlanResponse.Persist?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .persist(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .persist(v)
        }
      }()
      case 13: try {
        var v: Spark_Connect_AnalyzePlanResponse.Unpersist?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .unpersist(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .unpersist(v)
        }
      }()
      case 14: try {
        var v: Spark_Connect_AnalyzePlanResponse.GetStorageLevel?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .getStorageLevel(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .getStorageLevel(v)
        }
      }()
      case 15: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      case 16: try {
        var v: Spark_Connect_AnalyzePlanResponse.JsonToDDL?
        var hadOneofValue = false
        if let current = self.result {
          hadOneofValue = true
          if case .jsonToDdl(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.result = .jsonToDdl(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    switch self.result {
    case .schema?: try {
      guard case .schema(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .explain?: try {
      guard case .explain(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .treeString?: try {
      guard case .treeString(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .isLocal?: try {
      guard case .isLocal(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .isStreaming?: try {
      guard case .isStreaming(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case .inputFiles?: try {
      guard case .inputFiles(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    }()
    case .sparkVersion?: try {
      guard case .sparkVersion(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
    }()
    case .ddlParse?: try {
      guard case .ddlParse(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
    }()
    case .sameSemantics?: try {
      guard case .sameSemantics(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    }()
    case .semanticHash?: try {
      guard case .semanticHash(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
    }()
    case .persist?: try {
      guard case .persist(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 12)
    }()
    case .unpersist?: try {
      guard case .unpersist(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 13)
    }()
    case .getStorageLevel?: try {
      guard case .getStorageLevel(let v)? = self.result else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 14)
    }()
    default: break
    }
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 15)
    }
    try { if case .jsonToDdl(let v)? = self.result {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 16)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse, rhs: Spark_Connect_AnalyzePlanResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.result != rhs.result {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.Schema: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".Schema"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "schema"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._schema) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._schema {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.Schema, rhs: Spark_Connect_AnalyzePlanResponse.Schema) -> Bool {
    if lhs._schema != rhs._schema {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.Explain: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".Explain"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "explain_string"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.explainString) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.explainString.isEmpty {
      try visitor.visitSingularStringField(value: self.explainString, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.Explain, rhs: Spark_Connect_AnalyzePlanResponse.Explain) -> Bool {
    if lhs.explainString != rhs.explainString {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.TreeString: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".TreeString"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "tree_string"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.treeString) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.treeString.isEmpty {
      try visitor.visitSingularStringField(value: self.treeString, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.TreeString, rhs: Spark_Connect_AnalyzePlanResponse.TreeString) -> Bool {
    if lhs.treeString != rhs.treeString {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.IsLocal: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".IsLocal"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "is_local"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.isLocal) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.isLocal != false {
      try visitor.visitSingularBoolField(value: self.isLocal, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.IsLocal, rhs: Spark_Connect_AnalyzePlanResponse.IsLocal) -> Bool {
    if lhs.isLocal != rhs.isLocal {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.IsStreaming: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".IsStreaming"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "is_streaming"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.isStreaming) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.isStreaming != false {
      try visitor.visitSingularBoolField(value: self.isStreaming, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.IsStreaming, rhs: Spark_Connect_AnalyzePlanResponse.IsStreaming) -> Bool {
    if lhs.isStreaming != rhs.isStreaming {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.InputFiles: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".InputFiles"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "files"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.files) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.files.isEmpty {
      try visitor.visitRepeatedStringField(value: self.files, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.InputFiles, rhs: Spark_Connect_AnalyzePlanResponse.InputFiles) -> Bool {
    if lhs.files != rhs.files {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.SparkVersion: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".SparkVersion"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.version) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.version.isEmpty {
      try visitor.visitSingularStringField(value: self.version, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.SparkVersion, rhs: Spark_Connect_AnalyzePlanResponse.SparkVersion) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.DDLParse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".DDLParse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "parsed"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._parsed) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._parsed {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.DDLParse, rhs: Spark_Connect_AnalyzePlanResponse.DDLParse) -> Bool {
    if lhs._parsed != rhs._parsed {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.SameSemantics: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".SameSemantics"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "result"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.result) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.result != false {
      try visitor.visitSingularBoolField(value: self.result, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.SameSemantics, rhs: Spark_Connect_AnalyzePlanResponse.SameSemantics) -> Bool {
    if lhs.result != rhs.result {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.SemanticHash: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".SemanticHash"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "result"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt32Field(value: &self.result) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.result != 0 {
      try visitor.visitSingularInt32Field(value: self.result, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.SemanticHash, rhs: Spark_Connect_AnalyzePlanResponse.SemanticHash) -> Bool {
    if lhs.result != rhs.result {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.Persist: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".Persist"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.Persist, rhs: Spark_Connect_AnalyzePlanResponse.Persist) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.Unpersist: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".Unpersist"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.Unpersist, rhs: Spark_Connect_AnalyzePlanResponse.Unpersist) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.GetStorageLevel: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".GetStorageLevel"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "storage_level"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._storageLevel) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._storageLevel {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.GetStorageLevel, rhs: Spark_Connect_AnalyzePlanResponse.GetStorageLevel) -> Bool {
    if lhs._storageLevel != rhs._storageLevel {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AnalyzePlanResponse.JsonToDDL: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AnalyzePlanResponse.protoMessageName + ".JsonToDDL"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "ddl_string"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.ddlString) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.ddlString.isEmpty {
      try visitor.visitSingularStringField(value: self.ddlString, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AnalyzePlanResponse.JsonToDDL, rhs: Spark_Connect_AnalyzePlanResponse.JsonToDDL) -> Bool {
    if lhs.ddlString != rhs.ddlString {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ExecutePlanRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    8: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    6: .standard(proto: "operation_id"),
    3: .same(proto: "plan"),
    4: .standard(proto: "client_type"),
    5: .standard(proto: "request_options"),
    7: .same(proto: "tags"),
  ]

  fileprivate class _StorageClass {
    var _sessionID: String = String()
    var _clientObservedServerSideSessionID: String? = nil
    var _userContext: Spark_Connect_UserContext? = nil
    var _operationID: String? = nil
    var _plan: Spark_Connect_Plan? = nil
    var _clientType: String? = nil
    var _requestOptions: [Spark_Connect_ExecutePlanRequest.RequestOption] = []
    var _tags: [String] = []

      // This property is used as the initial default value for new instances of the type.
      // The type itself is protecting the reference to its storage via CoW semantics.
      // This will force a copy to be made of this reference when the first mutation occurs;
      // hence, it is safe to mark this as `nonisolated(unsafe)`.
      static nonisolated(unsafe) let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _sessionID = source._sessionID
      _clientObservedServerSideSessionID = source._clientObservedServerSideSessionID
      _userContext = source._userContext
      _operationID = source._operationID
      _plan = source._plan
      _clientType = source._clientType
      _requestOptions = source._requestOptions
      _tags = source._tags
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularStringField(value: &_storage._sessionID) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._userContext) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._plan) }()
        case 4: try { try decoder.decodeSingularStringField(value: &_storage._clientType) }()
        case 5: try { try decoder.decodeRepeatedMessageField(value: &_storage._requestOptions) }()
        case 6: try { try decoder.decodeSingularStringField(value: &_storage._operationID) }()
        case 7: try { try decoder.decodeRepeatedStringField(value: &_storage._tags) }()
        case 8: try { try decoder.decodeSingularStringField(value: &_storage._clientObservedServerSideSessionID) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._sessionID.isEmpty {
        try visitor.visitSingularStringField(value: _storage._sessionID, fieldNumber: 1)
      }
      try { if let v = _storage._userContext {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._plan {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._clientType {
        try visitor.visitSingularStringField(value: v, fieldNumber: 4)
      } }()
      if !_storage._requestOptions.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._requestOptions, fieldNumber: 5)
      }
      try { if let v = _storage._operationID {
        try visitor.visitSingularStringField(value: v, fieldNumber: 6)
      } }()
      if !_storage._tags.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._tags, fieldNumber: 7)
      }
      try { if let v = _storage._clientObservedServerSideSessionID {
        try visitor.visitSingularStringField(value: v, fieldNumber: 8)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanRequest, rhs: Spark_Connect_ExecutePlanRequest) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._sessionID != rhs_storage._sessionID {return false}
        if _storage._clientObservedServerSideSessionID != rhs_storage._clientObservedServerSideSessionID {return false}
        if _storage._userContext != rhs_storage._userContext {return false}
        if _storage._operationID != rhs_storage._operationID {return false}
        if _storage._plan != rhs_storage._plan {return false}
        if _storage._clientType != rhs_storage._clientType {return false}
        if _storage._requestOptions != rhs_storage._requestOptions {return false}
        if _storage._tags != rhs_storage._tags {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanRequest.RequestOption: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanRequest.protoMessageName + ".RequestOption"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "reattach_options"),
    999: .same(proto: "extension"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_ReattachOptions?
        var hadOneofValue = false
        if let current = self.requestOption {
          hadOneofValue = true
          if case .reattachOptions(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.requestOption = .reattachOptions(v)
        }
      }()
      case 999: try {
        var v: SwiftProtobuf.Google_Protobuf_Any?
        var hadOneofValue = false
        if let current = self.requestOption {
          hadOneofValue = true
          if case .extension(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.requestOption = .extension(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.requestOption {
    case .reattachOptions?: try {
      guard case .reattachOptions(let v)? = self.requestOption else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .extension?: try {
      guard case .extension(let v)? = self.requestOption else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 999)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanRequest.RequestOption, rhs: Spark_Connect_ExecutePlanRequest.RequestOption) -> Bool {
    if lhs.requestOption != rhs.requestOption {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ExecutePlanResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    15: .standard(proto: "server_side_session_id"),
    12: .standard(proto: "operation_id"),
    13: .standard(proto: "response_id"),
    2: .standard(proto: "arrow_batch"),
    5: .standard(proto: "sql_command_result"),
    8: .standard(proto: "write_stream_operation_start_result"),
    9: .standard(proto: "streaming_query_command_result"),
    10: .standard(proto: "get_resources_command_result"),
    11: .standard(proto: "streaming_query_manager_command_result"),
    16: .standard(proto: "streaming_query_listener_events_result"),
    14: .standard(proto: "result_complete"),
    17: .standard(proto: "create_resource_profile_command_result"),
    18: .standard(proto: "execution_progress"),
    19: .standard(proto: "checkpoint_command_result"),
    20: .standard(proto: "ml_command_result"),
    21: .standard(proto: "pipeline_event_result"),
    22: .standard(proto: "pipeline_command_result"),
    999: .same(proto: "extension"),
    4: .same(proto: "metrics"),
    6: .standard(proto: "observed_metrics"),
    7: .same(proto: "schema"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try {
        var v: Spark_Connect_ExecutePlanResponse.ArrowBatch?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .arrowBatch(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .arrowBatch(v)
        }
      }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._metrics) }()
      case 5: try {
        var v: Spark_Connect_ExecutePlanResponse.SqlCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .sqlCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .sqlCommandResult(v)
        }
      }()
      case 6: try { try decoder.decodeRepeatedMessageField(value: &self.observedMetrics) }()
      case 7: try { try decoder.decodeSingularMessageField(value: &self._schema) }()
      case 8: try {
        var v: Spark_Connect_WriteStreamOperationStartResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .writeStreamOperationStartResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .writeStreamOperationStartResult(v)
        }
      }()
      case 9: try {
        var v: Spark_Connect_StreamingQueryCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .streamingQueryCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .streamingQueryCommandResult(v)
        }
      }()
      case 10: try {
        var v: Spark_Connect_GetResourcesCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .getResourcesCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .getResourcesCommandResult(v)
        }
      }()
      case 11: try {
        var v: Spark_Connect_StreamingQueryManagerCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .streamingQueryManagerCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .streamingQueryManagerCommandResult(v)
        }
      }()
      case 12: try { try decoder.decodeSingularStringField(value: &self.operationID) }()
      case 13: try { try decoder.decodeSingularStringField(value: &self.responseID) }()
      case 14: try {
        var v: Spark_Connect_ExecutePlanResponse.ResultComplete?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .resultComplete(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .resultComplete(v)
        }
      }()
      case 15: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      case 16: try {
        var v: Spark_Connect_StreamingQueryListenerEventsResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .streamingQueryListenerEventsResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .streamingQueryListenerEventsResult(v)
        }
      }()
      case 17: try {
        var v: Spark_Connect_CreateResourceProfileCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .createResourceProfileCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .createResourceProfileCommandResult(v)
        }
      }()
      case 18: try {
        var v: Spark_Connect_ExecutePlanResponse.ExecutionProgress?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .executionProgress(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .executionProgress(v)
        }
      }()
      case 19: try {
        var v: Spark_Connect_CheckpointCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .checkpointCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .checkpointCommandResult(v)
        }
      }()
      case 20: try {
        var v: Spark_Connect_MlCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .mlCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .mlCommandResult(v)
        }
      }()
      case 21: try {
        var v: Spark_Connect_PipelineEventResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .pipelineEventResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .pipelineEventResult(v)
        }
      }()
      case 22: try {
        var v: Spark_Connect_PipelineCommandResult?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .pipelineCommandResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .pipelineCommandResult(v)
        }
      }()
      case 999: try {
        var v: SwiftProtobuf.Google_Protobuf_Any?
        var hadOneofValue = false
        if let current = self.responseType {
          hadOneofValue = true
          if case .extension(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.responseType = .extension(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if case .arrowBatch(let v)? = self.responseType {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._metrics {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try { if case .sqlCommandResult(let v)? = self.responseType {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    } }()
    if !self.observedMetrics.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.observedMetrics, fieldNumber: 6)
    }
    try { if let v = self._schema {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    } }()
    switch self.responseType {
    case .writeStreamOperationStartResult?: try {
      guard case .writeStreamOperationStartResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
    }()
    case .streamingQueryCommandResult?: try {
      guard case .streamingQueryCommandResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
    }()
    case .getResourcesCommandResult?: try {
      guard case .getResourcesCommandResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    }()
    case .streamingQueryManagerCommandResult?: try {
      guard case .streamingQueryManagerCommandResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
    }()
    default: break
    }
    if !self.operationID.isEmpty {
      try visitor.visitSingularStringField(value: self.operationID, fieldNumber: 12)
    }
    if !self.responseID.isEmpty {
      try visitor.visitSingularStringField(value: self.responseID, fieldNumber: 13)
    }
    try { if case .resultComplete(let v)? = self.responseType {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 14)
    } }()
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 15)
    }
    switch self.responseType {
    case .streamingQueryListenerEventsResult?: try {
      guard case .streamingQueryListenerEventsResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 16)
    }()
    case .createResourceProfileCommandResult?: try {
      guard case .createResourceProfileCommandResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 17)
    }()
    case .executionProgress?: try {
      guard case .executionProgress(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 18)
    }()
    case .checkpointCommandResult?: try {
      guard case .checkpointCommandResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 19)
    }()
    case .mlCommandResult?: try {
      guard case .mlCommandResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
    }()
    case .pipelineEventResult?: try {
      guard case .pipelineEventResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 21)
    }()
    case .pipelineCommandResult?: try {
      guard case .pipelineCommandResult(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 22)
    }()
    case .extension?: try {
      guard case .extension(let v)? = self.responseType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 999)
    }()
    default: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse, rhs: Spark_Connect_ExecutePlanResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.operationID != rhs.operationID {return false}
    if lhs.responseID != rhs.responseID {return false}
    if lhs.responseType != rhs.responseType {return false}
    if lhs._metrics != rhs._metrics {return false}
    if lhs.observedMetrics != rhs.observedMetrics {return false}
    if lhs._schema != rhs._schema {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.SqlCommandResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.protoMessageName + ".SqlCommandResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "relation"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._relation) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._relation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.SqlCommandResult, rhs: Spark_Connect_ExecutePlanResponse.SqlCommandResult) -> Bool {
    if lhs._relation != rhs._relation {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.ArrowBatch: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.protoMessageName + ".ArrowBatch"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "row_count"),
    2: .same(proto: "data"),
    3: .standard(proto: "start_offset"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.rowCount) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.data) }()
      case 3: try { try decoder.decodeSingularInt64Field(value: &self._startOffset) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.rowCount != 0 {
      try visitor.visitSingularInt64Field(value: self.rowCount, fieldNumber: 1)
    }
    if !self.data.isEmpty {
      try visitor.visitSingularBytesField(value: self.data, fieldNumber: 2)
    }
    try { if let v = self._startOffset {
      try visitor.visitSingularInt64Field(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.ArrowBatch, rhs: Spark_Connect_ExecutePlanResponse.ArrowBatch) -> Bool {
    if lhs.rowCount != rhs.rowCount {return false}
    if lhs.data != rhs.data {return false}
    if lhs._startOffset != rhs._startOffset {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.Metrics: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.protoMessageName + ".Metrics"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "metrics"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.metrics) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.metrics.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.metrics, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.Metrics, rhs: Spark_Connect_ExecutePlanResponse.Metrics) -> Bool {
    if lhs.metrics != rhs.metrics {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.Metrics.MetricObject: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.Metrics.protoMessageName + ".MetricObject"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .standard(proto: "plan_id"),
    3: .same(proto: "parent"),
    4: .standard(proto: "execution_metrics"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.planID) }()
      case 3: try { try decoder.decodeSingularInt64Field(value: &self.parent) }()
      case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ExecutePlanResponse.Metrics.MetricValue>.self, value: &self.executionMetrics) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if self.planID != 0 {
      try visitor.visitSingularInt64Field(value: self.planID, fieldNumber: 2)
    }
    if self.parent != 0 {
      try visitor.visitSingularInt64Field(value: self.parent, fieldNumber: 3)
    }
    if !self.executionMetrics.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ExecutePlanResponse.Metrics.MetricValue>.self, value: self.executionMetrics, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.Metrics.MetricObject, rhs: Spark_Connect_ExecutePlanResponse.Metrics.MetricObject) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.planID != rhs.planID {return false}
    if lhs.parent != rhs.parent {return false}
    if lhs.executionMetrics != rhs.executionMetrics {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.Metrics.MetricValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.Metrics.protoMessageName + ".MetricValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "value"),
    3: .standard(proto: "metric_type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.value) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.metricType) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if self.value != 0 {
      try visitor.visitSingularInt64Field(value: self.value, fieldNumber: 2)
    }
    if !self.metricType.isEmpty {
      try visitor.visitSingularStringField(value: self.metricType, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.Metrics.MetricValue, rhs: Spark_Connect_ExecutePlanResponse.Metrics.MetricValue) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.value != rhs.value {return false}
    if lhs.metricType != rhs.metricType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.ObservedMetrics: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.protoMessageName + ".ObservedMetrics"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "values"),
    3: .same(proto: "keys"),
    4: .standard(proto: "plan_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.values) }()
      case 3: try { try decoder.decodeRepeatedStringField(value: &self.keys) }()
      case 4: try { try decoder.decodeSingularInt64Field(value: &self.planID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if !self.values.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.values, fieldNumber: 2)
    }
    if !self.keys.isEmpty {
      try visitor.visitRepeatedStringField(value: self.keys, fieldNumber: 3)
    }
    if self.planID != 0 {
      try visitor.visitSingularInt64Field(value: self.planID, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.ObservedMetrics, rhs: Spark_Connect_ExecutePlanResponse.ObservedMetrics) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.values != rhs.values {return false}
    if lhs.keys != rhs.keys {return false}
    if lhs.planID != rhs.planID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.ResultComplete: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.protoMessageName + ".ResultComplete"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.ResultComplete, rhs: Spark_Connect_ExecutePlanResponse.ResultComplete) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.ExecutionProgress: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.protoMessageName + ".ExecutionProgress"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "stages"),
    2: .standard(proto: "num_inflight_tasks"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.stages) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.numInflightTasks) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.stages.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.stages, fieldNumber: 1)
    }
    if self.numInflightTasks != 0 {
      try visitor.visitSingularInt64Field(value: self.numInflightTasks, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.ExecutionProgress, rhs: Spark_Connect_ExecutePlanResponse.ExecutionProgress) -> Bool {
    if lhs.stages != rhs.stages {return false}
    if lhs.numInflightTasks != rhs.numInflightTasks {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutePlanResponse.ExecutionProgress.StageInfo: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ExecutePlanResponse.ExecutionProgress.protoMessageName + ".StageInfo"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "stage_id"),
    2: .standard(proto: "num_tasks"),
    3: .standard(proto: "num_completed_tasks"),
    4: .standard(proto: "input_bytes_read"),
    5: .same(proto: "done"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.stageID) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.numTasks) }()
      case 3: try { try decoder.decodeSingularInt64Field(value: &self.numCompletedTasks) }()
      case 4: try { try decoder.decodeSingularInt64Field(value: &self.inputBytesRead) }()
      case 5: try { try decoder.decodeSingularBoolField(value: &self.done) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.stageID != 0 {
      try visitor.visitSingularInt64Field(value: self.stageID, fieldNumber: 1)
    }
    if self.numTasks != 0 {
      try visitor.visitSingularInt64Field(value: self.numTasks, fieldNumber: 2)
    }
    if self.numCompletedTasks != 0 {
      try visitor.visitSingularInt64Field(value: self.numCompletedTasks, fieldNumber: 3)
    }
    if self.inputBytesRead != 0 {
      try visitor.visitSingularInt64Field(value: self.inputBytesRead, fieldNumber: 4)
    }
    if self.done != false {
      try visitor.visitSingularBoolField(value: self.done, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutePlanResponse.ExecutionProgress.StageInfo, rhs: Spark_Connect_ExecutePlanResponse.ExecutionProgress.StageInfo) -> Bool {
    if lhs.stageID != rhs.stageID {return false}
    if lhs.numTasks != rhs.numTasks {return false}
    if lhs.numCompletedTasks != rhs.numCompletedTasks {return false}
    if lhs.inputBytesRead != rhs.inputBytesRead {return false}
    if lhs.done != rhs.done {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_KeyValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".KeyValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "key"),
    2: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.key) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._value) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.key.isEmpty {
      try visitor.visitSingularStringField(value: self.key, fieldNumber: 1)
    }
    try { if let v = self._value {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_KeyValue, rhs: Spark_Connect_KeyValue) -> Bool {
    if lhs.key != rhs.key {return false}
    if lhs._value != rhs._value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ConfigRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    8: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    3: .same(proto: "operation"),
    4: .standard(proto: "client_type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._operation) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 8: try { try decoder.decodeSingularStringField(value: &self._clientObservedServerSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._operation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._clientObservedServerSideSessionID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 8)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest, rhs: Spark_Connect_ConfigRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._clientObservedServerSideSessionID != rhs._clientObservedServerSideSessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs._operation != rhs._operation {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.Operation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".Operation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "set"),
    2: .same(proto: "get"),
    3: .standard(proto: "get_with_default"),
    4: .standard(proto: "get_option"),
    5: .standard(proto: "get_all"),
    6: .same(proto: "unset"),
    7: .standard(proto: "is_modifiable"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_ConfigRequest.Set?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .set(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .set(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_ConfigRequest.Get?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .get(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .get(v)
        }
      }()
      case 3: try {
        var v: Spark_Connect_ConfigRequest.GetWithDefault?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .getWithDefault(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .getWithDefault(v)
        }
      }()
      case 4: try {
        var v: Spark_Connect_ConfigRequest.GetOption?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .getOption(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .getOption(v)
        }
      }()
      case 5: try {
        var v: Spark_Connect_ConfigRequest.GetAll?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .getAll(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .getAll(v)
        }
      }()
      case 6: try {
        var v: Spark_Connect_ConfigRequest.Unset?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .unset(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .unset(v)
        }
      }()
      case 7: try {
        var v: Spark_Connect_ConfigRequest.IsModifiable?
        var hadOneofValue = false
        if let current = self.opType {
          hadOneofValue = true
          if case .isModifiable(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.opType = .isModifiable(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.opType {
    case .set?: try {
      guard case .set(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .get?: try {
      guard case .get(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .getWithDefault?: try {
      guard case .getWithDefault(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .getOption?: try {
      guard case .getOption(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .getAll?: try {
      guard case .getAll(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .unset?: try {
      guard case .unset(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case .isModifiable?: try {
      guard case .isModifiable(let v)? = self.opType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.Operation, rhs: Spark_Connect_ConfigRequest.Operation) -> Bool {
    if lhs.opType != rhs.opType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.Set: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".Set"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "pairs"),
    2: .same(proto: "silent"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.pairs) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self._silent) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.pairs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.pairs, fieldNumber: 1)
    }
    try { if let v = self._silent {
      try visitor.visitSingularBoolField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.Set, rhs: Spark_Connect_ConfigRequest.Set) -> Bool {
    if lhs.pairs != rhs.pairs {return false}
    if lhs._silent != rhs._silent {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.Get: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".Get"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "keys"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.keys) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.keys.isEmpty {
      try visitor.visitRepeatedStringField(value: self.keys, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.Get, rhs: Spark_Connect_ConfigRequest.Get) -> Bool {
    if lhs.keys != rhs.keys {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.GetWithDefault: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".GetWithDefault"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "pairs"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.pairs) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.pairs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.pairs, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.GetWithDefault, rhs: Spark_Connect_ConfigRequest.GetWithDefault) -> Bool {
    if lhs.pairs != rhs.pairs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.GetOption: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".GetOption"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "keys"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.keys) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.keys.isEmpty {
      try visitor.visitRepeatedStringField(value: self.keys, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.GetOption, rhs: Spark_Connect_ConfigRequest.GetOption) -> Bool {
    if lhs.keys != rhs.keys {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.GetAll: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".GetAll"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "prefix"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._prefix) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._prefix {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.GetAll, rhs: Spark_Connect_ConfigRequest.GetAll) -> Bool {
    if lhs._prefix != rhs._prefix {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.Unset: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".Unset"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "keys"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.keys) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.keys.isEmpty {
      try visitor.visitRepeatedStringField(value: self.keys, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.Unset, rhs: Spark_Connect_ConfigRequest.Unset) -> Bool {
    if lhs.keys != rhs.keys {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigRequest.IsModifiable: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ConfigRequest.protoMessageName + ".IsModifiable"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "keys"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.keys) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.keys.isEmpty {
      try visitor.visitRepeatedStringField(value: self.keys, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigRequest.IsModifiable, rhs: Spark_Connect_ConfigRequest.IsModifiable) -> Bool {
    if lhs.keys != rhs.keys {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ConfigResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ConfigResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    4: .standard(proto: "server_side_session_id"),
    2: .same(proto: "pairs"),
    3: .same(proto: "warnings"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.pairs) }()
      case 3: try { try decoder.decodeRepeatedStringField(value: &self.warnings) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    if !self.pairs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.pairs, fieldNumber: 2)
    }
    if !self.warnings.isEmpty {
      try visitor.visitRepeatedStringField(value: self.warnings, fieldNumber: 3)
    }
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ConfigResponse, rhs: Spark_Connect_ConfigResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.pairs != rhs.pairs {return false}
    if lhs.warnings != rhs.warnings {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AddArtifactsRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AddArtifactsRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    2: .standard(proto: "user_context"),
    7: .standard(proto: "client_observed_server_side_session_id"),
    6: .standard(proto: "client_type"),
    3: .same(proto: "batch"),
    4: .standard(proto: "begin_chunk"),
    5: .same(proto: "chunk"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try {
        var v: Spark_Connect_AddArtifactsRequest.Batch?
        var hadOneofValue = false
        if let current = self.payload {
          hadOneofValue = true
          if case .batch(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.payload = .batch(v)
        }
      }()
      case 4: try {
        var v: Spark_Connect_AddArtifactsRequest.BeginChunkedArtifact?
        var hadOneofValue = false
        if let current = self.payload {
          hadOneofValue = true
          if case .beginChunk(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.payload = .beginChunk(v)
        }
      }()
      case 5: try {
        var v: Spark_Connect_AddArtifactsRequest.ArtifactChunk?
        var hadOneofValue = false
        if let current = self.payload {
          hadOneofValue = true
          if case .chunk(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.payload = .chunk(v)
        }
      }()
      case 6: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 7: try { try decoder.decodeSingularStringField(value: &self._clientObservedServerSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    switch self.payload {
    case .batch?: try {
      guard case .batch(let v)? = self.payload else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .beginChunk?: try {
      guard case .beginChunk(let v)? = self.payload else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .chunk?: try {
      guard case .chunk(let v)? = self.payload else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case nil: break
    }
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 6)
    } }()
    try { if let v = self._clientObservedServerSideSessionID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 7)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AddArtifactsRequest, rhs: Spark_Connect_AddArtifactsRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs._clientObservedServerSideSessionID != rhs._clientObservedServerSideSessionID {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs.payload != rhs.payload {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AddArtifactsRequest.ArtifactChunk: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AddArtifactsRequest.protoMessageName + ".ArtifactChunk"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "data"),
    2: .same(proto: "crc"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.data) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.crc) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.data.isEmpty {
      try visitor.visitSingularBytesField(value: self.data, fieldNumber: 1)
    }
    if self.crc != 0 {
      try visitor.visitSingularInt64Field(value: self.crc, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AddArtifactsRequest.ArtifactChunk, rhs: Spark_Connect_AddArtifactsRequest.ArtifactChunk) -> Bool {
    if lhs.data != rhs.data {return false}
    if lhs.crc != rhs.crc {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AddArtifactsRequest.SingleChunkArtifact: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AddArtifactsRequest.protoMessageName + ".SingleChunkArtifact"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "data"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._data) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    try { if let v = self._data {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AddArtifactsRequest.SingleChunkArtifact, rhs: Spark_Connect_AddArtifactsRequest.SingleChunkArtifact) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs._data != rhs._data {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AddArtifactsRequest.Batch: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AddArtifactsRequest.protoMessageName + ".Batch"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "artifacts"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.artifacts) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.artifacts.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.artifacts, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AddArtifactsRequest.Batch, rhs: Spark_Connect_AddArtifactsRequest.Batch) -> Bool {
    if lhs.artifacts != rhs.artifacts {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AddArtifactsRequest.BeginChunkedArtifact: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AddArtifactsRequest.protoMessageName + ".BeginChunkedArtifact"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .standard(proto: "total_bytes"),
    3: .standard(proto: "num_chunks"),
    4: .standard(proto: "initial_chunk"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.totalBytes) }()
      case 3: try { try decoder.decodeSingularInt64Field(value: &self.numChunks) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._initialChunk) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if self.totalBytes != 0 {
      try visitor.visitSingularInt64Field(value: self.totalBytes, fieldNumber: 2)
    }
    if self.numChunks != 0 {
      try visitor.visitSingularInt64Field(value: self.numChunks, fieldNumber: 3)
    }
    try { if let v = self._initialChunk {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AddArtifactsRequest.BeginChunkedArtifact, rhs: Spark_Connect_AddArtifactsRequest.BeginChunkedArtifact) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.totalBytes != rhs.totalBytes {return false}
    if lhs.numChunks != rhs.numChunks {return false}
    if lhs._initialChunk != rhs._initialChunk {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AddArtifactsResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AddArtifactsResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .standard(proto: "session_id"),
    3: .standard(proto: "server_side_session_id"),
    1: .same(proto: "artifacts"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.artifacts) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.artifacts.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.artifacts, fieldNumber: 1)
    }
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 2)
    }
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AddArtifactsResponse, rhs: Spark_Connect_AddArtifactsResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.artifacts != rhs.artifacts {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_AddArtifactsResponse.ArtifactSummary: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_AddArtifactsResponse.protoMessageName + ".ArtifactSummary"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .standard(proto: "is_crc_successful"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.isCrcSuccessful) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if self.isCrcSuccessful != false {
      try visitor.visitSingularBoolField(value: self.isCrcSuccessful, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_AddArtifactsResponse.ArtifactSummary, rhs: Spark_Connect_AddArtifactsResponse.ArtifactSummary) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.isCrcSuccessful != rhs.isCrcSuccessful {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ArtifactStatusesRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ArtifactStatusesRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    5: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    3: .standard(proto: "client_type"),
    4: .same(proto: "names"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 4: try { try decoder.decodeRepeatedStringField(value: &self.names) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self._clientObservedServerSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    if !self.names.isEmpty {
      try visitor.visitRepeatedStringField(value: self.names, fieldNumber: 4)
    }
    try { if let v = self._clientObservedServerSideSessionID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 5)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ArtifactStatusesRequest, rhs: Spark_Connect_ArtifactStatusesRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._clientObservedServerSideSessionID != rhs._clientObservedServerSideSessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs.names != rhs.names {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ArtifactStatusesResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ArtifactStatusesResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .standard(proto: "session_id"),
    3: .standard(proto: "server_side_session_id"),
    1: .same(proto: "statuses"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ArtifactStatusesResponse.ArtifactStatus>.self, value: &self.statuses) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.statuses.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ArtifactStatusesResponse.ArtifactStatus>.self, value: self.statuses, fieldNumber: 1)
    }
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 2)
    }
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ArtifactStatusesResponse, rhs: Spark_Connect_ArtifactStatusesResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.statuses != rhs.statuses {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ArtifactStatusesResponse.ArtifactStatus: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ArtifactStatusesResponse.protoMessageName + ".ArtifactStatus"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "exists"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.exists) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.exists != false {
      try visitor.visitSingularBoolField(value: self.exists, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ArtifactStatusesResponse.ArtifactStatus, rhs: Spark_Connect_ArtifactStatusesResponse.ArtifactStatus) -> Bool {
    if lhs.exists != rhs.exists {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_InterruptRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".InterruptRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    7: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    3: .standard(proto: "client_type"),
    4: .standard(proto: "interrupt_type"),
    5: .standard(proto: "operation_tag"),
    6: .standard(proto: "operation_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 4: try { try decoder.decodeSingularEnumField(value: &self.interruptType) }()
      case 5: try {
        var v: String?
        try decoder.decodeSingularStringField(value: &v)
        if let v = v {
          if self.interrupt != nil {try decoder.handleConflictingOneOf()}
          self.interrupt = .operationTag(v)
        }
      }()
      case 6: try {
        var v: String?
        try decoder.decodeSingularStringField(value: &v)
        if let v = v {
          if self.interrupt != nil {try decoder.handleConflictingOneOf()}
          self.interrupt = .operationID(v)
        }
      }()
      case 7: try { try decoder.decodeSingularStringField(value: &self._clientObservedServerSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    if self.interruptType != .unspecified {
      try visitor.visitSingularEnumField(value: self.interruptType, fieldNumber: 4)
    }
    switch self.interrupt {
    case .operationTag?: try {
      guard case .operationTag(let v)? = self.interrupt else { preconditionFailure() }
      try visitor.visitSingularStringField(value: v, fieldNumber: 5)
    }()
    case .operationID?: try {
      guard case .operationID(let v)? = self.interrupt else { preconditionFailure() }
      try visitor.visitSingularStringField(value: v, fieldNumber: 6)
    }()
    case nil: break
    }
    try { if let v = self._clientObservedServerSideSessionID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 7)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_InterruptRequest, rhs: Spark_Connect_InterruptRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._clientObservedServerSideSessionID != rhs._clientObservedServerSideSessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs.interruptType != rhs.interruptType {return false}
    if lhs.interrupt != rhs.interrupt {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_InterruptRequest.InterruptType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "INTERRUPT_TYPE_UNSPECIFIED"),
    1: .same(proto: "INTERRUPT_TYPE_ALL"),
    2: .same(proto: "INTERRUPT_TYPE_TAG"),
    3: .same(proto: "INTERRUPT_TYPE_OPERATION_ID"),
  ]
}

extension Spark_Connect_InterruptResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".InterruptResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    3: .standard(proto: "server_side_session_id"),
    2: .standard(proto: "interrupted_ids"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeRepeatedStringField(value: &self.interruptedIds) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    if !self.interruptedIds.isEmpty {
      try visitor.visitRepeatedStringField(value: self.interruptedIds, fieldNumber: 2)
    }
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_InterruptResponse, rhs: Spark_Connect_InterruptResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.interruptedIds != rhs.interruptedIds {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReattachOptions: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReattachOptions"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "reattachable"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.reattachable) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.reattachable != false {
      try visitor.visitSingularBoolField(value: self.reattachable, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReattachOptions, rhs: Spark_Connect_ReattachOptions) -> Bool {
    if lhs.reattachable != rhs.reattachable {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReattachExecuteRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReattachExecuteRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    6: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    3: .standard(proto: "operation_id"),
    4: .standard(proto: "client_type"),
    5: .standard(proto: "last_response_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.operationID) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self._lastResponseID) }()
      case 6: try { try decoder.decodeSingularStringField(value: &self._clientObservedServerSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.operationID.isEmpty {
      try visitor.visitSingularStringField(value: self.operationID, fieldNumber: 3)
    }
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._lastResponseID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 5)
    } }()
    try { if let v = self._clientObservedServerSideSessionID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 6)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReattachExecuteRequest, rhs: Spark_Connect_ReattachExecuteRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._clientObservedServerSideSessionID != rhs._clientObservedServerSideSessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs.operationID != rhs.operationID {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs._lastResponseID != rhs._lastResponseID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReleaseExecuteRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReleaseExecuteRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    7: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    3: .standard(proto: "operation_id"),
    4: .standard(proto: "client_type"),
    5: .standard(proto: "release_all"),
    6: .standard(proto: "release_until"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.operationID) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 5: try {
        var v: Spark_Connect_ReleaseExecuteRequest.ReleaseAll?
        var hadOneofValue = false
        if let current = self.release {
          hadOneofValue = true
          if case .releaseAll(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.release = .releaseAll(v)
        }
      }()
      case 6: try {
        var v: Spark_Connect_ReleaseExecuteRequest.ReleaseUntil?
        var hadOneofValue = false
        if let current = self.release {
          hadOneofValue = true
          if case .releaseUntil(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.release = .releaseUntil(v)
        }
      }()
      case 7: try { try decoder.decodeSingularStringField(value: &self._clientObservedServerSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.operationID.isEmpty {
      try visitor.visitSingularStringField(value: self.operationID, fieldNumber: 3)
    }
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    switch self.release {
    case .releaseAll?: try {
      guard case .releaseAll(let v)? = self.release else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .releaseUntil?: try {
      guard case .releaseUntil(let v)? = self.release else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case nil: break
    }
    try { if let v = self._clientObservedServerSideSessionID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 7)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReleaseExecuteRequest, rhs: Spark_Connect_ReleaseExecuteRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._clientObservedServerSideSessionID != rhs._clientObservedServerSideSessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs.operationID != rhs.operationID {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs.release != rhs.release {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReleaseExecuteRequest.ReleaseAll: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ReleaseExecuteRequest.protoMessageName + ".ReleaseAll"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    // Load everything into unknown fields
    while try decoder.nextFieldNumber() != nil {}
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReleaseExecuteRequest.ReleaseAll, rhs: Spark_Connect_ReleaseExecuteRequest.ReleaseAll) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReleaseExecuteRequest.ReleaseUntil: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_ReleaseExecuteRequest.protoMessageName + ".ReleaseUntil"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "response_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.responseID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.responseID.isEmpty {
      try visitor.visitSingularStringField(value: self.responseID, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReleaseExecuteRequest.ReleaseUntil, rhs: Spark_Connect_ReleaseExecuteRequest.ReleaseUntil) -> Bool {
    if lhs.responseID != rhs.responseID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReleaseExecuteResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReleaseExecuteResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    3: .standard(proto: "server_side_session_id"),
    2: .standard(proto: "operation_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._operationID) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._operationID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReleaseExecuteResponse, rhs: Spark_Connect_ReleaseExecuteResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs._operationID != rhs._operationID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReleaseSessionRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReleaseSessionRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    2: .standard(proto: "user_context"),
    3: .standard(proto: "client_type"),
    4: .standard(proto: "allow_reconnect"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 4: try { try decoder.decodeSingularBoolField(value: &self.allowReconnect) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    if self.allowReconnect != false {
      try visitor.visitSingularBoolField(value: self.allowReconnect, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReleaseSessionRequest, rhs: Spark_Connect_ReleaseSessionRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs.allowReconnect != rhs.allowReconnect {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ReleaseSessionResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReleaseSessionResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    2: .standard(proto: "server_side_session_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ReleaseSessionResponse, rhs: Spark_Connect_ReleaseSessionResponse) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_FetchErrorDetailsRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FetchErrorDetailsRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "session_id"),
    5: .standard(proto: "client_observed_server_side_session_id"),
    2: .standard(proto: "user_context"),
    3: .standard(proto: "error_id"),
    4: .standard(proto: "client_type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._userContext) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.errorID) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._clientType) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self._clientObservedServerSideSessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 1)
    }
    try { if let v = self._userContext {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    if !self.errorID.isEmpty {
      try visitor.visitSingularStringField(value: self.errorID, fieldNumber: 3)
    }
    try { if let v = self._clientType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._clientObservedServerSideSessionID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 5)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_FetchErrorDetailsRequest, rhs: Spark_Connect_FetchErrorDetailsRequest) -> Bool {
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._clientObservedServerSideSessionID != rhs._clientObservedServerSideSessionID {return false}
    if lhs._userContext != rhs._userContext {return false}
    if lhs.errorID != rhs.errorID {return false}
    if lhs._clientType != rhs._clientType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_FetchErrorDetailsResponse: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FetchErrorDetailsResponse"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    3: .standard(proto: "server_side_session_id"),
    4: .standard(proto: "session_id"),
    1: .standard(proto: "root_error_idx"),
    2: .same(proto: "errors"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt32Field(value: &self._rootErrorIdx) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.errors) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.serverSideSessionID) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self.sessionID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._rootErrorIdx {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 1)
    } }()
    if !self.errors.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.errors, fieldNumber: 2)
    }
    if !self.serverSideSessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.serverSideSessionID, fieldNumber: 3)
    }
    if !self.sessionID.isEmpty {
      try visitor.visitSingularStringField(value: self.sessionID, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_FetchErrorDetailsResponse, rhs: Spark_Connect_FetchErrorDetailsResponse) -> Bool {
    if lhs.serverSideSessionID != rhs.serverSideSessionID {return false}
    if lhs.sessionID != rhs.sessionID {return false}
    if lhs._rootErrorIdx != rhs._rootErrorIdx {return false}
    if lhs.errors != rhs.errors {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_FetchErrorDetailsResponse.StackTraceElement: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_FetchErrorDetailsResponse.protoMessageName + ".StackTraceElement"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "declaring_class"),
    2: .standard(proto: "method_name"),
    3: .standard(proto: "file_name"),
    4: .standard(proto: "line_number"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.declaringClass) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.methodName) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._fileName) }()
      case 4: try { try decoder.decodeSingularInt32Field(value: &self.lineNumber) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.declaringClass.isEmpty {
      try visitor.visitSingularStringField(value: self.declaringClass, fieldNumber: 1)
    }
    if !self.methodName.isEmpty {
      try visitor.visitSingularStringField(value: self.methodName, fieldNumber: 2)
    }
    try { if let v = self._fileName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    if self.lineNumber != 0 {
      try visitor.visitSingularInt32Field(value: self.lineNumber, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_FetchErrorDetailsResponse.StackTraceElement, rhs: Spark_Connect_FetchErrorDetailsResponse.StackTraceElement) -> Bool {
    if lhs.declaringClass != rhs.declaringClass {return false}
    if lhs.methodName != rhs.methodName {return false}
    if lhs._fileName != rhs._fileName {return false}
    if lhs.lineNumber != rhs.lineNumber {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_FetchErrorDetailsResponse.QueryContext: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_FetchErrorDetailsResponse.protoMessageName + ".QueryContext"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .standard(proto: "context_type"),
    1: .standard(proto: "object_type"),
    2: .standard(proto: "object_name"),
    3: .standard(proto: "start_index"),
    4: .standard(proto: "stop_index"),
    5: .same(proto: "fragment"),
    6: .standard(proto: "call_site"),
    7: .same(proto: "summary"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.objectType) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.objectName) }()
      case 3: try { try decoder.decodeSingularInt32Field(value: &self.startIndex) }()
      case 4: try { try decoder.decodeSingularInt32Field(value: &self.stopIndex) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.fragment) }()
      case 6: try { try decoder.decodeSingularStringField(value: &self.callSite) }()
      case 7: try { try decoder.decodeSingularStringField(value: &self.summary) }()
      case 10: try { try decoder.decodeSingularEnumField(value: &self.contextType) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.objectType.isEmpty {
      try visitor.visitSingularStringField(value: self.objectType, fieldNumber: 1)
    }
    if !self.objectName.isEmpty {
      try visitor.visitSingularStringField(value: self.objectName, fieldNumber: 2)
    }
    if self.startIndex != 0 {
      try visitor.visitSingularInt32Field(value: self.startIndex, fieldNumber: 3)
    }
    if self.stopIndex != 0 {
      try visitor.visitSingularInt32Field(value: self.stopIndex, fieldNumber: 4)
    }
    if !self.fragment.isEmpty {
      try visitor.visitSingularStringField(value: self.fragment, fieldNumber: 5)
    }
    if !self.callSite.isEmpty {
      try visitor.visitSingularStringField(value: self.callSite, fieldNumber: 6)
    }
    if !self.summary.isEmpty {
      try visitor.visitSingularStringField(value: self.summary, fieldNumber: 7)
    }
    if self.contextType != .sql {
      try visitor.visitSingularEnumField(value: self.contextType, fieldNumber: 10)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_FetchErrorDetailsResponse.QueryContext, rhs: Spark_Connect_FetchErrorDetailsResponse.QueryContext) -> Bool {
    if lhs.contextType != rhs.contextType {return false}
    if lhs.objectType != rhs.objectType {return false}
    if lhs.objectName != rhs.objectName {return false}
    if lhs.startIndex != rhs.startIndex {return false}
    if lhs.stopIndex != rhs.stopIndex {return false}
    if lhs.fragment != rhs.fragment {return false}
    if lhs.callSite != rhs.callSite {return false}
    if lhs.summary != rhs.summary {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_FetchErrorDetailsResponse.QueryContext.ContextType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQL"),
    1: .same(proto: "DATAFRAME"),
  ]
}

extension Spark_Connect_FetchErrorDetailsResponse.SparkThrowable: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_FetchErrorDetailsResponse.protoMessageName + ".SparkThrowable"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "error_class"),
    2: .standard(proto: "message_parameters"),
    3: .standard(proto: "query_contexts"),
    4: .standard(proto: "sql_state"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._errorClass) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.messageParameters) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.queryContexts) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._sqlState) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._errorClass {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    if !self.messageParameters.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.messageParameters, fieldNumber: 2)
    }
    if !self.queryContexts.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.queryContexts, fieldNumber: 3)
    }
    try { if let v = self._sqlState {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_FetchErrorDetailsResponse.SparkThrowable, rhs: Spark_Connect_FetchErrorDetailsResponse.SparkThrowable) -> Bool {
    if lhs._errorClass != rhs._errorClass {return false}
    if lhs.messageParameters != rhs.messageParameters {return false}
    if lhs.queryContexts != rhs.queryContexts {return false}
    if lhs._sqlState != rhs._sqlState {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_FetchErrorDetailsResponse.Error: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_FetchErrorDetailsResponse.protoMessageName + ".Error"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "error_type_hierarchy"),
    2: .same(proto: "message"),
    3: .standard(proto: "stack_trace"),
    4: .standard(proto: "cause_idx"),
    5: .standard(proto: "spark_throwable"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.errorTypeHierarchy) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.message) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.stackTrace) }()
      case 4: try { try decoder.decodeSingularInt32Field(value: &self._causeIdx) }()
      case 5: try { try decoder.decodeSingularMessageField(value: &self._sparkThrowable) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.errorTypeHierarchy.isEmpty {
      try visitor.visitRepeatedStringField(value: self.errorTypeHierarchy, fieldNumber: 1)
    }
    if !self.message.isEmpty {
      try visitor.visitSingularStringField(value: self.message, fieldNumber: 2)
    }
    if !self.stackTrace.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.stackTrace, fieldNumber: 3)
    }
    try { if let v = self._causeIdx {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._sparkThrowable {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_FetchErrorDetailsResponse.Error, rhs: Spark_Connect_FetchErrorDetailsResponse.Error) -> Bool {
    if lhs.errorTypeHierarchy != rhs.errorTypeHierarchy {return false}
    if lhs.message != rhs.message {return false}
    if lhs.stackTrace != rhs.stackTrace {return false}
    if lhs._causeIdx != rhs._causeIdx {return false}
    if lhs._sparkThrowable != rhs._sparkThrowable {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_CheckpointCommandResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CheckpointCommandResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "relation"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._relation) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._relation {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_CheckpointCommandResult, rhs: Spark_Connect_CheckpointCommandResult) -> Bool {
    if lhs._relation != rhs._relation {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
