// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// automatically generated by the FlatBuffers compiler, do not modify
// swiftlint:disable all
// swiftformat:disable all

import FlatBuffers

/// @nodoc
public enum org_apache_arrow_flatbuf_CompressionType: Int8, Enum, Verifiable {
  public typealias T = Int8
  public static var byteSize: Int { return MemoryLayout<Int8>.size }
  public var value: Int8 { return self.rawValue }
  case lz4Frame = 0
  case zstd = 1

  public static var max: org_apache_arrow_flatbuf_CompressionType { return .zstd }
  public static var min: org_apache_arrow_flatbuf_CompressionType { return .lz4Frame }
}

///  Provided for forward compatibility in case we need to support different
///  strategies for compressing the IPC message body (like whole-body
///  compression rather than buffer-level) in the future
public enum org_apache_arrow_flatbuf_BodyCompressionMethod: Int8, Enum, Verifiable {
  public typealias T = Int8
  public static var byteSize: Int { return MemoryLayout<Int8>.size }
  public var value: Int8 { return self.rawValue }
  ///  Each constituent buffer is first compressed with the indicated
  ///  compressor, and then written with the uncompressed length in the first 8
  ///  bytes as a 64-bit little-endian signed integer followed by the compressed
  ///  buffer bytes (and then padding as required by the protocol). The
  ///  uncompressed length may be set to -1 to indicate that the data that
  ///  follows is not compressed, which can be useful for cases where
  ///  compression does not yield appreciable savings.
  case buffer = 0

  public static var max: org_apache_arrow_flatbuf_BodyCompressionMethod { return .buffer }
  public static var min: org_apache_arrow_flatbuf_BodyCompressionMethod { return .buffer }
}

///  ----------------------------------------------------------------------
///  The root Message type
///  This union enables us to easily send different message types without
///  redundant storage, and in the future we can easily add new message types.
///
///  Arrow implementations do not need to implement all of the message types,
///  which may include experimental metadata types. For maximum compatibility,
///  it is best to send data using RecordBatch
/// @nodoc
public enum org_apache_arrow_flatbuf_MessageHeader: UInt8, UnionEnum {
  public typealias T = UInt8

  public init?(value: T) {
    self.init(rawValue: value)
  }

  public static var byteSize: Int { return MemoryLayout<UInt8>.size }
  public var value: UInt8 { return self.rawValue }
  case none_ = 0
  case schema = 1
  case dictionarybatch = 2
  case recordbatch = 3
  case tensor = 4
  case sparsetensor = 5

  public static var max: org_apache_arrow_flatbuf_MessageHeader { return .sparsetensor }
  public static var min: org_apache_arrow_flatbuf_MessageHeader { return .none_ }
}

///  ----------------------------------------------------------------------
///  Data structures for describing a table row batch (a collection of
///  equal-length Arrow arrays)
///  Metadata about a field at some level of a nested type tree (but not
///  its children).
///
///  For example, a List<Int16> with values `[[1, 2, 3], null, [4], [5, 6], null]`
///  would have {length: 5, null_count: 2} for its List node, and {length: 6,
///  null_count: 0} for its Int16 node, as separate FieldNode structs
/// @nodoc
public struct org_apache_arrow_flatbuf_FieldNode: NativeStruct, Verifiable, FlatbuffersInitializable
{

  static func validateVersion() { FlatBuffersVersion_23_1_4() }

  ///  The number of value slots in the Arrow array at this level of a nested
  ///  tree
  private var _length: Int64
  ///  The number of observed nulls. Fields with null_count == 0 may choose not
  ///  to write their physical validity bitmap out as a materialized buffer,
  ///  instead setting the length of the bitmap buffer to 0.
  private var _nullCount: Int64

  public init(_ bb: ByteBuffer, o: Int32) {
    let _accessor = Struct(bb: bb, position: o)
    _length = _accessor.readBuffer(of: Int64.self, at: 0)
    _nullCount = _accessor.readBuffer(of: Int64.self, at: 8)
  }

  public init(length: Int64, nullCount: Int64) {
    _length = length
    _nullCount = nullCount
  }

  public init() {
    _length = 0
    _nullCount = 0
  }

  ///  The number of value slots in the Arrow array at this level of a nested
  ///  tree
  public var length: Int64 { _length }
  ///  The number of observed nulls. Fields with null_count == 0 may choose not
  ///  to write their physical validity bitmap out as a materialized buffer,
  ///  instead setting the length of the bitmap buffer to 0.
  public var nullCount: Int64 { _nullCount }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    try verifier.inBuffer(position: position, of: org_apache_arrow_flatbuf_FieldNode.self)
  }
}

///  ----------------------------------------------------------------------
///  Data structures for describing a table row batch (a collection of
///  equal-length Arrow arrays)
///  Metadata about a field at some level of a nested type tree (but not
///  its children).
///
///  For example, a List<Int16> with values `[[1, 2, 3], null, [4], [5, 6], null]`
///  would have {length: 5, null_count: 2} for its List node, and {length: 6,
///  null_count: 0} for its Int16 node, as separate FieldNode structs
/// @nodoc
public struct org_apache_arrow_flatbuf_FieldNode_Mutable: FlatBufferObject {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Struct

  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Struct(bb: bb, position: o) }

  public var length: Int64 { return _accessor.readBuffer(of: Int64.self, at: 0) }
  public var nullCount: Int64 { return _accessor.readBuffer(of: Int64.self, at: 8) }
}

///  Optional compression for the memory buffers constituting IPC message
///  bodies. Intended for use with RecordBatch but could be used for other
///  message types
/// @nodoc
public struct org_apache_arrow_flatbuf_BodyCompression: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsBodyCompression(bb: ByteBuffer)
    -> org_apache_arrow_flatbuf_BodyCompression
  {
    return org_apache_arrow_flatbuf_BodyCompression(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case codec = 4
    case method = 6
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  Compressor library.
  ///  For LZ4_FRAME, each compressed buffer must consist of a single frame.
  public var codec: org_apache_arrow_flatbuf_CompressionType {
    let o = _accessor.offset(VTOFFSET.codec.v)
    return o == 0
      ? .lz4Frame
      : org_apache_arrow_flatbuf_CompressionType(
        rawValue: _accessor.readBuffer(of: Int8.self, at: o)) ?? .lz4Frame
  }
  ///  Indicates the way the record batch body was compressed
  public var method: org_apache_arrow_flatbuf_BodyCompressionMethod {
    let o = _accessor.offset(VTOFFSET.method.v)
    return o == 0
      ? .buffer
      : org_apache_arrow_flatbuf_BodyCompressionMethod(
        rawValue: _accessor.readBuffer(of: Int8.self, at: o)) ?? .buffer
  }
  public static func startBodyCompression(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 2)
  }
  public static func add(
    codec: org_apache_arrow_flatbuf_CompressionType, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: codec.rawValue, def: 0, at: VTOFFSET.codec.p) }
  public static func add(
    method: org_apache_arrow_flatbuf_BodyCompressionMethod, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: method.rawValue, def: 0, at: VTOFFSET.method.p) }
  public static func endBodyCompression(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createBodyCompression(
    _ fbb: inout FlatBufferBuilder,
    codec: org_apache_arrow_flatbuf_CompressionType = .lz4Frame,
    method: org_apache_arrow_flatbuf_BodyCompressionMethod = .buffer
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_BodyCompression.startBodyCompression(&fbb)
    org_apache_arrow_flatbuf_BodyCompression.add(codec: codec, &fbb)
    org_apache_arrow_flatbuf_BodyCompression.add(method: method, &fbb)
    return org_apache_arrow_flatbuf_BodyCompression.endBodyCompression(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.codec.p, fieldName: "codec", required: false,
      type: org_apache_arrow_flatbuf_CompressionType.self)
    try _v.visit(
      field: VTOFFSET.method.p, fieldName: "method", required: false,
      type: org_apache_arrow_flatbuf_BodyCompressionMethod.self)
    _v.finish()
  }
}

///  A data header describing the shared memory layout of a "record" or "row"
///  batch. Some systems call this a "row batch" internally and others a "record
///  batch".
/// @nodoc
public struct org_apache_arrow_flatbuf_RecordBatch: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsRecordBatch(bb: ByteBuffer) -> org_apache_arrow_flatbuf_RecordBatch {
    return org_apache_arrow_flatbuf_RecordBatch(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case length = 4
    case nodes = 6
    case buffers = 8
    case compression = 10
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  ///  number of records / rows. The arrays in the batch should all have this
  ///  length
  public var length: Int64 {
    let o = _accessor.offset(VTOFFSET.length.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int64.self, at: o)
  }
  ///  Nodes correspond to the pre-ordered flattened logical schema
  public var hasNodes: Bool {
    let o = _accessor.offset(VTOFFSET.nodes.v)
    return o == 0 ? false : true
  }
  public var nodesCount: Int32 {
    let o = _accessor.offset(VTOFFSET.nodes.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func nodes(at index: Int32) -> org_apache_arrow_flatbuf_FieldNode? {
    let o = _accessor.offset(VTOFFSET.nodes.v)
    return o == 0
      ? nil
      : _accessor.directRead(
        of: org_apache_arrow_flatbuf_FieldNode.self, offset: _accessor.vector(at: o) + index * 16)
  }
  public func mutableNodes(at index: Int32) -> org_apache_arrow_flatbuf_FieldNode_Mutable? {
    let o = _accessor.offset(VTOFFSET.nodes.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_FieldNode_Mutable(
        _accessor.bb, o: _accessor.vector(at: o) + index * 16)
  }
  ///  Buffers correspond to the pre-ordered flattened buffer tree
  ///
  ///  The number of buffers appended to this list depends on the schema. For
  ///  example, most primitive arrays will have 2 buffers, 1 for the validity
  ///  bitmap and 1 for the values. For struct arrays, there will only be a
  ///  single buffer for the validity (nulls) bitmap
  public var hasBuffers: Bool {
    let o = _accessor.offset(VTOFFSET.buffers.v)
    return o == 0 ? false : true
  }
  public var buffersCount: Int32 {
    let o = _accessor.offset(VTOFFSET.buffers.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func buffers(at index: Int32) -> org_apache_arrow_flatbuf_Buffer? {
    let o = _accessor.offset(VTOFFSET.buffers.v)
    return o == 0
      ? nil
      : _accessor.directRead(
        of: org_apache_arrow_flatbuf_Buffer.self, offset: _accessor.vector(at: o) + index * 16)
  }
  public func mutableBuffers(at index: Int32) -> org_apache_arrow_flatbuf_Buffer_Mutable? {
    let o = _accessor.offset(VTOFFSET.buffers.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_Buffer_Mutable(
        _accessor.bb, o: _accessor.vector(at: o) + index * 16)
  }
  ///  Optional compression of the message body
  public var compression: org_apache_arrow_flatbuf_BodyCompression? {
    let o = _accessor.offset(VTOFFSET.compression.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_BodyCompression(
        _accessor.bb, o: _accessor.indirect(o + _accessor.position))
  }
  public static func startRecordBatch(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 4)
  }
  public static func add(length: Int64, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: length, def: 0, at: VTOFFSET.length.p)
  }
  public static func addVectorOf(nodes: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: nodes, at: VTOFFSET.nodes.p)
  }
  public static func startVectorOfNodes(_ size: Int, in builder: inout FlatBufferBuilder) {
    builder.startVector(
      size * MemoryLayout<org_apache_arrow_flatbuf_FieldNode>.size,
      elementSize: MemoryLayout<org_apache_arrow_flatbuf_FieldNode>.alignment)
  }
  public static func addVectorOf(buffers: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: buffers, at: VTOFFSET.buffers.p)
  }
  public static func startVectorOfBuffers(_ size: Int, in builder: inout FlatBufferBuilder) {
    builder.startVector(
      size * MemoryLayout<org_apache_arrow_flatbuf_Buffer>.size,
      elementSize: MemoryLayout<org_apache_arrow_flatbuf_Buffer>.alignment)
  }
  public static func add(compression: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: compression, at: VTOFFSET.compression.p)
  }
  public static func endRecordBatch(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createRecordBatch(
    _ fbb: inout FlatBufferBuilder,
    length: Int64 = 0,
    nodesVectorOffset nodes: Offset = Offset(),
    buffersVectorOffset buffers: Offset = Offset(),
    compressionOffset compression: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_RecordBatch.startRecordBatch(&fbb)
    org_apache_arrow_flatbuf_RecordBatch.add(length: length, &fbb)
    org_apache_arrow_flatbuf_RecordBatch.addVectorOf(nodes: nodes, &fbb)
    org_apache_arrow_flatbuf_RecordBatch.addVectorOf(buffers: buffers, &fbb)
    org_apache_arrow_flatbuf_RecordBatch.add(compression: compression, &fbb)
    return org_apache_arrow_flatbuf_RecordBatch.endRecordBatch(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(field: VTOFFSET.length.p, fieldName: "length", required: false, type: Int64.self)
    try _v.visit(
      field: VTOFFSET.nodes.p, fieldName: "nodes", required: false,
      type: ForwardOffset<
        Vector<org_apache_arrow_flatbuf_FieldNode, org_apache_arrow_flatbuf_FieldNode>
      >.self)
    try _v.visit(
      field: VTOFFSET.buffers.p, fieldName: "buffers", required: false,
      type: ForwardOffset<Vector<org_apache_arrow_flatbuf_Buffer, org_apache_arrow_flatbuf_Buffer>>
        .self)
    try _v.visit(
      field: VTOFFSET.compression.p, fieldName: "compression", required: false,
      type: ForwardOffset<org_apache_arrow_flatbuf_BodyCompression>.self)
    _v.finish()
  }
}

///  For sending dictionary encoding information. Any Field can be
///  dictionary-encoded, but in this case none of its children may be
///  dictionary-encoded.
///  There is one vector / column per dictionary, but that vector / column
///  may be spread across multiple dictionary batches by using the isDelta
///  flag
/// @nodoc
public struct org_apache_arrow_flatbuf_DictionaryBatch: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsDictionaryBatch(bb: ByteBuffer)
    -> org_apache_arrow_flatbuf_DictionaryBatch
  {
    return org_apache_arrow_flatbuf_DictionaryBatch(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case id = 4
    case data = 6
    case isDelta = 8
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var id: Int64 {
    let o = _accessor.offset(VTOFFSET.id.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int64.self, at: o)
  }
  public var data: org_apache_arrow_flatbuf_RecordBatch? {
    let o = _accessor.offset(VTOFFSET.data.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_RecordBatch(
        _accessor.bb, o: _accessor.indirect(o + _accessor.position))
  }
  ///  If isDelta is true the values in the dictionary are to be appended to a
  ///  dictionary with the indicated id. If isDelta is false this dictionary
  ///  should replace the existing dictionary.
  public var isDelta: Bool {
    let o = _accessor.offset(VTOFFSET.isDelta.v)
    return o == 0 ? false : 0 != _accessor.readBuffer(of: Byte.self, at: o)
  }
  public static func startDictionaryBatch(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 3)
  }
  public static func add(id: Int64, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: id, def: 0, at: VTOFFSET.id.p)
  }
  public static func add(data: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: data, at: VTOFFSET.data.p)
  }
  public static func add(isDelta: Bool, _ fbb: inout FlatBufferBuilder) {
    fbb.add(
      element: isDelta, def: false,
      at: VTOFFSET.isDelta.p)
  }
  public static func endDictionaryBatch(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createDictionaryBatch(
    _ fbb: inout FlatBufferBuilder,
    id: Int64 = 0,
    dataOffset data: Offset = Offset(),
    isDelta: Bool = false
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_DictionaryBatch.startDictionaryBatch(&fbb)
    org_apache_arrow_flatbuf_DictionaryBatch.add(id: id, &fbb)
    org_apache_arrow_flatbuf_DictionaryBatch.add(data: data, &fbb)
    org_apache_arrow_flatbuf_DictionaryBatch.add(isDelta: isDelta, &fbb)
    return org_apache_arrow_flatbuf_DictionaryBatch.endDictionaryBatch(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(field: VTOFFSET.id.p, fieldName: "id", required: false, type: Int64.self)
    try _v.visit(
      field: VTOFFSET.data.p, fieldName: "data", required: false,
      type: ForwardOffset<org_apache_arrow_flatbuf_RecordBatch>.self)
    try _v.visit(field: VTOFFSET.isDelta.p, fieldName: "isDelta", required: false, type: Bool.self)
    _v.finish()
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_Message: FlatBufferObject, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsMessage(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Message {
    return org_apache_arrow_flatbuf_Message(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case version = 4
    case headerType = 6
    case header = 8
    case bodyLength = 10
    case customMetadata = 12
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var version: org_apache_arrow_flatbuf_MetadataVersion {
    let o = _accessor.offset(VTOFFSET.version.v)
    return o == 0
      ? .v1
      : org_apache_arrow_flatbuf_MetadataVersion(
        rawValue: _accessor.readBuffer(of: Int16.self, at: o)) ?? .v1
  }
  public var headerType: org_apache_arrow_flatbuf_MessageHeader {
    let o = _accessor.offset(VTOFFSET.headerType.v)
    return o == 0
      ? .none_
      : org_apache_arrow_flatbuf_MessageHeader(
        rawValue: _accessor.readBuffer(of: UInt8.self, at: o)) ?? .none_
  }
  public func header<T: FlatbuffersInitializable>(type: T.Type) -> T? {
    let o = _accessor.offset(VTOFFSET.header.v)
    return o == 0 ? nil : _accessor.union(o)
  }
  public var bodyLength: Int64 {
    let o = _accessor.offset(VTOFFSET.bodyLength.v)
    return o == 0 ? 0 : _accessor.readBuffer(of: Int64.self, at: o)
  }
  public var hasCustomMetadata: Bool {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? false : true
  }
  public var customMetadataCount: Int32 {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func customMetadata(at index: Int32) -> org_apache_arrow_flatbuf_KeyValue? {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_KeyValue(
        _accessor.bb, o: _accessor.indirect(_accessor.vector(at: o) + index * 4))
  }
  public static func startMessage(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 5)
  }
  public static func add(
    version: org_apache_arrow_flatbuf_MetadataVersion, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: version.rawValue, def: 0, at: VTOFFSET.version.p) }
  public static func add(
    headerType: org_apache_arrow_flatbuf_MessageHeader, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: headerType.rawValue, def: 0, at: VTOFFSET.headerType.p) }
  public static func add(header: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: header, at: VTOFFSET.header.p)
  }
  public static func add(bodyLength: Int64, _ fbb: inout FlatBufferBuilder) {
    fbb.add(element: bodyLength, def: 0, at: VTOFFSET.bodyLength.p)
  }
  public static func addVectorOf(customMetadata: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: customMetadata, at: VTOFFSET.customMetadata.p)
  }
  public static func endMessage(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createMessage(
    _ fbb: inout FlatBufferBuilder,
    version: org_apache_arrow_flatbuf_MetadataVersion = .v1,
    headerType: org_apache_arrow_flatbuf_MessageHeader = .none_,
    headerOffset header: Offset = Offset(),
    bodyLength: Int64 = 0,
    customMetadataVectorOffset customMetadata: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Message.startMessage(&fbb)
    org_apache_arrow_flatbuf_Message.add(version: version, &fbb)
    org_apache_arrow_flatbuf_Message.add(headerType: headerType, &fbb)
    org_apache_arrow_flatbuf_Message.add(header: header, &fbb)
    org_apache_arrow_flatbuf_Message.add(bodyLength: bodyLength, &fbb)
    org_apache_arrow_flatbuf_Message.addVectorOf(customMetadata: customMetadata, &fbb)
    return org_apache_arrow_flatbuf_Message.endMessage(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.version.p, fieldName: "version", required: false,
      type: org_apache_arrow_flatbuf_MetadataVersion.self)
    try _v.visit(
      unionKey: VTOFFSET.headerType.p, unionField: VTOFFSET.header.p, unionKeyName: "headerType",
      fieldName: "header", required: false,
      completion: { (verifier, key: org_apache_arrow_flatbuf_MessageHeader, pos) in
        switch key {
        case .none_:
          break  // NOTE - SWIFT doesnt support none
        case .schema:
          try ForwardOffset<org_apache_arrow_flatbuf_Schema>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Schema.self)
        case .dictionarybatch:
          try ForwardOffset<org_apache_arrow_flatbuf_DictionaryBatch>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_DictionaryBatch.self)
        case .recordbatch:
          try ForwardOffset<org_apache_arrow_flatbuf_RecordBatch>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_RecordBatch.self)
        case .tensor:
          try ForwardOffset<org_apache_arrow_flatbuf_Tensor>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_Tensor.self)
        case .sparsetensor:
          try ForwardOffset<org_apache_arrow_flatbuf_SparseTensor>.verify(
            &verifier, at: pos, of: org_apache_arrow_flatbuf_SparseTensor.self)
        }
      })
    try _v.visit(
      field: VTOFFSET.bodyLength.p, fieldName: "bodyLength", required: false, type: Int64.self)
    try _v.visit(
      field: VTOFFSET.customMetadata.p, fieldName: "customMetadata", required: false,
      type: ForwardOffset<
        Vector<ForwardOffset<org_apache_arrow_flatbuf_KeyValue>, org_apache_arrow_flatbuf_KeyValue>
      >.self)
    _v.finish()
  }
}
