/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.util.Geo;
import org.apache.spark.unsafe.types.GeographyVal;

public final class Geography
implements Geo {
    protected final GeographyVal value;
    public static int DEFAULT_SRID = 4326;

    private Geography(byte[] bytes) {
        this.value = GeographyVal.fromBytes((byte[])bytes);
    }

    private Geography(GeographyVal value) {
        this.value = value;
    }

    public static Geography fromBytes(byte[] bytes) {
        return new Geography(bytes);
    }

    public static Geography fromValue(GeographyVal value) {
        return new Geography(value);
    }

    public GeographyVal getValue() {
        return this.value;
    }

    public byte[] getBytes() {
        return this.value.getBytes();
    }

    public Geography copy() {
        byte[] bytes = this.getBytes();
        return Geography.fromBytes(Arrays.copyOf(bytes, bytes.length));
    }

    public static Geography fromWkb(byte[] wkb, int srid) {
        byte[] bytes = new byte[4 + wkb.length];
        ByteBuffer.wrap(bytes).order(DEFAULT_ENDIANNESS).putInt(srid);
        System.arraycopy(wkb, 0, bytes, 4, wkb.length);
        return Geography.fromBytes(bytes);
    }

    public static Geography fromWkb(byte[] wkb) {
        return Geography.fromWkb(wkb, DEFAULT_SRID);
    }

    public static Geography fromEwkb(byte[] ewkb) {
        throw new UnsupportedOperationException("Geography EWKB parsing is not yet supported.");
    }

    public static Geography fromWkt(byte[] wkt, int srid) {
        throw new UnsupportedOperationException("Geography WKT parsing is not yet supported.");
    }

    public static Geography fromWkt(byte[] wkt) {
        return Geography.fromWkt(wkt, DEFAULT_SRID);
    }

    public static Geography fromEwkt(byte[] ewkt) {
        throw new UnsupportedOperationException("Geography EWKT parsing is not yet supported.");
    }

    @Override
    public byte[] toWkb() {
        return Arrays.copyOfRange(this.getBytes(), 4, this.getBytes().length);
    }

    @Override
    public byte[] toWkb(ByteOrder endianness) {
        if (endianness == DEFAULT_ENDIANNESS) {
            return this.toWkb();
        }
        throw new UnsupportedOperationException("Geography WKB endianness is not yet supported.");
    }

    @Override
    public byte[] toEwkb() {
        throw new UnsupportedOperationException("Geography EWKB conversion is not yet supported.");
    }

    @Override
    public byte[] toEwkb(ByteOrder endianness) {
        throw new UnsupportedOperationException("Geography EWKB endianness is not yet supported.");
    }

    @Override
    public byte[] toWkt() {
        throw new UnsupportedOperationException("Geography WKT conversion is not yet supported.");
    }

    @Override
    public byte[] toEwkt() {
        throw new UnsupportedOperationException("Geography EWKT conversion is not yet supported.");
    }

    @Override
    public int srid() {
        return this.getWrapper().getInt(0);
    }

    @Override
    public void setSrid(int srid) {
        this.getWrapper().putInt(0, srid);
    }

    private ByteBuffer getWrapper() {
        return ByteBuffer.wrap(this.getBytes()).order(DEFAULT_ENDIANNESS);
    }
}

