/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.DecimalAddNoOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.DecimalDivideWithOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.DivideDTInterval;
import org.apache.spark.sql.catalyst.expressions.DivideYMInterval;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the mean calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (3) AS tab(col);\n       2.0\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (NULL) AS tab(col);\n       1.5\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0005\t%g\u0001\u0002\u00180\u0001zB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005!\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003k\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0015\u0019\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0011|\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!I\u00111\t\u0001C\u0002\u0013\u0015\u0013Q\t\u0005\t\u0003_\u0002\u0001\u0015!\u0004\u0002H!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%\t\"a\u001d\t\u0015\u0005=\u0005\u0001#b\u0001\n\u0003\t\t\n\u0003\u0006\u0002\u0018\u0002A)\u0019!C\u0001\u00033C!\"!)\u0001\u0011\u000b\u0007I\u0011AAM\u0011\u001d\t\u0019\u000b\u0001C\t\u0003KC!\"a,\u0001\u0011\u000b\u0007I\u0011IAY\u0011)\t\u0019\r\u0001EC\u0002\u0013\u0005\u0013Q\u0019\u0005\u000b\u0003#\u0004\u0001R1A\u0005B\u0005M\u0007\"CAl\u0001!\u0015\r\u0011\"\u0011g\u0011)\tI\u000e\u0001EC\u0002\u0013\u0005\u00131\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\ty\u000f\u0001C)\u0003cDq!a>\u0001\t\u0003\nI\u0010C\u0005\u0003\n\u0001\t\t\u0011\"\u0001\u0003\f!I!\u0011\u0003\u0001\u0012\u0002\u0013\u0005!1\u0003\u0005\n\u0005S\u0001\u0011\u0013!C\u0001\u0005WA\u0011Ba\f\u0001\u0003\u0003%\tE!\r\t\u0013\tu\u0002!!A\u0005\u0002\t}\u0002\"\u0003B$\u0001\u0005\u0005I\u0011\u0001B%\u0011%\u0011y\u0005AA\u0001\n\u0003\u0012\t\u0006C\u0005\u0003Z\u0001\t\t\u0011\"\u0001\u0003\\!I!q\f\u0001\u0002\u0002\u0013\u0005#\u0011\r\u0005\n\u0005K\u0002\u0011\u0011!C!\u0005O:\u0011Ba#0\u0003\u0003E\tA!$\u0007\u00119z\u0013\u0011!E\u0001\u0005\u001fCaa\u001d\u0014\u0005\u0002\tu\u0005\"\u0003BPM\u0005\u0005IQ\tBQ\u0011%\u0011\u0019KJA\u0001\n\u0003\u0013)\u000bC\u0005\u0003,\u001a\n\n\u0011\"\u0001\u0003,!I!Q\u0016\u0014\u0002\u0002\u0013\u0005%q\u0016\u0005\n\u0005{3\u0013\u0013!C\u0001\u0005WA\u0011Ba0'\u0003\u0003%IA!1\u0003\u000f\u00053XM]1hK*\u0011\u0001'M\u0001\nC\u001e<'/Z4bi\u0016T!AM\u001a\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003iU\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003m]\n1a]9m\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\b\u0001}\u001auIS*Z!\t\u0001\u0015)D\u00010\u0013\t\u0011uF\u0001\u000bEK\u000ed\u0017M]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003\t\u0016k\u0011!M\u0005\u0003\rF\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\t\"K!!S\u0019\u0003'M+\b\u000f]8siF+XM]=D_:$X\r\u001f;\u0011\u0007-s\u0005+D\u0001M\u0015\ti5'A\u0003ue\u0016,7/\u0003\u0002P\u0019\nIQK\\1ss2K7.\u001a\t\u0003\tFK!AU\u0019\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVKA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0013gBA.a\u001d\tav,D\u0001^\u0015\tqV(\u0001\u0004=e>|GOP\u0005\u0002-&\u0011\u0011-V\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GM\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002b+\u0006)1\r[5mIV\t\u0001+\u0001\u0004dQ&dG\rI\u0001\tKZ\fG.T8eKV\t!\u000e\u0005\u0002l]:\u0011A\t\\\u0005\u0003[F\n\u0001\"\u0012<bY6{G-Z\u0005\u0003_B\u0014QAV1mk\u0016L!!]+\u0003\u0017\u0015sW/\\3sCRLwN\\\u0001\nKZ\fG.T8eK\u0002\na\u0001P5oSRtDcA;woB\u0011\u0001\t\u0001\u0005\u0006K\u0016\u0001\r\u0001\u0015\u0005\bQ\u0016\u0001\n\u00111\u0001k)\t)\u0018\u0010C\u0003f\r\u0001\u0007\u0001+\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001 \t\u0004{\u0006\raB\u0001@\u0000!\taV+C\u0002\u0002\u0002U\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001+\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u00055\u0001#\u0002.\u0002\u0010\u0005M\u0011bAA\tI\n\u00191+Z9\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u00076\u0003\u0015!\u0018\u0010]3t\u0013\u0011\ti\"a\u0006\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015g\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002.\u0005\u001d\"a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00119,H\u000e\\1cY\u0016,\"!a\r\u0011\u0007Q\u000b)$C\u0002\u00028U\u0013qAQ8pY\u0016\fg.\u0001\u0005eCR\fG+\u001f9f+\t\ti\u0004\u0005\u0003\u0002\u0016\u0005}\u0012\u0002BA!\u0003/\u0011\u0001\u0002R1uCRK\b/Z\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0003\u0003\u000f\u0002RAWA\b\u0003\u0013\u0002B!a\u0013\u0002j9!\u0011QJA3\u001d\u0011\ty%a\u0019\u000f\t\u0005E\u0013\u0011\r\b\u0005\u0003'\nyF\u0004\u0003\u0002V\u0005uc\u0002BA,\u00037r1\u0001XA-\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(\u0003\u00027o%\u0011A'N\u0005\u0003\u001bNJ1!a\u001aM\u0003-!&/Z3QCR$XM\u001d8\n\t\u0005-\u0014Q\u000e\u0002\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002h1\u000bQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013A\u0003:fgVdG\u000fV=qKV\u0011\u0011Q\u000f\n\b\u0003o\nYhUAA\r\u0019\tI\b\u0001\u0001\u0002v\taAH]3gS:,W.\u001a8u}A!\u0011QCA?\u0013\u0011\ty(a\u0006\u0003\u0015\u0005#x.\\5d)f\u0004X\r\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u0005%|'BAAF\u0003\u0011Q\u0017M^1\n\u0007\r\f))A\u0006tk6$\u0015\r^1UsB,WCAAJ%\u001d\t)*a\u001fT\u0003\u00033a!!\u001f\u0001\u0001\u0005M\u0015aA:v[V\u0011\u00111\u0014\t\u0004\t\u0006u\u0015bAAPc\t\u0011\u0012\t\u001e;sS\n,H/\u001a*fM\u0016\u0014XM\\2f\u0003\u0015\u0019w.\u001e8u\u0003\r\tG\r\u001a\u000b\u0006!\u0006\u001d\u00161\u0016\u0005\u0007\u0003S\u0013\u0002\u0019\u0001)\u0002\t1,g\r\u001e\u0005\u0007\u0003[\u0013\u0002\u0019\u0001)\u0002\u000bILw\r\u001b;\u0002'\u0005<wMQ;gM\u0016\u0014\u0018\t\u001e;sS\n,H/Z:\u0016\u0005\u0005M\u0006CBA[\u0003\u007f\u000bY*\u0004\u0002\u00028*!\u0011\u0011XA^\u0003%IW.\\;uC\ndWMC\u0002\u0002>V\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t-a.\u0003\t1K7\u000f^\u0001\u000eS:LG/[1m-\u0006dW/Z:\u0016\u0005\u0005\u001d\u0007CBA[\u0003\u0013\fY-\u0003\u0003\u0002\u0012\u0005]\u0006c\u0001#\u0002N&\u0019\u0011qZ\u0019\u0003\u000f1KG/\u001a:bY\u0006\u0001R.\u001a:hK\u0016C\bO]3tg&|gn]\u000b\u0003\u0003+\u0004R!!.\u0002JB\u000b!#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0006\tR\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:\u0016\u0005\u0005u\u0007\u0003\u0002.\u0002\u0010A\u000bQB\u001a7bi\u0006\u0013x-^7f]R\u001cXCAAr!\u0015Q\u0016Q]Au\u0013\r\t9\u000f\u001a\u0002\t\u0013R,'/\u0019;peB\u0019A+a;\n\u0007\u00055XKA\u0002B]f\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA;\u0002t\"1\u0011Q_\rA\u0002A\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0011S:LG/U;fef\u001cuN\u001c;fqR$\"!a?\u0011\u000bQ\u000biP!\u0001\n\u0007\u0005}XK\u0001\u0004PaRLwN\u001c\t\u0005\u0005\u0007\u0011)!D\u00018\u0013\r\u00119a\u000e\u0002\r#V,'/_\"p]R,\u0007\u0010^\u0001\u0005G>\u0004\u0018\u0010F\u0003v\u0005\u001b\u0011y\u0001C\u0004f7A\u0005\t\u0019\u0001)\t\u000f!\\\u0002\u0013!a\u0001U\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u000bU\r\u0001&qC\u0016\u0003\u00053\u0001BAa\u0007\u0003&5\u0011!Q\u0004\u0006\u0005\u0005?\u0011\t#A\u0005v]\u000eDWmY6fI*\u0019!1E+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003(\tu!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0017U\rQ'qC\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tM\u0002\u0003\u0002B\u001b\u0005wi!Aa\u000e\u000b\t\te\u0012\u0011R\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0006\t]\u0012\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B!!\r!&1I\u0005\u0004\u0005\u000b*&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAu\u0005\u0017B\u0011B!\u0014!\u0003\u0003\u0005\rA!\u0011\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\u0006\u0005\u0004\u0003V\t]\u0013\u0011^\u0007\u0003\u0003wKA!a:\u0002<\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00024\tu\u0003\"\u0003B'E\u0005\u0005\t\u0019AAu\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\tM\"1\r\u0005\n\u0005\u001b\u001a\u0013\u0011!a\u0001\u0005\u0003\na!Z9vC2\u001cH\u0003BA\u001a\u0005SB\u0011B!\u0014%\u0003\u0003\u0005\r!!;)'\u0001\u0011iGa\u001d\u0003v\te$1\u0010B@\u0005\u0003\u0013)Ia\"\u0011\u0007\u0011\u0013y'C\u0002\u0003rE\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003x\u0005\u0011uLR+O\u0007~CS\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002jW-\u00198!G\u0006d7-\u001e7bi\u0016$\u0007E\u001a:p[\u00022\u0018\r\\;fg\u0002zg\rI1!OJ|W\u000f\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A! \u0002\u0003;R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QEJC\u0006\t\u00153S1\u0002\u0003fM\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113]AR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QEJC\u0006\t\u00153S1\u0002\u0003FT+M\u0019&\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\nd&\u000e\u0006!A\u0005)qM]8va\u0006\u0012!1Q\u0001\nC\u001e<wLZ;oGN\fQa]5oG\u0016\f#A!#\u0002\u000bEr\u0003G\f\u0019\u0002\u000f\u00053XM]1hKB\u0011\u0001IJ\n\u0006M\tE\u0015\u0011\u0011\t\b\u0005'\u0013I\n\u00156v\u001b\t\u0011)JC\u0002\u0003\u0018V\u000bqA];oi&lW-\u0003\u0003\u0003\u001c\nU%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!QR\u0001\ti>\u001cFO]5oOR\u0011!1G\u0001\u0006CB\u0004H.\u001f\u000b\u0006k\n\u001d&\u0011\u0016\u0005\u0006K&\u0002\r\u0001\u0015\u0005\bQ&\u0002\n\u00111\u0001k\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005c\u0013I\fE\u0003U\u0003{\u0014\u0019\fE\u0003U\u0005k\u0003&.C\u0002\u00038V\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B^W\u0005\u0005\t\u0019A;\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0007\u0004BA!\u000e\u0003F&!!q\u0019B\u001c\u0005\u0019y%M[3di\u0002")
public class Average
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
SupportQueryContext,
UnaryLike<Expression> {
    private AtomicType resultType;
    private AtomicType sumDataType;
    private AttributeReference sum;
    private AttributeReference count;
    private List<AttributeReference> aggBufferAttributes;
    private Seq<Literal> initialValues;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private Seq<Expression> updateExpressions;
    private final Expression child;
    private final Enumeration.Value evalMode;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<Expression> children;
    private Option<QueryContext> queryContext;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$2() {
        return Average$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Enumeration.Value>> unapply(Average x$0) {
        return Average$.MODULE$.unapply(x$0);
    }

    public static Enumeration.Value apply$default$2() {
        return Average$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Enumeration.Value>, Average> tupled() {
        return Average$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Enumeration.Value, Average>> curried() {
        return Average$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    private Seq<Expression> children$lzycompute() {
        Average average = this;
        synchronized (average) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "avg");
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child());
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 1) == 0) {
                Object object;
                DecimalType decimalType;
                Option option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    object = DecimalType$.MODULE$.bounded(p + 4, s + 4);
                } else {
                    object = dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : (dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : DoubleType$.MODULE$);
                }
                this.resultType = object;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    public AtomicType resultType() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.resultType$lzycompute();
        }
        return this.resultType;
    }

    private AtomicType sumDataType$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 2) == 0) {
                Object object;
                DecimalType decimalType;
                Option option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int p = ((Tuple2)option.get())._1$mcI$sp();
                    int s = ((Tuple2)option.get())._2$mcI$sp();
                    object = DecimalType$.MODULE$.bounded(p + 10, s);
                } else {
                    object = dataType instanceof YearMonthIntervalType ? YearMonthIntervalType$.MODULE$.apply() : (dataType instanceof DayTimeIntervalType ? DayTimeIntervalType$.MODULE$.apply() : DoubleType$.MODULE$);
                }
                this.sumDataType = object;
                this.bitmap$0 |= 2;
            }
        }
        return this.sumDataType;
    }

    public AtomicType sumDataType() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.sumDataType$lzycompute();
        }
        return this.sumDataType;
    }

    private AttributeReference sum$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.sumDataType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", (DataType)x$2, x$3, x$4);
                this.sum = new AttributeReference("sum", (DataType)x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.sum;
    }

    public AttributeReference sum() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.sum$lzycompute();
        }
        return this.sum;
    }

    private AttributeReference count$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 8) == 0) {
                String x$1 = "count";
                LongType$ x$2 = LongType$.MODULE$;
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("count", (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("count", (DataType)x$2, x$3, x$4);
                this.count = new AttributeReference("count", (DataType)x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 8;
            }
        }
        return this.count;
    }

    public AttributeReference count() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.count$lzycompute();
        }
        return this.count;
    }

    public Expression add(Expression left, Expression right) {
        DataType dataType = left.dataType();
        if (dataType instanceof DecimalType) {
            return new DecimalAddNoOverflowCheck(left, right, left.dataType());
        }
        return new Add(left, right, this.evalMode());
    }

    private List<AttributeReference> aggBufferAttributes$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x10) == 0) {
                AttributeReference attributeReference = this.sum();
                AttributeReference attributeReference2 = this.count();
                this.aggBufferAttributes = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    public List<AttributeReference> aggBufferAttributes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Literal> initialValues$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = new .colon.colon((Object)Literal$.MODULE$.default((DataType)this.sumDataType()), (List)new .colon.colon((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L)), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    public Seq<Literal> initialValues() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.mergeExpressions = new .colon.colon((Object)this.add(this.RichAttribute(this.sum()).left(), this.RichAttribute(this.sum()).right()), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.count()).left()).$plus(this.RichAttribute(this.count()).right()), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.mergeExpressions$lzycompute();
        }
        return this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Expression expression;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType) {
                    Enumeration.Value value = this.evalMode();
                    Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
                    boolean bl = value == null ? value2 != null : !value.equals(value2);
                    expression = new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, (DataType)this.resultType()), new DecimalDivideWithOverflowCheck(this.sum(), package$expressions$.MODULE$.DslExpression(this.count()).cast((DataType)DecimalType$.MODULE$.LongDecimal()), (DecimalType)this.resultType(), this.getContextOrNull(), bl));
                } else {
                    expression = dataType instanceof YearMonthIntervalType ? new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, (DataType)YearMonthIntervalType$.MODULE$.apply()), new DivideYMInterval(this.sum(), this.count())) : (dataType instanceof DayTimeIntervalType ? new If(new EqualTo(this.count(), Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)0L))), new Literal(null, (DataType)DayTimeIntervalType$.MODULE$.apply()), new DivideDTInterval(this.sum(), this.count())) : new Divide(package$expressions$.MODULE$.DslExpression(this.sum()).cast((DataType)this.resultType()), package$expressions$.MODULE$.DslExpression(this.count()).cast((DataType)this.resultType()), EvalMode$.MODULE$.LEGACY()));
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Average average = this;
        synchronized (average) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.updateExpressions = new .colon.colon((Object)this.add(this.sum(), package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.sumDataType()), Literal$.MODULE$.default((DataType)this.sumDataType())}))), (List)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.count(), package$expressions$.MODULE$.DslExpression(this.count()).$plus(package$expressions$.MODULE$.longToLiteral(1L))), (List)Nil$.MODULE$));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Average withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    public Average copy(Expression child, Enumeration.Value evalMode) {
        return new Average(child, evalMode);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Enumeration.Value copy$default$2() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Average";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.evalMode();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Average;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "evalMode";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Average)) return false;
        boolean bl = true;
        if (!bl) return false;
        Average average = (Average)x$1;
        Expression expression = this.child();
        Expression expression2 = average.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = average.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!average.canEqual(this)) return false;
        return true;
    }

    public Average(Expression child, Enumeration.Value evalMode) {
        this.child = child;
        this.evalMode = evalMode;
        ExpectsInputTypes.$init$(this);
        SupportQueryContext.$init$(this);
        UnaryLike.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.AVERAGE(), (List)Nil$.MODULE$);
    }

    public Average(Expression child) {
        this(child, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

