/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Length$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the character length of string data or number of bytes of binary data. The length of string data includes the trailing spaces. The length of binary data includes binary zeros.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL ');\n       10\n      > SELECT _FUNC_(x'537061726b2053514c');\n       9\n      > SELECT CHAR_LENGTH('Spark SQL ');\n       10\n      > SELECT CHARACTER_LENGTH('Spark SQL ');\n       10\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\")\u0001\n\u0001C\u0001\u0013\")A\n\u0001C!\u001b\")\u0011\u000b\u0001C!%\")\u0011\f\u0001C!5\")\u0011\r\u0001C)E\")\u0001\u000e\u0001C!S\")q\u000f\u0001C)q\"91\u0010AA\u0001\n\u0003a\bb\u0002@\u0001#\u0003%\ta \u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/A\u0011\"!\u000b\u0001\u0003\u0003%\t!a\u000b\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0002\"CA\u001e\u0001\u0005\u0005I\u0011IA\u001f\u0011%\tY\u0005AA\u0001\n\u0003\ti\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0011\u0002T!I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0013\u0011L\u0004\n\u0003{Z\u0012\u0011!E\u0001\u0003\u007f2\u0001BG\u000e\u0002\u0002#\u0005\u0011\u0011\u0011\u0005\u0007\u0011R!\t!!'\t\u0013\u0005mE#!A\u0005F\u0005u\u0005\"CAP)\u0005\u0005I\u0011QAQ\u0011%\t)\u000bFA\u0001\n\u0003\u000b9\u000bC\u0005\u00024R\t\t\u0011\"\u0003\u00026\n1A*\u001a8hi\"T!\u0001H\u000f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003=}\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003A\u0005\n1a]9m\u0015\t\u00113%A\u0003ta\u0006\u00148N\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0006\u0001%j\u0003G\u000e\t\u0003U-j\u0011aG\u0005\u0003Ym\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003U9J!aL\u000e\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00028\u007f9\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w\u001d\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005y\u0012\u0014a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0010\u001a\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\u0011\u0003\"AK#\n\u0005\u0019[\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDC\u0001&L!\tQ\u0003\u0001C\u0003C\u0007\u0001\u0007A)\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u00039\u0003\"!M(\n\u0005A\u0013$a\u0002\"p_2,\u0017M\\\u0001\tI\u0006$\u0018\rV=qKV\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002W?\u0005)A/\u001f9fg&\u0011\u0001,\u0016\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003m\u00032a\u000e/_\u0013\ti\u0016IA\u0002TKF\u0004\"\u0001V0\n\u0005\u0001,&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\t\u0019g\r\u0005\u00022I&\u0011QM\r\u0002\u0004\u0003:L\b\"B4\b\u0001\u0004\u0019\u0017!\u0002<bYV,\u0017!\u00033p\u000f\u0016t7i\u001c3f)\rQ\u0007/\u001e\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[n\tqaY8eK\u001e,g.\u0003\u0002pY\nAQ\t\u001f9s\u0007>$W\rC\u0003r\u0011\u0001\u0007!/A\u0002dib\u0004\"a[:\n\u0005Qd'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006m\"\u0001\rA[\u0001\u0003KZ\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGC\u0001&z\u0011\u0015Q\u0018\u00021\u0001E\u0003!qWm^\"iS2$\u0017\u0001B2paf$\"AS?\t\u000f\tS\u0001\u0013!a\u0001\t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0001U\r!\u00151A\u0016\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0002\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0005%!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005!A.\u00198h\u0015\t\t\u0019#\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0003;\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0017!\r\t\u0014qF\u0005\u0004\u0003c\u0011$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA2\u00028!I\u0011\u0011\b\b\u0002\u0002\u0003\u0007\u0011QF\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0002#BA!\u0003\u000f\u001aWBAA\"\u0015\r\t)EM\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019a*a\u0014\t\u0011\u0005e\u0002#!AA\u0002\r\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011DA+\u0011%\tI$EA\u0001\u0002\u0004\ti#\u0001\u0004fcV\fGn\u001d\u000b\u0004\u001d\u0006m\u0003\u0002CA\u001d%\u0005\u0005\t\u0019A2)'\u0001\ty&!\u001a\u0002h\u0005-\u0014QNA9\u0003g\n9(!\u001f\u0011\u0007)\n\t'C\u0002\u0002dm\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002j\u0005\tii\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043\r[1sC\u000e$XM\u001d\u0011mK:<G\u000f\u001b\u0011pM\u0002\u001aHO]5oO\u0002\"\u0017\r^1!_J\u0004c.^7cKJ\u0004sN\u001a\u0011csR,7\u000fI8gA\tLg.\u0019:zA\u0011\fG/\u0019\u0018!)\",\u0007\u0005\\3oORD\u0007e\u001c4!gR\u0014\u0018N\\4!I\u0006$\u0018\rI5oG2,H-Z:!i\",\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cWm\u001d\u0018!)\",\u0007\u0005\\3oORD\u0007e\u001c4!E&t\u0017M]=!I\u0006$\u0018\rI5oG2,H-Z:!E&t\u0017M]=!u\u0016\u0014xn\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001c\u0002\u0003\u0013T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MA\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"Bx%N\u001a8aY\ntG\r\u001cceA*4'N\u00195G\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\rC\u0015IU0M\u000b:;E\u000b\u0013\u0015('B\f'o\u001b\u0011T#2\u0003s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0011%B%\u0006\u001bE+\u0012*`\u0019\u0016su\t\u0016%)OM\u0003\u0018M]6!'Fc\u0005eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0002$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005U\u0014!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAA>\u00031\u0019HO]5oO~3WO\\2t\u0003\u0019aUM\\4uQB\u0011!\u0006F\n\u0006)\u0005\r\u0015q\u0012\t\u0007\u0003\u000b\u000bY\t\u0012&\u000e\u0005\u0005\u001d%bAAEe\u00059!/\u001e8uS6,\u0017\u0002BAG\u0003\u000f\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u0003C\t!![8\n\u0007\u0001\u000b\u0019\n\u0006\u0002\u0002\u0000\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u001a\u0005)\u0011\r\u001d9msR\u0019!*a)\t\u000b\t;\u0002\u0019\u0001#\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011VAX!\u0011\t\u00141\u0016#\n\u0007\u00055&G\u0001\u0004PaRLwN\u001c\u0005\t\u0003cC\u0012\u0011!a\u0001\u0015\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005]\u0006\u0003BA\u000e\u0003sKA!a/\u0002\u001e\t1qJ\u00196fGR\u0004")
public class Length
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Length x$0) {
        return Length$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Length, A> g) {
        return Length$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Length> compose(Function1<A$, Expression> g) {
        return Length$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object value) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return BoxesRunTime.boxToInteger((int)((UTF8String)value).numChars());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)((byte[])value).length);
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").numChars()");
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ").length");
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Length withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Length copy(Expression child) {
        return new Length(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Length";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Length;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Length)) return false;
        boolean bl = true;
        if (!bl) return false;
        Length length = (Length)x$1;
        Expression expression = this.child();
        Expression expression2 = length.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!length.canEqual(this)) return false;
        return true;
    }

    public Length(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

