/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001B\u0010!\u00016B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005O\u0001\tE\t\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015!\u0006\u0001\"\u0011V\u0011!I\u0006\u0001#b\u0001\n\u000bQ\u0006\"\u00020\u0001\t\u0003z\u0006\"B5\u0001\t#R\u0007\"\u0002:\u0001\t\u0003\u001a\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\t\t\u0003\u0001C)\u0003GA\u0011\"!\f\u0001\u0003\u0003%\t!a\f\t\u0013\u0005U\u0002!%A\u0005\u0002\u0005]\u0002\"CA'\u0001E\u0005I\u0011AA\u001c\u0011%\ty\u0005AA\u0001\n\u0003\n\t\u0006\u0003\u0005\u0002b\u0001\t\t\u0011\"\u0001[\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002l\u0001\t\t\u0011\"\u0011\u0002n!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u0003\u0003\u0011\u0011!C!\u0003\u0007C\u0011\"a\"\u0001\u0003\u0003%\t%!#\b\u0013\u00055\u0006%!A\t\u0002\u0005=f\u0001C\u0010!\u0003\u0003E\t!!-\t\r=KB\u0011AAe\u0011%\tY-GA\u0001\n\u000b\ni\rC\u0005\u0002Pf\t\t\u0011\"!\u0002R\"I\u0011q[\r\u0002\u0002\u0013\u0005\u0015\u0011\u001c\u0005\n\u0003WL\u0012\u0011!C\u0005\u0003[\u0014\u0011BR5oI&s7+\u001a;\u000b\u0005\u0005\u0012\u0013aC3yaJ,7o]5p]NT!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00183km\u0002\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00184\u0013\t!\u0004E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0010#\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!-\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002Do\u00059\u0001/Y2lC\u001e,\u0017BA#G\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019u'\u0001\u0003mK\u001a$X#A%\u0011\u0005=R\u0015BA&!\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r\t&k\u0015\t\u0003_\u0001AQaR\u0003A\u0002%CQ!T\u0003A\u0002%\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001W!\t1t+\u0003\u0002Yo\t9!i\\8mK\u0006t\u0017aC2pY2\fG/[8o\u0013\u0012,\u0012a\u0017\t\u0003mqK!!X\u001c\u0003\u0007%sG/\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0019\t\u0004y\u0005\u001c\u0017B\u00012G\u0005\r\u0019V-\u001d\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0012\nQ\u0001^=qKNL!\u0001[3\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA6oaB\u0011a\u0007\\\u0005\u0003[^\u00121!\u00118z\u0011\u0015y\u0017\u00021\u0001l\u0003\u00119xN\u001d3\t\u000bEL\u0001\u0019A6\u0002\u0007M,G/A\u0005e_\u001e+gnQ8eKR\u0019AO_@\u0011\u0005UDX\"\u0001<\u000b\u0005]\u0004\u0013aB2pI\u0016<WM\\\u0005\u0003sZ\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006w*\u0001\r\u0001`\u0001\u0004GRD\bCA;~\u0013\tqhO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u0005!\u00021\u0001u\u0003\t)g/\u0001\u0005eCR\fG+\u001f9f+\t\t9\u0001E\u0002e\u0003\u0013I1!a\u0003f\u0005!!\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tYB\u0004\u0003\u0002\u0016\u0005]\u0001C\u0001 8\u0013\r\tIbN\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0011q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005eq'A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)\u0011+!\n\u0002*!1\u0011qE\u0007A\u0002%\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002,5\u0001\r!S\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0015\t\u0016\u0011GA\u001a\u0011\u001d9e\u0002%AA\u0002%Cq!\u0014\b\u0011\u0002\u0003\u0007\u0011*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"fA%\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002H]\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&!\u0011QDA,\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a[A4\u0011!\tIgEA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002pA)\u0011\u0011OA<W6\u0011\u00111\u000f\u0006\u0004\u0003k:\u0014AC2pY2,7\r^5p]&!\u0011\u0011PA:\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007Y\u000by\b\u0003\u0005\u0002jU\t\t\u00111\u0001l\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u0013Q\u0011\u0005\t\u0003S2\u0012\u0011!a\u00017\u00061Q-];bYN$2AVAF\u0011!\tIgFA\u0001\u0002\u0004Y\u0007f\u0005\u0001\u0002\u0010\u0006U\u0015qSAN\u0003;\u000b\t+a)\u0002(\u0006%\u0006cA\u0018\u0002\u0012&\u0019\u00111\u0013\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011T\u0001\u0002D*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003e\u001d;s?\u0006\u0014(/Y=*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA%tG-\u001a=!QEj#-Y:fI&\u0002sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001aHO]5oO\u0002B\u0003m\u001d;sA&\u0002\u0013N\u001c\u0011uQ\u0016\u00043m\\7nC6\"W\r\\5nSR,G\r\t7jgR\u0004\u0003\u0006Y:ue~\u000b'O]1zA&r#\u0002\t\u0011!A\u0001\u0002#+\u001a;ve:\u001c\b\u0005\r\u0017!S\u001a\u0004C\u000f[3!gR\u0014\u0018N\\4!o\u0006\u001c\bE\\8uA\u0019|WO\u001c3!_J\u0004\u0013N\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u001aHO]5oO\u0002B\u0003m\u001d;sA&\u00023m\u001c8uC&t7\u000fI1!G>lW.\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003?\u000b\u0001J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(C\n<CfJ1cG2\u0012G&\u00192-G2\"WMZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAAV\u00031\u0019HO]5oO~3WO\\2t\u0003%1\u0015N\u001c3J]N+G\u000f\u0005\u000203M)\u0011$a-\u0002@B9\u0011QWA^\u0013&\u000bVBAA\\\u0015\r\tIlN\u0001\beVtG/[7f\u0013\u0011\ti,a.\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002B\u0006\u001dWBAAb\u0015\u0011\t)-a\u0017\u0002\u0005%|\u0017bA#\u0002DR\u0011\u0011qV\u0001\ti>\u001cFO]5oOR\u0011\u00111K\u0001\u0006CB\u0004H.\u001f\u000b\u0006#\u0006M\u0017Q\u001b\u0005\u0006\u000fr\u0001\r!\u0013\u0005\u0006\u001br\u0001\r!S\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY.a:\u0011\u000bY\ni.!9\n\u0007\u0005}wG\u0001\u0004PaRLwN\u001c\t\u0006m\u0005\r\u0018*S\u0005\u0004\u0003K<$A\u0002+va2,'\u0007\u0003\u0005\u0002jv\t\t\u00111\u0001R\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003_\u0004B!!\u0016\u0002r&!\u00111_A,\u0005\u0019y%M[3di\u0002")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet x$0) {
        return FindInSet$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private int collationId$lzycompute() {
        FindInSet findInSet = this;
        synchronized (findInSet) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.left().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)CollationSupport.FindInSet.exec((UTF8String)((UTF8String)word), (UTF8String)((UTF8String)set), (int)this.collationId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(word, set) -> CollationSupport.FindInSet.genCode((String)word, (String)set, (int)this.collationId()));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    @Override
    public FindInSet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

