/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connect.ui.SessionStatsPagedTable;
import org.apache.spark.sql.connect.ui.SparkConnectServerAppStatusStore;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab;
import org.apache.spark.sql.connect.ui.SqlStatsPagedTable;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005%4Qa\u0003\u0007\u0001\u0019aA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006U\u0001!\ta\u000b\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0019\u0019\u0004\u0001)A\u0005a!9A\u0007\u0001b\u0001\n\u0013)\u0004B\u0002 \u0001A\u0003%a\u0007C\u0003@\u0001\u0011\u0005\u0001\tC\u0003b\u0001\u0011%!\rC\u0003d\u0001\u0011%A\rC\u0003g\u0001\u0011%qM\u0001\fTa\u0006\u00148nQ8o]\u0016\u001cGoU3sm\u0016\u0014\b+Y4f\u0015\tia\"\u0001\u0002vS*\u0011q\u0002E\u0001\bG>tg.Z2u\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\n\u0004\u0001eq\u0002C\u0001\u000e\u001d\u001b\u0005Y\"BA\u0007\u0013\u0013\ti2DA\u0005XK\n,\u0016\nU1hKB\u0011qDI\u0007\u0002A)\u0011\u0011EE\u0001\tS:$XM\u001d8bY&\u00111\u0005\t\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0001\u0018M]3oi\u000e\u0001\u0001CA\u0014)\u001b\u0005a\u0011BA\u0015\r\u0005U\u0019\u0006/\u0019:l\u0007>tg.Z2u'\u0016\u0014h/\u001a:UC\n\fa\u0001P5oSRtDC\u0001\u0017.!\t9\u0003\u0001C\u0003%\u0005\u0001\u0007a%A\u0003ti>\u0014X-F\u00011!\t9\u0013'\u0003\u00023\u0019\t\u00013\u000b]1sW\u000e{gN\\3diN+'O^3s\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0003\u0019\u0019Ho\u001c:fA\u0005I1\u000f^1siRKW.Z\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0005kRLGNC\u0001<\u0003\u0011Q\u0017M^1\n\u0005uB$\u0001\u0002#bi\u0016\f!b\u001d;beR$\u0016.\\3!\u0003\u0019\u0011XM\u001c3feR\u0011\u0011)\u0016\t\u0004\u00052{eBA\"J\u001d\t!u)D\u0001F\u0015\t1U%\u0001\u0004=e>|GOP\u0005\u0002\u0011\u0006)1oY1mC&\u0011!jS\u0001\ba\u0006\u001c7.Y4f\u0015\u0005A\u0015BA'O\u0005\r\u0019V-\u001d\u0006\u0003\u0015.\u0003\"\u0001U*\u000e\u0003ES!AU&\u0002\u0007alG.\u0003\u0002U#\n!aj\u001c3f\u0011\u00151v\u00011\u0001X\u0003\u001d\u0011X-];fgR\u0004\"\u0001W0\u000e\u0003eS!AW.\u0002\t!$H\u000f\u001d\u0006\u00039v\u000bqa]3sm2,GOC\u0001_\u0003\u001dQ\u0017m[1si\u0006L!\u0001Y-\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\u0013O\u0016tWM]1uK\n\u000b7/[2Ti\u0006$8\u000fF\u0001B\u0003U9WM\\3sCR,7+\u0015'Ti\u0006$8\u000fV1cY\u0016$\"!Q3\t\u000bYK\u0001\u0019A,\u00023\u001d,g.\u001a:bi\u0016\u001cVm]:j_:\u001cF/\u0019;t)\u0006\u0014G.\u001a\u000b\u0003\u0003\"DQA\u0016\u0006A\u0002]\u0003")
public class SparkConnectServerPage
extends WebUIPage
implements Logging {
    private final SparkConnectServerTab parent;
    private final SparkConnectServerAppStatusStore store;
    private final Date startTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkConnectServerAppStatusStore store() {
        return this.store;
    }

    private Date startTime() {
        return this.startTime;
    }

    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq seq;
        SparkConnectServerAppStatusStore sparkConnectServerAppStatusStore = this.store();
        synchronized (sparkConnectServerAppStatusStore) {
            IterableOps iterableOps = (IterableOps)this.generateBasicStats().$plus$plus((IterableOnce)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.store().getOnlineSessionNum()));
            $buf.$amp$plus((Object)new Text("\n          session(s) are online,\n          running\n          "));
            $buf.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.store().getTotalRunning()));
            $buf.$amp$plus((Object)new Text("\n          Request(s)\n        "));
            seq = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)iterableOps.$plus$plus((IterableOnce)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)))).$plus$plus(this.generateSessionStatsTable(request))).$plus$plus(this.generateSQLStatsTable(request));
        }
        scala.collection.immutable.Seq content = seq;
        return UIUtils$.MODULE$.headerSparkPage(request, "Spark Connect", (Function0 & Serializable)() -> content, (SparkUITab)this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    private scala.collection.immutable.Seq<Node> generateBasicStats() {
        long timeSinceStart = System.currentTimeMillis() - this.startTime().getTime();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Started at: "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.formatDate(this.startTime()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Time since start: "));
        $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(timeSinceStart));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private scala.collection.immutable.Seq<Node> generateSQLStatsTable(HttpServletRequest request) {
        None$ none$;
        int numStatement = this.store().getExecutionList().size();
        if (numStatement > 0) {
            String sqlTableTag = "sqlstat";
            int sqlTablePage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(sqlTableTag + ".page")).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
            try {
                none$ = new Some(new SqlStatsPagedTable(request, this.parent, this.store().getExecutionList(), "connect", UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), sqlTableTag, true).table(sqlTablePage));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
                    $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)new Text("\n              "));
                    $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                    $buf3.$amp$plus((Object)new Text("\n            "));
                    $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
                    $buf.$amp$plus((Object)new Text("\n          "));
                    Some some = new Some((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
                    none$ = some;
                }
                throw throwable;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ table = none$;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-sqlstat',\n                'aggregated-sqlstat')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-sqlstat collapse-table"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("sqlstat"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Request Statistics ("));
        $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numStatement));
        $buf5.$amp$plus((Object)new Text(")"));
        $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-sqlstat collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus(table.getOrElse((Function0 & Serializable)() -> "No statistics have been generated yet."));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeSeq content = elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        return content;
    }

    private scala.collection.immutable.Seq<Node> generateSessionStatsTable(HttpServletRequest request) {
        None$ none$;
        int numSessions = this.store().getSessionList().size();
        if (numSessions > 0) {
            String sessionTableTag = "sessionstat";
            int sessionTablePage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(sessionTableTag + ".page")).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
            try {
                none$ = new Some(new SessionStatsPagedTable(request, this.parent, this.store().getSessionList(), "connect", UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), sessionTableTag).table(sessionTablePage));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
                    $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)new Text("\n              "));
                    $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                    $buf3.$amp$plus((Object)new Text("\n            "));
                    $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
                    $buf.$amp$plus((Object)new Text("\n          "));
                    Some some = new Some((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
                    none$ = some;
                }
                throw throwable;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ table = none$;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-sessionstat',\n                'aggregated-sessionstat')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-sessionstat collapse-table"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("sessionstat"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Session Statistics ("));
        $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)numSessions));
        $buf5.$amp$plus((Object)new Text(")"));
        $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-sessionstat collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus(table.getOrElse((Function0 & Serializable)() -> "No statistics have been generated yet."));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeSeq content = elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        return content;
    }

    public SparkConnectServerPage(SparkConnectServerTab parent) {
        this.parent = parent;
        super("");
        Logging.$init$((Logging)this);
        this.store = parent.store();
        this.startTime = parent.startTime();
    }
}

